import random
import json
import os
from datetime import datetime

# 재학습을 트리거할 정확도 임계값
ACCURACY_THRESHOLD = 0.85

def get_model_performance():
    """
    실제 환경에서는 이 함수가 예측 로그와 실제 레이블을 비교하여
    모델의 현재 성능(예: 정확도)을 계산합니다.
    이 예제에서는 성능 저하를 시뮬레이션하기 위해 난수를 사용합니다.
    """
    # 70% ~ 95% 사이의 정확도를 무작위로 시뮬레이션
    mock_accuracy = random.uniform(0.70, 0.95)
    print(f"현재 모델 정확도 (시뮬레이션): {mock_accuracy:.4f}")
    return mock_accuracy

def main():
    print("모델 성능 모니터링을 시작합니다...")
    current_accuracy = get_model_performance()

    retrain_needed = False
    if current_accuracy < ACCURACY_THRESHOLD:
        print(f"경고: 모델 정확도가 임계값({ACCURACY_THRESHOLD}) 이하로 떨어졌습니다. 재학습이 필요합니다.")
        retrain_needed = True
    else:
        print(f"모델 성능이 양호합니다 (정확도 > {ACCURACY_THRESHOLD}).")

    # 모니터링 결과를 파일로 저장하여 다른 파이프라인에서 사용할 수 있도록 함
    # 이 파일의 존재 여부나 내용을 통해 재학습 파이프라인을 트리거할 수 있음
    monitoring_result = {
        'timestamp': datetime.utcnow().isoformat(),
        'accuracy': current_accuracy,
        'threshold': ACCURACY_THRESHOLD,
        'retrain_needed': retrain_needed
    }

    if not os.path.exists('logs'):
        os.makedirs('logs')

    with open('logs/monitoring_latest.json', 'w') as f:
        json.dump(monitoring_result, f, indent=2)

    print("모니터링 결과가 'logs/monitoring_latest.json'에 저장되었습니다.")

if __name__ == "__main__":
    main() 