# MLOps: 모델 모니터링 및 재학습 시뮬레이션

이 모듈은 MLOps 사이클의 단순화된 시뮬레이션을 제공하며, 모델 성능 모니터링과 자동화된 재학습에 중점을 둡니다.

## 개념

실제 MLOps 환경에서는 배포된 모델의 성능이 데이터 드리프트나 기타 요인으로 인해 시간이 지남에 따라 저하될 수 있습니다. 다음 사항들이 중요합니다:
1.  **모니터링:** 실제 데이터에 대한 모델의 성능을 지속적으로 추적합니다.
2.  **트리거:** 성능이 특정 임계값 이하로 떨어지면 자동으로 재학습 파이프라인을 시작합니다.
3.  **재학습:** 새로운 데이터로 모델을 다시 훈련시킵니다.
4.  **재배포:** 새로 훈련된 모델이 기존 모델보다 성능이 좋다면 배포합니다.

이 예제는 간단한 파이썬 스크립트를 사용하여 1, 2, 3단계를 시뮬레이션합니다.

## 스크립트

### 1. `monitor.py`
이 스크립트는 모니터링 과정을 시뮬레이션합니다.
- "현재 배포된" 모델의 모의 정확도 점수를 생성합니다.
- 이 점수가 미리 정의된 `ACCURACY_THRESHOLD` 이하인지 확인합니다.
- 결과(재학습 필요 여부 포함)를 `logs/monitoring_latest.json`에 저장합니다.

### 2. `retrain.py`
이 스크립트는 재학습 파이프라인을 시뮬레이션합니다.
- `logs/monitoring_latest.json` 파일을 읽습니다.
- `retrain_needed` 플래그가 `True`인 경우, 모의 재학습 과정을 실행합니다(`time.sleep`로 시뮬레이션).
- 재학습 결과를 `logs/retraining_history.log`에 기록합니다.

## 시뮬레이션 실행 방법

1.  **모니터링 스크립트 실행:**
    성능 점수를 생성합니다. 여러 번 실행하여 다른 결과를 확인해보세요.
    ```bash
    python monitor.py
    ```

2.  **모니터링 로그 확인:**
    생성된 `logs/monitoring_latest.json` 파일을 확인하여 결과를 봅니다.

3.  **재학습 스크립트 실행:**
    모니터링 스크립트가 재학습이 필요하다고 표시한 경우에만 (모의) 재학습 파이프라인이 트리거됩니다.
    ```bash
    python retrain.py
    ``` 