from fastapi import FastAPI
from pydantic import BaseModel
import random

# Pydantic model for request body
class Review(BaseModel):
    text: str

# Create a FastAPI app instance
app = FastAPI()

# A mock sentiment analysis function
def mock_sentiment_analysis(text: str):
    """
    This is a mock function.
    In a real scenario, this would load a trained model
    (e.g., from scikit-learn, TensorFlow, or PyTorch)
    and perform inference.
    """
    if not text or not text.strip():
        return {"label": "NEUTRAL", "score": 0.5}

    # Simple logic for the mock-up
    positive_words = ["good", "great", "excellent", "love", "best", "fantastic"]
    negative_words = ["bad", "terrible", "worst", "hate"]

    text_lower = text.lower()
    
    score = 0.5
    if any(word in text_lower for word in positive_words):
        score = random.uniform(0.8, 1.0)
        label = "POSITIVE"
    elif any(word in text_lower for word in negative_words):
        score = random.uniform(0.0, 0.2)
        label = "NEGATIVE"
    else:
        label = "NEUTRAL"
        score = random.uniform(0.4, 0.6)

    return {"label": label, "score": round(score, 4)}

@app.get("/")
def read_root():
    return {"message": "Welcome to the Sentiment Analysis API. Send a POST request to /predict."}

@app.post("/predict")
def predict_sentiment(review: Review):
    """
    Predicts the sentiment of a given movie review text.
    """
    prediction = mock_sentiment_analysis(review.text)
    return prediction 