# FastAPI를 이용한 모델 서빙 예제

이 프로젝트는 FastAPI를 사용하여 머신러닝 모델을 REST API로 제공하는 간단한 예제입니다.

API는 영화 리뷰 텍스트를 입력받아 감성 예측 결과(긍정, 부정 또는 중립)를 반환하는 단일 엔드포인트 `/predict`를 제공합니다.

**참고:** 이 예제는 데모 목적으로 **모의(mock)** 감성 분석 모델을 사용합니다. 모델의 정확성보다는 API 구조 자체에 초점을 맞추고 있습니다.

## 실행 방법

1.  **의존성 설치:**
    ```bash
    pip install -r requirements.txt
    ```

2.  **서버 실행:**
    ```bash
    uvicorn main:app --reload
    ```
    `--reload` 플래그는 코드가 변경될 때마다 서버를 자동으로 재시작합니다.

3.  **API 접속:**
    서버가 실행되면, 다음 주소에서 대화형 API 문서(Swagger UI)에 접속할 수 있습니다:
    [http://127.0.0.1:8000/docs](http://127.0.0.1:8000/docs)

    브라우저에서 직접 `/predict` 엔드포인트를 테스트할 수 있습니다.

## 요청 예시

`curl`을 사용하여 엔드포인트를 테스트할 수도 있습니다:

```bash
curl -X 'POST' \
  'http://127.0.0.1:8000/predict' \
  -H 'accept: application/json' \
  -H 'Content-Type: application/json' \
  -d '{
  "text": "이 영화는 정말 환상적이었어요!"
}'
```

### 예상 응답

```json
{
  "label": "POSITIVE",
  "score": 0.95
}
```

---

## Docker로 실행하는 방법

이 애플리케이션은 Docker 컨테이너 안에서도 실행할 수 있습니다. 이는 프로덕션 환경에서 애플리케이션을 배포하는 일반적인 방법입니다.

### 방법 1: Dockerfile 사용
1.  **Docker 이미지 빌드:**
    ```bash
    docker build -t fastapi-sentiment-api .
    ```

2.  **Docker 컨테이너 실행:**
    ```bash
    docker run -d -p 8000:80 --name sentiment-api-container fastapi-sentiment-api
    ```
    - `-d`는 컨테이너를 백그라운드(detached mode)에서 실행합니다.
    - `-p 8000:80`는 로컬 머신의 8000번 포트를 컨테이너의 80번 포트에 매핑합니다.

    이제 [http://localhost:8000/docs](http://localhost:8000/docs)에서 API에 접속할 수 있습니다.

### 방법 2: Docker Compose 사용 (개발용으로 추천)
`docker-compose`는 여러 컨테이너를 사용하는 애플리케이션의 실행 과정을 단순화합니다.

1.  **서비스 빌드 및 실행:**
    ```bash
    docker-compose up --build
    ```
    - 백그라운드에서 실행하려면 `docker-compose up -d`를 사용하세요.

2.  **서비스 중지:**
    ```bash
    docker-compose down
    ```
이제 [http://localhost:8000/docs](http://localhost:8000/docs)에서 API에 접속할 수 있습니다. `docker-compose.yml`의 `volumes` 설정은 로컬 코드를 컨테이너에 마운트하므로, 코드를 변경하면 `uvicorn` 서버가 자동으로 변경사항을 반영하여 재시작합니다. 