# AI 학습자를 위한 파이썬 레벨별 학습 경로

이 문서는 AI 및 데이터 과학을 공부하는 학습자를 위해 파이썬 프로그래밍 실력을 수준별로 향상시킬 수 있는 맞춤형 학습 경로를 제안합니다.

## 1. 초급자 경로 (Beginner Path)

**목표:** 파이썬 프로그래밍의 기본 문법을 익히고, 간단한 프로그래밍 문제 해결 능력을 기릅니다.

**학습 내용:**
- **변수와 자료형:** 숫자, 문자열, 불리언 등 기본 데이터 타입 이해
- **기본 자료구조:** 리스트, 튜플, 딕셔너리의 기본 사용법
- **제어문:** `if`, `for`, `while`을 이용한 조건 및 반복문 작성
- **함수:** 간단한 함수를 정의하고 사용하는 방법
- **파일 입출력:** 기본적인 텍스트 파일 읽고 쓰기

**추천 연습 문제:**
- `python_basics_practice.md`의 Part 1, 2 문제

---

## 2. 중급자 경로 (Intermediate Path)

**목표:** 데이터 분석 및 처리에 필수적인 핵심 라이브러리 사용법을 익힙니다.

**학습 내용:**
- **Numpy:** 다차원 배열 생성, 벡터화 연산, 기본 통계 계산
- **Pandas:** `DataFrame` 및 `Series` 다루기, 데이터 불러오기/저장, 데이터 정제, 그룹화 및 집계
- **Matplotlib/Seaborn:** 데이터를 시각화하는 기본 차트(라인, 바, 히스토그램, 산점도) 그리기
- **객체 지향 프로그래밍 (OOP) 기초:** 클래스와 객체의 개념 이해

**추천 연습 문제:**
- `python_basics_practice.md`의 Part 3 문제
- Kaggle의 초급 데이터셋을 이용한 간단한 데이터 탐색 및 시각화 프로젝트

---

## 3. AI 전문가 경로 (Advanced Path)

**목표:** 머신러닝 및 딥러닝 모델을 직접 구현하고, 관련 프레임워크 사용에 능숙해집니다.

**학습 내용:**
- **Scikit-learn (머신러닝):**
  - 분류(Classification), 회귀(Regression), 군집화(Clustering) 모델 학습 및 평가
  - 교차 검증, 하이퍼파라미터 튜닝 등 모델 성능 개선 기법
- **TensorFlow / PyTorch (딥러닝):**
  - 딥러닝 프레임워크의 기본 텐서 조작
  - 간단한 신경망(ANN), 합성곱 신경망(CNN), 순환 신경망(RNN) 모델 구축
- **API 및 웹 프레임워크 기초 (Flask/FastAPI):**
  - 학습된 모델을 서빙하기 위한 간단한 API 서버 구축

**추천 프로젝트:**
- Scikit-learn을 이용한 캐글 경진대회 참여
- 자신만의 이미지 분류기 또는 텍스트 생성기 만들기
- 간단한 머신러닝 모델 API로 배포하기 