# AI 학습을 위한 실제 산업 데이터셋 추천

이 문서는 AI 모델 개발 및 데이터 분석 프로젝트에 활용할 수 있는 실제 산업 분야의 공개 데이터셋 5가지를 추천합니다. 각 데이터셋은 특성과 활용 분야가 달라 다양한 실습 경험을 제공합니다.

---

## 1. E-commerce: Online Retail II UCI

- **분야:** 전자상거래, 고객 분석 (Customer Analytics), 재고 관리
- **설명:** 영국 기반의 온라인 소매업체의 2009년 12월부터 2011년 12월까지의 거래 데이터입니다. 고객별, 상품별 구매 패턴, 시간대별 매출 분석 등을 통해 고객 세분화(Customer Segmentation), 장바구니 분석(Market Basket Analysis) 등의 프로젝트를 수행할 수 있습니다.
- **주요 컬럼:** `InvoiceNo`, `StockCode`, `Description`, `Quantity`, `InvoiceDate`, `UnitPrice`, `CustomerID`, `Country`
- **링크:** [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/datasets/Online+Retail+II)
- **프로젝트 아이디어:**
  - RFM 분석을 통한 고객 세분화
  - 연관 규칙 분석(Apriori)을 이용한 상품 추천
  - 시계열 분석을 통한 매출 예측

---

## 2. Healthcare: Heart Disease UCI

- **분야:** 헬스케어, 의료 진단
- **설명:** 심장 질환 진단과 관련된 다양한 환자들의 익명화된 의료 기록입니다. 나이, 성별, 콜레스테롤 수치, 혈압 등 14개의 의학적 특성을 바탕으로 심장병 유무를 예측하는 분류(Classification) 모델을 개발하는 데 주로 사용됩니다.
- **주요 컬럼:** `age`, `sex`, `cp`(가슴 통증 유형), `trestbps`(안정 시 혈압), `chol`(콜레스테롤), `target`(심장병 유무)
- **링크:** [UCI Machine Learning Repository](https://archive.ics.uci.edu/ml/datasets/Heart+Disease)
- **프로젝트 아이디어:**
  - 로지스틱 회귀, SVM, 결정 트리 등 다양한 분류 모델 성능 비교
  - 주요 위험 인자(Feature) 분석 및 시각화

---

## 3. Finance: Credit Card Fraud Detection

- **분야:** 금융, 이상 탐지 (Anomaly Detection)
- **설명:** 유럽 카드 소지자들의 이틀간 신용카드 거래 데이터로, 극도로 불균형한 데이터셋(Imbalanced Dataset)의 특징을 가집니다. PCA 변환된 익명화된 거래 내역(`V1`~`V28`)과 거래 시간, 금액을 바탕으로 사기 거래를 탐지하는 모델을 개발합니다.
- **주요 컬럼:** `Time`, `V1`...`V28`, `Amount`, `Class` (0: 정상, 1: 사기)
- **링크:** [Kaggle](https://www.kaggle.com/mlg-ulb/creditcardfraud)
- **프로젝트 아이디어:**
  - 불균형 데이터 처리를 위한 샘플링 기법(SMOTE, Undersampling) 적용
  - Autoencoder, Isolation Forest 등을 이용한 이상 탐지 모델 개발

---

## 4. Image Recognition: CIFAR-10

- **분야:** 컴퓨터 비전, 이미지 분류
- **설명:** 10개 클래스로 분류된 60,000개의 32x32 컬러 이미지 데이터셋입니다. 비행기, 자동차, 새, 고양이 등 일상적인 사물 이미지를 분류하는 CNN(합성곱 신경망) 모델의 성능을 테스트하고 학습하는 데 표준처럼 사용됩니다.
- **클래스:** `airplane`, `automobile`, `bird`, `cat`, `deer`, `dog`, `frog`, `horse`, `ship`, `truck`
- **링크:** [Official Website](https://www.cs.toronto.edu/~kriz/cifar.html) (TensorFlow/PyTorch 등 딥러닝 프레임워크에서 직접 로드 가능)
- **프로젝트 아이디어:**
  - 직접 CNN 모델을 설계하여 이미지 분류기 만들기
  - 전이 학습(Transfer Learning)을 이용한 성능 개선

---

## 5. Natural Language Processing: IMDb Movie Reviews

- **분야:** 자연어 처리 (NLP), 감성 분석 (Sentiment Analysis)
- **설명:** 50,000개의 영화 리뷰 텍스트 데이터로, 긍정(Positive) 또는 부정(Negative) 라벨이 붙어있습니다. 텍스트 데이터를 처리하고, 이를 바탕으로 감성을 분류하는 모델을 개발하는 NLP의 대표적인 입문용 데이터셋입니다.
- **데이터 구성:** 25,000개의 훈련용 리뷰, 25,000개의 테스트용 리뷰
- **링크:** [Kaggle](https://www.kaggle.com/lakshmi25npathi/imdb-dataset-of-50k-movie-reviews) (TensorFlow Datasets 등으로도 쉽게 사용 가능)
- **프로젝트 아이디어:**
  - Bag-of-Words, TF-IDF를 이용한 텍스트 벡터화 및 분류
  - RNN, LSTM, Transformer(BERT 등) 기반의 딥러닝 감성 분석 모델 개발 