# 케이스 스터디 3: 영화 리뷰 감성 분석 (NLP)

## 1. 문제 정의 (Problem Definition)

**비즈니스 목표:** 영화 배급사나 온라인 스트리밍 플랫폼에서 사용자들이 남긴 영화 리뷰의 감성을 자동으로 분석하여, 영화에 대한 대중의 반응을 신속하게 파악하고자 합니다. 이를 통해 마케팅 전략을 수정하거나, 사용자에게 개인화된 영화를 추천하는 데 활용할 수 있습니다.

**분석 목표:** 자연어 처리(NLP) 기술을 사용하여 영화 리뷰 텍스트가 긍정적인지 부정적인지를 분류하는 머신러닝/딥러닝 모델을 개발합니다.

## 2. 데이터셋

- **데이터:** [IMDb Dataset of 50K Movie Reviews](https://www.kaggle.com/lakshmi25npathi/imdb-dataset-of-50k-movie-reviews)
- **설명:** 긍정 또는 부정 라벨이 붙은 50,000개의 영화 리뷰 텍스트 데이터. 긍정과 부정이 각각 25,000개로 균형 잡힌 데이터셋입니다.

## 3. 분석 방법론 (Methodology)

### 1단계: 텍스트 데이터 전처리
- **정제 (Cleaning):** HTML 태그, 특수 문자, 숫자 등을 제거합니다.
- **정규화 (Normalization):** 모든 텍스트를 소문자로 변환합니다.
- **불용어 처리 (Stopword Removal):** 분석에 큰 의미가 없는 단어(예: 'the', 'a', 'is')를 제거합니다.
- **어간 추출/표제어 추출 (Stemming/Lemmatization):** 단어를 기본 형태로 변환하여 단어의 수를 줄입니다. (예: 'running', 'ran' -> 'run')

### 2단계: 텍스트 벡터화 (Vectorization)
컴퓨터가 이해할 수 있도록 텍스트를 숫자 벡터로 변환합니다.
- **방법 1: Bag-of-Words (BoW)**
  - **CountVectorizer:** 단어의 등장 횟수를 기반으로 벡터를 생성합니다.
  - **TF-IDF Vectorizer:** 단어의 빈도와 문서 전반에서의 중요도를 함께 고려하여 벡터를 생성합니다.
- **방법 2: 워드 임베딩 (Word Embedding)**
  - **Word2Vec, GloVe:** 사전 훈련된 임베딩을 사용하여 단어의 의미적 관계를 벡터 공간에 표현합니다.
  - **딥러닝 모델 내 임베딩 레이어:** 모델이 텍스트 데이터를 학습하면서 스스로 최적의 임베딩을 생성하도록 합니다.

### 3단계: 모델링
- **머신러닝 접근:**
  - 벡터화된 텍스트를 입력으로 하여 로지스틱 회귀, 나이브 베이즈, 서포트 벡터 머신(SVM) 등의 모델을 학습시킵니다.
- **딥러닝 접근:**
  - **RNN/LSTM/GRU:** 순차적인 데이터(텍스트)의 특징을 잘 학습하는 순환 신경망 계열 모델을 사용합니다.
  - **1D CNN:** 텍스트에서 지역적인 특징을 추출하는 데 효과적인 합성곱 신경망을 사용합니다.
  - **Transformer (BERT 등):** 사전 훈련된 대규모 언어 모델을 파인튜닝(Fine-tuning)하여 매우 높은 성능의 분류기를 만듭니다.

### 4단계: 모델 평가
- 훈련/테스트 데이터로 분리하여 모델을 학습시키고 평가합니다.
- **평가 지표:** 정확도(Accuracy), 정밀도(Precision), 재현율(Recall), F1-Score, AUC-ROC를 사용하여 모델 성능을 종합적으로 평가합니다.
- 혼동 행렬(Confusion Matrix)을 통해 모델이 어떤 클래스를 잘 맞추고, 어떤 클래스를 어려워하는지 분석합니다.

## 4. 기대 결과 (Expected Outcome)

- **고성능 감성 분석 모델:** 주어진 영화 리뷰 텍스트의 긍정/부정을 90% 이상의 정확도로 분류하는 모델.
- **핵심 키워드 추출:** 긍정 리뷰와 부정 리뷰에서 각각 가장 중요하게 작용한 키워드(단어)들을 시각화하여, 사람들이 영화의 어떤 점을 좋아하고 싫어하는지 직관적으로 파악.
- **모델 비교 분석:** 전통적인 머신러닝 기법과 딥러닝 기법의 성능을 비교 분석하고, 문제 상황에 가장 적합한 모델을 선택한 근거를 제시하는 보고서. 