# 케이스 스터디 2: 신용카드 사기 탐지 (불균형 데이터 처리)

## 1. 문제 정의 (Problem Definition)

**비즈니스 목표:** 신용카드 회사에서 발생하는 사기 거래를 실시간으로 탐지하여 회사의 재정적 손실을 최소화하고 고객의 자산을 보호하는 것입니다. 정상 거래를 사기로 잘못 판단(False Positive)하는 것을 최소화하면서, 실제 사기 거래(True Positive)를 최대한 정확하게 식별하는 것이 중요합니다.

**분석 목표:** 극도로 불균형한 데이터셋을 효과적으로 처리하고, 머신러닝을 이용해 신용카드 거래가 정상인지 사기인지를 분류하는 정교한 모델을 개발합니다.

## 2. 데이터셋

- **데이터:** [Credit Card Fraud Detection on Kaggle](https://www.kaggle.com/mlg-ulb/creditcardfraud)
- **설명:** 유럽 카드 소지자들의 이틀간 거래 데이터. 전체 거래 중 사기 거래의 비율이 약 0.17%에 불과하여, 대표적인 불균형 데이터셋으로 꼽힙니다. 보안을 위해 대부분의 변수는 PCA로 변환되었습니다.

## 3. 분석 방법론 (Methodology)

### 1단계: 데이터 탐색 및 시각화 (EDA)
- 데이터의 클래스 분포(정상 vs 사기)를 시각화하여 데이터 불균형 정도를 확인합니다.
- 시간(`Time`) 및 거래 금액(`Amount`) 변수가 정상 거래와 사기 거래 간에 어떤 차이를 보이는지 분석합니다. `Amount` 변수는 분포가 매우 넓으므로, 로그 변환(log transformation)을 적용하여 정규화하는 것을 고려합니다.
- PCA로 변환된 `V1`~`V28` 변수들과 클래스 간의 상관관계를 확인합니다.

### 2단계: 데이터 전처리 및 분할
- `Amount` 컬럼을 `StandardScaler`나 `RobustScaler`를 이용해 스케일링합니다. `Time` 컬럼은 분석에 따라 포함하거나 제외할 수 있습니다.
- 훈련(Train) 데이터와 테스트(Test) 데이터를 분리합니다. 이 때, 원본 데이터의 클래스 비율을 유지하기 위해 `stratify` 옵션을 사용하는 것이 중요합니다.

### 3단계: 불균형 데이터 처리 및 모델링
다양한 기법을 적용하고 성능을 비교합니다.
- **방법 1: 샘플링 기법 적용**
  - **언더샘플링 (Undersampling):** 다수 클래스인 정상 거래 데이터의 수를 줄여 사기 거래 데이터 수와 맞춥니다. 데이터 손실이 발생할 수 있습니다.
  - **오버샘플링 (Oversampling):** 소수 클래스인 사기 거래 데이터를 복제하거나 새롭게 생성하여 데이터 수를 늘립니다. **SMOTE(Synthetic Minority Over-sampling Technique)**가 대표적입니다.
- **방법 2: 모델의 가중치 조절 (Cost-Sensitive Learning)**
  - 분류 모델(예: `LogisticRegression`, `XGBoost`) 학습 시, 소수 클래스에 더 높은 가중치(`scale_pos_weight` 또는 `class_weight='balanced'`)를 부여하여 모델이 사기 거래를 더 중요하게 학습하도록 만듭니다.

### 4단계: 모델 평가
- **평가 지표 선택:** 정확도(Accuracy)는 불균형 데이터에서 모델 성능을 제대로 평가하지 못합니다. 대신 **정밀도(Precision), 재현율(Recall), F1-Score, 그리고 AUC-ROC**를 핵심 평가지표로 사용합니다.
  - **재현율(Recall):** 실제 사기 거래 중에서 모델이 사기라고 예측한 비율. (가장 중요할 수 있음)
  - **AUC-ROC:** 모델의 전반적인 분류 성능을 나타내는 지표.
- Precision-Recall 커브를 시각화하여 임계값(Threshold) 변화에 따른 모델 성능을 분석합니다.

## 4. 기대 결과 (Expected Outcome)

- **최적의 사기 탐지 모델:** 다양한 샘플링 기법과 모델 파라미터를 테스트하여 재현율과 AUC가 가장 높은 모델을 선정.
- **성능 보고서:** 선택된 모델의 평가 지표(Confusion Matrix, Precision, Recall, F1-score, AUC)를 포함한 상세 성능 분석 리포트.
- **실시간 적용 방안:** 개발된 모델을 실제 거래 시스템에 통합하기 위한 기술적 요구사항 및 임계값 설정 전략 제안. 