# 케이스 스터디 1: 전자상거래 고객 세분화 (RFM 분석)

## 1. 문제 정의 (Problem Definition)

**비즈니스 목표:** 온라인 소매점의 한정된 마케팅 리소스를 효율적으로 활용하기 위해, 고객을 가치에 따라 그룹으로 나누고 각 그룹에 맞는 맞춤형 마케팅 전략을 수립하고자 합니다. "가장 가치 있는 고객(VIP)은 누구인가?", "어떤 고객이 이탈할 가능성이 높은가?" 등의 질문에 답하는 것을 목표로 합니다.

**분석 목표:** RFM(Recency, Frequency, Monetary) 모델을 사용하여 고객을 세분화하고, 각 고객 그룹의 특성을 파악하여 비즈니스 인사이트를 도출합니다.

## 2. 데이터셋

- **데이터:** [Online Retail II UCI Dataset](https://archive.ics.uci.edu/ml/datasets/Online+Retail+II)
- **설명:** 영국의 온라인 소매업체의 2년간의 거래 데이터.

## 3. 분석 방법론 (Methodology)

### 1단계: 데이터 전처리 (Data Preprocessing)
- 데이터 로드 및 기본 정보 확인 (`.info()`, `.describe()`).
- 결측치 처리: `CustomerID`가 없는 데이터는 고객 식별이 불가능하므로 제거합니다.
- 데이터 타입 변환: `InvoiceDate`를 datetime 형식으로 변환합니다.
- 불필요한 데이터 제거: 반품 거래(`InvoiceNo`가 'C'로 시작)는 분석에서 제외합니다.
- `Monetary` 계산: `Quantity`와 `UnitPrice`를 곱하여 총 거래 금액(`TotalPrice`) 컬럼을 생성합니다.

### 2단계: RFM 지표 계산
분석의 기준이 될 현재 날짜(오늘)를 가장 마지막 거래일 다음 날로 가정합니다.
- **Recency (최신성):** 각 고객의 마지막 구매일로부터 기준일까지 며칠이 지났는지 계산합니다. (값이 작을수록 좋음)
- **Frequency (빈도):** 각 고객이 얼마나 자주 구매했는지, 즉 총 거래 횟수(고유 `InvoiceNo` 개수)를 계산합니다. (값이 클수록 좋음)
- **Monetary (금액):** 각 고객이 총 얼마를 지출했는지, 즉 `TotalPrice`의 합계를 계산합니다. (값이 클수록 좋음)

### 3단계: RFM 점수화 및 고객 세분화
- 계산된 R, F, M 값을 기준으로 각 고객에게 등급(예: 1~5점)을 부여합니다. (e.g., Recency는 낮을수록 높은 점수, F/M은 높을수록 높은 점수).
- 각 고객의 R, F, M 점수를 조합하여 최종 RFM 점수를 생성하거나, 각 점수를 문자열처럼 이어 붙여 'RFM Segment'를 만듭니다.
- RFM 점수를 기반으로 고객을 의미 있는 그룹(예: 'VIP', '충성 고객', '잠재 고객', '이탈 위험 고객')으로 나눕니다.

### 4단계: 결과 분석 및 시각화
- 각 고객 그룹의 크기와 평균 R, F, M 값을 시각화하여 그룹별 특징을 비교합니다.
- 그룹별 주요 구매 상품이나 국가 분포 등 추가적인 분석을 통해 각 세그먼트에 대한 깊은 이해를 도모합니다.

## 4. 기대 결과 (Expected Outcome)

- **고객 세그먼트 프로필:** 각 고객 그룹(VIP, 이탈 위험 고객 등)의 인구통계학적, 행동적 특성을 정의한 프로필.
- **전략적 제안:**
  - **VIP/충성 고객:** 신제품 우선 체험 기회, 특별 할인 등 로열티 강화 프로그램 제안.
  - **잠재 고객:** 첫 구매 유도 쿠폰, 관련 상품 추천 등 활성화 전략 제안.
  - **이탈 위험 고객:** 할인 쿠폰 제공, 특별 관심 표현 등 재방문 유도(Re-engagement) 전략 제안. 