# GitHub을 활용한 실시간 멘토 피드백 시스템 가이드

이 문서는 캡스톤 프로젝트 진행 중 GitHub의 Issue와 Pull Request(PR) 기능을 활용하여 멘토와 효율적으로 소통하고 피드백을 받는 방법을 안내합니다.

---

## 왜 GitHub을 사용하나요?

- **중앙화된 기록:** 모든 질문, 답변, 코드 변경 요청이 프로젝트 저장소에 투명하게 기록됩니다.
- **비동기 소통:** 멘토와 학생이 서로 다른 시간에 작업하더라도 편하게 질문하고 답변할 수 있습니다.
- **코드 기반 논의:** 실제 코드 변경 사항을 보며 구체적인 피드백을 주고받을 수 있어 매우 효율적입니다.

---

## 1. Issue를 통한 주간 보고 및 질의응답

**목적:** 매주 진행 상황을 멘토에게 보고하고, 프로젝트 진행 중 발생하는 질문이나 문제점을 해결합니다.

### 주간 보고 방법
1. 프로젝트 GitHub 저장소의 **'Issues'** 탭으로 갑니다.
2. **'New issue'** 버튼을 클릭합니다.
3. **제목(Title):** `[주간 보고] O주차 홍길동` 과 같은 형식으로 작성합니다.
4. **내용(Content):** 아래 템플릿을 사용하여 내용을 작성합니다.
   ```markdown
   ## 이번 주 진행 상황
   - (예시) 마일스톤 2의 EDA를 완료하고, 데이터에서 주요 인사이트 3가지를 발견했습니다.
   - (예시) 모델링을 시작하여 로지스틱 회귀 기준 모델을 구현했습니다.

   ## 다음 주 계획
   - (예시) SVM, XGBoost 등 추가 모델을 구현하고 성능을 비교할 예정입니다.
   - (예시) 모델 성능이 낮을 경우, 특성 공학(feature engineering)을 추가로 시도할 계획입니다.

   ## 문제점 및 질문
   - (예시) 모델 성능 평가 시, 정확도(Accuracy) 외에 어떤 지표를 중점적으로 봐야 할까요?
   - (예시) 데이터 불균형이 심한데, SMOTE를 적용하는 것이 좋을지, 가중치 조절(class weight) 방식이 좋을지 조언을 구합니다.
   ```
5. **'Submit new issue'** 를 클릭하여 이슈를 등록합니다. 멘토가 이슈를 확인하고 댓글로 피드백을 제공할 것입니다.

---

## 2. Pull Request(PR)를 통한 코드 리뷰

**목적:** 주요 코드 작성이 완료되었을 때, 멘토에게 코드 리뷰를 요청하여 코드의 품질을 높이고 잠재적인 문제를 미리 발견합니다.

### 코드 리뷰 요청 방법
1. **새로운 브랜치(Branch) 생성:** 코드 작업을 시작하기 전에, `main` 또는 `master` 브랜치에서 새로운 기능 브랜치(feature branch)를 만듭니다. (예: `feature/add-eda-notebook`)
   ```bash
   git checkout -b feature/add-eda-notebook
   ```
2. **코드 작업 및 커밋(Commit):** 새로운 브랜치에서 코드를 작성하거나 수정한 후, 변경 사항을 커밋합니다.
   ```bash
   git add .
   git commit -m "feat: EDA 노트북 및 시각화 코드 추가"
   ```
3. **브랜치 푸시(Push):** 작업한 브랜치를 원격 저장소(GitHub)에 푸시합니다.
   ```bash
   git push origin feature/add-eda-notebook
   ```
4. **Pull Request 생성:**
   - GitHub 저장소로 이동하면, 방금 푸시한 브랜치에 대한 Pull Request를 생성하라는 노란색 알림이 뜹니다. **'Compare & pull request'** 버튼을 클릭합니다.
   - **제목(Title):** 변경 사항을 요약하는 제목을 작성합니다. (예: `EDA 및 기준 모델 구현 코드 리뷰 요청`)
   - **내용(Content):** 어떤 작업을 했는지, 멘토가 어떤 부분을 중점적으로 봐주었으면 하는지 상세히 작성합니다.
   - **Reviewers:** 오른쪽 사이드바에서 멘토의 GitHub 계정을 리뷰어로 지정합니다.
5. **'Create pull request'** 를 클릭하여 PR을 생성합니다. 멘토는 'Files changed' 탭에서 코드 변경 사항을 직접 보며 댓글로 피드백을 남길 수 있습니다. 