# 캡스톤 프로젝트 단계별 마일스톤 가이드

이 문서는 성공적인 AI 캡스톤 프로젝트 완수를 위한 단계별 가이드입니다. 각 마일스톤을 순서대로 따라가며 프로젝트를 체계적으로 진행하세요.

---

## 마일스톤 1: 프로젝트 정의 및 계획 (1-2주차)

**목표:** 해결하고자 하는 문제를 명확히 정의하고, 구체적인 프로젝트 계획을 수립합니다.

**수행 과제:**
- **[ ] 문제 정의:** 풀고 싶은 실제 문제나 아이디어를 구체화합니다.
- **[ ] 목표 설정:** 프로젝트를 통해 달성하고자 하는 SMART(구체적, 측정 가능, 달성 가능, 관련성 높은, 시간 기반) 목표를 설정합니다.
- **[ ] 데이터 소스 확보:** 사용할 데이터셋을 탐색하고, 확보 계획을 세웁니다. (공개 데이터셋, 웹 크롤링, 자체 수집 등)
- **[ ] 기술 스택 선정:** 사용할 프로그래밍 언어, 라이브러리, 프레임워크를 결정합니다.
- **[ ] 프로젝트 제안서 작성:** 위 내용을 담은 1-2페이지 분량의 제안서를 작성하여 제출합니다.

**결과물:** 프로젝트 제안서 (Project Proposal)

---

## 마일스톤 2: 데이터 수집 및 탐색 (3-4주차)

**목표:** 데이터를 수집하고, 데이터의 특성을 깊이 있게 이해합니다.

**수행 과제:**
- **[ ] 데이터 수집:** 계획에 따라 데이터를 수집합니다.
- **[ ] 데이터 정제 (Cleaning):** 결측치, 이상치, 중복 데이터를 처리합니다.
- **[ ] 탐색적 데이터 분석 (EDA):** 데이터의 분포, 변수 간의 관계 등을 시각화하고 통계적으로 분석하여 인사이트를 도출합니다.
- **[ ] EDA 보고서 작성:** 분석 과정과 발견한 점을 요약한 보고서를 작성합니다.

**결과물:** 정제된 데이터셋, EDA 보고서

---

## 마일스톤 3: 모델링 및 실험 (5-7주차)

**목표:** 정의한 문제에 적합한 모델을 설계, 훈련하고 성능을 평가합니다.

**수행 과제:**
- **[ ] 기준 모델(Baseline Model) 설정:** 비교 기준으로 삼을 간단한 모델을 먼저 구현합니다.
- **[ ] 모델 설계 및 구현:** 더 정교한 머신러닝 또는 딥러닝 모델을 설계하고 코드로 구현합니다.
- **[ ] 모델 훈련 및 하이퍼파라미터 튜닝:** 준비된 데이터로 모델을 훈련시키고, 최적의 성능을 내기 위해 하이퍼파라미터를 조정합니다.
- **[ ] 모델 평가:** 설정한 평가지표(예: 정확도, F1-score, MSE)에 따라 모델의 성능을 객관적으로 평가하고, 기준 모델과 비교 분석합니다.

**결과물:** 훈련된 모델 코드, 실험 결과 및 성능 분석 보고서

---

## 마일스톤 4: 결과 분석 및 시스템 통합 (8-9주차)

**목표:** 모델의 예측 결과를 분석하고, 실제 사용 가능한 형태로 시스템을 개발합니다.

**수행 과제:**
- **[ ] 결과 해석:** 모델이 왜 그렇게 예측했는지 해석하고, 비즈니스 관점에서의 의미를 분석합니다. (예: SHAP, LIME 사용)
- **[ ] 프로토타입 개발:** (선택사항) 모델을 활용한 간단한 웹 애플리케이션, API, 또는 데모용 스크립트를 개발합니다.
- **[ ] 최종 보고서 초안 작성:** 프로젝트의 전 과정(문제 정의, 데이터, 모델링, 결과)을 상세히 기술한 최종 보고서의 초안을 작성합니다.

**결과물:** 최종 보고서 초안, 작동하는 프로토타입 또는 데모

---

## 마일스톤 5: 최종 발표 및 제출 (10주차)

**목표:** 프로젝트의 성과를 명확하고 설득력 있게 전달합니다.

**수행 과제:**
- **[ ] 발표 자료 제작:** 프로젝트의 핵심 내용을 요약한 발표 슬라이드를 제작합니다.
- **[ ] 최종 보고서 완성:** 초안을 수정하고 보완하여 최종 보고서를 완성합니다.
- **[ ] 코드 제출:** 잘 정리되고 주석이 달린 전체 코드를 제출합니다.
- **[ ] 최종 발표:** 정해진 시간에 맞춰 프로젝트 결과를 발표하고 질의응답을 진행합니다.

**결과물:** 최종 발표 슬라이드, 최종 보고서, 프로젝트 전체 코드 