# AI 강의 학습 자료 모음

이 디렉터리는 AI 강의에 필요한 모든 학습 자료들을 체계적으로 정리한 곳입니다.

## 📁 디렉터리 구조

```
ai_lecture/resources/
├── practice_exercises/          # 연습 문제
├── infographics/               # 시각적 학습 자료
├── case_studies/               # 케이스 스터디 및 데이터셋
├── mlops_examples/             # MLOps 실습 예제
├── capstone_guide/             # 캡스톤 프로젝트 가이드
└── learning_paths.md           # 학습 경로 가이드
```

---

## 🐍 파이썬 기초 및 연습

### 📝 연습 문제
- **[파이썬 기초 연습 문제](practice_exercises/python_basics_practice.md)** - 15개의 단계별 연습 문제
  - Part 1: 변수와 자료형 (문제 1-5)
  - Part 2: 제어문 (문제 6-10)
  - Part 3: 함수와 라이브러리 활용 (문제 11-15)

### 📊 시각적 학습 자료
- **[파이썬 데이터 구조](infographics/python_data_structures.md)** - 리스트, 튜플, 세트, 딕셔너리 비교
- **[AI, ML, DL 관계](infographics/ai_ml_dl_relationship.md)** - 인공지능 분야 관계도

### 🗺️ 학습 경로
- **[수준별 학습 경로](learning_paths.md)** - 초급/중급/고급 단계별 학습 로드맵

---

## 🤖 AI 모델 및 케이스 스터디

### 📊 데이터셋
- **[산업 데이터셋 5개](case_studies/industry_datasets.md)** - 실제 산업 분야 데이터셋 소개
  - 전자상거래: Online Retail II UCI
  - 헬스케어: Heart Disease UCI
  - 금융: Credit Card Fraud Detection
  - 컴퓨터 비전: CIFAR-10
  - 자연어 처리: IMDb Movie Reviews

### 🔍 케이스 스터디
- **[전자상거래 고객 세분화](case_studies/1_ecommerce_segmentation.md)** - RFM 분석
- **[신용카드 사기 탐지](case_studies/2_finance_fraud_detection.md)** - 불균형 데이터 처리
- **[영화 리뷰 감성 분석](case_studies/3_nlp_sentiment_analysis.md)** - NLP 텍스트 분석

---

## 🔧 MLOps 실습 예제

### 🚀 모델 서빙
- **[FastAPI 모델 서빙 예제](mlops_examples/model_serving_fastapi_example/README.md)** - 감성 분석 API 구현
  - `main.py` - FastAPI 애플리케이션
  - `Dockerfile` - 컨테이너화
  - `docker-compose.yml` - 개발 환경

### 📈 모니터링 및 재학습
- **[MLOps 모니터링 시스템](mlops_examples/monitoring_retraining/README.md)** - 모델 성능 추적
  - `monitor.py` - 성능 모니터링
  - `retrain.py` - 자동 재학습 파이프라인

### 🔄 CI/CD 파이프라인
- **[GitHub Actions CI/CD](mlops_examples/.github/workflows/ci-pipeline.yml)** - 자동화 파이프라인

---

## 🎓 캡스톤 프로젝트 가이드

### 📋 프로젝트 관리
- **[단계별 마일스톤 가이드](capstone_guide/capstone_milestone_guide.md)** - 10주 프로젝트 로드맵
- **[멘토 피드백 시스템](capstone_guide/mentor_feedback_system_guide.md)** - GitHub 기반 멘토링

### 🎤 발표 및 평가
- **[발표 가이드라인](capstone_guide/presentation_guide.md)** - 성공적인 발표를 위한 팁
- **[평가 루브릭](capstone_guide/evaluation_rubric.md)** - 100점 만점 평가 기준

---

## 🚀 빠른 시작

### 1. 파이썬 기초 학습
```bash
# 학습 경로 확인
cat learning_paths.md

# 연습 문제 풀기
cat practice_exercises/python_basics_practice.md

# 데이터 구조 학습
cat infographics/python_data_structures.md
```

### 2. AI 모델 실습
```bash
# 데이터셋 선택
cat case_studies/industry_datasets.md

# 케이스 스터디 학습
ls case_studies/*.md

# FastAPI 실습
cd mlops_examples/model_serving_fastapi_example/
python main.py
```

### 3. MLOps 실습
```bash
# 모니터링 시스템
cd mlops_examples/monitoring_retraining/
python monitor.py
python retrain.py

# CI/CD 파이프라인
cat mlops_examples/.github/workflows/ci-pipeline.yml
```

### 4. 캡스톤 프로젝트
```bash
# 마일스톤 가이드
cat capstone_guide/capstone_milestone_guide.md

# 멘토링 시스템
cat capstone_guide/mentor_feedback_system_guide.md

# 발표 준비
cat capstone_guide/presentation_guide.md
```

---

## 📞 추가 지원

- **전체 프로젝트 개요:** 루트의 `PROJECT_IMPROVEMENT_SUMMARY.md` 참조
- **문서 인덱스:** 루트의 `DOCUMENT_INDEX.md` 참조
- **기술적 문제:** 각 디렉터리의 README.md 파일 참조

---

**마지막 업데이트:** 2024년 12월  
**문서 버전:** 2.0 (체계적 정리 완료) 