# AI 전문가 양성 과정 - 통합 용어집

이 용어집은 AI 전문가 양성 과정 전체에서 사용되는 핵심 용어들을 통합하여 정리한 문서입니다.
---

## Introduction


- **객체 지향 프로그래밍 (Object-Oriented Programming, OOP)**
  - **정의**: 현실 세계의 사물이나 개념을 '객체(Object)'로 보고, 객체들의 상호작용으로 프로그램의 로직을 구성하는 프로그래밍 패러다임. 데이터(속성)와 기능(메서드)을 하나의 객체로 묶고, 캡슐화, 상속, 다형성 등의 특징을 통해 코드의 재사용성과 유지보수성을 높입니다.
  - **관련 파트**: [Part 0: 시작하며](./part_0_introduction.md), [Part 4: 파이썬 객체 지향 프로그래밍](../04_object_oriented_programming/part_4_object_oriented_programming.md)

- **머신러닝 (Machine Learning)**
  - **정의**: 명시적인 프로그램 없이 컴퓨터가 데이터로부터 학습하여 스스로 패턴을 찾고 예측이나 결정을 내릴 수 있도록 하는 인공지능의 한 분야입니다. 지도 학습, 비지도 학습, 강화 학습 등 다양한 학습 방법론을 포함합니다.
  - **관련 파트**: [Part 0: 시작하며](./part_0_introduction.md), [Part 6: 머신러닝 완전 정복](../06_machine_learning/part_6_machine_learning.md)

- **FastAPI**
  - **정의**: Python 3.7+를 기반으로 API를 구축하기 위한 현대적이고 빠른(고성능) 웹 프레임워크. 표준 파이썬 타입 힌트를 사용하여 개발자의 실수를 줄이고, 데이터 유효성 검사, 자동 API 문서 생성 등 강력한 기능을 제공합니다.
  - **비유**: '최신식 주방 시스템'. 주문(요청) 처리 속도가 매우 빠르고, 모든 레시피(코드)가 표준화되어 있으며, 손님이 직접 보고 주문할 수 있는 스마트 메뉴판(Swagger UI)이 자동으로 만들어집니다.
  - **관련 파트**: [Part 8: FastAPI를 이용한 모델 서빙](../08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md)

- **도커 (Docker)**
  - **정의**: 애플리케이션과 그 실행에 필요한 모든 것(라이브러리, 시스템 도구, 코드, 런타임 등)을 '컨테이너'라는 격리된 공간에 패키징하여, 어떤 환경에서든 동일하게 실행될 수 있도록 하는 플랫폼. "제 컴퓨터에서는 되는데요?" 문제를 해결하는 핵심 기술입니다. **도커 이미지(Image)는 애플리케이션 실행에 필요한 모든 것을 담은 설계도이며, 이 이미지를 실행한 인스턴스가 컨테이너(Container)입니다. 하나의 이미지를 사용해 여러 컨테이너를 생성할 수 있습니다.**
  - **비유**: '어디서든 똑같은 맛을 내는 밀키트'. 애플리케이션의 모든 재료와 레시피를 밀키트(**이미지**)로 만들어, 어떤 주방(서버)에서 조리하든 항상 동일한 결과물(**컨테이너**)을 보장합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](../01_ai_development_environment/part_1_ai_development_environment.md), [Part 9: 프로덕션 레벨 API와 Docker](../09_production_ready_api/part_9_production_ready_api.md)

- **캡스톤 프로젝트 (Capstone Project)**
  - **정의**: 교육 과정에서 배운 모든 이론, 기술, 경험을 총동원하여 실제적인 문제 해결 능력을 보여주는 최종 프로젝트. 기획부터 개발, 배포, 발표까지 전 과정을 직접 수행하며 실무 역량을 종합적으로 증명하는 기회입니다.
  - **관련 파트**: [Part 0: 시작하며](./part_0_introduction.md), [Part 15: 캡스톤 프로젝트](../15_capstone_project/part_15_capstone_project.md)

- **파이썬 (Python)**
  - **정의**: 간결하고 읽기 쉬운 문법을 가진 고급 프로그래밍 언어. 방대한 라이브러리 생태계 덕분에 웹 개발, 데이터 분석, 인공지능, 자동화 등 다양한 분야에서 널리 사용됩니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](../02_python_core_syntax/part_2_python_core_syntax.md)

- **NumPy (넘파이)**
  - **정의**: Numerical Python의 약자로, 파이썬에서 고성능 과학 계산과 수치 연산을 위한 핵심 라이브러리. `ndarray`라는 효율적인 다차원 배열 객체를 제공하여, 벡터 및 행렬 연산을 매우 빠르게 처리할 수 있습니다. Pandas, Scikit-learn, PyTorch 등 대부분의 AI 라이브러리의 기반이 되는 기술입니다.
  - **비유**: '계란판'. 모든 데이터를 동일한 타입의 숫자(계란)으로 취급하여, '모든 계란에 도장 찍기'와 같은 동일한 연산을 매우 빠른 속도로 처리할 수 있습니다.
  - **관련 파트**: [Part 5: AI 핵심 라이브러리](../05_ai_core_libraries/part_5_ai_core_libraries.md)

- **Pandas (판다스)**
  - **정의**: 파이썬에서 구조화된 데이터를 쉽고 직관적으로 다룰 수 있도록 설계된 핵심 데이터 분석 라이브러리. `DataFrame`과 `Series`라는 강력한 데이터 구조를 제공하여, 데이터 정제, 변환, 분석, 시각화 등 데이터 처리의 전 과정을 효율적으로 수행할 수 있게 돕습니다.
  - **비유**: '데이터용 엑셀'. 행과 열로 이루어진 데이터를 정렬, 필터링, 그룹화하는 등 복잡한 데이터 조작을 몇 줄의 코드로 수행할 수 있습니다.
  - **관련 파트**: [Part 5: AI 핵심 라이브러리](../05_ai_core_libraries/part_5_ai_core_libraries.md)

- **Scikit-learn (사이킷런)**
  - **정의**: 파이썬을 대표하는 머신러닝 라이브러리. 분류, 회귀, 군집화, 차원 축소 등 다양한 머신러닝 알고리즘과 데이터 전처리, 모델 평가 등을 위한 도구를 제공하여 누구나 쉽게 머신러닝 모델을 개발할 수 있도록 돕습니다.
  - **관련 파트**: [Part 6: 머신러닝 완전 정복](../06_machine_learning/part_6_machine_learning.md)

- **딥러닝 (Deep Learning)**
  - **정의**: 여러 계층의 인공 신경망(Artificial Neural Network)을 사용하여 복잡한 데이터에서 고수준의 특징을 자동으로 학습하는 머신러닝의 한 분야. 이미지 인식, 자연어 처리, 음성 인식 등 다양한 분야에서 혁신적인 성과를 보여주고 있습니다.
  - **관련 파트**: [Part 7: 딥러닝 첫걸음](../07_deep_learning/part_7_deep_learning.md)

- **API (Application Programming Interface)**
  - **정의**: 응용 프로그램에서 사용할 수 있도록, 운영 체제나 프로그래밍 언어가 제공하는 기능을 제어할 수 있게 만든 인터페이스. 쉽게 말해, 서로 다른 프로그램이나 서비스가 약속된 규칙에 따라 정보를 주고받을 수 있도록 하는 '소통 창구'입니다.
  - **비유**: '레스토랑의 메뉴판과 주문 시스템'. 손님(클라이언트)은 주방(서버) 내부를 몰라도, 정해진 메뉴판(API 명세)을 보고 주문(요청)하면 원하는 음식(결과)을 받을 수 있습니다.
  - **관련 파트**: [Part 8: FastAPI를 이용한 모델 서빙](../08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md)

- **AI 에이전트 (AI Agent)**
  - **정의**: 단순히 주어진 질문에 한 번 답하고 끝나는 것이 아니라, 목표를 달성하기 위해 스스로 계획을 세우고, 도구를 사용하며, 스스로 피드백하고 수정하는 과정을 반복하는 지능형 시스템.
  - **관련 파트**: [Part 13: 생성형 AI와 자율 에이전트](../13_generative_ai/part_13_generative_ai.md)

- **에이전틱 워크플로우 (Agentic Workflow)**
  - **정의**: AI 에이전트가 목표를 달성하기 위해 사용하는 자율적인 작업 흐름. 계획 수립, 도구 사용, 실행, 결과 분석, 계획 수정 등의 단계를 반복하며 복잡한 문제를 해결합니다.
  - **관련 파트**: [Part 13: 생성형 AI와 자율 에이전트](../13_generative_ai/part_13_generative_ai.md)

- **Google Colab (구글 코랩)**
  - **정의**: 구글에서 제공하는 클라우드 기반의 무료 Jupyter 노트북 환경. 별도의 개발 환경 설정 없이 웹 브라우저만으로 파이썬 코드를 작성하고 실행할 수 있으며, 특히 무료로 GPU 가속을 사용할 수 있어 머신러닝 및 딥러닝 모델 학습에 매우 유용합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](../01_ai_development_environment/part_1_ai_development_environment.md) 
---

## Ai Development Environment


- **가상환경 (Virtual Environment)**
  - **정의**: 프로젝트별로 독립된 파이썬 실행 환경을 만들어주는 도구. 각 프로젝트가 필요로 하는 라이브러리 버전 간의 충돌을 방지하고, 프로젝트의 의존성을 깔끔하게 관리할 수 있도록 돕습니다. 파이썬에서는 `venv`, `conda` 등이 대표적인 가상환경 관리 도구입니다.
  - **비유**: 프로젝트마다 별도의 '격리된 작업실'을 만들어, 각 작업실에 필요한 도구(라이브러리)들만 설치하여 서로 영향을 주지 않도록 하는 것과 같습니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **패키지 (Package)**
  - **정의**: 특정 목적과 관련된 여러 파이썬 모듈들을 모아놓은 디렉토리 구조. 패키지를 통해 관련된 코드들을 체계적으로 관리하고 재사용할 수 있습니다. `pip`는 파이썬의 공식 패키지 관리자로, PyPI(Python Package Index)에 등록된 수많은 패키지들을 쉽게 설치하고 관리할 수 있게 해줍니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **pip**
  - **정의**: 파이썬의 공식 패키지 관리 시스템. PyPI(Python Package Index)에 호스팅된 소프트웨어 패키지를 설치하고 관리하는 데 사용됩니다. `pip install <package_name>` 명령어로 라이브러리를 쉽게 설치할 수 있습니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **의존성 관리 (Dependency Management)**
  - **정의**: 프로젝트가 올바르게 실행되기 위해 필요한 외부 라이브러리(패키지)와 그 버전을 관리하는 작업. 파이썬에서는 `requirements.txt` 파일을 통해 프로젝트의 모든 의존성을 명시하고, `pip install -r requirements.txt` 명령어로 한 번에 설치하여 어떤 환경에서든 동일한 개발 환경을 재현할 수 있도록 합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **IDE (Integrated Development Environment, 통합 개발 환경)**
  - **정의**: 코딩, 디버깅, 컴파일, 배포 등 프로그램 개발에 관련된 모든 작업을 하나의 인터페이스에서 처리할 수 있도록 도와주는 소프트웨어. 코드 자동 완성, 구문 강조, 디버거 등의 기능을 통해 개발 생산성을 크게 향상시킵니다. (예: VS Code, PyCharm)
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **Jupyter Notebook (주피터 노트북)**
  - **정의**: 코드, 텍스트(마크다운), 시각화 결과 등을 하나의 문서에 담아 대화형으로 프로그래밍할 수 있는 오픈소스 웹 애플리케이션. 코드 셀 단위 실행이 가능하여 데이터 분석, 머신러닝 모델링, 실험 기록 등 탐색적 프로그래밍에 널리 사용됩니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **커널 (Kernel)**
  - **정의**: Jupyter Notebook이나 JupyterLab과 같은 대화형 컴퓨팅 환경에서, 사용자가 작성한 코드를 실제로 해석하고 실행하는 '계산 엔진'. 각 노트북은 특정 커널(예: 특정 가상환경의 파이썬)에 연결되어, 해당 환경의 라이브러리와 설정을 사용하여 코드를 실행합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **버전 충돌 (Version Conflict)**
  - **정의**: 하나의 시스템에서 두 개 이상의 프로젝트가 동일한 라이브러리의 서로 다른 버전을 필요로 할 때 발생하는 문제. 가상환경은 각 프로젝트에 독립적인 라이브러리 설치 공간을 제공하여 이 문제를 근본적으로 해결합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md)

- **Google Colab (구글 코랩)**
  - **정의**: 구글에서 제공하는 클라우드 기반의 무료 Jupyter 노트북 환경. 별도의 개발 환경 설정 없이 웹 브라우저만으로 파이썬 코드를 작성하고 실행할 수 있으며, 특히 무료로 GPU 가속을 사용할 수 있어 머신러닝 및 딥러닝 모델 학습에 매우 유용합니다.
  - **관련 파트**: [Part 1: AI 개발 환경 완벽 구축 가이드](./part_1_ai_development_environment.md) 
---

## 자주 묻는 질문 (FAQ)

- **Q: `conda: command not found` 오류가 발생합니다.**
  - **A:** Anaconda Prompt를 사용하고 있는지 확인하거나, 쉘(bash, zsh 등)을 초기화(`conda init`)했는지 확인하세요. 자세한 해결 방법은 [메인 가이드의 트러블슈팅 섹션](./part_1_ai_development_environment.md#7-자주-묻는-질문faq-및-트러블슈팅-troubleshooting)을 참고하세요.

- **Q: Jupyter Notebook에서 '커널 오류(Kernel Error)'가 발생합니다.**
  - **A:** 현재 가상환경에 `ipykernel` 패키지가 설치되어 있는지 확인하고(`conda install ipykernel`), 필요하다면 가상환경을 Jupyter 커널로 직접 등록해주세요. 자세한 해결 방법은 [메인 가이드의 트러블슈팅 섹션](./part_1_ai_development_environment.md#7-자주-묻는-질문faq-및-트러블슈팅-troubleshooting)을 참고하세요.

- **Q: VS Code에서 가상환경이 제대로 인식되지 않습니다.**
  - **A:** `Ctrl+Shift+P`를 눌러 `Python: Select Interpreter`를 실행하고, 사용하려는 `conda` 가상환경을 직접 선택했는지 확인하세요. 
---

## Python Core Syntax


- **변수 (Variable)**
  - **정의**: 특정 값을 저장하기 위해 이름을 붙인 메모리 공간. 변수에 저장된 값은 프로그램 실행 중에 변경될 수 있습니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **자료형 (Data Type)**
  - **정의**: 프로그래밍 언어에서 다룰 수 있는 데이터의 종류. 파이썬의 기본 자료형에는 숫자형(`int`, `float`), 문자열(`str`), 불리언(`bool`) 등이 있습니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **숫자형 (Numeric Types)**
  - **정의**: 숫자를 나타내는 자료형.
    - **정수 (Integer, `int`)**: `1`, `100`, `-5` 같이 소수점이 없는 숫자.
    - **실수 (Float)**: `3.14`, `-0.5` 같이 소수점이 있는 숫자.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **문자열 (String, `str`)**
  - **정의**: `'Hello'`, `"Python"`과 같이 따옴표로 감싼 글자들의 나열(시퀀스). 텍스트 데이터를 표현하는 데 사용됩니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **불리언 (Boolean, `bool`)**
  - **정의**: `True`(참)와 `False`(거짓) 두 가지 값만 가지는 자료형. 주로 조건문의 결과를 표현하는 데 사용됩니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **리스트 (List)**
  - **정의**: 여러 개의 값을 순서대로 저장하는 파이썬의 대표적인 자료구조. 대괄호(`[]`)를 사용하여 생성하며, 저장된 값(요소)들은 변경 가능(mutable)하고, 중복된 값을 허용합니다. 인덱스를 통해 각 요소에 접근할 수 있습니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md), [Part 3: 파이썬 컬렉션 심화](../03_python_collections/part_3_python_collections.md)

- **튜플 (Tuple)**
  - **정의**: 여러 개의 값을 순서대로 저장하는 파이썬의 대표적인 자료구조. 소괄호(`()`)를 사용하여 생성하며, 저장된 값(요소)들은 변경 불가능(immutable)합니다. 인덱스를 통해 각 요소에 접근할 수 있습니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md), [Part 3: 파이썬 컬렉션 심화](../03_python_collections/part_3_python_collections.md)

- **딕셔너리 (Dictionary, `dict`)**
  - **정의**: 키(Key)와 값(Value)을 하나의 쌍으로 묶어 저장하는 파이썬의 자료구조. 각 키는 고유해야 하며, 키를 통해 해당 값을 빠르게 찾거나 수정, 삭제할 수 있습니다. 중괄호(`{}`)를 사용하여 생성하며, 데이터의 순서가 중요하지 않고 의미 있는 이름으로 데이터에 접근하고 싶을 때 유용합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md), [Part 3: 파이썬 컬렉션 심화](../03_python_collections/part_3_python_collections.md)

- **셋 (Set)**
  - **정의**: 중복을 허용하지 않는, 순서 없는 요소들의 모음. 중괄호(`{}`)나 `set()` 함수로 생성합니다. 주로 데이터의 중복을 제거하거나, 멤버십 테스트(특정 요소의 존재 여부 확인), 집합 연산(합집합, 교집합 등)에 사용됩니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **제어문 (Control Flow Statement)**
  - **정의**: 프로그램의 실행 흐름을 특정 조건이나 반복에 따라 제어하는 구문.
    - **조건문 (`if`, `elif`, `else`)**: 주어진 조건의 참/거짓에 따라 다른 코드 블록을 실행합니다.
    - **반복문 (`for`, `while`)**: 특정 코드 블록을 여러 번 반복해서 실행합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **들여쓰기 (Indentation)**
  - **정의**: 파이썬에서 코드 블록의 시작과 끝을 나타내는 문법적 요소. 다른 언어들이 중괄호(`{}`) 등을 사용하는 것과 달리, 파이썬은 동일한 수의 공백(일반적으로 스페이스 4칸)을 사용하여 코드의 논리적 구조와 종속 관계를 표현합니다. 올바른 들여쓰기는 파이썬 코드의 가독성을 높이고 문법 오류를 방지하는 데 매우 중요합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **함수 (Function)**
  - **정의**: 특정 작업을 수행하는 코드 블록에 이름을 붙인 것. 코드를 재사용하고, 프로그램을 모듈화하여 구조를 더 명확하게 만드는 데 사용됩니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **매개변수 (Parameter)와 인자 (Argument)**
  - **정의**:
    - **매개변수 (Parameter)**: 함수를 정의할 때, 함수가 호출될 때 전달받을 값을 담기 위해 선언하는 변수 이름. 함수의 '입력 인터페이스' 역할을 합니다.
    - **인자 (Argument)**: 함수를 호출할 때, 매개변수에 실제로 전달되는 값.
  - **예시**: `def add(a, b): # a, b는 매개변수` / `add(3, 5) # 3, 5는 인자`
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **반환 값 (Return Value)**
  - **정의**: 함수가 `return` 키워드를 사용하여 자신의 실행 결과를 호출한 쪽으로 돌려주는 값. 함수는 특정 계산을 수행한 뒤 그 결과를 반환하여 다른 변수에 저장하거나 다른 연산에 사용될 수 있게 합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **리스트 컴프리헨션 (List Comprehension)**
  - **정의**: 기존 리스트나 다른 순회 가능한(iterable) 객체로부터 새로운 리스트를 간결하고 효율적으로 생성하는 파이썬의 기능. `for` 반복문과 `if` 조건문을 한 줄로 표현하여 가독성 높고 파이썬다운(Pythonic) 코드를 작성할 수 있게 합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md)

- **슬라이싱 (Slicing)**
  - **정의**: 리스트, 튜플, 문자열 등 순서가 있는 시퀀스 자료형의 일부를 잘라내어 새로운 시퀀스를 만드는 기능. `시퀀스[시작:끝:간격]` 형태로 사용합니다.
  - **관련 파트**: [Part 2: 파이썬 핵심 문법](./part_2_python_core_syntax.md) 
---

## Python Collections


- **자료구조 (Data Structure)**
  - **정의**: 프로그램에서 데이터를 효율적으로 저장, 관리, 처리하기 위한 구조. 데이터의 특성과 사용 목적에 맞는 적절한 자료구조를 선택하는 것은 알고리즘의 성능에 큰 영향을 미칩니다. (예: 리스트, 튜플, 딕셔너리, 셋)
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md)

- **튜플 언패킹 (Tuple Unpacking)**
  - **정의**: 튜플이나 리스트 같은 시퀀스의 각 요소를 여러 변수에 한 번에 할당하는 기능. 코드의 가독성을 높이고 간결하게 만들어줍니다. `*`를 사용하면 나머지 요소들을 리스트로 묶어 받을 수도 있습니다.
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md)

- **`collections.Counter`**
  - **정의**: 리스트나 문자열과 같은 순회 가능한(iterable) 객체 안의 요소들의 개수를 세어 딕셔너리 형태로 반환하는 특수 컨테이너. `most_common()` 메서드를 통해 가장 빈번하게 등장하는 요소를 쉽게 찾을 수 있습니다.
  - **비유**: '똑똑한 재고 관리인'. 각 항목이 몇 개 있는지 자동으로 세고, 가장 인기 있는 상품이 무엇인지 즉시 알려줍니다.
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md)

- **`collections.defaultdict`**
  - **정의**: 딕셔너리를 생성할 때 키(key)가 없을 경우의 기본값을 미리 지정할 수 있는 특수 컨테이너. 존재하지 않는 키에 접근할 때 `KeyError`를 발생시키는 대신, 지정된 기본값(예: `int`->0, `list`->[])을 자동으로 생성하여 코드를 간결하게 만들어줍니다. 특히 데이터를 그룹핑할 때 유용합니다.
  - **비유**: '자동 완성 노트'. 빈 페이지에 글을 쓰려고 할 때마다 자동으로 줄을 그어주는 노트처럼, 키가 없을 때마다 기본값을 알아서 채워줍니다.
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md)

- **`collections.deque`**
  - **정의**: '덱(Deck)'이라고 읽으며, 데이터의 양쪽 끝(앞, 뒤)에서 항목을 빠르게 추가(`append`, `appendleft`)하거나 제거(`pop`, `popleft`)할 수 있도록 최적화된 리스트와 유사한 컨테이너.
  - **비유**: '양방향 고속도로 입출구'. 일반적인 일방통행 도로와 달리, 양쪽 끝에서 차가 빠르게 진입하고 빠져나갈 수 있습니다. 최근 사용 목록(LRU 캐시)이나 큐(Queue)를 구현할 때 매우 효율적입니다.
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md)

- **`collections.namedtuple`**
  - **정의**: 튜플의 각 위치에 이름을 부여하여, 인덱스뿐만 아니라 이름으로도 데이터에 접근할 수 있게 만든 튜플의 확장 버전. 코드의 가독성을 획기적으로 높여줍니다.
  - **비유**: '이름표가 붙은 칸막이 상자'. 그냥 '0번 칸'이 아니라 'x좌표 칸', 'y좌표 칸'처럼 이름으로 내용물을 명확하게 구분할 수 있습니다.
  - **관련 파트**: [Part 3: 파이썬 컬렉션 심화](./part_3_python_collections.md) 
---

## Object Oriented Programming


**[⬆️ 파트 4으로 돌아가기](./part_4_object_oriented_programming.md)**

---

## 용어 목록 (Glossary)

- [클래스 (Class)](#클래스-class)
- [객체 (Object)](#객체-object)
- [상속 (Inheritance)](#상속-inheritance)
- [다형성 (Polymorphism)](#다형성-polymorphism)
- [캡슐화 (Encapsulation)](#캡슐화-encapsulation)
- [추상화 (Abstraction)](#추상화-abstraction)
- [@dataclass](#dataclass)
- [super()](#super)
- [매직 메서드 (Magic Methods)](#매직-메서드-magic-methods)

---

### **클래스 (Class)**

- **설명**: 객체를 만들기 위한 '설계도' 또는 '청사진'입니다. 붕어빵을 만들기 위한 '붕어빵 틀'에 비유할 수 있습니다.
- **예시**: 자동차의 설계도는 '클래스'이고, 그 설계도로 만들어진 각각의 자동차는 '객체'입니다.
- **참고**: `class` 키워드를 사용하여 정의합니다.

### **객체 (Object)**

- **설명**: 클래스라는 설계도를 바탕으로 메모리에 실제로 생성된 '실체'입니다. '붕어빵 틀'에서 찍어낸 '붕어빵' 하나하나에 해당합니다.
- **예시**: `red_bean_car = Car()` 코드에서 `red_bean_car`는 `Car` 클래스의 인스턴스(객체)입니다.

### **상속 (Inheritance)**

- **설명**: 부모 클래스의 속성과 메서드를 자식 클래스가 물려받아 사용할 수 있게 하는 기능입니다. 코드의 재사용성을 높여줍니다. '기본 붕어빵 틀'의 특징을 물려받아 '피자 붕어빵 틀'을 만드는 것에 비유할 수 있습니다.
- **예시**: `Vehicle` 클래스를 `Car` 클래스가 상속받으면, `Car`는 `Vehicle`의 `move()` 메서드를 바로 사용할 수 있습니다.

### **다형성 (Polymorphism)**

- **설명**: '여러(Poly) 가지 형태(Morph)'를 가진다는 의미로, 동일한 이름의 메서드가 객체에 따라 다른 방식으로 동작하는 것을 말합니다. "주문하신 것 나왔습니다!" 라는 동일한 요청(`sell()`)에 '팥 붕어빵'과 '피자 붕어빵'이 각기 다르게 반응하는 것과 같습니다.
- **예시**: `animal.speak()` 라는 동일한 코드가 `animal` 객체가 `Dog`일 때는 '멍멍'을, `Cat`일 때는 '야옹'을 출력하게 만들 수 있습니다.

### **캡슐화 (Encapsulation)**

- **설명**: 데이터(속성)와 해당 데이터를 처리하는 메서드를 하나로 묶고, 데이터에 대한 직접적인 접근을 제한하는 기능입니다. 붕어빵의 '비밀 레시피'를 외부에서 함부로 바꾸지 못하게 숨기고, 정해진 방법으로만 레시피를 수정/조회하게 하는 것과 같습니다.
- **예시**: `private` 변수(예: `__secret_recipe`)를 선언하고, `getter`와 `setter` 메서드를 통해서만 값에 접근하도록 하여 데이터의 무결성을 지킵니다.

### **추상화 (Abstraction)**

- **설명**: 객체의 복잡한 내부 구현은 숨기고, 실제 사용에 필요한 필수적인 부분(인터페이스)만 외부에 드러내는 것입니다. 프랜차이즈 본사에서 모든 가맹점이 반드시 지켜야 할 '운영 매뉴얼'의 필수 기능(예: `bake()`)을 강제하는 것에 비유할 수 있습니다.
- **예시**: `ABC (Abstract Base Class)`를 사용하여 추상 클래스를 만들고, `@abstractmethod`로 자식 클래스가 반드시 구현해야 할 메서드를 정의합니다.

### **@dataclass**

- **설명**: 클래스 정의 위에 사용하는 데코레이터로, `__init__`, `__repr__`, `__eq__` 등 객체 초기화와 비교에 필요한 메서드들을 자동으로 생성해주는 기능입니다. 반복적인 코드를 크게 줄여줍니다.
- **예시**: `@dataclass`를 붙이기만 하면 `Book(title="...", author="...")`와 같이 바로 객체를 생성할 수 있습니다.

### **super()**

- **설명**: 자식 클래스에서 부모 클래스의 메서드를 호출할 때 사용하는 내장 함수입니다. 메서드 오버라이딩 시 부모의 원래 기능을 그대로 사용하면서 새로운 기능을 추가하고 싶을 때 유용합니다.
- **예시**: `super().attack()`를 호출하면 자식 클래스의 `attack` 메서드 내에서 부모 클래스의 `attack` 메서드를 실행할 수 있습니다.

### **매직 메서드 (Magic Methods)**

- **설명**: `__init__`, `__str__`처럼 이름 앞뒤에 더블 언더스코어(`__`)가 붙은 특수 메서드입니다. `+`, `==`, `len()` 같은 파이썬의 내장 연산자나 함수가 객체에 사용될 때의 동작을 우리가 원하는 대로 재정의(customizing)할 수 있게 해줍니다.
- **예시**: `__add__` 매직 메서드를 구현하면 두 객체를 `+` 연산자로 더할 수 있습니다. 
---

## Ai Core Libraries


**[⬆️ 파트 5으로 돌아가기](./part_5_ai_core_libraries.md)**

---

## 용어 목록 (Glossary)

- [NumPy](#numpy)
- [ndarray](#ndarray)
- [Pandas](#pandas)
- [DataFrame](#dataframe)
- [Series](#series)
- [벡터화 (Vectorization)](#벡터화-vectorization)
- [브로드캐스팅 (Broadcasting)](#브로드캐스팅-broadcasting)
- [인덱싱 (Indexing) & 필터링 (Filtering)](#인덱싱-indexing--필터링-filtering)
- [loc](#loc)
- [iloc](#iloc)
- [groupby](#groupby)
- [merge](#merge)
- [concat](#concat)
- [pivot_table](#pivot_table)

---

### **NumPy**

- **설명**: "Numerical Python"의 약자로, 파이썬에서 과학 및 수치 계산을 위한 가장 기본적인 핵심 라이브러리입니다. 고성능 다차원 배열 객체인 `ndarray`를 중심으로 벡터, 행렬 등 고성능 연산을 위한 방대한 함수를 제공합니다.

### **ndarray**

- **설명**: NumPy의 핵심 자료구조인 N-dimensional array(다차원 배열)입니다. 파이썬 리스트와 달리 동일한 자료형의 데이터만 담을 수 있어 메모리 효율이 높고, '계란판'처럼 구조가 균일하여 매우 빠른 속도로 원소 전체에 대한 연산(벡터화)이 가능합니다.

### **Pandas**

- **설명**: 행과 열로 이루어진 표 형식의 데이터(Tabular Data)를 쉽게 다룰 수 있게 해주는 데이터 분석 라이브러리입니다. `DataFrame`과 `Series`라는 강력한 자료구조를 제공하며, 데이터 정제, 처리, 분석에 필수적인 도구입니다. 기능이 강력하여 '슈퍼 엑셀'에 비유되기도 합니다.

### **DataFrame**

- **설명**: Pandas의 핵심 자료구조로, 2차원 테이블(표) 형태의 데이터를 담습니다. 행(row)과 열(column)으로 구성되며, 각 열은 서로 다른 데이터 타입을 가질 수 있습니다. 엑셀 스프레드시트나 데이터베이스 테이블과 유사한 구조입니다.

### **Series**

- **설명**: Pandas의 1차원 배열 형태의 자료구조입니다. `DataFrame`의 한 열(column)이 하나의 `Series`에 해당합니다. 데이터 배열과 함께 인덱스(index)를 가집니다.

### **벡터화 (Vectorization)**

- **설명**: 반복문을 사용하지 않고 배열의 모든 요소에 대해 한 번에 연산을 수행하는 방식입니다. NumPy가 고속으로 동작하는 핵심 원리이며, 코드를 간결하고 효율적으로 만듭니다.
- **예시**: `for` 문으로 배열의 각 원소에 2를 곱하는 대신, `numpy_array * 2` 와 같이 한 줄로 연산을 처리합니다.

### **브로드캐스팅 (Broadcasting)**

- **설명**: NumPy에서 서로 다른 크기(shape)를 가진 배열 간에도 산술 연산이 가능하도록, 특정 조건 하에 배열을 자동으로 확장하여 크기를 맞춰주는 기능입니다.
- **예시**: (3, 3) 모양의 행렬과 (3,) 모양의 벡터를 더할 때, 벡터가 행렬의 각 행에 더해지도록 자동으로 확장됩니다.

### **인덱싱 (Indexing) & 필터링 (Filtering)**

- **설명**: `DataFrame`이나 `ndarray`에서 특정 위치의 데이터를 선택하거나, 특정 조건을 만족하는 데이터 부분집합을 추출하는 작업을 의미합니다.
- **예시**: `df['age'] > 30` 와 같이 특정 조건을 만족하는 행만 걸러내는 것이 필터링입니다.

### **loc**

- **설명**: "Location"의 약자로, Pandas `DataFrame`에서 **레이블(이름)** 기반으로 데이터를 선택(indexing)하는 속성입니다. 행과 열의 이름을 직접 지정하여 데이터를 추출합니다.
- **사용법**: `df.loc[행_이름, 열_이름]`

### **iloc**

- **설명**: "Integer Location"의 약자로, Pandas `DataFrame`에서 **정수 위치(0부터 시작하는 순서)** 기반으로 데이터를 선택하는 속성입니다.
- **사용법**: `df.iloc[행_번호, 열_번호]`

### **groupby**

- **설명**: 데이터를 특정 기준으로 그룹으로 묶고(Split), 각 그룹에 특정 함수(예: `sum`, `mean`)를 적용(Apply)한 뒤, 그 결과를 하나로 합쳐서(Combine) 보여주는 기능입니다. '반별 평균 성적 계산'과 같은 집계 분석에 매우 유용합니다.

### **merge**

- **설명**: 두 `DataFrame`을 특정 공통 열(Key)을 기준으로 합치는 기능입니다. 데이터베이스의 `JOIN` 연산과 매우 유사하며, 여러 데이터 소스를 하나로 결합할 때 사용됩니다.
- **예시**: '학생 정보' 테이블과 '성적 정보' 테이블을 '학번'을 기준으로 합칠 수 있습니다.

### **concat**

- **설명**: "Concatenate"의 약자로, 여러 `DataFrame`을 행(row)이나 열(column) 방향으로 그대로 이어 붙이는 기능입니다. `merge`처럼 특정 키를 기준으로 맞추는 것이 아니라, 단순히 아래나 옆으로 데이터를 연결합니다.

### **pivot_table**

- **설명**: 엑셀의 피벗 테이블 기능처럼, `DataFrame`의 데이터를 재구성하여 새로운 관점의 요약 테이블을 만드는 기능입니다. 특정 열을 행과 열 인덱스로 사용하고, 다른 열의 데이터로 값을 채워 데이터를 요약, 분석할 수 있습니다. 
---

## Machine Learning


## 핵심 용어

| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **데이터 시각화 (Data Visualization)** | 데이터 속에 숨겨진 패턴, 관계, 추세, 이상치 등을 쉽게 파악할 수 있도록 데이터를 그래프나 차트 등 시각적인 형태로 표현하는 과정입니다. Matplotlib, Seaborn 등의 라이브러리가 사용됩니다. |
| **Matplotlib** | 파이썬에서 가장 널리 사용되는 데이터 시각화 라이브러리입니다. 거의 모든 종류의 정적, 동적, 인터랙티브 시각화를 생성할 수 있는 강력하고 유연한 기능을 제공합니다. (비유: 하얀 도화지) |
| **Seaborn** | Matplotlib을 기반으로 더 매력적이고 정보량이 풍부한 통계 그래픽을 쉽게 만들 수 있도록 하는 고수준 인터페이스를 제공하는 파이썬 시각화 라이브러리입니다. 통계적 데이터 탐색에 특히 유용합니다. (비유: 밑그림과 색칠 도구가 갖춰진 스케치북) |
| **Scikit-learn** | 파이썬을 위한 대표적인 오픈소스 머신러닝 라이브러리입니다. 분류, 회귀, 클러스터링, 차원 축소, 모델 선택, 데이터 전처리 등 다양한 머신러닝 알고리즘과 도구를 제공하며, `fit()`/`predict()`의 일관된 인터페이스를 가집니다. |
| **지도학습 (Supervised Learning)** | 머신러닝의 한 종류로, 입력 데이터(피처)와 해당 데이터의 정답(레이블)이 있는 '지도된' 데이터를 사용하여 모델을 학습시키는 방식입니다. 모델은 입력과 정답 사이의 관계를 학습하여 새로운 입력에 대한 정답을 예측합니다. |
| **훈련/테스트 분리 (Train/Test Split)** | 머신러닝 모델의 일반화 성능을 평가하기 위해 전체 데이터셋을 훈련 데이터(Training Data)와 테스트 데이터(Test Data)로 나누는 과정입니다. 모델은 훈련 데이터로 학습하고, 테스트 데이터로 성능을 평가받습니다. |
| **데이터 전처리 (Data Preprocessing)** | 원시(raw) 데이터를 머신러닝 모델에 적합한 형태로 변환하는 모든 과정을 의미합니다. 결측치 처리, 이상치 제거, 피처 스케일링, 인코딩 등이 포함되며, 모델 성능에 큰 영향을 미칩니다. "Garbage In, Garbage Out"이라는 말이 있을 정도로 중요합니다. |
| **피처 스케일링 (Feature Scaling)** | 데이터의 여러 피처(특성, 변수)들의 값 범위를 일정하게 조정하는 데이터 전처리 기법입니다. 거리 기반 알고리즘이나 경사 하강법 기반 알고리즘에서 피처 간의 단위 차이로 인해 발생하는 문제를 방지하고 모델 학습을 안정적으로 만듭니다. 대표적으로 `StandardScaler`, `MinMaxScaler`가 있습니다. |
| **모델 평가 (Model Evaluation)** | 학습된 머신러닝 모델이 얼마나 잘 작동하는지, 즉 새로운 데이터에 대해 얼마나 정확한 예측을 하는지를 측정하는 과정입니다. 정확도, 정밀도, 재현율, F1 스코어, AUC 등 다양한 평가지표가 사용됩니다. |
| **정확도 (Accuracy)** | 분류 모델의 성능을 평가하는 가장 기본적인 지표 중 하나로, 전체 예측 건수 중에서 올바르게 예측한 건수의 비율을 나타냅니다. (정확도 = (TP + TN) / (TP + TN + FP + FN)) |
| **과적합 (Overfitting)** | 모델이 훈련 데이터에만 너무 과도하게 맞춰져, 노이즈나 특정 패턴까지 전부 외워버린 상태. 훈련 데이터에서는 성능이 매우 높지만, 새로운 테스트 데이터에서는 성능이 급격히 떨어지는 특징을 보입니다. |
| **과소적합 (Underfitting)** | 모델이 너무 단순해서 데이터의 내재된 패턴을 제대로 학습하지 못하는 상태. 훈련 데이터에서도 성능이 낮고, 테스트 데이터에서도 성능이 낮은 특징을 보입니다. |
| **편향-분산 트레이드오프 (Bias-Variance Tradeoff)** | 모델의 복잡도와 관련된 문제로, 예측이 실제 값과 벗어나는 경향(편향)과 데이터의 작은 변화에 모델이 민감하게 변하는 정도(분산) 사이의 상충 관계. 이상적인 모델은 편향과 분산이 모두 낮은 균형점을 찾는 것을 목표로 합니다. |
| **혼동 행렬 (Confusion Matrix)** | 분류 모델의 예측 성능을 시각화하는 표. 모델이 각 클래스를 얼마나 헷갈렸는지(confused)를 보여주며, True Positive, False Positive, True Negative, False Negative로 구성됩니다. 정밀도, 재현율 등의 지표를 계산하는 기반이 됩니다. |
| **정밀도 (Precision)** | 모델이 "양성(Positive)"이라고 예측한 것들 중, 실제로 양성이었던 것의 비율. `TP / (TP + FP)`. 스팸 메일 필터와 같이, 잘못된 긍정 예측(FP)의 비용이 클 때 중요한 지표입니다. |
| **재현율 (Recall)** | 실제 양성인 것들 중, 모델이 양성으로 예측한 것의 비율. `TP / (TP + FN)`. 암 진단과 같이, 놓치는 부정 예측(FN)의 비용이 클 때 중요한 지표입니다. |
| **F1-Score** | 정밀도와 재현율의 조화 평균. 두 지표가 모두 중요할 때, 특히 데이터가 불균형할 때 정확도보다 신뢰할 수 있는 성능 지표로 사용됩니다. |
| **교차 검증 (Cross-Validation)** | 데이터를 여러 번 다른 방식으로 나누어 학습과 평가를 반복하는 방법. 특정 데이터 분할에 따른 성능 변동의 위험을 줄이고, 모델의 일반화 성능을 더 안정적이고 신뢰성 있게 평가할 수 있습니다. K-겹(K-Fold) 교차 검증이 대표적입니다. |
| **데이터 누수 (Data Leakage)** | 모델 학습 과정에서, 훈련 시점에는 사용할 수 없는 미래의 정보(예: 테스트 데이터의 정보)가 모델에 흘러 들어가는 문제. 모델의 성능이 비정상적으로 높게 측정되지만 실제 환경에서는 성능이 매우 저조하게 됩니다. |
| **파이프라인 (Pipeline)** | 데이터 전처리 단계와 모델 학습 단계를 하나로 묶어주는 Scikit-learn의 기능. 여러 단계를 체계적으로 관리하고, 데이터 누수와 같은 실수를 방지하며 코드의 재사용성을 높입니다. |

---

*이 용어집은 `geumdo_docs/ai lecture/part_6_machine_learning.md` 파일 내용을 기반으로 작성되었습니다.* 
---

## Deep Learning


| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **강화학습 (Reinforcement Learning, RL)** | '정답' 데이터 없이 '보상(Reward)'이라는 신호를 통해, 에이전트가 환경과 상호작용하며 누적 보상을 최대화하는 행동 전략(정책)을 스스로 학습하는 머신러닝 패러다임입니다. (예: 게임 AI, 로봇 제어) |
| **게이트 (Gate)** | LSTM의 핵심 구성요소로, 정보의 흐름을 제어하는 장치. 시그모이드 함수를 통해 정보의 양을 조절하며, 망각/입력/출력 게이트를 통해 장기 기억을 가능하게 합니다. |
| **검색 증강 생성 (Retrieval-Augmented Generation, RAG)** | LLM이 최신 정보나 특정 도메인 지식 없이 답변을 생성할 때 발생할 수 있는 환각(Hallucination) 현상을 줄이고, 답변의 신뢰성과 정확성을 높이기 위한 기술입니다. 사용자의 질문에 대해 외부 데이터 소스(벡터 저장소 등)에서 관련 정보를 검색한 후, 이 정보를 LLM에게 참고 자료로 제공하여 답변을 생성하도록 하는 방식입니다. ("오픈북 시험"에 비유) |
| **거대 언어 모델 (LLM, Large Language Model)** | 방대한 양의 텍스트 데이터로 사전 훈련된 매우 큰 규모의 딥러닝 모델입니다. 인간과 유사한 수준으로 텍스트를 이해하고 생성할 수 있으며, 질문 답변, 번역, 요약, 코드 생성 등 다양한 자연어 처리 작업을 수행할 수 있습니다. (예: GPT-3, BERT) |
| **경사 하강법 (Gradient Descent)** | 손실 함수의 값을 최소화하기 위해, 손실 함수의 기울기(gradient)가 가리키는 반대 방향으로 모델의 파라미터를 점진적으로 업데이트하는 최적화 알고리즘. 딥러닝 모델 학습의 기본 원리입니다. |
| **그래프 신경망 (Graph Neural Network, GNN)** | 소셜 네트워크, 분자 구조와 같이 노드(객체)와 엣지(관계)로 구성된 그래프 데이터를 직접 처리하고 학습하는 데 특화된 신경망 아키텍처입니다. |
| **기울기 소실/폭발 (Vanishing/Exploding Gradient)** | 깊은 신경망이나 RNN에서 역전파 시, 그래디언트(기울기)가 층을 거치면서 너무 작아져(소실) 학습이 멈추거나, 너무 커져(폭발) 학습이 불안정해지는 문제입니다. |
| **기호주의 (Symbolic AI)** | AI 초기의 주요 접근법으로, 인간의 지식과 논리적 추론 과정을 기호와 규칙(Rule)으로 표현하고 컴퓨터로 처리하여 지능을 구현하려는 시도입니다. (예: 전문가 시스템) |
| **내부 공변량 변화 (Internal Covariate Shift)** | 딥러닝 모델의 각 층을 지날 때마다 이전 층의 파라미터가 변하면서, 현재 층의 입력 데이터 분포가 계속 바뀌는 현상. 배치 정규화(Batch Normalization)는 이 문제를 완화하여 학습을 안정시킵니다. |
| **딥러닝 (Deep Learning)** | 여러 층(layers)으로 구성된 인공 신경망(ANN)을 사용하여 복잡한 패턴을 데이터로부터 학습하는 머신러닝의 한 분야입니다. 이미지, 음성, 텍스트와 같은 비정형 데이터 처리에서 뛰어난 성능을 보입니다. |
| **딥블루 (Deep Blue)** | 1997년, 당시 체스 세계 챔피언 가리 카스파로프를 꺾은 IBM의 체스 컴퓨터. AI가 특정 영역에서 인간 최고수를 이길 수 있음을 보여준 상징적인 사건입니다. |
| **드롭아웃 (Dropout)** | 훈련 과정에서 신경망의 일부 뉴런을 무작위로 비활성화하여, 모델이 특정 뉴런에 과도하게 의존하는 것을 방지하는 정규화(Regularization) 기법. 과적합을 줄이는 데 효과적입니다. |
| **레스넷 (ResNet)** | '잔차 학습(Residual Learning)'과 '스킵 연결(Skip Connection)' 개념을 도입하여, 네트워크가 깊어져도 학습이 잘 되지 않는 퇴화(Degradation) 문제를 해결한 혁신적인 CNN 아키텍처입니다. 100층 이상의 매우 깊은 신경망 훈련을 가능하게 했습니다. |
| **머신러닝 (Machine Learning)** | 컴퓨터가 명시적인 프로그래밍 없이, 데이터를 기반으로 스스로 학습하여 특정 작업을 수행하는 능력을 갖추게 하는 AI의 한 분야입니다. |
| **메시지 패싱 (Message Passing)** | GNN의 핵심 작동 원리. 각 노드가 자신의 이웃 노드들과 정보를 주고받으며(메시지), 자신의 상태(표현 벡터)를 반복적으로 업데이트하는 과정입니다. |
| **문서 분할 (Chunking / Text Splitting)** | RAG 파이프라인에서 긴 문서를 LLM이 처리하기 적합한 작은 조각(chunk)으로 나누는 과정입니다. 너무 작으면 문맥을 잃고, 너무 크면 관련 없는 정보가 포함되어 LLM의 처리 효율과 정확도를 떨어뜨릴 수 있으므로, 적절한 크기와 중첩(overlap)을 고려하여 분할하는 것이 중요합니다. |
| **버트 (BERT)** | Transformer의 인코더 구조만을 사용하여 문장의 양방향 문맥을 학습하는 언어 모델. 문맥 이해에 강점을 보여 분류, 개체명 인식 등 분석 작업에 주로 사용됩니다. |
| **보상 (Reward)** | 강화학습에서 에이전트가 특정 행동을 취했을 때 환경으로부터 받는 신호. 에이전트는 이 보상을 누적하여 최대화하는 방향으로 학습합니다. |
| **배치 정규화 (Batch Normalization)** | 각 레이어에 들어오는 미니배치(mini-batch) 입력의 분포를 평균 0, 분산 1로 정규화하는 기법. 학습을 안정화하고 속도를 높이며, 약간의 규제 효과도 있습니다. |
| **벡터 저장소 (Vector Store / Vector Database)** | 텍스트나 이미지 등에서 추출한 임베딩 벡터를 효율적으로 저장하고 검색할 수 있도록 설계된 특수한 데이터베이스입니다. 의미 기반 검색(Semantic Search), 즉 사용자의 질의 벡터와 가장 유사한 벡터들을 빠르게 찾아내는 기능을 제공합니다. (예: FAISS, Chroma, Pinecone, Weaviate) |
| **손실 함수 (Loss Function)** | 모델의 예측값과 실제 정답 사이의 차이, 즉 '오차(Error)'를 계산하는 함수. 딥러닝 학습은 이 손실 함수의 값을 최소화하는 것을 목표로 합니다. 문제의 종류(회귀, 분류)에 따라 적절한 손실 함수(MSE, Cross-Entropy 등)를 선택해야 합니다. |
| **순차 데이터 (Sequential Data)** | 텍스트, 시계열 데이터와 같이 데이터의 순서가 중요한 의미를 갖는 데이터입니다. |
| **순환 신경망 (Recurrent Neural Network, RNN)** | 내부에 순환 구조를 가져 이전 시간 단계의 정보(은닉 상태)를 기억하고, 이를 현재 계산에 활용하는 순차 데이터 처리에 특화된 신경망입니다. |
| **스킵 연결 (Skip Connection)** | ResNet의 핵심 아이디어. 입력값을 몇 개의 층을 건너뛰어 출력값에 바로 더해주는 '지름길' 구조입니다. 그래디언트의 흐름을 원활하게 하여 깊은 망의 학습을 돕습니다. |
| **셀프 어텐션 (Self-Attention)** | Transformer의 핵심 메커니즘으로, 문장 내의 단어들이 서로에게 얼마나 중요한지(관련 있는지)를 계산하여 문맥을 파악하는 방식입니다. |
| **에이전트 (Agent)** | 강화학습에서 학습의 주체. 환경과 상호작용하며 행동을 결정하고 보상을 통해 학습합니다. (예: 게임 플레이어, 로봇) |
| **역전파 (Backpropagation)** | 순전파 결과 나온 예측값과 실제 정답의 오차를 이용해, 신경망의 각 파라미터가 오차에 얼마나 기여했는지를 출력층부터 입력층까지 역으로 계산하고 업데이트하는 알고리즘입니다. 딥러닝 학습의 핵심입니다. |
| **연결주의 (Connectionism)** | 뇌의 뉴런 구조에서 영감을 받아, 수많은 단순한 처리 장치(노드)들의 연결과 상호작용을 통해 지능을 구현하려는 AI 접근법입니다. 현대 딥러닝의 철학적 기반이 됩니다. |
| **옵티마이저 (Optimizer)** | 손실 함수가 계산한 오차(기울기)를 바탕으로, 모델의 파라미터를 어떻게 업데이트할지 결정하는 알고리즘. 경사 하강법을 실제로 구현하는 방법으로, SGD, Adam 등이 있습니다. |
| **위치 인코딩 (Positional Encoding)** | 단어를 순차적으로 처리하지 않는 Transformer에게 단어의 순서 정보를 알려주기 위해, 각 단어의 위치마다 고유한 값을 임베딩에 더해주는 기법입니다. |
| **은닉 상태 (Hidden State)** | RNN에서 특정 시간 단계까지의 입력 순서와 내용을 요약한 '기억' 또는 '문맥' 벡터. 이전 시간 단계의 은닉 상태와 현재의 입력을 받아 계산되며, 다음 시간 단계로 전달됩니다. |
| **임베딩 (Embedding)** | 텍스트(단어, 문장, 문서)를 저차원의 밀집 벡터(dense vector)로 변환하는 과정 또는 그 결과 벡터를 의미합니다. 이 벡터는 단어나 문장의 의미론적 정보를 담고 있어, 벡터 공간에서 의미적으로 유사한 단어나 문장들이 가깝게 위치하게 됩니다. 텍스트 간 유사도 계산, 검색, 분류 등 다양한 NLP 작업에 활용됩니다. |
| **인셉션 모듈 (Inception Module)** | GoogLeNet에서 제안된 구조로, 1x1, 3x3, 5x5 등 다양한 크기의 커널을 병렬로 적용하고 결과를 합쳐, 연산 효율을 높이면서 다양한 스케일의 특징을 한번에 잡아내는 블록입니다. |
| **어텐션 (Attention)** | 디코더가 출력 단어를 예측할 때마다, 인코더의 입력 시퀀스 전체를 다시 참고하여 현재 예측과 가장 관련이 높은 단어에 더 높은 가중치를 부여하는 메커니즘입니다. |
| **잔차 학습 (Residual Learning)** | ResNet의 핵심 아이디어. 층이 출력값 `H(x)`를 직접 학습하는 대신, 변화량(Residual)인 `H(x) - x`를 학습하도록 하여 깊은 신경망의 학습을 용이하게 합니다. |
| **장기 의존성 문제 (Long-Term Dependency Problem)** | RNN이 순차 데이터의 길이가 길어질 경우, 먼 과거의 정보가 현재까지 제대로 전달되지 못하고 소실되는 문제. 기울기 소실 문제가 주요 원인입니다. |
| **전문가 시스템 (Expert System)** | 특정 전문 분야의 지식을 규칙 기반으로 컴퓨터에 저장하고, 이를 바탕으로 일반인도 전문가처럼 문제 해결을 할 수 있도록 돕는 기호주의 기반의 AI 시스템입니다. |
| **정책 (Policy)** | 강화학습에서 에이전트의 '뇌' 또는 전략. 특정 상태(State)에서 어떤 행동(Action)을 할지 결정하는 함수입니다. |
| **지피티 (GPT)** | Transformer의 디코더 구조만을 사용하여 이전 단어들을 바탕으로 다음 단어를 예측하며 학습하는 언어 모델. 텍스트 생성에 강점을 보여 챗봇, 콘텐츠 작성 등에 주로 사용됩니다. |
| **특징 공학 (Feature Engineering)** | 머신러닝 모델의 성능을 높이기 위해, 원본 데이터로부터 모델 학습에 더 유용한 특징(feature)을 수동으로 설계하고 추출, 변환하는 과정. 도메인 지식이 중요하며, 딥러닝의 표현 학습과 대비됩니다. |
| **튜링 테스트 (Turing Test)** | 앨런 튜링이 제안한 기계의 지능을 판별하는 테스트. 심사관이 인간과 기계의 대화를 구별할 수 없다면, 그 기계는 '생각'할 수 있다고 간주합니다. |
| **트랜스포머 (Transformer)** | 2017년 구글에서 발표한 딥러닝 모델로, RNN 구조 없이 '어텐션' 메커니즘만으로 언어를 처리합니다. 병렬 처리에 용이하여 현대 LLM의 기반 아키텍처가 되었습니다. |
| **퍼셉트론 (Perceptron)** | 1957년 프랭크 로젠블랫이 고안한 초창기 인공 신경망 모델. 여러 입력을 받아 하나의 출력을 내보내는 구조로, 딥러닝의 가장 기본적인 단위인 인공 뉴런의 시초가 되었습니다. |
| **표현 학습 (Representation Learning)** | 데이터로부터 문제 해결에 필요한 특징(feature)을 모델이 스스로 학습하는 능력. 특징 공학 과정을 자동화하며, 딥러닝 모델의 가장 큰 강점 중 하나입니다. |
| **학습률 (Learning Rate)** | 경사 하강법에서 파라미터를 업데이트할 때, 기울기 방향으로 얼마나 큰 보폭(step)으로 이동할지를 결정하는 하이퍼파라미터. 학습 과정의 안정성과 속도에 큰 영향을 미칩니다. |
| **행동 (Action)** | 강화학습에서 에이전트가 특정 상태에서 취할 수 있는 행위입니다. |
| **환경 (Environment)** | 강화학습에서 에이전트가 상호작용하는 대상. 에이전트의 행동에 따라 상태를 바꾸고 보상을 줍니다. (예: 게임 맵, 물리적 공간) |
| **환각 (Hallucination)** | LLM이 사실이 아니거나 맥락에 맞지 않는 그럴듯한 거짓 정보를 생성하는 현상입니다. 모델이 훈련 데이터에 없는 내용을 추론하거나, 잘못된 패턴을 학습했을 때 발생할 수 있습니다. RAG는 이러한 환각을 줄이는 데 효과적입니다. |
| **활성화 함수 (Activation Function)** | 신경망의 선형 계층 통과 후 적용되는 비선형 함수. 모델이 복잡한 패턴을 학습할 수 있는 표현력을 부여하는 핵심적인 역할을 합니다. (예: ReLU, Sigmoid, Tanh) |
| **AI 겨울 (AI Winter)** | AI에 대한 기대가 과장되었다가 기술적 한계와 실망으로 인해 연구 자금 투자가 급격히 위축되는 시기를 의미합니다. 역사적으로 두 차례의 큰 겨울이 있었습니다. |
| **AlexNet** | 2012년 이미지 인식 대회(ILSVRC)에서 압도적인 성능으로 우승한 CNN 모델. ReLU 함수, Dropout, GPU 활용 등을 통해 딥러닝의 부흥을 이끈 기념비적인 모델입니다. |
| **BPTT (Backpropagation Through Time)** | RNN에서 시간의 흐름에 따라 펼쳐진 네트워크를 통해 오차를 역전파하는 학습 방식입니다. |
| **Chroma (ChromaDB)** | LLM 애플리케이션을 위해 설계된 오픈소스 임베딩 데이터베이스입니다. 사용하기 쉽고, Python 네이티브 지원 및 다양한 임베딩 모델과의 통합을 제공하며, 데이터를 디스크에 영구 저장할 수 있습니다. 개발 및 프로토타이핑에 적합합니다. |
| **CNN (Convolutional Neural Network / 합성곱 신경망)** | 이미지 인식 및 처리에 특화된 딥러닝 모델. 데이터의 특징을 추출하는 합성곱 계층(Convolutional Layer)과 풀링 계층(Pooling Layer)을 사용합니다. |
| **FAISS (Facebook AI Similarity Search)** | Facebook AI Research에서 개발한 고밀도 벡터 유사성 검색 및 클러스터링을 위한 라이브러리입니다. 대량의 벡터 데이터를 메모리에 저장하고 매우 빠르게 유사 벡터를 검색할 수 있어 RAG 시스템의 인덱싱 및 검색 단계에서 자주 사용됩니다. 주로 인메모리(in-memory) 방식으로 작동하여 속도가 빠릅니다. |
| **GoogLeNet** | 2014년 이미지 인식 대회에서 우승한 CNN 모델. '인셉션 모듈'을 사용하여 파라미터 수를 줄이면서도 깊고 효율적인 네트워크를 구축했습니다. |
| **LangChain** | LLM을 활용한 애플리케이션 개발을 용이하게 하는 오픈소스 프레임워크입니다. LLM을 외부 데이터 소스(문서, DB 등)나 다른 도구들과 쉽게 연동할 수 있도록 다양한 모듈(체인, 에이전트, 메모리 등)과 인터페이스를 제공합니다. RAG 시스템 구축에 널리 사용됩니다. |
| **LSTM (Long Short-Term Memory)** | RNN의 장기 의존성 문제를 해결하기 위해 고안된 개선된 모델. '셀 상태(Cell State)'와 '게이트(Gate)' 구조를 통해 중요한 정보는 오래 기억하고 불필요한 정보는 잊는 메커니즘을 가집니다. |
| **`model.train()` / `model.eval()`** | PyTorch 모델의 모드를 전환하는 함수. `model.train()`은 드롭아웃, 배치 정규화 등을 활성화하여 학습 모드로 설정하고, `model.eval()`은 이를 비활성화하여 일관된 예측을 보장하는 평가 모드로 설정합니다. |
| **PyTorch** | `Tensor` 연산과 자동 미분(Autograd) 기능을 통해 유연하고 동적인 신경망 구축을 지원하는 오픈소스 머신러닝 라이브러리입니다. (비유: 레고 블록) |
| **VGGNet** | 3x3의 작은 합성곱 필터를 깊게 쌓는 단순하면서도 강력한 구조를 제시한 CNN 모델. 네트워크의 '깊이(depth)'가 성능에 중요하다는 것을 보여주었습니다. |

---
*이 용어집은 [`part_0.1_history_of_ai.md`](../00_introduction/part_0.1_history_of_ai.md) 및 `Part 7` 딥러닝 시리즈([`part_7_deep_learning.md`](./part_7_deep_learning.md), [`part_7.1_recurrent_neural_networks.md`](./part_7.1_recurrent_neural_networks.md), [`part_7.2_transformer_and_llm_principles.md`](./part_7.2_transformer_and_llm_principles.md), [`part_7.3_llm_application_development_with_langchain.md`](./part_7.3_llm_application_development_with_langchain.md), [`part_7.4_graph_neural_networks.md`](./part_7.4_graph_neural_networks.md), [`part_7.5_reinforcement_learning.md`](./part_7.5_reinforcement_learning.md)) 파일 내용을 기반으로 작성되었습니다.*
---

## Model Serving With Fastapi


## 핵심 용어

| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **모델 서빙 (Model Serving)** | 학습된 머신러닝 모델을 실제 애플리케이션이나 사용자가 접근하여 예측 결과를 받을 수 있도록 배포하고 운영하는 과정입니다. API 형태로 제공하는 것이 일반적입니다. (비유: 비법 레시피로 요리를 만들어 손님에게 판매하는 '레스토랑' 운영) |
| **API (Application Programming Interface)** | 애플리케이션(소프트웨어)들이 서로 상호작용하기 위한 약속 또는 규격입니다. 클라이언트(손님)가 서버(주방)에 특정 형식으로 요청(주문)을 보내면, 서버는 약속된 형식으로 응답(요리)을 제공합니다. 웹에서는 주로 HTTP 프로토콜을 사용합니다. |
| **FastAPI** | Python 3.7+ 버전을 위한 현대적이고, 빠르며(고성능), 사용하기 쉬운 웹 프레임워크입니다. ASGI(Asynchronous Server Gateway Interface)를 기반으로 비동기 처리를 지원하며, Pydantic을 이용한 자동 데이터 검증 및 직렬화, 자동 API 문서 생성(Swagger UI, ReDoc) 기능이 강력합니다. |
| **uvicorn** | FastAPI와 같은 ASGI 애플리케이션을 위한 가볍고 빠른 ASGI 서버입니다. 개발 환경 및 프로덕션 환경에서 FastAPI 애플리케이션을 실행하는 데 사용됩니다. (비유: 레스토랑의 서버 매니저) |
| **Pydantic** | 파이썬 타입 힌트를 사용하여 데이터 유효성 검사 및 설정을 관리하는 라이브러리입니다. FastAPI에서는 요청 및 응답 데이터의 형식을 정의하고, 입력 데이터가 정의된 형식과 일치하는지 자동으로 검증하며, 데이터를 직렬화/역직렬화하는 데 사용됩니다. (비유: 주문서 양식 및 검토 직원) |
| **경로 매개변수 (Path Parameter)** | API 엔드포인트의 URL 경로 일부로 전달되는 변수입니다. 특정 리소스를 식별하는 데 사용됩니다. (예: `/items/{item_id}` 에서 `{item_id}` 부분) FastAPI에서는 함수 매개변수에 타입 힌트와 함께 선언하여 사용합니다. |
| **요청 본문 (Request Body)** | 클라이언트가 서버로 데이터를 전송할 때 HTTP 요청의 본문(body)에 담아 보내는 데이터입니다. 주로 POST, PUT, PATCH 메소드에서 사용되며, JSON, XML, 폼 데이터 등 다양한 형식이 가능합니다. FastAPI에서는 Pydantic 모델을 사용하여 요청 본문의 구조를 정의하고 유효성을 검사합니다. |
| **Swagger UI** | OpenAPI Specification(OAS)을 기반으로 API를 시각적으로 문서화하고, 브라우저에서 직접 API를 테스트할 수 있는 대화형 UI 도구입니다. FastAPI는 자동으로 Swagger UI를 `/docs` 경로에 생성해줍니다. (비유: 스마트 메뉴판) |
| **`lifespan` (FastAPI)** | FastAPI 애플리케이션의 시작과 종료 시점에 특정 작업을 수행하도록 하는 이벤트 핸들러입니다. 비동기 컨텍스트 매니저(`@asynccontextmanager`)를 사용하여 정의하며, 서버 시작 시 모델 로드, 데이터베이스 연결 초기화 등을, 서버 종료 시 리소스 정리 등을 수행하는 데 유용합니다. (비유: 가게 오픈 전 준비, 마감 후 정리) |

---

*이 용어집은 [`part_8_model_serving_with_fastapi.md`](./part_8_model_serving_with_fastapi.md) 파일 내용을 기반으로 작성되었습니다.* 
---

## Production Ready Api


## 핵심 용어

| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **프로젝트 구조화 (Project Structuring)** | 소프트웨어 프로젝트의 코드와 파일들을 기능, 역할, 또는 모듈별로 논리적인 폴더 및 파일 구조로 정리하는 작업입니다. 코드의 가독성, 유지보수성, 재사용성을 높이고 팀 협업을 용이하게 합니다. |
| **관심사 분리 (Separation of Concerns, SoC)** | 컴퓨터 프로그램을 서로 다른 역할을 수행하는 독립적인 부분(모듈, 계층 등)으로 나누는 설계 원칙입니다. 각 부분은 자신만의 책임(관심사)에 집중하여, 시스템 전체의 복잡도를 낮추고 유연성과 확장성을 향상시킵니다. FastAPI 프로젝트에서는 라우터, 스키마, 설정 파일 등으로 분리할 수 있습니다. |
| **`APIRouter` (FastAPI)** | FastAPI에서 API 엔드포인트들을 그룹화하고 모듈화하는 데 사용되는 클래스입니다. 대규모 애플리케이션에서 특정 기능 또는 리소스와 관련된 경로들을 별도의 파일로 분리하여 관리할 수 있게 해줍니다. `main.py`에서는 `app.include_router()`를 통해 이러한 라우터들을 통합합니다. (비유: 레스토랑의 '한식 코너', '중식 코너') |
| **의존성 주입 (Dependency Injection, DI)** | 객체(클래스 인스턴스)가 내부에서 직접 다른 객체(의존성)를 생성하는 대신, 외부에서 생성된 객체를 전달받아 사용하는 디자인 패턴입니다. 코드 간의 결합도를 낮추고, 유연성, 테스트 용이성을 높입니다. FastAPI는 경로 연산 함수 매개변수에 타입 힌트를 통해 의존성을 선언하면 자동으로 주입해주는 강력한 DI 시스템을 갖추고 있습니다. |
| **Docker** | 애플리케이션과 그 실행에 필요한 모든 환경(코드, 라이브러리, 시스템 도구, 설정 등)을 '컨테이너'라는 격리된 공간에 패키징하여, 어떤 환경에서든 동일하게 실행될 수 있도록 하는 오픈소스 플랫폼입니다. "제 컴퓨터에서는 되는데요..." 문제를 해결하고, 개발, 배포, 운영의 효율성을 크게 향상시킵니다. (비유: 어디서든 똑같은 맛을 내는 밀키트) |
| **컨테이너 (Container)** | Docker의 핵심 개념으로, 애플리케이션과 그 종속성들을 격리된 환경에서 실행할 수 있도록 패키징한 단위입니다. 호스트 OS의 커널을 공유하면서도 독립적인 파일 시스템, 프로세스 공간 등을 가집니다. 이미지로부터 생성되며, 가볍고 빠릅니다. |
| **이미지 (Image)** | Docker 컨테이너를 생성하기 위한 읽기 전용 템플릿입니다. 애플리케이션 코드, 런타임, 시스템 도구, 라이브러리 및 설정 등 컨테이너 실행에 필요한 모든 것을 포함합니다. `Dockerfile`이라는 스크립트에 정의된 지침에 따라 빌드됩니다. (비유: 밀키트의 레시피와 재료가 담긴 포장) |
| **`Dockerfile`** | Docker 이미지를 빌드하기 위한 지침(명령어)들을 순서대로 기술한 텍스트 파일입니다. 베이스 이미지 선택, 작업 디렉토리 설정, 파일 복사, 의존성 설치, 실행 명령어 지정 등의 작업을 정의합니다. 이 파일을 통해 이미지를 재현 가능하고 자동화된 방식으로 생성할 수 있습니다. (비유: 밀키트 제조 레시피) |
| **Docker Compose** | 여러 개의 Docker 컨테이너로 구성된 애플리케이션을 정의하고 실행하기 위한 도구입니다. `docker-compose.yml`이라는 YAML 파일에 각 서비스(컨테이너)의 설정(이미지, 포트, 볼륨, 네트워크 등)을 기술하고, 단일 명령(`docker-compose up`)으로 모든 서비스를 한 번에 시작, 중지, 관리할 수 있습니다. (비유: 프랜차이즈 매장 동시 오픈 계획서) |

---

*이 용어집은 [`part_9_production_ready_api.md`](./part_9_production_ready_api.md) 파일 내용을 기반으로 작성되었습니다.* 
---

## Expert Path


## 핵심 용어

| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **MLOps (Machine Learning Operations)** | 머신러닝(ML) 모델 개발(Dev)과 운영(Ops)을 통합하여, ML 시스템의 개발, 배포, 유지보수를 자동화하고 효율화하는 일련의 원칙과 실천 방법입니다. CI/CD, 데이터/모델 버전 관리, 모니터링, 재학습 등을 포함하여 AI 서비스의 안정성과 지속성을 높입니다. (비유: AI 레스토랑 프랜차이즈의 '중앙 관제 시스템') |
| **CI/CD (Continuous Integration/Continuous Deployment or Delivery)** | 지속적 통합(CI)은 코드 변경사항을 정기적으로 중앙 리포지토리에 병합하고, 자동으로 빌드 및 테스트하는 프로세스입니다. 지속적 배포/딜리버리(CD)는 CI를 통과한 코드를 자동으로 프로덕션 환경까지 배포하거나, 배포 가능한 상태로 준비하는 프로세스입니다. MLOps에서 모델 및 애플리케이션의 빠르고 안정적인 업데이트를 가능하게 합니다. |
| **DVC (Data Version Control)** | Git과 함께 사용되어 대용량 데이터셋, 머신러닝 모델, 중간 파일 등의 버전을 관리하는 오픈소스 도구입니다. 실제 데이터 파일 대신 메타데이터(포인터)를 Git으로 관리하여, 대용량 파일로 인해 Git 리포지토리가 비대해지는 것을 방지하고 실험의 재현성을 높입니다. |
| **MLflow** | 머신러닝 수명주기 관리를 위한 오픈소스 플랫폼입니다. 실험 추적(파라미터, 코드, 데이터, 결과 로깅), 모델 패키징 및 버전 관리, 모델 배포 기능을 제공하여, ML 실험의 재현성을 높이고 협업을 용이하게 합니다. |
| **AI 네이티브 IDE (AI Native IDE)** | 인공지능 기능이 깊숙하게 통합된 통합 개발 환경(IDE)입니다. 코드 자동 생성, 리팩터링, 디버깅, 문서화 등 개발 과정 전반에 걸쳐 AI의 지원을 받아 생산성을 극대화합니다. (예: Cursor, GitHub Copilot이 통합된 VS Code) (비유: AI 비서(자비스)가 탑재된 F-35 스텔스기 조종석) |
| **Cursor** | AI 기능을 중심으로 설계된 코드 편집기로, GPT-4와 같은 LLM을 활용하여 코드 작성, 수정, 채팅 기반의 코드 관련 질문 답변, 버그 수정, 문서 참조 등 다양한 개발 작업을 지원하는 AI 네이티브 IDE의 한 종류입니다. |
| **GitHub Copilot** | GitHub와 OpenAI가 개발한 AI 페어 프로그래머(pair programmer) 서비스입니다. 개발자가 코드를 작성할 때 실시간으로 코드 라인이나 전체 함수를 제안하며, 주석을 코드로 변환하거나 테스트 코드를 생성하는 등 개발 생산성을 높이는 데 도움을 줍니다. VS Code 등 다양한 IDE의 확장 기능으로 제공됩니다. |
| **SLM (Small Language Model / 소형 언어 모델)** | 거대 언어 모델(LLM)의 성능을 특정 작업이나 도메인에서 유지하면서, 모델 크기와 계산 요구량을 크게 줄인 효율적인 언어 모델입니다. 스마트폰, 노트북 등 온디바이스(On-device) 환경에서의 실행을 목표로 하며, 속도, 비용, 개인정보 보호 측면에서 이점을 가집니다. (예: Llama 3 8B, Phi-3) |
| **멀티모달 AI (Multimodal AI)** | 텍스트, 이미지, 음성, 비디오 등 여러 종류의 데이터(양식, modality)를 동시에 이해하고 처리하며 생성할 수 있는 인공지능입니다. 인간처럼 다양한 감각 정보를 통합적으로 활용하여 보다 복잡하고 풍부한 상호작용 및 문제 해결이 가능합니다. (예: GPT-4o, Google Gemini) |
| **AI 에이전트 (AI Agent)** | 특정 목표를 달성하기 위해 자율적으로 환경을 관찰하고, 계획을 세우며, 도구(API, 코드 실행 등)를 사용하고, 행동을 실행하는 AI 시스템입니다. 단순 질의응답을 넘어, 복잡한 실제 태스크를 사용자를 대신하여 수행할 수 있는 잠재력을 가집니다. (예: Auto-GPT, LangGraph 기반 에이전트) |
| **AI 윤리 (AI Ethics)** | 인공지능 기술의 개발 및 사용과 관련된 윤리적 문제들을 다루는 분야입니다. 데이터 편향성, 개인정보 침해, 알고리즘의 공정성 및 투명성, 책임성, 일자리 대체, 잠재적 오용 등 AI가 사회에 미치는 영향을 고려하고 바람직한 방향으로 기술을 발전시키기 위한 원칙과 가이드라인을 포함합니다. |

---

*이 용어집은 [`part_10_expert_path.md`](./part_10_expert_path.md) 파일 내용을 기반으로 작성되었습니다.* 
---

## Mlops


- **Kubeflow**: Kubernetes 기반으로 머신러닝(ML) 워크플로우를 배포, 관리, 확장하는 오픈소스 플랫폼입니다. ML 파이프라인 구성, 하이퍼파라미터 튜닝, 모델 서빙 등 ML 수명주기 전반을 지원합니다.

- **CI/CD (Continuous Integration/Continuous Deployment)**: 코드 변경사항을 자동으로 빌드, 테스트, 배포하는 프로세스입니다. MLOps에서는 코드뿐만 아니라 데이터와 모델의 변경사항까지 관리하여 ML 시스템의 배포를 자동화합니다.

- **GitHub Actions**: GitHub 리포지토리 내에서 코드 푸시, Pull Request 등의 이벤트에 따라 CI/CD 와 같은 워크플로우를 자동화하는 도구입니다.

- **Prometheus**: 시스템 및 서비스의 상태를 모니터링하기 위해 시계열 데이터(time-series data)를 수집하고 저장하는 오픈소스 모니터링 시스템입니다.

- **Grafana**: Prometheus 등 다양한 데이터 소스로부터 수집된 메트릭을 시각화하고 분석하기 위한 오픈소스 대시보드 및 분석 플랫폼입니다.

- **Evidently AI**: 데이터 드리프트, 컨셉 드리프트, 모델 성능 저하 등 머신러닝 모델의 품질을 전문적으로 모니터링하고 시각화하는 오픈소스 라이브러리입니다.

- **Feature Store**: 머신러닝 모델의 학습과 추론에 사용되는 피처(feature)를 중앙에서 관리, 저장, 제공하는 데이터 시스템입니다. 학습-서빙 스큐를 방지하고 피처 재사용성을 높입니다.

- **Feast**: Feature Store를 구축하기 위한 널리 사용되는 오픈소스 프레임워크입니다. 
---

## Model Optimization


- **분산 학습 (Distributed Training)**: 하나의 모델을 여러 GPU 또는 여러 장비에서 병렬로 학습시키는 기술입니다. 대규모 모델 학습과 학습 시간 단축을 위해 사용됩니다.

- **데이터 병렬 처리 (Data Parallelism)**: 동일한 모델을 여러 GPU에 복제하고, 데이터를 나누어 학습시키는 가장 일반적인 분산 학습 방식입니다.

- **모델 병렬 처리 (Model Parallelism)**: 모델 자체가 너무 커서 단일 GPU에 올라가지 않을 때, 모델의 레이어나 파라미터를 여러 GPU에 나누어 학습시키는 방식입니다.

- **FSDP (Fully Sharded Data Parallel)**: PyTorch의 차세대 분산 학습 기술로, 모델 파라미터, 그래디언트, 옵티마이저 상태를 모든 GPU에 분할하여 메모리 효율성을 극대화합니다.

- **DeepSpeed**: Microsoft에서 개발한 대규모 분산 학습 라이브러리로, ZeRO와 같은 강력한 메모리 최적화 기술과 다양한 병렬 처리 기법을 통합 제공합니다.

- **모델 경량화 (Model Optimization)**: 학습된 모델의 성능을 최대한 유지하면서, 모델 크기를 줄이고 추론 속도를 향상시키는 기술들의 총칭입니다.

- **양자화 (Quantization)**: 모델의 가중치와 연산에 사용되는 데이터 타입을 32비트 부동소수점(FP32)에서 8비트 정수(INT8) 등으로 변환하여 모델 크기를 줄이고 연산 속도를 높이는 대표적인 경량화 기법입니다.

- **가지치기 (Pruning)**: 모델 성능에 거의 영향을 주지 않는 불필요한 가중치나 뉴런을 제거하여 모델의 파라미터 수를 줄이는 기법입니다.

- **지식 증류 (Knowledge Distillation)**: 크고 성능이 좋은 '선생님 모델'의 지식을 작고 가벼운 '학생 모델'에게 전달하여 학습시키는 기법입니다.

- **Triton Inference Server**: NVIDIA에서 개발한 고성능 추론 서버로, 다양한 프레임워크의 모델을 동적 배치(dynamic batching) 등의 기능을 활용하여 효율적으로 서빙합니다.

- **TorchServe**: PyTorch에서 공식적으로 지원하는 모델 서빙 라이브러리로, PyTorch 모델을 빠르고 쉽게 배포할 수 있는 기능을 제공합니다. 
---

## Generative Ai


- **PEFT (Parameter-Efficient Fine-Tuning)**: 거대 언어 모델(LLM)의 사전 학습된 가중치 대부분을 고정한 채, 일부 파라미터만 학습시켜 적은 리소스로 효율적으로 모델을 특정 작업에 맞게 미세 조정하는 기법들의 총칭입니다.

- **LoRA (Low-Rank Adaptation)**: PEFT의 대표적인 기법 중 하나로, 기존 가중치 행렬 옆에 작은 크기의 학습 가능한 행렬 두 개(Low-rank 행렬)를 추가하여 파라미터 업데이트를 효율화합니다.

- **RAG (Retrieval-Augmented Generation)**: LLM이 답변을 생성할 때, 외부 데이터베이스나 문서에서 관련 정보를 실시간으로 검색(Retrieval)하여 그 내용을 참고해 답변의 정확성과 신뢰도를 높이는(Augmented Generation) 기술입니다.

- **쿼리 변환 (Query Transformation)**: 사용자의 원본 질문을 더 나은 검색 결과를 얻기 위해 여러 개의 다양한 질문으로 변형하거나, 더 명확한 형태로 재구성하는 RAG의 심화 기법입니다.

- **재순위화 (Re-ranking)**: 1차적으로 검색된 문서들을 더 정교한 모델을 사용해 사용자 질문과의 관련도 순으로 다시 정렬하여, LLM에게 전달할 최종 문서의 정확도를 높이는 과정입니다.

- **AI 에이전트 (AI Agent)**: 목표 달성을 위해 스스로 생각하고(Reasoning), 계획을 세우며, 도구(Tools)를 사용하고, 환경과 상호작용하는 능동적인 AI 시스템입니다. LLM이 '뇌'의 역할을 수행합니다.

- **ReAct (Reason + Act)**: AI 에이전트가 '생각(Thought) -> 행동(Action) -> 관찰(Observation)'의 순환적인 추론 과정을 통해 복잡한 문제를 해결하도록 하는 대표적인 프레임워크입니다.

- **LangGraph**: 여러 에이전트가 협력하거나 순환적인 작업 흐름을 처리하는 복잡한 AI 시스템을 상태(State) 기반의 그래프 형태로 쉽게 구현하도록 돕는 LangChain의 확장 라이브러리입니다.

- **LLMOps (Large Language Model Operations)**: 프롬프트 관리, 정성적 성능 평가, 실행 과정 추적 등 LLM 기반 애플리케이션의 전체 수명 주기를 안정적으로 관리하고 운영하기 위한 MLOps의 특화된 분야입니다.

- **LangSmith**: LLM 애플리케이션의 개발 및 운영을 위한 통합 플랫폼으로, 복잡한 체인과 에이전트의 내부 동작을 추적, 모니터링, 평가하는 강력한 기능을 제공합니다.

- **하이브리드 검색 (Hybrid Search)**: 키워드 기반 검색(BM25 등)과 의미 기반 벡터 검색을 함께 사용하여 각 방식의 장점을 결합, 더 정확한 검색 결과를 얻는 RAG 기법입니다.

- **Cross-Encoder**: 두 텍스트(질문과 문서)를 함께 입력 받아 직접 관련성 점수를 계산하는 신경망 모델로, RAG에서 검색된 문서의 재순위화에 사용되며, 높은 정확도를 보이지만 계산 비용이 큽니다.

- **Bi-Encoder**: 텍스트를 독립적으로 임베딩(벡터화)하고 두 벡터 간의 유사도를 계산하는 모델로, RAG의 1차 검색에 주로 사용됩니다. Cross-Encoder보다 정확도는 낮지만 효율적입니다.

- **멀티 쿼리 확장 (Multi-Query Expansion)**: 하나의 사용자 질문을 LLM을 통해 여러 개의 다양한 관점의 질문으로 변환하여, 각 질문으로 검색 후 결과를 종합함으로써 검색의 다양성과 정확도를 높이는 기법입니다.

- **문맥 압축 (Contextual Compression)**: RAG 시스템에서 검색된 문서의 크기를 줄이고 관련성을 높이기 위해, 사용자 질문과 무관한 부분을 제거하고 핵심 내용만 추출하는 기술입니다. 임베딩 필터링, 중복 제거, LLM 기반 내용 추출 등의 방식을 조합하여 구현됩니다.

- **멀티에이전트 협업 시스템 (Multi-Agent Collaboration System)**: 여러 AI 에이전트가 각각 다른 역할과 전문 지식을 가지고 복잡한 작업을 협력하여 해결하는 시스템입니다. 각 에이전트는 특정 영역의 전문가로 동작하며, 최종 목표 달성을 위해 서로 통신하고 작업 결과를 공유합니다.

- **State Graph (상태 그래프)**: LangGraph에서 에이전트 워크플로우를 정의하는 핵심 개념으로, 노드(에이전트/함수)와 엣지(전환 경로)로 구성된 그래프입니다. 노드 간 메시지 전달 및 조건부 라우팅을 통해 복잡한 에이전트 시스템의 흐름을 제어합니다. 
---

## Ai Ethics


- **XAI (eXplainable AI, 설명가능 AI)**: '블랙박스'로 여겨지는 복잡한 AI 모델이 왜 그런 예측을 했는지 사람이 이해할 수 있는 형태로 설명하고 해석하는 것을 목표로 하는 기술 및 방법론입니다.

- **LIME (Local Interpretable Model-agnostic Explanations)**: 특정 예측 하나에 대해, 그 주변의 데이터를 분석하여 간단한 모델로 근사함으로써 "왜 이 예측을 했는가?"를 설명하는 대표적인 로컬 XAI 기법입니다.

- **SHAP (SHapley Additive exPlanations)**: 게임 이론의 '섀플리 값'을 이용해 각 피처(feature)가 모델의 예측 결과에 얼마나 기여했는지를 공정하게 측정하여 설명하는 XAI 기법입니다. 로컬 및 글로벌 설명이 모두 가능합니다.

- **편향성 (Bias)**: AI 모델이 학습 데이터에 내재된 편견을 학습하여, 특정 인구 집단(성별, 인종 등)에게 체계적으로 불리하거나 유리한 예측을 내놓는 경향을 의미합니다.

- **Fairlearn**: Microsoft에서 개발한 라이브러리로, 머신러닝 시스템의 공정성을 다양한 지표로 측정 및 시각화하고, 편향성을 완화하는 알고리즘을 제공합니다.

- **Demographic Parity (인구 통계학적 동등성)**: 모델의 긍정적인 예측(예: 대출 승인) 비율이 모든 민감 그룹(예: 남성/여성)에서 동일해야 한다는 공정성 원칙입니다.

- **Equalized Odds (동등한 기회)**: 실제 결과가 참일 때와 거짓일 때 각각의 경우에 대해, 모든 그룹이 동일한 예측률(TPR, FPR)을 가져야 한다는 공정성 원칙입니다. Demographic Parity보다 더 정교한 기준으로 여겨집니다.

- **EU AI Act**: 유럽연합(EU)에서 제정한 세계 최초의 포괄적인 AI 규제 법안으로, AI 시스템을 위험 수준에 따라 분류하고 차등적인 의무를 부과합니다.

- **모델 카드 (Model Cards)**: AI 모델의 사용 목적, 성능, 한계, 윤리적 고려사항 등을 표준화된 양식으로 정리한 문서입니다. 모델의 투명성을 높이기 위해 사용됩니다.

- **데이터 시트 (Datasheets for Datasets)**: 데이터셋의 수집 동기, 구성, 한계, 편향 가능성 등을 상세히 기술한 문서입니다. 데이터의 투명성을 확보하는 데 목적이 있습니다. 
---

## Capstone Project


## 핵심 용어

| 용어 (Term) | 설명 (Description) |
| --- | --- |
| **캡스톤 프로젝트 (Capstone Project)** | 학문 분야에서 여러 학기 동안 배운 이론과 기술을 총동원하여 실제 결과물(작품, 서비스, 논문 등)을 기획, 설계, 개발, 구현하는 종합 프로젝트입니다. 학습한 지식의 실질적인 적용 능력을 평가하고, 포트폴리오의 핵심적인 부분을 구성합니다. ("졸업 작품"과 유사) |
| **포트폴리오 (Portfolio)** | 개인이 자신의 기술, 능력, 경험, 성과를 보여주기 위해 만든 작품집 또는 자료 모음입니다. 개발자에게는 자신이 참여하거나 직접 만든 프로젝트, 코드 샘플, 기술 블로그, GitHub 프로필 등이 해당되며, 구직 및 경력 관리에 매우 중요합니다. |
| **문제 정의 (Problem Definition)** | 해결하고자 하는 특정 문제나 필요성을 명확하고 구체적으로 기술하는 과정입니다. 프로젝트의 목표와 범위를 설정하는 첫 단계이며, "무엇을 왜 만드는가?"에 대한 답을 제시합니다. |
| **프로젝트 기획 (Project Planning)** | 정의된 문제를 해결하기 위한 구체적인 실행 계획을 수립하는 과정입니다. 목표 설정, 범위 정의, 필요한 리소스(시간, 인력, 기술 등) 파악, 일정 계획, 위험 관리 등을 포함합니다. |
| **요구사항 정의서 (Product Requirements Document, PRD)** | 개발하고자 하는 제품(서비스)의 목적, 기능, 사용자, 기술적 요구사항 등을 상세하게 기술한 문서입니다. 프로젝트 팀원 모두가 동일한 이해를 바탕으로 제품을 개발할 수 있도록 하는 청사진 역할을 합니다. |
| **시스템 아키텍처 (System Architecture)** | 개발하려는 시스템의 전체적인 구조와 구성 요소, 그리고 그들 간의 관계 및 상호작용을 정의한 설계도입니다. 데이터 흐름, 컴포넌트 간 인터페이스, 사용 기술 등을 시각적으로 표현하여 시스템의 이해를 돕습니다. (예: Mermaid, draw.io 사용) |
| **깃헙(GitHub) 협업 (GitHub Collaboration)** | 버전 관리 시스템인 Git의 웹 기반 호스팅 서비스인 GitHub를 사용하여 여러 개발자가 함께 프로젝트를 진행하는 방식입니다. 이슈 트래킹, 브랜치 전략, 풀 리퀘스트(PR)를 통한 코드 리뷰, 프로젝트 관리 등의 기능을 활용하여 효율적인 팀 개발을 지원합니다. |
| **코드 리뷰 (Code Review)** | 다른 개발자가 작성한 소스 코드를 검토하고 피드백을 제공하는 과정입니다. 코드의 품질 향상, 버그 조기 발견, 지식 공유, 팀 전체의 코드 이해도 증진 등의 효과가 있습니다. GitHub의 풀 리퀘스트(Pull Request) 기능을 통해 주로 이루어집니다. |
| **데모 (Demonstration)** | 개발한 제품이나 서비스의 주요 기능을 실제로 시연하여 보여주는 것입니다. 프로젝트의 결과물을 시각적으로 전달하고, 이해 관계자(팀원, 평가자, 사용자 등)의 피드백을 받는 데 효과적입니다. |
| **기술 블로그 (Tech Blog)** | 개발자가 자신이 학습한 기술, 프로젝트 경험, 문제 해결 과정, 개발 팁 등을 글로 작성하여 온라인에 공유하는 것입니다. 지식 정리, 개인 브랜딩, 커뮤니티 기여, 포트폴리오 강화 등 다양한 이점이 있습니다. |

---

*이 용어집은 `part_15_capstone_project.md` 파일 내용을 기반으로 작성되었습니다.* 