# Part 15: 나만의 AI 서비스 만들기 (캡스톤 프로젝트 가이드)

**⬅️ 이전 시간: [Part 14: AI 윤리 및 거버넌스 실무](../14_ai_ethics/part_14_ai_ethics.md)**

---

## 1. 학습 목표 (Learning Objectives)

이번 캡스톤 프로젝트를 통해 여러분은 다음을 달성하게 됩니다.

- 배운 모든 AI 기술과 지식을 총동원하여, 현실의 문제를 정의하고 해결하는 '풀스택 AI 프로젝트'를 완수할 수 있습니다.
- 아이디어 기획부터 데이터 수집, 모델 개발, API 서빙, 그리고 최종 배포까지, AI 서비스 개발의 전체 수명주기를 주도적으로 경험합니다.
- 팀원들과 효과적으로 소통하고 Git/GitHub을 통해 협업하며, 실무와 유사한 개발 프로세스를 체득합니다.
- 프로젝트의 과정과 결과를 논리적으로 정리하여 발표하고, 나의 역량을 증명하는 '나만의 포트폴리오'를 완성합니다.

## 2. 핵심 키워드 (Keywords)

`캡스톤 프로젝트`, `포트폴리오`, `문제 정의`, `프로젝트 기획`, `요구사항 정의서(PRD)`, `시스템 아키텍처`, `깃헙(GitHub) 협업`, `코드 리뷰`, `데모`, `기술 블로그`

## 3. 도입: '학생'을 넘어 '개발자'로, 나를 증명하는 첫 번째 작품

지난 9주간, 여러분은 AI 개발자에게 필요한 모든 무기를 차근차근 모아왔습니다. 이제 그 무기들을 들고, 여러분의 이름으로 된 **'첫 번째 작품'**을 만들 시간입니다.

캡스톤 프로젝트는 단순한 마지막 과제가 아닙니다. 이것은 여러분이 지난 시간 동안 배운 것을 세상에 증명하고, 미래의 동료와 채용 담당자에게 **"나는 이만큼 성장했고, 이런 문제를 해결할 수 있는 개발자입니다"**라고 자신 있게 보여주는 **포트폴리오의 핵심**입니다.

조금 막막하고 두려울 수 있습니다. 하지만 괜찮습니다. 이 가이드는 여러분이 아이디어 발상부터 최종 발표까지, 성공적으로 프로젝트를 완수할 수 있도록 모든 단계를 함께하는 든든한 '내비게이션'이 되어줄 것입니다. 자, 이제 '학생'의 마침표를 찍고 '개발자'로서의 첫 페이지를 함께 열어봅시다!

---

## 4. 1단계 (1주차): 문제 정의와 아이디어 구체화

> **🎯 1주차 목표:** '어떤 문제를 풀 것인가?'를 명확히 정의하고, 실행 가능한 프로젝트 계획의 뼈대를 세웁니다.

모든 위대한 서비스는 '문제'를 해결하는 것에서 시작합니다. "어떤 주제를 해야 할지 모르겠어요"라는 막막함은, 주변을 둘러보는 작은 관찰로부터 해결될 수 있습니다.

### 아이디어 발상, 이렇게 시작해보세요!
- **내 안에서 찾기**: "내가 평소에 가장 불편했던 점은 무엇이지?", "내가 가장 흥미 있는 분야(게임, 영화, 운동 등)에 AI를 접목하면 어떨까?"
- **세상에서 찾기**: "요즘 뉴스에 자주 나오는 사회 문제는?", "내가 자주 쓰는 서비스의 아쉬운 점은?"
- **기술에서 찾기**: "최근에 배운 RAG 기술을 활용해볼까?", "이미지 생성 모델로 재미있는 걸 만들 수 있지 않을까?"

### 좋은 프로젝트 주제의 조건
- **명확하게 정의된 문제**: 해결하려는 문제가 무엇인지 한 문장으로 설명할 수 있는가?
- **데이터 확보 가능성**: 프로젝트에 필요한 데이터를 구할 수 있거나, 직접 만들 수 있는가?
- **측정 가능한 목표**: 성공/실패를 판단할 수 있는 구체적인 기준(e.g., 모델 정확도 90% 이상, 응답 시간 1초 이내)이 있는가?
- **3주 안에 구현 가능한 범위**: 너무 거창한 계획보다는, 핵심 기능(MVP, Minimum Viable Product)에 집중하고 있는가?

### 💡 1주차 To-Do List & Pitfalls
- **[ ] To-Do**: 팀 구성 및 팀 내 규칙 정하기 (회의 시간, 소통 채널 등)
- **[ ] To-Do**: 아이디어 브레인스토밍 및 최종 주제 1~2개 선정
- **[ ] To-Do**: 데이터 확보 방안 구체화 (크롤링, 공개 데이터셋, 직접 생성 등)
- **[ ] To-Do**: 프로젝트 계획서(PRD) 초안 작성
- **[ ] To-Do**: GitHub Repository 생성 및 기본 설정 완료
- **❌ Pitfall**: 너무 완벽하고 거대한 주제를 선정하려는 함정. '작게 시작해서 점진적으로 발전시키는 것'이 핵심입니다.
- **❌ Pitfall**: 데이터 확보의 어려움을 간과하는 것. "데이터가 없으면 AI 모델도 없다"는 사실을 명심하세요.

---

## 5. 2단계 (2주차): 핵심 기능 개발과 빠른 실패

> **🎯 2주차 목표:** 전체 시스템의 프로토타입(MVP)을 완성하고, '빠르게 실패하고 빠르게 개선하는' 사이클을 경험합니다.

계획은 끝났습니다. 이제는 실행입니다. 2주차의 핵심은 '완벽함'이 아니라 **'동작하는 것'**을 만드는 데 있습니다.

### 체계적인 개발을 위한 설계도
- **시스템 아키텍처**: 전체 서비스가 어떻게 구성되고 데이터가 어떻게 흐르는지 보여주는 간단한 다이어그램을 그려보세요. (e.g., Mermaid, draw.io)
  ```mermaid
  graph TD
      A[User] -->|Request| B(FastAPI Server);
      B -->|Query| C{AI Model};
      C -->|Result| B;
      B -->|Response| A;
  ```
- **API 명세**: 클라이언트와 서버가 주고받을 데이터의 형식을 미리 정의합니다. (`Pydantic` 모델 활용)

### Git & GitHub 협업 전략
- **기능 단위 브랜치(Feature Branch)**: `main` 브랜치에 직접 커밋하지 말고, `feat/login`, `fix/model-bug` 와 같이 기능별로 브랜치를 만들어 작업 후 Pull Request(PR)를 통해 합칩니다.
- **이슈 트래킹**: 해야 할 일, 버그 등을 GitHub 이슈에 등록하고 담당자를 지정하여 체계적으로 관리합니다.
- **코드 리뷰**: 모든 코드는 최소 1명 이상의 팀원에게 리뷰받는 것을 원칙으로 삼으세요. 서로의 코드를 보며 배우고, 잠재적인 버그를 예방할 수 있습니다.

### 💡 2주차 To-Do List & Pitfalls
- **[ ] To-Do**: 데이터 전처리 및 분석 완료
- **[ ] To-Do**: 핵심 AI 모델 v1.0 학습 및 성능 평가 완료
- **[ ] To-Do**: 모델을 서빙하는 FastAPI 엔드포인트 개발 완료
- **[ ] To-Do**: 핵심 기능을 시연할 수 있는 간단한 프론트엔드 또는 `curl`/`requests` 스크립트 작성
- **[ ] To-Do**: 팀원 간 첫 번째 코드 리뷰 진행
- **❌ Pitfall**: 모델 성능에만 집착하는 함정. 처음부터 99%짜리 모델을 만들려고 하지 마세요. 일단 전체 파이프라인이 돌아가게 하는 것이 중요합니다.
- **❌ Pitfall**: 소통 없이 혼자 개발하는 것. 매일 짧게라도 진행 상황을 공유(Daily Stand-up)하고, 문제가 생기면 즉시 도움을 요청하세요.

---

## 6. 3단계 (3주차): 고도화, 그리고 '나'를 파는 기술

> **🎯 3주차 목표:** 프로젝트를 완성도 있게 마무리하고, 나의 노력과 성과를 다른 사람에게 매력적으로 전달하는 방법을 익힙니다.

마지막 주차입니다. 이제 흩어져 있던 결과물들을 하나의 '상품'으로 포장하고, 그 가치를 세상에 알릴 시간입니다.

### 당신의 프로젝트를 빛나게 할 README.md
README는 당신의 프로젝트 **'얼굴'**입니다. 채용 담당자는 당신의 코드보다 README를 먼저 봅니다. 아래 항목들을 포함하여, 프로젝트의 가치를 한눈에 파악할 수 있도록 만드세요.

<details>
<summary><b>🚀 고품질 README.md 템플릿 (펼쳐보기)</b></summary>

```markdown
# 🚀 프로젝트 제목: (e.g., 딥러닝 기반 상품 추천 API)

## 📖 프로젝트 소개
이 프로젝트는 ... 문제를 해결하기 위해 ... 기술을 사용한 ... 서비스입니다.
(프로젝트의 핵심 기능과 목표를 1~2 문단으로 요약)

## 🖼️ 시스템 아키텍처
(2주차에 그렸던 시스템 아키텍처 다이어그램을 여기에 추가)

## 🛠️ 기술 스택
- **Language**: Python 3.9
- **Framework**: FastAPI
- **ML/DL**: PyTorch, Scikit-learn
- **Database**: PostgreSQL
- **Deployment**: Docker, Nginx

## ⚙️ 주요 기능
- **회원가입/로그인**: JWT 기반의 사용자 인증 기능
- **상품 추천**: 사용자의 구매 이력을 바탕으로 개인화된 상품 추천 목록 제공
- **리뷰 감성 분석**: 사용자가 작성한 리뷰의 긍정/부정을 분석하여 점수화

## 📥 설치 및 실행 방법
```bash
# 1. 레포지토리 클론
git clone https://github.com/your-id/your-repo.git

# 2. 가상환경 생성 및 활성화
...

# 3. 의존성 설치
pip install -r requirements.txt

# 4. 서버 실행
uvicorn app.main:app --reload
```

## 🤔 배운 점 및 회고 (Troubleshooting)
- **문제 상황**: (e.g., 모델 예측 속도가 너무 느려 API 응답 시간이 길어지는 문제 발생)
- **해결 과정**: (e.g., 모델 경량화(Quantization)를 적용하고, 중복 계산을 캐싱하여 응답 속도를 50% 개선)
- **느낀 점**: (e.g., 모델의 정확도뿐만 아니라 서빙 효율성까지 고려하는 것의 중요성을 깨달음)
```
</details>

### 성공적인 발표와 데모를 위한 팁
- **5분 스토리텔링**: `문제 제기 → 우리의 해결 방식(기술) → 결과(데모 시연) → 성과 및 향후 계획` 순서로 청중이 이해하기 쉬운 이야기를 만드세요.
- **인상적인 데모**: 잘 되는 시나리오만 보여주세요. 예상치 못한 에러에 대비해, 실제 시연이 어려울 경우를 대비한 '데모 영상'을 미리 녹화해두는 것도 좋은 방법입니다.
- **나는 어떤 기여를 했는가?**: 팀 프로젝트이지만, "저는 이 프로젝트에서 '어떤 문제'를 '어떤 기술'을 사용해 해결했고, 그 결과 '어떤 성과'에 기여했습니다"를 명확히 어필해야 합니다.

### 💡 3주차 To-Do List & Pitfalls
- **[ ] To-Do**: 모델 성능 개선 및 서비스 기능 고도화
- **[ ] To-Do**: 프로젝트 README.md 최종 완성
- **[ ] To-Do**: 최종 발표 자료(PPT) 및 데모 시연 준비 완료
- **[ ] To-Do**: Github 레포지토리 최종 정리 (불필요한 파일 삭제, 커밋 메시지 정돈)
- **[ ] To-Do**: (강력 추천) 프로젝트 과정과 배운 점을 기술 블로그에 기록하기
- **❌ Pitfall**: 마지막까지 새로운 기능 추가에만 몰두하는 함정. 3주차는 '새로운 것을 만드는 것'보다 '만든 것을 잘 포장하고 다듬는 것'이 더 중요합니다.
- **❌ Pitfall**: 발표 준비를 소홀히 하는 것. "같은 10의 노력을 했어도, 100으로 보여주는 사람이 있고 1로 보여주는 사람이 있습니다."

---

## 7. 최종 결과물 및 평가 기준

### 제출 항목
1.  **발표 자료 (PPT/PDF)**: 팀 소개, 프로젝트 목표, 개발 과정, 시스템 아키텍처, 데모 시연, 팀원별 기여도, 회고 등을 포함
2.  **GitHub 레포지토리 링크**: 모든 소스코드와 고품질의 README.md가 포함된 공개 레포지토리
3.  **데모 영상 (3~5분)**: 서비스의 핵심 기능을 명확하게 시연하는 영상

### 평가 기준
| 평가 항목                      | 세부 내용                                                                       | 배점 |
| :----------------------------- | :------------------------------------------------------------------------------ | :--: |
| **1. 문제 해결 능력 (30)**     | 해결하려는 문제가 명확하고, 아이디어의 실용성 및 창의성이 돋보이는가            |  15  |
|                                | 문제를 해결하기 위해 적절한 AI 기술과 도구를 선택하고 활용했는가                |  15  |
| **2. 기술적 완성도 (40)**      | AI 모델이 안정적으로 동작하고, 목표한 성능 수준을 달성했는가                      |  20  |
|                                | 전체 시스템이 기획대로 구현되었으며, 코드의 가독성과 구조가 우수한가            |  20  |
| **3. 협업 및 프로젝트 관리 (15)** | Git/GitHub을 통한 효과적인 협업 흔적이 보이는가 (커밋, PR, 이슈, 코드 리뷰 등) |  15  |
| **4. 발표 및 전달력 (15)**     | 프로젝트의 과정과 결과를 명확하고 논리적으로 전달하는가                           |  10  |
|                                | README, 발표 자료 등 문서의 완성도가 높은가                                     |  5   |

---

캡스톤 프로젝트는 여러분의 가능성을 세상에 보여주는 첫걸음입니다. 과정 자체를 즐기며, 마음껏 도전하고, 마음껏 성장하시길 바랍니다!

---

### 🚨 디버깅 및 트러블슈팅 가이드 (Debugging & Troubleshooting)

프로젝트를 진행하다 보면 예상치 못한 문제들이 발생하기 마련입니다. 다음은 캡스톤 프로젝트 중 흔히 겪는 문제와 해결을 위한 실마리입니다.

<details>
<summary><b>🔹 문제: 모델 학습이 너무 느리거나, GPU 메모리가 부족해요.</b></summary>
<ul>
<li><b>원인 분석:</b> 데이터셋 크기, 모델의 복잡도, 배치 사이즈(Batch Size) 등이 원인일 수 있습니다.</li>
<li><b>해결 방안:</b>
    <ul>
    <li><b>배치 사이즈 줄이기:</b> <code>batch_size</code>를 줄여서 한 번에 처리하는 데이터 양을 줄여보세요.</li>
    <li><b>데이터 증강(Augmentation) 줄이기:</b> 실시간으로 데이터를 변형하는 과정이 많으면 병목이 될 수 있습니다.</li>
    <li><b>모델 경량화:</b> 더 작은 모델(e.g., ResNet18 대신 MobileNet)을 사용하거나, 모델의 레이어 수를 줄여보세요.</li>
    <li><b>GPU 자원 확인:</b> <code>nvidia-smi</code> 명령어로 다른 프로세스가 GPU를 점유하고 있는지 확인하세요.</li>
    </ul>
</li>
</ul>
</details>

<details>
<summary><b>🔹 문제: API 서버(FastAPI)를 실행했는데, 'Connection refused' 오류가 발생해요.</b></summary>
<ul>
<li><b>원인 분석:</b> 서버가 정상적으로 실행되지 않았거나, 방화벽 문제, 혹은 잘못된 주소/포트로 접속을 시도하고 있을 가능성이 높습니다.</li>
<li><b>해결 방안:</b>
    <ul>
    <li><b>서버 로그 확인:</b> Uvicorn 실행 로그에 에러 메시지가 없는지 꼼꼼히 확인하세요.</li>
    <li><b>포트 확인:</b> <code>lsof -i :8000</code> (macOS/Linux) 또는 <code>netstat -ano | findstr :8000</code> (Windows) 명령어로 해당 포트를 다른 프로그램이 사용하고 있는지 확인하세요.</li>
    <li><b>호스트 주소 확인:</b> <code>uvicorn.run(app, host="0.0.0.0", port=8000)</code>과 같이 <code>host</code>를 <code>0.0.0.0</code>으로 설정해야 외부에서 접속이 가능합니다.</li>
    </ul>
</li>
</ul>
</details>

<details>
<summary><b>🔹 문제: Git 충돌(Conflict)이 발생해서 Pull/Merge가 안 돼요.</b></summary>
<ul>
<li><b>원인 분석:</b> 여러 명이 동시에 같은 파일의 같은 부분을 수정했을 때 발생합니다.</li>
<li><b>해결 방안:</b>
    <ul>
    <li><b>침착하게 충돌 해결하기:</b> Git이 알려주는 충돌 파일(e.g., <code>&lt;&lt;&lt;&lt;&lt;&lt;&lt; HEAD</code>, <code>=======</code>, <code>&gt;&gt;&gt;&gt;&gt;&gt;&gt; branch-name</code>)을 열어, 팀원과 상의하여 남길 코드를 결정하고 충돌 마커를 직접 수정하세요.</li>
    <li><b>예방이 최선:</b> 작업 시작 전 항상 <code>git pull origin main</code>으로 최신 코드를 받고 시작하는 습관을 들이고, 서로 작업하는 파일이 겹치지 않도록 사전에 소통하는 것이 중요합니다.</li>
    </ul>
</li>
</ul>
</details>

여러분의 성공적인 캡스톤 프로젝트를 통해, 이 과정에서 배운 모든 것을 종합하고 한 단계 더 성장하는 경험을 하시기를 바랍니다!

---

### ⚠️ What Could Go Wrong? (토론 주제)

캡스톤 프로젝트는 실제 현업의 미니 버전과 같습니다. 기술적인 문제뿐만 아니라, 기획, 소통, 일정 관리 등 다양한 부분에서 예상치 못한 어려움이 발생할 수 있습니다.

1.  **지나치게 야심 찬 목표 설정 (Setting Overly Ambitious Goals)**
    *   제한된 시간과 리소스 안에서 달성 불가능한 거창한 주제(예: "사람처럼 대화하는 AI 챗봇 만들기", "알파고 수준의 바둑 AI 개발")를 선정하여, 결국 아무것도 제대로 완성하지 못하고 이도 저도 아닌 결과물을 내는 경우가 많습니다.
    *   현실적인 프로젝트 범위(Scope)를 설정하는 것이 왜 중요할까요? '핵심 기능(MVP, Minimum Viable Product)'을 먼저 정의하고 점진적으로 확장해나가는 방식의 장점은 무엇일까요?

2.  **'데이터' 없이 '모델'부터 생각하는 함정 (The "Model-first, Data-later" Trap)**
    *   최신 유행하는 멋진 모델(예: LLM, Diffusion Model)을 사용하겠다는 생각에 사로잡혀, 정작 그 모델을 학습시키거나 파인튜닝할 양질의 데이터를 어떻게 확보할지에 대한 계획 없이 프로젝트를 시작하는 경우.
    *   '데이터 가용성'과 '데이터 품질'이 프로젝트 성패에 미치는 영향을 간과하면 어떤 문제가 발생할까요? 프로젝트 기획 단계에서 데이터 확보 계획이 왜 가장 먼저 검토되어야 할까요?

3.  **문제 정의의 실패 (Failure in Problem Definition)**
    *   "무엇을(WHAT)" 만들고 "왜(WHY)" 만드는지에 대한 명확한 고민 없이, 단순히 '어떻게(HOW)' 만들지에만 집중하는 경우. 이로 인해 프로젝트의 목표와 성공의 기준이 모호해지고, 팀원들이 각자 다른 방향으로 헤맬 수 있습니다.
    *   성공적인 프로젝트가 되기 위해, "우리가 해결하려는 문제는 무엇인가?" 와 "프로젝트의 성공 여부를 어떻게 측정할 것인가?" 라는 질문에 먼저 답해야 하는 이유는 무엇일까요?

4.  **팀원 간의 역할 및 책임 불균형 (Imbalance of Roles and Responsibilities)**
    *   팀 프로젝트에서 일부 팀원에게만 업무가 과중되거나, 누구도 책임지지 않는 업무 공백(예: 문서 정리, 최종 발표 자료 제작)이 발생하는 경우가 빈번합니다. 이는 팀의 사기를 저하시키고 갈등을 유발하는 주요 원인이 됩니다.
    *   성공적인 협업을 위해 프로젝트 초기에 어떤 것들(예: 역할 분담(R&R), 소통 규칙, 정기 회의, 일정 관리 도구 사용)을 명확히 정의해야 할까요?

5.  **'완성'에 대한 집착으로 학습 기회 상실 (Losing Learning Opportunities by Obsessing over "Completion")**
    *   최종 결과물의 '완성도'와 '발표'에만 집착한 나머지, 과정에서 겪는 수많은 실패와 디버깅, 다양한 실험과 그로부터 얻은 교훈의 중요성을 간과할 수 있습니다.
    *   캡스톤 프로젝트의 진정한 목표가 '완벽한 제품 출시'가 아니라 '과정을 통한 실용적 학습'에 있다는 것을 어떻게 상기할 수 있을까요? 실패 기록과 회고(Retrospective)가 왜 중요할까요? 