# Part 15: 캡스톤 프로젝트 템플릿

이 문서는 여러분의 최종 캡스톤 프로젝트를 체계적으로 기획하고 관리하는 데 도움을 주기 위한 템플릿입니다. 이 구조를 바탕으로 팀원들과 논의하며 내용을 채워나가세요.

---

## 1. 프로젝트 개요 (Project Overview)

### 1.1. 프로젝트 명
- (예: 챗봇과 이미지 생성을 결합한 동화 작가 어시스턴트)

### 1.2. 한 줄 요약
- (프로젝트를 한 문장으로 설명해주세요)

### 1.3. 팀원 및 역할
- `홍길동`: 프로젝트 총괄, 백엔드 API 개발
- `김철수`: 모델 리서치, 프롬프트 엔지니어링, RAG 파이프라인 구축
- `이영희`: 데이터 수집 및 전처리, 모델 성능 평가

---

## 2. 문제 정의 (Problem Definition)

### 2.1. 해결하고자 하는 문제
- (어떤 문제를 해결하고 싶으신가요? 이 문제가 왜 중요한가요?)
- (예: 아이를 키우는 부모들이 매일 밤 새로운 동화를 지어주는 데 어려움을 겪고 있음. 창의적인 아이디어를 제공하고, 아이의 선택에 따라 이야기가 변하는 인터랙티브한 경험을 제공하고 싶음.)

### 2.2. 기존 해결책의 한계
- (현재 시장에 나와있는 유사 서비스나 해결책은 무엇이며, 어떤 한계점을 가지고 있나요?)
- (예: 기존 동화 앱은 이야기가 고정되어 있어 반복적으로 사용하기 지루함. 사용자의 참여가 제한적임.)

### 2.3. 우리 프로젝트만의 차별점
- (우리 프로젝트가 기존 해결책과 비교했을 때 가지는 독창적인 장점은 무엇인가요?)
- (예: LLM을 이용해 아이가 원하는 키워드(주인공, 장소 등)를 입력하면 실시간으로 새로운 이야기를 생성. DALL-E와 같은 이미지 생성 모델을 연동하여, 생성된 이야기의 장면을 즉시 시각화하여 보여줌.)

---

## 3. 개발 계획 (Development Plan)

### 3.1. 기술 스택 (Tech Stack)
- **언어**: Python
- **AI/ML**: `PyTorch`, `LangChain`, `Hugging Face Transformers`
- **백엔드**: `FastAPI`
- **프론트엔드**: `Streamlit` 또는 `React` (선택)
- **데이터베이스/저장소**: `ChromaDB` (벡터 저장소), `S3` (이미지 저장)
- **배포**: `Docker`

### 3.2. 데이터 수집 및 가공
- (어떤 데이터를 사용하실 건가요? 데이터는 어디서 수집하고, 어떻게 가공할 계획인가요?)
- (예: 공개된 동화 텍스트 데이터셋(약 1000편)을 수집하여, RAG의 외부 지식 소스로 활용. 별도의 파인튜닝은 초기 버전에서는 제외.)

### 3.3. 핵심 기능 정의 (Core Features)
- **1순위 (Must-have)**
  - [ ] 키워드 기반 동화 텍스트 생성 기능
  - [ ] 생성된 텍스트의 핵심 장면을 이미지로 생성하는 기능
  - [ ] FastAPI를 이용한 API 서버 구축
- **2순위 (Should-have)**
  - [ ] 사용자가 이야기의 다음 분기를 선택할 수 있는 인터랙티브 기능
  - [ ] 생성된 동화를 PDF나 이미지 파일로 저장하는 기능
- **3순위 (Nice-to-have)**
  - [ ] 생성된 이야기에 어울리는 배경 음악 추천/생성 기능

### 3.4. 주차별 개발 마일스톤 (Milestones)
- **1주차**: 프로젝트 기획 구체화, 데이터 수집 및 분석, 기본 모델 리서치
- **2주차**: RAG 파이프라인 프로토타입 개발, 핵심 프롬프트 설계
- **3주차**: 백엔드 API 서버 구조 설계 및 기본 기능 구현
- **4주차**: 프론트엔드 UI/UX 설계 및 개발, 최종 발표 준비

---

## 4. 평가 계획 (Evaluation Plan)

### 4.1. 성공의 기준
- (프로젝트가 '성공했다'고 판단할 수 있는 기준은 무엇인가요? 정성적/정량적 기준을 모두 생각해보세요.)
- **정량적 목표**:
  - 하루 평균 100건 이상의 동화 생성 요청 처리
  - 생성된 이야기의 문법적 오류율 5% 미만
- **정성적 목표**:
  - 최종 발표 시, '아이디어가 참신하고 재미있다'는 평가를 2/3 이상으로부터 받기
  - 팀원 모두가 자신이 맡은 역할에 대해 만족하고, 프로젝트 경험을 통해 성장했다고 느끼기

### 4.2. 예상되는 어려움 및 해결 방안
- **어려움**: 이미지 생성 모델의 API 비용 문제
  - **해결 방안**: 개발 단계에서는 무료 티어(tier)를 최대한 활용하고, 실제 배포 시에는 사용량 제한(rate limit) 기능 구현
- **어려움**: 원하는 품질의 동화 생성을 위한 프롬프트 엔지니어링
  - **해결 방안**: 다양한 프롬프트 패턴(예: Few-shot, Chain-of-Thought)을 실험하고, 가장 결과가 좋은 템플릿을 시스템에 적용

---

> [!NOTE]
> 이 템플릿은 가이드일 뿐입니다. 프로젝트의 특성에 맞게 자유롭게 수정하고 발전시켜 나가세요! 