# Part 11: 프로덕션 레벨 MLOps 심화

**⬅️ 이전 시간: [Part 10: 전문가로 가는 길](../10_expert_path/part_10_expert_path.md)**
**➡️ 다음 시간: [Part 12: 대규모 AI 모델 최적화 및 서빙](../12_model_optimization/part_12_model_optimization.md)**

---

## 1. 학습 목표 (Learning Objectives)

> 이 섹션에서는 MLOps의 핵심 요소들을 심도 있게 다루고, 프로덕션 환경에서 머신러닝 모델을 안정적으로 운영하기 위한 기술들을 학습합니다.

- Kubeflow를 이용한 ML 파이프라인 오케스트레이션 방법을 이해합니다.
- GitHub Actions를 활용하여 ML 모델을 위한 CI/CD 파이프라인을 구축할 수 있습니다.
- Prometheus, Grafana, Evidently AI를 사용하여 실시간으로 모델 성능과 데이터 드리프트를 모니터링하는 시스템을 설계합니다.
- Feature Store의 개념을 이해하고, Feast를 활용하여 피처 관리의 효율성을 높이는 방법을 학습합니다.

## 2. 핵심 키워드 (Keywords)

`MLOps`, `Kubeflow`, `CI/CD`, `GitHub Actions`, `Prometheus`, `Grafana`, `Evidently AI`, `Feature Store`, `Feast`

## 3. 도입

머신러닝 모델을 성공적으로 개발하는 것과, 이를 안정적으로 운영하여 비즈니스 가치를 창출하는 것은 전혀 다른 차원의 문제입니다. Part 11에서는 '모델 개발' 이후의 단계, 즉 프로덕션 환경에서 마주하게 될 현실적인 과제들을 해결하는 '프로덕션 레벨 MLOps' 기술을 심도 있게 탐구합니다. 이제 여러분의 모델을 실험실에서 꺼내 실제 세상에서 살아 숨 쉬게 만드는 여정을 시작하겠습니다.

---

## 4. ML 파이프라인 오케스트레이션

### Kubeflow 소개

Kubeflow는 머신러닝(ML) 워크플로우를 Kubernetes 상에서 간단하고, 이식성 있으며, 확장 가능하게 배포하는 것을 목표로 하는 오픈소스 플랫폼입니다. Google에서 시작하여 현재는 커뮤니티 중심으로 개발되고 있으며, ML 수명주기 전반을 지원하는 다양한 도구들을 통합 제공합니다.

**주요 특징:**

- **Composability (구성성)**: 각기 다른 클라우드와 온프레미스 환경에서 동일하게 실행되는 ML 파이프라인을 쉽게 구성할 수 있습니다.
- **Portability (이식성)**: 한번 개발한 ML 워크플로우는 큰 변경 없이 로컬, 온프레미스, 클라우드 등 다양한 Kubernetes 환경으로 이전할 수 있습니다.
- **Scalability (확장성)**: Kubernetes의 강력한 확장성을 기반으로 데이터 처리, 모델 학습, 서빙 등 각 단계의 리소스를 유연하게 조절할 수 있습니다.

**핵심 구성 요소:**

- **Kubeflow Pipelines**: ML 워크플로우를 파이프라인으로 구성하고 관리하는 도구입니다. 각 단계를 컨테이너화된 컴포넌트로 정의하고, 이들의 실행 순서와 의존성을 관리합니다. 재사용 가능한 컴포넌트를 만들어 파이프라인을 효율적으로 구축할 수 있습니다.
- **Katib**: 하이퍼파라미터 튜닝 및 신경망 아키텍처 탐색(NAS)을 자동화하는 도구입니다. 최적의 모델을 찾기 위한 다양한 알고리즘(예: Grid Search, Random Search, Bayesian Optimization)을 지원합니다.
- **KServe (구 KFServing)**: 복잡한 서버리스 추론 워크로드를 Kubernetes에서 실행하기 위한 표준 모델 추론 플랫폼입니다. Canary 배포, 자동 스케일링 등 프로덕션 환경에 필수적인 기능을 제공합니다.
- **Training Operators**: TensorFlow, PyTorch, XGBoost, MPI 등 다양한 프레임워크를 사용하여 분산 학습을 쉽게 실행할 수 있도록 Kubernetes Custom Resource (CRD)를 제공합니다.

---

## 5. CI/CD for Machine Learning

### GitHub Actions를 활용한 ML CI/CD

CI/CD(Continuous Integration/Continuous Deployment & Delivery)는 소프트웨어 개발의 핵심적인 자동화 프로세스입니다. 머신러닝 시스템에 CI/CD를 적용하는 것을 특별히 MLOps의 CI/CD라고 하며, 이는 코드뿐만 아니라 데이터와 모델의 변경사항까지 지속적으로 통합하고 테스트하며 배포하는 것을 목표로 합니다.

**ML을 위한 CI/CD의 주요 단계:**

- **CI (Continuous Integration)**:
    - **코드 통합**: 새로운 코드(데이터 처리, 피처 엔지니어링, 모델링 등)가 중앙 리포지토리(예: Git)에 통합될 때마다 자동화된 빌드 및 테스트를 실행합니다.
    - **단위/통합 테스트**: 코드의 기능적 정확성을 검증합니다.
    - **데이터 유효성 검사**: 새로운 데이터의 스키마, 분포 등을 검증합니다.
    - **모델 품질 검증**: 학습된 모델이 최소 성능 요구사항을 만족하는지 검증합니다.
- **CD (Continuous Deployment/Delivery)**:
    - **모델 배포 자동화**: CI를 통과한 모델을 자동으로 스테이징 또는 프로덕션 환경에 배포합니다.
    - **점진적 배포 (Progressive Delivery)**: Canary 배포, Blue/Green 배포, A/B 테스트 등의 전략을 사용하여 새로운 모델을 점진적으로 릴리즈하고, 안정성을 모니터링합니다.
    - **모델 롤백**: 새로운 모델에 문제가 발생했을 경우, 이전 버전으로 신속하게 롤백하는 파이프라인을 구축합니다.

**GitHub Actions란?**

GitHub Actions는 GitHub 리포지토리에서 바로 소프트웨어 개발 워크플로우를 자동화할 수 있게 해주는 도구입니다. 코드 푸시, Pull Request 생성 등 특정 이벤트에 의해 트리거되는 워크플로우를 YAML 파일 형식으로 간단하게 정의할 수 있어, ML을 위한 CI/CD 파이프라인을 구축하는 데 매우 유용합니다.

**GitHub Actions 워크플로우 예시 (.github/workflows/main.yml):**

```yaml
name: CI/CD for ML Model

on:
  push:
    branches: [ main ]

jobs:
  build-and-test:
    runs-on: ubuntu-latest
    steps:
    - name: Checkout code
      uses: actions/checkout@v3

    - name: Set up Python
      uses: actions/setup-python@v4
      with:
        python-version: '3.9'

    - name: Install dependencies
      run: |
        python -m pip install --upgrade pip
        pip install -r requirements.txt

    - name: Run tests
      run: |
        # 여기에 단위 테스트, 데이터 유효성 검사 등 실행
        pytest

    - name: Train model
      run: |
        python train.py # 모델 학습 스크립트 실행

    # ... 이후 모델을 저장하고, 배포하는 단계 추가 ...
``` 

---

## 6. 실시간 모델 모니터링 및 Alarming

프로덕션 환경에서 운영되는 머신러닝 모델은 시간이 지남에 따라 성능이 저하될 수 있습니다. 입력 데이터의 분포가 변하는 '데이터 드리프트(Data Drift)'나 모델의 예측 성능 자체가 떨어지는 '컨셉 드리프트(Concept Drift)'가 주요 원인입니다. 따라서 모델의 상태와 성능을 실시간으로 모니터링하고, 문제가 발생했을 때 즉시 대응할 수 있는 시스템을 구축하는 것이 필수적입니다.

이 섹션에서는 다음과 같은 오픈소스 도구를 활용한 모니터링 및 알림 시스템 구축 방법을 다룹니다.

- **Prometheus**: 시계열 데이터(Time-series data)를 수집하고 저장하는 모니터링 시스템 및 데이터베이스
- **Grafana**: 수집된 데이터를 시각화하고 대시보드를 구축하는 분석 플랫폼
- **Evidently AI**: 데이터 드리프트, 모델 성능 등 ML 시스템의 품질을 평가하고 시각화하는 전문 라이브러리

### Prometheus: 시스템 메트릭 수집

Prometheus는 서비스 디스커버리 또는 정적 설정을 통해 대상(endpoint)으로부터 HTTP 요청으로 메트릭을 주기적으로 수집(pull)하는 방식으로 동작합니다. FastAPI와 같은 API 서버에서는 클라이언트 라이브러리를 사용하여 예측 요청 수, 지연 시간, 에러율 등 다양한 메트릭을 노출할 수 있습니다.

### Grafana: 모니터링 대시보드 시각화

Grafana는 Prometheus를 데이터 소스(Data Source)로 연동하여, 수집된 메트릭을 의미 있는 그래프와 차트로 시각화합니다. 사용자는 드래그 앤 드롭 인터페이스를 통해 다음과 같은 정보를 포함하는 맞춤형 대시보드를 쉽게 만들 수 있습니다.

- 시간당 예측 요청 수 (RPS)
- 예측 응답 시간의 분포 (Latency)
- HTTP 상태 코드별 에러율

또한, 특정 메트릭이 임계값을 넘었을 때 Slack, 이메일 등으로 알림(Alert)을 보내도록 설정할 수 있습니다.

### Evidently AI: ML 모델 품질 모니터링

Prometheus와 Grafana가 시스템의 운영 메트릭에 중점을 둔다면, Evidently AI는 모델 자체의 품질과 데이터의 통계적 특성 변화를 모니터링하는 데 특화되어 있습니다.

**주요 기능:**

- **데이터 드리프트 감지**: 학습에 사용된 참조(reference) 데이터셋과 현재 프로덕션 환경의 입력 데이터셋 간의 통계적 분포 차이를 감지합니다.
- **타겟 드리프트 및 모델 성능 모니터링**: 예측값의 분포 변화나, 실제 레이블이 제공될 경우 정확도/F1 점수 등 모델 성능 지표의 변화를 추적합니다.
- **시각적 리포트 생성**: 드리프트 및 성능 분석 결과를 HTML 리포트나 JSON 프로필로 생성하여 직관적으로 확인할 수 있습니다.

Evidently AI는 배치(batch) 작업으로 리포트를 생성하거나, FastAPI 엔드포인트와 통합하여 실시간으로 메트릭을 계산하고 이를 Prometheus로 노출시켜 Grafana 대시보드에 함께 표시하는 방식으로 활용할 수 있습니다. 

---

## 7. Feature Store의 이해와 활용

머신러닝 모델을 개발하고 운영하는 과정에서 '피처(Feature)'는 매우 중요한 역할을 합니다. 좋은 피처를 발굴하고, 일관성 있게 관리하며, 학습과 추론 파이프라인에 안정적으로 제공하는 것은 성공적인 MLOps의 핵심 과제 중 하나입니다. Feature Store는 바로 이러한 피처 관련 작업을 중앙에서 체계적으로 관리하기 위한 데이터 시스템입니다.

### Feature Store란?

Feature Store는 ML 피처를 저장, 관리, 검색하고 제공하는 중앙 집중식 저장소입니다. ML 시스템의 학습(Training)과 서빙(Serving)이라는 두 가지 주요 사용 사례를 모두 지원하도록 설계되었습니다.

**주요 필요성:**

- **학습-서빙 스큐(Training-Serving Skew) 방지**: 모델 학습 시점과 실시간 예측 시점에서 피처를 계산하는 로직이 달라 발생할 수 있는 불일치 문제를 해결합니다. 동일한 피처 정의를 공유하여 일관성을 보장합니다.
- **피처 재사용성 증대**: 여러 모델과 팀에서 공통으로 사용하는 피처를 중앙에서 관리하여 중복 개발을 방지하고 협업을 촉진합니다.
- **피처 검색 및 탐색 용이**: 어떤 피처가 사용 가능한지, 어떻게 정의되었는지 쉽게 검색하고 이해할 수 있는 중앙 카탈로그 역할을 합니다.
- **Point-in-Time Correctness 보장**: 특정 시점 기준으로 정확한 피처를 조회할 수 있게 하여, 데이터 누수(Data Leakage) 없이 과거 데이터를 사용한 모델 학습을 지원합니다.

### Feast (Feature Store for ML) 소개

Feast는 Feature Store를 구축하기 위한 널리 사용되는 오픈소스 프레임워크입니다. Python 라이브러리 기반으로 가볍게 시작할 수 있으며, 프로덕션 환경까지 확장 가능한 유연성을 제공합니다.

**Feast의 주요 개념:**

- **Feature Repository**: Feast의 핵심으로, 피처 정의, 데이터 소스, 관련 객체들을 파일 기반으로 관리하는 디렉토리입니다. Git과 같은 버전 관리 시스템으로 쉽게 추적할 수 있습니다.
- **Data Source**: 원본 데이터가 저장된 위치를 가리킵니다. 파일(Parquet, CSV), BigQuery, Redshift, Snowflake 등 다양한 소스를 지원합니다.
- **Entity**: 피처가 연결되는 기본 키(Primary Key)입니다. 예를 들어, '사용자 ID', '상품 ID' 등이 Entity가 될 수 있습니다.
- **Feature View**: 피처를 논리적으로 그룹화하고, 데이터 소스와 Entity를 연결하는 핵심 객체입니다. Feature View를 통해 특정 Entity에 대한 피처들을 어떻게 가져올지 정의합니다.
- **Offline Store**: 대량의 과거 피처 데이터를 저장하는 곳입니다. 주로 모델 학습용 데이터를 생성하는 데 사용됩니다. (예: 파일, BigQuery, Snowflake)
- **Online Store**: 낮은 지연 시간(Low-latency)으로 최신 피처 값을 조회할 수 있도록 저장하는 키-밸류(Key-Value) 저장소입니다. 실시간 모델 추론 시 사용됩니다. (예: Redis, DynamoDB, Datastore)

**Feast 아키텍처:**

Feast는 크게 두 가지 데이터 흐름을 관리합니다.

- **Materialization (구체화)**: 오프라인 스토어의 피처 데이터를 주기적으로 읽어와 온라인 스토어에 최신 상태로 적재하는 프로세스입니다. `feast materialize` 명령어로 실행합니다.
- **Data Retrieval (데이터 조회)**:
    - **학습 데이터셋 생성**: `get_historical_features()` 함수를 사용하여 여러 Feature View에서 특정 시점 기준의 피처들을 조인하여 학습용 데이터프레임을 생성합니다.
    - **온라인 피처 서빙**: `get_online_features()` 함수를 사용하여 특정 Entity 키에 해당하는 최신 피처 벡터를 빠르게 조회하여 실시간 추론에 사용합니다. 

---

## 캡스톤 프로젝트 연계 미니 프로젝트: 나만의 AI API를 위한 CI 파이프라인 구축하기

지금까지 우리는 훌륭한 AI 모델을 만들고, API로 서빙하며, Docker로 포장하는 방법을 배웠습니다. 이제 '전문가처럼' 이 과정을 자동화할 시간입니다. 이번 미니 프로젝트에서는 9장에서 만든 '나만의 AI API 밀키트' 프로젝트에 CI(Continuous Integration, 지속적 통합) 파이프라인을 구축합니다. 코드가 변경될 때마다 자동으로 테스트를 실행하여, 우리 서비스의 안정성을 한 단계 끌어올리는 것을 목표로 합니다.

### 프로젝트 목표
- `pytest`를 사용하여 FastAPI 애플리케이션의 기본적인 동작을 검증하는 테스트 코드를 작성할 수 있습니다.
- GitHub 리포지토리에 코드를 푸시(push)할 때, 특정 작업이 자동으로 실행되도록 GitHub Actions 워크플로우를 설정할 수 있습니다.
- CI 파이프라인에 테스트 자동화, Docker 이미지 빌드 등 ML 프로젝트에 필수적인 단계들을 포함시키고, 실행 결과를 GitHub에서 직접 확인할 수 있습니다.

### 개발 과정
1.  **테스트 코드 작성 (`tests/test_api.py`)**:
    - 9장에서 만든 프로덕션 API 프로젝트(`my_prod_api`)에 `tests` 폴더를 추가하고, `pytest`와 `httpx` 라이브러리를 설치합니다. (`pip install pytest httpx`)
    - API의 상태와 예측 엔드포인트가 정상적으로 동작하는지 확인하는 간단한 테스트 코드를 작성합니다.
      ```python
      from fastapi.testclient import TestClient
      from app.main import app # 여러분의 FastAPI 앱을 임포트합니다.
      import pytest

      client = TestClient(app)

      def test_read_main():
          response = client.get("/")
          assert response.status_code == 200
          assert response.json() == {"message": "AI 레스토랑에 오신 것을 환영합니다."}

      def test_predict_sentiment_positive():
          # 8장에서 만든 감성분석 API를 테스트하는 예시
          response = client.post("/predict", json={"text": "This movie is fantastic!"})
          assert response.status_code == 200
          data = response.json()
          assert data["sentiment"] == "positive"
          assert data["score"] > 0.5
      ```

2.  **GitHub 리포지토리 생성 및 코드 푸시**:
    - GitHub에 새로운 리포지토리를 생성합니다.
    - 9장에서 수정한 `my_prod_api` 프로젝트를 이 리포지토리에 푸시합니다.

3.  **GitHub Actions 워크플로우 파일 생성 (`.github/workflows/ci.yml`)**:
    - 프로젝트 루트에 `.github/workflows` 폴더를 생성하고, 그 안에 `ci.yml` 파일을 작성합니다.
      ```yaml
      name: CI Pipeline

      on:
        push:
          branches: [ main ]
        pull_request:
          branches: [ main ]

      jobs:
        build-and-test:
          runs-on: ubuntu-latest
          steps:
            - name: Checkout code
              uses: actions/checkout@v3

            - name: Set up Python 3.9
              uses: actions/setup-python@v4
              with:
                python-version: '3.9'

            - name: Install dependencies
              run: |
                python -m pip install --upgrade pip
                pip install -r requirements.txt
                pip install pytest httpx # 테스트에 필요한 라이브러리 설치

            - name: Run tests with pytest
              run: pytest tests/

            - name: Build Docker image
              run: docker build -t my-awesome-api .
      ```

4.  **CI 파이프라인 실행 및 결과 확인**:
    - `ci.yml` 파일을 포함한 변경사항을 `main` 브랜치에 푸시합니다.
    - GitHub 리포지토리의 'Actions' 탭으로 이동하여, 방금 푸시한 커밋에 대해 워크플로우가 자동으로 실행되는 것을 확인합니다.
    - 각 단계(코드 체크아웃, 의존성 설치, 테스트 실행, 도커 빌드)가 성공적으로 완료되어 녹색 체크 표시가 뜨는지 확인합니다. 만약 실패한다면, 로그를 통해 원인을 분석하고 코드를 수정하여 다시 푸시합니다.

### 캡스톤 프로젝트 연계 방안
이번에 구축한 CI 파이프라인은 캡스톤 프로젝트의 '품질 관리 시스템'입니다. 팀원들이 새로운 코드를 추가하거나 수정할 때마다, 이 파이프라인이 자동으로 코드의 안정성을 검증해줍니다. 이를 통해 "제 컴퓨터에선 됐는데..."와 같은 문제를 예방하고, 여러 명이 협업하더라도 항상 안정적인 상태의 프로젝트를 유지할 수 있습니다. 캡스톤 프로젝트에서는 이 파이프라인을 확장하여, 테스트를 통과한 모델을 자동으로 스테이징 서버에 배포(CD)하는 단계까지 구현해볼 수 있습니다.

---

## 8. 트러블슈팅 (Troubleshooting)

- **GitHub Actions 워크플로우 실행 시 `command not found: pytest` 또는 `No module named 'pandas'` 오류가 발생하나요?**
  - 이는 워크플로우의 `runner`(실행 환경)에 필요한 라이브러리가 설치되지 않았기 때문입니다.
- **Evidently AI로 리포트 생성 시 `ValueError: Reference data has ... features, but current data has ... features` 오류가 발생하나요?**
  - 참조(reference) 데이터와 현재(current) 데이터의 컬럼(피처) 수가 일치하지 않는 경우입니다. 데이터 전처리 파이프라인이 두 데이터셋에 동일하게 적용되었는지, 특정 컬럼이 누락되거나 추가되지는 않았는지 스키마를 확인해야 합니다.
- **Feast `get_historical_features()` 실행이 매우 느리거나 메모리 부족 오류가 발생하나요?**
  - 오프라인 스토어에서 대규모 데이터를 처리할 때 발생할 수 있는 문제입니다. `entity_df`에 포함된 엔티티의 수나 조회 기간이 너무 크지 않은지 확인해보세요. 필요한 피처만 선택적으로 조회하거나, Spark와 같은 분산 처리 엔진을 데이터 소스로 사용하여 성능을 개선할 수 있습니다.
- **Feast `materialize` 실행 후 온라인 스토어에서 피처를 조회해도 예전 값만 보이나요?**
  - `materialize` 명령은 특정 시간 범위의 데이터를 오프라인 스토어에서 온라인 스토어로 '밀어넣는' 작업입니다. `materialize-incremental`을 사용하여 주기적으로 최신 데이터를 증분(incremental) 반영하도록 스케줄링했는지 확인하세요. 또는, `feast materialize <end-date> --view <feature-view-name>` 와 같이 시간 범위를 명시적으로 지정하여 최신 데이터가 포함되도록 실행했는지 확인해야 합니다.

더 자세한 문제 해결 가이드나 다른 동료들이 겪은 문제에 대한 해결책이 궁금하다면, 아래 문서를 참고해주세요.

- **➡️ [Geumdo-Docs: TROUBLESHOOTING.md](../../../TROUBLESHOOTING.md)**

---

## 9. 개념 확인 퀴즈 (Concept Check Quiz)

1. Kubeflow Pipelines의 주요 역할은 무엇이며, ML 워크플로우를 어떻게 구성하나요?
2. ML을 위한 CI/CD 파이프라인에서 '데이터 유효성 검사'와 '모델 품질 검증'이 왜 중요한가요?
3. Feature Store가 해결하고자 하는 핵심 문제인 '학습-서빙 스큐(Training-Serving Skew)'는 무엇인가요?

---

## 10. 과제 (Assignment)

1. **모니터링 시스템 설계**: Prometheus와 Grafana를 사용하여 간단한 FastAPI 애플리케이션의 API 요청 수와 응답 시간을 모니터링하는 대시보드를 구축하는 과정을 순서대로 설명해 보세요. (실제 구축이 아닌, 개념적 순서 설명)
2. **Feature Store 도입 설득**: 여러분이 데이터 사이언티스트 팀의 리드라고 상상해 보세요. 동료들에게 Feature Store 도입의 필요성을 설득하기 위한 3가지 핵심 논거를 제시해 보세요.

---

## 11. 되짚어보기 (Summary)

이번 파트에서는 모델 개발 이후, 프로덕션 환경에서 AI 모델을 안정적으로 운영하기 위한 MLOps 기술들을 심도 있게 다루었습니다.

- **ML 파이프라인 오케스트레이션**: Kubernetes 기반의 ML 워크플로우 자동화 도구인 Kubeflow의 핵심 구성 요소와 역할을 이해했습니다.
- **CI/CD for ML**: GitHub Actions를 활용하여 코드, 데이터, 모델의 변경 사항을 지속적으로 통합하고 배포하는 자동화 파이프라인 구축법을 배웠습니다.
- **실시간 모니터링**: Prometheus, Grafana, Evidently AI를 조합하여 시스템 메트릭부터 데이터 드리프트, 모델 성능까지 다각도로 모니터링하는 방법을 확인했습니다.
- **Feature Store**: 학습-서빙 스큐 방지, 피처 재사용성 증대를 위한 Feature Store의 개념을 이해하고, 오픈소스 프레임워크인 Feast의 작동 방식을 탐구했습니다.

---

## 12. 더 깊이 알아보기 (Further Reading)
- [Kubeflow 공식 문서](https://www.kubeflow.org/docs/): Kubeflow의 다양한 컴포넌트에 대한 상세한 가이드
- [GitHub Actions 문서](https://docs.github.com/en/actions): 워크플로우 작성법 및 다양한 예제
- [Evidently AI 공식 문서](https://docs.evidentlyai.com/): 데이터 드리프트 및 모델 성능 모니터링 리포트 생성 가이드
- [Feast 공식 문서](https://docs.feast.dev/): Feature Store 구축을 위한 튜토리얼 및 핵심 개념

---

**➡️ 다음 시간: [Part 12: 대규모 AI 모델 최적화 및 서빙](../12_model_optimization/part_12_model_optimization.md)**

### 참고 자료

*   [MLOps Community](https://mlops.community/): MLOps 관련 최신 정보, 아티클, 팟캐스트를 얻을 수 있는 커뮤니티
*   [Google Cloud의 MLOps 가이드](https://cloud.google.com/architecture/mlops-continuous-delivery-and-automation-pipelines-in-machine-learning?hl=ko): MLOps의 레벨별 정의와 구성 요소를 체계적으로 설명한 문서

---

### ⚠️ What Could Go Wrong? (토론 주제)

MLOps는 단순히 도구를 도입하는 것을 넘어, 조직의 문화와 프로세스를 바꾸는 복잡한 과정입니다. 많은 조직이 MLOps 도입 과정에서 어려움을 겪습니다.

1.  **'모든 것을 자동화'하려는 함정 (The "Automate Everything" Trap)**
    *   MLOps의 궁극적인 목표가 자동화는 맞지만, 아직 프로토타입 단계에 있거나 비즈니스 가치가 불확실한 모델에 대해 처음부터 너무 거대하고 복잡한 CI/CD/CT 파이프라인을 구축하는 것은 '과도한 엔지니어링(Over-engineering)'일 수 있습니다.
    *   프로젝트의 성숙도(초기 연구 vs 프로덕션)에 따라 MLOps의 적용 수준을 어떻게 조절하는 것이 현명할까요? "좋은 MLOps"와 "나쁜 MLOps"를 가르는 기준은 무엇일까요?

2.  **데이터 중심 원칙의 부재 (Lack of Data-centric Principles)**
    *   멋진 파이프라인을 구축하고 모델 버전을 관리하는 데 집중하느라, 정작 그 파이프라인에 입력되는 데이터의 품질, 버전, 통계적 분포 변화(Data Drift)를 추적하고 관리하는 데 소홀히 하는 경우가 많습니다.
    *   "쓰레기가 들어가면 쓰레기가 나온다(Garbage In, Garbage Out)"는 원칙이, 지속적으로 재학습되는 ML 시스템에서는 왜 더욱 치명적일까요? 데이터 중심(Data-centric) MLOps를 위해 어떤 요소(e.g., Feature Stores, Data Validation)가 중요할까요?

3.  **사일로화된 MLOps 팀 (Siloed MLOps Team)**
    *   MLOps를 위한 플랫폼을 구축하는 엔지니어링 팀이 모델을 개발하는 데이터 사이언티스트 팀과 긴밀하게 협업하지 않고, "그들만의" 인프라를 구축하는 경우가 있습니다. 이로 인해 실제 모델 개발 및 배포의 어려움이 전혀 반영되지 않은, 사용하기 어려운 MLOps 플랫폼이 탄생하게 됩니다.
    *   DevOps와 마찬가지로 MLOps가 특정 팀의 업무가 아닌 '문화'로 자리 잡기 위해, 조직 내에서 어떤 노력이 필요할까요?

4.  **보안 및 규제 준수 간과 (Overlooking Security and Compliance)**
    *   학습에 사용된 민감 데이터, 모델 아티팩트, 예측 API 엔드포인트에 대한 접근 제어 및 보안을 소홀히 하여, 모델의 가중치나 내부 데이터가 외부에 유출될 수 있습니다.
    *   GDPR, HIPAA 등 데이터 규제가 엄격한 산업에서, "이 모델이 왜 이런 예측을 했는가?"를 설명하고 감사(Audit)에 대비하기 위해 MLOps 파이프라인에 어떤 기능(예: 예측 결과 및 근거 로깅, 모델 카드)이 포함되어야 할까요?

5.  **비용 관리의 실패 (Failure in Cost Management)**
    *   코드가 커밋될 때마다 전체 학습 파이프라인이 자동으로 실행되도록 설정하여 막대한 클라우드 비용이 발생하거나, 실험 추적을 위해 모든 중간 결과물을 저장하다 스토리지 비용이 폭증하는 등 비용 관리에 실패할 수 있습니다.
    *   효율적인 MLOps를 위해, 성능과 비용 사이의 균형을 맞출 수 있는 전략(예: 캐싱, GPU 자원 관리, 경량 모델 실험)은 무엇이 있을까요? 