# Part 7.5: 강화학습 (Reinforcement Learning)

**⬅️ 이전 시간: [Part 7.4: 그래프 신경망 (GNN)](./part_7.4_graph_neural_networks.md)**
**➡️ 다음 시간: [Part 8: FastAPI를 이용한 모델 서빙](../08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md)**

---

<br>

> [!WARNING]
> 이 파트는 현재 준비 중입니다. 강화학습의 핵심 개념과 Gymnasium 라이브러리를 사용한 실습 코드가 추가될 예정입니다.

<br>

> ## 1. 학습 목표 (Learning Objectives)
>
> 이번 파트가 끝나면, 여러분은 다음을 할 수 있게 됩니다.
> 
> - 강화학습이 지도/비지도학습과 어떻게 다른지 설명할 수 있습니다.
> - 에이전트, 환경, 상태, 행동, 보상 등 강화학습의 핵심 구성요소를 이해합니다.
> - 정책(Policy)과 가치 함수(Value Function)의 개념을 설명할 수 있습니다.
> - 강화학습이 어떤 문제들을 해결하는 데 사용될 수 있는지 이해합니다.

<br>

> ## 2. 핵심 키워드 (Keywords)
> 
> `강화학습(Reinforcement Learning)`, `에이전트(Agent)`, `환경(Environment)`, `상태(State)`, `행동(Action)`, `보상(Reward)`, `정책(Policy)`, `Q-러닝(Q-Learning)`, `Gymnasium`

<br>

> ## 3. 도입: 보상을 통해 학습하는 모델
> 
> 지금까지 우리가 배운 딥러닝(지도학습)은 '정답'이 있는 데이터를 기반으로 했습니다. '이 이미지는 고양이'라는 정답을 알려주며 학습시켰습니다.
> 
> 하지만 '자전거 타는 법'이나 '게임에서 이기는 법'을 배울 때를 생각해보세요. 모든 순간마다 '정답' 행동이 주어지지 않습니다. 우리는 수많은 '시행착오'를 통해 '이렇게 하니 넘어지더라(나쁜 보상)', '저렇게 하니 더 멀리 가더라(좋은 보상)'를 스스로 터득합니다.
> 
> **강화학습(Reinforcement Learning, RL)**은 이처럼 '정답' 대신 **'보상(Reward)'** 이라는 신호를 통해, 주어진 환경(Environment) 속에서 보상을 최대로 얻을 수 있는 행동 전략, 즉 **정책(Policy)** 을 학습하는 패러다임입니다.
> 
> ![Reinforcement Learning](https://i.imgur.com/g8nN8e6.gif)
> *(이미지 출처: MathWorks)*
> 
> - **에이전트 (Agent)**: 학습의 주체. 우리의 모델 (예: 게임 플레이어, 로봇)
> - **환경 (Environment)**: 에이전트가 상호작용하는 세상 (예: 게임 맵, 실제 공간)
> - **상태 (State)**: 환경의 현재 상황.
> - **행동 (Action)**: 에이전트가 상태를 보고 취할 수 있는 행동.
> - **보상 (Reward)**: 행동의 결과로 환경이 에이전트에게 주는 신호. (긍정적 또는 부정적)
> 
> 에이전트의 목표는 단 하나, **누적 보상을 최대화**하는 것입니다.

---

<br>

> ## 4. 강화학습의 핵심 개념
> 
> - **정책 (Policy, π)**: 특정 상태에서 어떤 행동을 할지 결정하는 에이전트의 전략 또는 뇌. `π(action | state)`는 상태 `s`에서 행동 `a`를 할 확률을 의미합니다.
> - **가치 함수 (Value Function, V, Q)**: 특정 상태 또는 (상태, 행동) 쌍이 미래에 얻을 것으로 예상되는 누적 보상의 기댓값. 즉, 현재 상태가 얼마나 '좋은지'를 나타냅니다.
>   - `V(s)`: 상태 `s`의 가치.
>   - `Q(s, a)`: 상태 `s`에서 행동 `a`를 했을 때의 가치.
> 
> 강화학습은 이 정책과 가치 함수를 반복적으로 업데이트하며 최적의 해를 찾아갑니다.

---

<br>

> ## 5. 직접 해보기 (Hands-on Lab): (내용 추가 예정)
> 
> `Gymnasium` 라이브러리를 사용하여, 간단한 게임 환경('CartPole')에서 막대가 쓰러지지 않도록 균형을 잡는 에이전트를 학습시키는 딥러닝 모델(DQN)을 만들어볼 예정입니다.

---

<br>

> ## 6. 되짚어보기 (Summary)
> 
> - **강화학습**: 정답이 아닌 '보상'을 통해 시행착오를 거쳐 학습하는 머신러닝의 한 분야입니다.
> - **핵심 구성요소**: **에이전트**가 **환경** 속에서 특정 **상태**를 인식하고 **행동**을 취하면, 환경은 **보상**을 줍니다.
> - **목표**: 에이전트는 누적 보상을 최대화하는 **정책**을 학습합니다.
> - **활용**: 게임 AI(알파고), 로봇 제어, 자율주행, 자원 최적화 등 복잡한 의사결정 문제에 널리 사용됩니다.

---

<br>

**➡️ 다음 시간: [Part 8: FastAPI를 이용한 모델 서빙](../08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md)**

<br>

> ### 참고 자료
> 
> *   [OpenAI Spinning Up in Deep RL](https://spinningup.openai.com/en/latest/): 심층 강화학습에 대한 체계적인 가이드
> *   [Hugging Face Deep RL Course](https://huggingface.co/learn/deep-rl-course/unit0/introduction): 허깅페이스에서 제공하는 실습 중심의 강화학습 코스

---

<br>

> ### ⚠️ What Could Go Wrong? (토론 주제)
> 
> 강화학습은 에이전트가 스스로 최적의 전략을 학습한다는 점에서 매력적이지만, 실제 문제에 적용하기까지는 수많은 난관을 극복해야 합니다.
> 
> 1.  **탐험과 활용의 딜레마 (Exploration vs. Exploitation Dilemma)**
>     *   에이전트가 현재까지 알아낸 최선의 방법(활용)만 고집하면 더 좋은 해결책을 찾을 기회를 놓치고, 새로운 시도(탐험)에만 집중하면 보상을 극대화하지 못합니다. 이 근본적인 딜레마를 해결하기 위한 전략(e.g., Epsilon-Greedy, UCB)들은 각각 어떤 상황에서 유리하고 불리할까요?
>     *   실제 비즈니스 문제(예: 추천 시스템)에서, 사용자의 만족도를 떨어뜨릴 수 있는 '탐험'을 어느 수준까지 허용해야 할까요? 탐험의 비용과 잠재적 이득을 어떻게 정량화할 수 있을까요?
> 
> 2.  **희소한 보상 문제 (Sparse Reward Problem)**
>     *   체스나 바둑처럼 게임이 끝날 때만 승패라는 보상이 주어지는 경우, 수많은 중간 행동들 중 어떤 것이 승리에 기여했는지 알기 어렵습니다. 이러한 '희소한 보상' 환경에서 에이전트를 효과적으로 학습시키기 어려운 이유는 무엇일까요?
>     *   이를 해결하기 위해 인위적으로 중간 보상을 설계('Reward Shaping')해주는 것은 어떤 부작용을 낳을 수 있을까요? (예: 에이전트가 보상의 허점을 파고들어 의도치 않은 행동을 학습하는 경우)
> 
> 3.  **시뮬레이션과 현실의 차이 (Sim2Real Gap)**
>     *   시뮬레이션 환경에서 완벽하게 작동하도록 학습된 로봇 팔이, 실제 공장 라인에서는 미묘한 마찰력이나 조명 변화 때문에 처참하게 실패하는 'Sim2Real Gap'은 왜 발생할까요?
>     *   이 간극을 줄이기 위해 시뮬레이션 환경을 최대한 현실과 비슷하게 만들려는 노력과, 오히려 환경을 무작위로 계속 바꾸어 에이전트의 강인함(Robustness)을 키우려는 'Domain Randomization' 전략 중 어느 것이 더 효과적일까요?
> 
> 4.  **안전성과 예측 불가능성 (Safety and Unpredictability)**
>     *   자율주행차가 보상을 최대로 하기 위해 위험한 추월을 학습하거나, 청소 로봇이 특정 구역을 피하도록 음(-)의 보상을 주었더니 아예 움직이지 않는 방법을 터득하는 등, RL 에이전트는 명시적으로 금지하지 않은 모든 행동을 할 수 있습니다.
>     *   '절대로 해서는 안 되는 행동'을 어떻게 정의하고 학습시킬 수 있을까요? 시스템의 안전을 보장하기 위한 강화학습 설계는 어떻게 접근해야 할까요?
> 
> 5.  **샘플 비효율성 (Sample Inefficiency)**
>     *   많은 강화학습 알고리즘, 특히 Model-Free 방식은 최적 정책을 배우기 위해 수백만, 수천만 번의 시행착오를 거쳐야 합니다. 현실 세계에서 이 정도의 데이터를 수집하는 것이 불가능한 경우가 많습니다. (예: 로봇이 수백만 번 넘어져야 걷는 법을 배울 수는 없음)
>     *   '환경 모델'을 학습하여 상호작용을 시뮬레이션하는 Model-Based RL은 이 문제를 어떻게 완화하며, 그 접근법의 근본적인 한계(예: 모델이 부정확할 경우의 성능 저하)는 무엇일까요?

---

<br>

> ## 캡스톤 프로젝트 연계 미니 프로젝트: 게임 AI 에이전트 훈련시키기
> 
> 강화학습의 핵심은 '최적의 의사결정'을 찾는 것입니다. 15장 캡스톤 프로젝트에서 자원 관리, 추천 순서 최적화, 자율 에이전트 등 동적인 시스템을 구상하고 있다면, 강화학습은 강력한 무기가 될 수 있습니다. 이번 미니 프로젝트에서는 `Gymnasium` 라이브러리를 사용해 간단한 게임 환경 속에서 스스로 학습하고 성장하는 AI 에이전트를 만들며 강화학습의 원리를 체득합니다.
> 
> ### 프로젝트 목표
> - `Gymnasium` 라이브러리를 사용하여 'LunarLander-v2' 환경을 설정하고 이해합니다.
> - DQN(Deep Q-Network) 알고리즘의 기본 아이디어를 이해하고, `stable-baselines3`와 같은 라이브러리를 사용해 에이전트를 학습시킵니다.
> - 학습된 에이전트가 게임을 플레이하는 과정을 시각화하고, 학습 전후의 성능을 '누적 보상'으로 비교 분석합니다.
> 
> ### 개발 과정
> 1. **환경 설정**: `pip install gymnasium[box2d] stable-baselines3[extra]` 명령어로 필요한 라이브러리를 설치합니다.
> 2. **에이전트 학습**:
>     - `stable-baselines3` 라이브러리의 `DQN` 모델을 불러옵니다.
>     - 'LunarLander-v2' 환경을 생성하고, 모델에 환경을 지정하여 학습을 시작합니다. (`model.learn(total_timesteps=100000)`)
>     - 학습된 모델을 저장합니다.
> 3. **성능 평가 및 시각화**:
>     - 학습된 모델을 불러와, 렌더링 모드로 환경을 실행하여 에이전트가 어떻게 우주선을 착륙시키는지 직접 관찰합니다.
>     - 학습하지 않은 무작위 에이전트의 평균 누적 보상과, 학습된 에이전트의 평균 누적 보상을 비교하여 성능 향상을 수치적으로 확인합니다.
> 4. **결과 해석 및 활용**:
>     - 에이전트는 어떤 전략(Policy)을 학습했을까요? (예: 특정 상황에서 어떤 엔진을 분사하는가)
>     - 학습의 '보상'을 어떻게 설계하는지에 따라 에이전트의 행동이 어떻게 달라질지 토론해봅니다.
> 
> ### 캡스톤 프로젝트 연계 방안
> - **커스텀 환경 제작**: 캡스톤 프로젝트의 주제에 맞춰 `Gymnasium`의 `Env` 클래스를 상속받아 '나만의 강화학습 환경'을 직접 만들어볼 수 있습니다. 예를 들어, '웹사이트 광고 배치 최적화' 환경을 만들고, '광고 클릭 수'를 보상으로 설정하여 최적의 광고 배치 전략을 학습하는 에이전트를 개발할 수 있습니다.
> - **금융 트레이딩 봇**: 주가 데이터를 상태로, '매수/매도/보유'를 행동으로, '수익률'을 보상으로 하는 환경을 설계하여, 시장 상황에 맞춰 최적의 투자를 수행하는 트레이딩 봇을 강화학습으로 개발할 수 있습니다.
> - **자율 에이전트**: `LangChain`의 'Agent' 개념과 강화학습을 결합하여, 특정 목표(예: '최신 AI 논문 3개 요약하기')를 달성하기 위해 스스로 웹 검색, 코드 실행 등의 도구를 선택하고 사용하는 고차원적인 자율 에이전트를 구상해볼 수 있습니다. 