# Part 7.2: Transformer와 LLM의 핵심 원리

**⬅️ 이전 시간: [Part 7.1: 순환 신경망 (RNN)과 LSTM](./part_7.1_recurrent_neural_networks.md)**
**➡️ 다음 시간: [Part 7.3: LangChain으로 LLM 애플리케이션 개발 맛보기](./part_7.3_llm_application_development_with_langchain.md)**

---

<br>

> ## 1. 학습 목표 (Learning Objectives)
>
> 이번 파트가 끝나면, 여러분은 다음을 할 수 있게 됩니다.
> 
> - 순차 데이터 처리에서 RNN이 가졌던 한계를 설명하고, 이를 해결하기 위해 'Attention'이 왜 등장했는지 이해할 수 있습니다.
> - Transformer의 핵심 구성 요소인 인코더(Encoder), 디코더(Decoder), 그리고 셀프 어텐션(Self-Attention)의 역할을 설명할 수 있습니다.
> - Transformer가 단어의 순서를 학습하는 방법, 즉 Positional Encoding의 필요성을 이해할 수 있습니다.
> - Transformer 아키텍처를 기반으로 한 BERT와 GPT가 각각 어떤 구조적 특징을 가지며, 어떤 종류의 작업에 더 특화되어 있는지 설명할 수 있습니다.

<br>

> ## 2. 핵심 요약 (Key Summary)
> 
> RNN의 순차 처리 방식과 장기 의존성 문제를 해결하기 위해 등장한 Transformer는, 문장 전체를 한 번에 보고 단어 간의 관계와 중요도를 파악하는 Self-Attention 메커니즘을 사용합니다. Transformer는 문장을 이해하는 인코더와 문장을 생성하는 디코더로 구성되며, 단어의 순서 정보는 Positional Encoding으로 학습합니다. 이 구조를 기반으로 문맥 이해에 특화된 BERT(인코더 활용)와 텍스트 생성에 특화된 GPT(디코더 활용) 같은 현대적인 LLM이 탄생했습니다.

<br>

> ## 3. 도입: 문장의 '진짜 의미'를 파악하는 똑똑한 번역가 (Introduction)
>
> > [!NOTE] 비유: Transformer는 '능숙한 동시통역사'
> > - **초보 번역가 (RNN)**: 문장을 앞에서부터 한 단어씩 순서대로 듣고 바로 번역합니다. "나는 강가에 가서..." 까지 듣고 'I go to the river bank and...' 라고 번역을 시작합니다. 하지만 뒤에 '낚시를 했다'가 나올지 '수영을 했다'가 나올지에 따라 문맥이 달라질 수 있습니다. 긴 문장을 들으면 앞부분을 잊어버리는 단점도 있습니다.
> > - **능숙한 통역사 (Transformer)**: 문장 전체("그는 강가에서 낚시를 했다")를 일단 다 듣습니다. 그리고 '낚시를 했다'라는 핵심 행동을 파악한 뒤, 이 행동과 가장 관련이 깊은 '강가', '그'라는 단어에 **더 집중(Attention)**하여 "He went fishing by the river" 라는 자연스러운 번역을 완성합니다. 문장 전체의 핵심과 단어 간의 관계를 파악하는 데 능숙합니다.
> 
> 이처럼 Transformer는 문장 전체를 보고 단어 간의 관계와 중요도를 파악하는 **Attention** 메커니즘을 사용하여 자연어의 복잡한 문맥을 이해하는 혁신적인 방법을 제시했습니다.

---

<br>

> ## 4. Transformer 핵심 원리 파헤치기
> 
> ### 4-1. Attention 메커니즘의 등장: RNN의 한계를 넘어서
> 
> 기존의 순차 데이터 처리 모델인 RNN(Recurrent Neural Network)은 문장이 길어질수록 앞쪽 정보가 뒤로 전달되며 소실되는 **장기 의존성 문제(Long-Term Dependency Problem)**가 있었습니다. 또한, 순차적으로 계산해야 해서 GPU 병렬 처리가 어려워 학습 속도가 느렸습니다.
> 
> 이를 해결하기 위해 **Attention**이 제안되었습니다. 출력 단어를 예측할 때마다, 입력 문장 전체를 다시 참고하여 **가장 관련 높은 단어에 '주목'**하는 방식입니다.
> 
> ### 4-2. Transformer: "Attention Is All You Need"
> 
> 2017년 구글 논문 "Attention Is All You Need"에서 소개된 Transformer는 RNN 구조를 완전히 버리고 오직 Attention 메커니즘만으로 언어를 처리하는 모델입니다.
> 
> **주요 구성 요소**
> 
> - **인코더 (Encoder)**: 입력 문장을 받아 각 단어의 의미와 문맥 정보를 풍부하게 담은 **표현(Representation)**으로 변환합니다. 문장을 '이해'하는 데 특화된 부분입니다.
> - **디코더 (Decoder)**: 인코더가 만든 표현과 이전에 생성된 단어들을 바탕으로 다음 단어를 예측하여 새로운 문장을 '생성'하는 데 특화된 부분입니다.
> 
> ### 4-3. 핵심 메커니즘: Self-Attention
> 
> Transformer의 심장은 **Self-Attention**입니다. 문장 안에서 단어들이 **서로에게 얼마나 중요한지**를 계산하여, 문맥에 맞는 단어의 의미를 파악하는 과정입니다.
> 
> > **예시**: "The animal didn't cross the street because **it** was too tired."
> >
> > 여기서 'it'이 가리키는 대상은 'animal'일까요, 'street'일까요? 사람은 쉽게 'animal'이라고 파악합니다. Self-Attention은 'it'과 문장 내 다른 모든 단어와의 관련도 점수를 계산하여, 'it'이 'animal'을 가리킨다는 것을 높은 확률로 학습하게 됩니다.
> 
> 이 과정은 각 단어에 대해 `Query(Q)`, `Key(K)`, `Value(V)`라는 세 가지 벡터를 만들어 계산합니다.
> - `Query`: 현재 단어의 정보 (분석의 주체)
> - `Key`: 다른 단어들과의 관련성을 계산하기 위한 '꼬리표'
> - `Value`: 다른 단어들의 실제 의미
> 
> 현재 단어의 `Query`가 다른 모든 단어의 `Key`들과 얼마나 '어울리는지(유사도)'를 계산하고, 이 점수를 각 단어의 `Value`에 곱해 최종적으로 문맥이 반영된 새로운 표현을 만들어냅니다.
> 
> ### 4-4. 순서 정보 학습: Positional Encoding
> 
> Transformer는 RNN과 달리 단어를 한 번에 처리하므로, "나는 너를 좋아해"와 "너는 나를 좋아해"를 구분하지 못합니다. 단어의 순서 정보를 알려주기 위해, 각 단어의 위치마다 고유한 값을 더해주는 **Positional Encoding**을 사용합니다. 사인(sine), 코사인(cosine) 함수를 이용해 각 위치에 대한 벡터를 만들어 입력 임베딩에 추가해 줍니다.

---

<br>

> ## 5. Transformer의 두 갈래: BERT와 GPT
> 
> Transformer 아키텍처는 현대 LLM의 근간이 되었습니다. 대표적인 두 모델인 BERT와 GPT는 Transformer의 구조를 각기 다른 방식으로 활용합니다.
> 
> | 구분 | BERT (Bidirectional Encoder Representations from Transformers) | GPT (Generative Pre-trained Transformer) |
> |---|---|---|
> | **개발사** | Google | OpenAI |
> | **주요 구조** | Transformer의 **인코더(Encoder)만** 사용 | Transformer의 **디코더(Decoder)만** 사용 |
> | **특징** | **"문맥을 이해하는 전문가"**<br>문장 전체를 보고 빈칸(Mask)을 채우는 방식으로 학습 (양방향). 문맥 이해, 의미 분석, 분류 등 **이해(Understanding)** 기반 작업에 강력함. | **"이야기를 만들어내는 작가"**<br>이전 단어들을 보고 다음 단어를 예측하며 순차적으로 학습 (단방향). 문장 생성, 요약, 번역 등 **생성(Generation)** 기반 작업에 강력함. |
> | **주요 활용** | 구글 검색 엔진, 텍스트 분류, 감성 분석, 개체명 인식 | 챗봇(ChatGPT), 콘텐츠 초안 생성, 코드 자동 완성 |

---

<br>

> ## 6. 연습 문제
> 
> 1.  **개념 확인**: Transformer 이전의 순차 데이터 모델(RNN)이 가졌던 가장 큰 한계점은 무엇이었나요?
> 2.  **개념 확인**: 'Self-Attention' 메커니즘의 역할을 한 문장으로 설명해 보세요.
> 3.  **개념 확인**: GPT가 주로 사용하는 Transformer의 구성요소는 인코더(Encoder)인가요, 디코더(Decoder)인가요?
> 4.  **심화 조사**: BERT와 GPT가 각각 어떤 종류의 AI 서비스(e.g., 검색 엔진, 챗봇, 번역기)에 더 적합한지, 그 이유와 함께 실제 서비스 예시를 2가지 이상 찾아 설명해 주세요.
> 5.  **설명 능력**: 'Self-Attention'의 원리를 비전공자 친구에게 설명한다고 상상하고, 쉬운 비유를 들어 3문장 이내로 설명하는 글을 작성해 주세요. (예: "칵테일 파티에서 여러 사람과 대화할 때, 나와 가장 관련 있는 주제를 이야기하는 사람의 목소리에 더 집중하는 것과 같아요.")

---

<br>

> ## 7. 심화 토론 (What Could Go Wrong?)
> 
> Transformer는 현대 AI의 혁신을 이끌었지만, 그 강력함만큼 새로운 종류의 문제와 한계를 드러냈습니다. 다음 시나리오들에 대해 함께 토론해보세요.
> 
> 1.  **Self-Attention의 연산량 병목(Quadratic Bottleneck)**
>     -   **상황**: 한 연구팀이 고해상도 이미지를 처리하기 위해, 각 픽셀을 하나의 토큰으로 간주하여 표준 Transformer 모델에 입력했습니다. 최고 사양의 GPU를 사용했음에도 불구하고, 시퀀스 길이가 조금만 길어져도 메모리 부족(Out of Memory) 오류가 발생하며 모델을 훈련시킬 수 없었습니다.
>     -   **토론**:
>         -   Self-Attention은 RNN의 순차 처리 병목을 해결했지만, 대신 어떤 새로운 병목을 만들었을까요? 왜 Self-Attention의 연산량과 메모리 사용량은 시퀀스 길이(n)에 따라 제곱(O(n²))으로 증가할까요?
>         -   이러한 한계점 때문에 표준 Transformer를 매우 긴 시퀀스(긴 문서, 고화질 이미지, 음성 등)에 적용하기 어려운 이유는 무엇이며, 이를 해결하기 위해 어떤 아이디어(예: Sparse Attention, Longformer, Linformer 등)들이 제시되었는지 조사하고 토론해보세요.
> 
> 2.  **위치 정보의 한계와 일반화 문제**
>     -   **상황**: 최대 512 토큰 길이의 문장으로 학습된 Transformer 모델이 있습니다. 추론 시점에 600 토큰 길이의 문장을 입력하자, 모델의 성능이 급격히 저하되고 문법에 맞지 않는 문장을 생성하기 시작했습니다.
>     -   **토론**:
>         -   왜 기본적인 Positional Encoding 방식은 학습 시 사용된 최대 길이를 넘어선 위치에 대해 잘 일반화하지 못할까요? 모델이 한 번도 본 적 없는 위치 값(예: 513번째 위치)을 마주했을 때 어떤 일이 벌어질까요?
>         -   이러한 문제를 해결하기 위한 대안적인 위치 인코딩 방식들에는 어떤 것들이 있을까요? (예: Relative Positional Encoding, RoPE 등)
> 
> 3.  **LLM의 환각(Hallucination) 현상**
>     -   **상황**: GPT 기반의 역사 Q&A 봇에게 잘 알려지지 않은 역사적 인물에 대해 질문하자, 매우 유창하고 그럴듯하지만 완전히 허구인 사실을 자신감 있게 생성해냈습니다.
>     -   **토론**:
>         -   이러한 '환각' 현상은 왜 발생할까요? 모델이 '거짓말'을 하는 것일까요, 아니면 다른 원인이 있을까요? 이 현상이 모델의 근본적인 학습 목표("정답을 말하기"가 아닌 "다음에 올 가장 그럴듯한 단어 예측하기")와 어떻게 연결되는지 토론해보세요.
>         -   이러한 환각 현상을 완화하기 위한 기술적인 전략들에는 어떤 것들이 있을까요? (예: Retrieval-Augmented Generation (RAG), Grounding, Fact-Checking 등)
> 
> 4.  **"이해" 모델 vs. "생성" 모델: 올바른 도구 선택하기**
>     -   **상황**: 한 개발자가 문장의 긍정/부정을 판단하는 감성 분류(Classification) Task에 GPT(Decoder-only) 모델을 사용했습니다. 모델이 작동은 하지만, 비슷한 크기의 BERT(Encoder-only) 모델에 비해 추론 속도가 훨씬 느리고 정확도도 낮았습니다.
>     -   **토론**:
>         -   왜 GPT와 같은 생성 모델이 BERT와 같은 이해 모델에 비해 분류 Task에서 비효율적일까요? Decoder 아키텍처의 단방향(Causal) 어텐션 마스크가 어떻게 전체 문맥을 파악하는 능력에 한계를 주는지, BERT의 양방향(Bidirectional) 어텐션과 비교하여 설명해보세요.
>         -   풀고자 하는 문제(Downstream Task)의 성격에 맞게 모델의 아키텍처와 사전학습 방식을 선택하는 것이 왜 중요한지 토론해보세요.

<br>

> ## 8. 더 깊이 알아보기 (Further Reading)
> - [Attention Is All You Need (원문 논문)](https://arxiv.org/abs/1706.03762): 모든 것의 시작이 된 논문.
> - [The Illustrated Transformer (영문 블로그)](http://jalammar.github.io/illustrated-transformer/): 그림과 함께 Transformer를 쉽게 설명한 최고의 자료 중 하나.
> - [Hugging Face Course - How do Transformers work?](https://huggingface.co/learn/llm-course/en/chapter1/4): 본문에 많이 참고된 허깅페이스의 LLM 강좌.

---

<br>

> ## 9. 심화 프로젝트: Self-Attention 계산해보기
> 
> 이론으로 배운 Self-Attention 메커니즘이 실제 코드 레벨에서 어떻게 동작하는지 직접 구현해보며 Transformer의 심장을 파헤쳐봅니다. 이 과정을 통해 캡스톤 프로젝트에서 Transformer 기반 모델을 다룰 때 내부 동작에 대한 깊은 직관을 얻을 수 있습니다.
> 
> -   **목표**: PyTorch를 사용하여 Self-Attention의 핵심 계산 과정을 단계별로 직접 구현합니다.
> -   **핵심 단계**:
>     1.  **입력 준비**: 간단한 문장을 토큰화하고, 각 토큰을 표현하는 임베딩 벡터(여기서는 랜덤 텐서)를 생성합니다.
>     2.  **Q, K, V 생성**: 각 임베딩 벡터로부터 Query, Key, Value 벡터를 만들어내는 가중치 행렬(`nn.Linear`)을 정의하고, 행렬 곱을 통해 Q, K, V 행렬을 계산합니다.
>     3.  **Attention Score 계산**: `(Q @ K.transpose) / sqrt(d_k)` 공식을 그대로 코드로 옮겨 어텐션 스코어를 계산합니다.
>     4.  **Attention Distribution**: 스코어에 `Softmax` 함수를 적용하여 특정 단어가 다른 모든 단어에 얼마나 '집중'할지를 나타내는 확률 분포를 구합니다.
>     5.  **최종 결과**: 계산된 어텐션 가중치를 Value 행렬에 곱하여 문맥이 풍부하게 반영된 최종 결과 벡터를 얻습니다.
> -   **기대 효과**:
>     -   `Q`, `K`, `V`의 역할과 텐서의 차원 변화를 명확하게 이해합니다.
>     -   Self-Attention의 복잡한 수식이 실제로는 몇 줄의 행렬 연산 코드로 구현됨을 확인하며 자신감을 얻습니다.
>     -   Hugging Face 라이브러리의 Transformer 모델 내부를 상상할 수 있는 능력을 기릅니다.
> -   **구현 가이드**: [live_coding_transformer_block.md](./live_coding_transformer_block.md) 파일의 단계별 가이드를 참고하여 직접 코드를 작성해보세요.

---

<br>

**➡️ 다음 시간: [Part 7.3: LangChain으로 LLM 애플리케이션 개발 맛보기](./part_7.3_llm_application_development_with_langchain.md)** 