> # Part 7: Deep Learning

<br>

이 파트에서는 인공 신경망의 개념부터 시작하여 CNN, RNN, Transformer 등 주요 딥러닝 아키텍처를 학습하고, PyTorch와 LangChain을 이용해 LLM 애플리케이션까지 구축하는 방법을 다룹니다.

<br>

> ## 📚 학습 자료

- **[메인 강의 노트](./part_7_deep_learning.md)**: 딥러닝의 전반적인 개념을 소개합니다.
- **[7.1 순환 신경망 (RNN)](./part_7.1_recurrent_neural_networks.md)**
- **[7.2 Transformer와 LLM의 원리](./part_7.2_transformer_and_llm_principles.md)**
- **[7.3 LangChain을 활용한 LLM 애플리케이션 개발](./part_7.3_llm_application_development_with_langchain.md)**
- **[7.4 그래프 신경망 (GNN)](./part_7.4_graph_neural_networks.md)**
- **[7.5 강화학습 (RL)](./part_7.5_reinforcement_learning.md)**
- **[핵심 용어집](../../glossary.md)**
- **[LLM 앱 개발 용어집](./glossary_llm_application.md)**

<br>

> ## 💻 실습 코드

- **[딥러닝 예제 코드](../../source_code/07_deep_learning/part_7_deep_learning.py)**
- **[LLM 앱 개발 예제 코드](../../source_code/07_deep_learning/7.3_llm_application_development_with_langchain/part_7.3_llm_application_development.py)**

---

<br>

[↩️ 전체 커리큘럼으로 돌아가기](../../README.md) 