# Part 5.6: 머신러닝/딥러닝을 위한 미적분 - 직관적 이해 중심

## 🎯 학습 목표

이번 파트에서는 **복잡한 수식보다는 시각화와 비유를 통해** 미적분의 핵심 개념을 직관적으로 이해합니다.

### 핵심 접근법
- **미분** = "순간 변화율", "기울기"
- **기울기 하강법** = "산에서 내려오는 사람"
- **편미분** = "여러 변수 중 하나만 바꾸기"
- **연쇄법칙** = "파이프라인을 통해 변화 전파"

## 📚 학습 내용

### 1. 미분: 순간 변화율과 기울기 📈
- 미분의 직관적 이해 (기울기 시각화)
- 여러 점에서의 미분값 비교
- 수치 미분 vs 해석적 미분

### 2. 기울기 하강법: 산에서 내려오는 사람 🏔️
- 기울기 하강법의 시각화
- 학습률의 중요성
- 다양한 최적화 알고리즘 비교

### 3. 편미분: 여러 변수 중 하나만 바꾸기 🔧
- 편미분의 3D 시각화
- 그래디언트 벡터의 의미
- 다변수 함수의 최적화

### 4. 연쇄법칙: 파이프라인을 통해 변화 전파 🔗
- 합성 함수의 미분
- 신경망의 역전파 이해
- 딥러닝의 핵심 원리

### 5. 실제 활용 예제
- 선형 회귀의 경사 하강법
- 간단한 신경망 구현
- 최적화 알고리즘 비교

## 🛠️ 실습 도구

- **Python + NumPy**: 실제 계산과 구현
- **Matplotlib**: 시각화로 직관적 이해
- **Jupyter Notebook**: 대화형 학습
- **실제 예제**: 선형 회귀, 신경망 등

## 📖 학습 자료

### 강의 자료
- `part_5.6_calculus_for_ml.md`: 시각화 중심의 이론 설명

### 실습 코드
- `source_code/linear_regression_gradient_descent.py`: 11개의 시각화 예제

## 🎯 핵심 메시지

> **"왜 이걸 배워야 하는가?"** 에 집중합니다.
> 
> 미적분은 머신러닝의 "학습 엔진"입니다. 
> 복잡한 수식보다는 **직관적 이해**와 **실제 구현**에 집중하세요!

## 🚀 다음 단계

이제 선형대수와 미적분을 모두 배웠으니, **실제 머신러닝 모델**을 만들어보겠습니다! 