# Part 5.5: NumPy로 배우는 선형대수학 - 직관적 이해 중심

## 🎯 학습 목표

이번 파트에서는 **복잡한 수식보다는 시각화와 비유를 통해** 선형대수의 핵심 개념을 직관적으로 이해합니다.

### 핵심 접근법
- **벡터** = "방향과 크기를 가진 화살표"
- **행렬** = "데이터를 변형하는 마법 상자"
- **고유벡터** = "변하지 않는 특별한 방향"
- **PCA** = "데이터의 핵심 방향 찾기"

## 📚 학습 내용

### 1. 벡터: 방향과 크기를 가진 화살표 🏹
- 벡터의 직관적 이해 (화살표 비유)
- 벡터 연산의 시각화 (이동 경로 합치기)
- 벡터 내적의 의미 (서로 얼마나 같은 방향인지)

### 2. 행렬: 데이터를 변형하는 마법 상자 🎁
- 행렬 변환의 시각화 (회전, 크기 조절, 전단)
- 행렬곱의 직관적 의미 (복합 변환)
- 이미지 필터링으로 이해하는 행렬

### 3. 고유값과 고유벡터: 변하지 않는 특별한 방향 🧭
- 고유벡터의 시각화 (방향 유지)
- PCA: 데이터의 핵심 방향 찾기
- 차원 축소의 직관적 이해

### 4. 실제 활용 예제
- 이미지 처리와 행렬
- 추천 시스템과 행렬 분해
- 신경망 가중치 시각화

## 🛠️ 실습 도구

- **Python + NumPy**: 실제 계산과 구현
- **Matplotlib**: 시각화로 직관적 이해
- **Jupyter Notebook**: 대화형 학습
- **실제 예제**: 이미지 처리, 데이터 분석 등

## 📖 학습 자료

### 강의 자료
- `part_5.5_linear_algebra_with_numpy.md`: 시각화 중심의 이론 설명

### 실습 코드
- `source_code/part_5.5_linear_algebra_with_numpy.py`: 11개의 시각화 예제

## 🎯 핵심 메시지

> **"왜 이걸 배워야 하는가?"** 에 집중합니다.
> 
> 선형대수는 머신러닝의 "언어"입니다. 
> 복잡한 수식보다는 **직관적 이해**와 **실제 활용**에 집중하세요!

## 🚀 다음 단계

이제 미적분을 배워서 **"어떻게 최적화할 것인가?"**를 알아보겠습니다!

---

[↩️ 전체 커리큘럼으로 돌아가기](../../README.md) 