# Part 2: Python Core Syntax - Quick Review for Experienced Developers

This document provides a fast-paced review of Python's core syntax for developers already familiar with programming concepts.

---

### 1. Variables and Basic Data Types

- **Dynamic Typing**: No explicit type declaration needed.
  ```python
  my_string = "hello" # str
  my_int = 100       # int
  my_float = 3.14    # float
  my_bool = True     # bool
  ```
- **F-strings (Formatted String Literals)**: Convenient way to embed expressions inside string literals.
  ```python
  name = "World"
  print(f"Hello, {name}!")
  ```

---

### 2. Core Data Structures

A brief overview of Python's built-in data structures.

| Structure | Syntax | Mutable? | Ordered? | Use Case |
| :--- | :--- | :---: | :---: | :--- |
| **List** | `[1, 2, 3]` | Yes | Yes | General-purpose, ordered collection. |
| **Tuple** | `(1, 2, 3)` | No | Yes | Immutable data, function return values, dictionary keys. |
| **Dictionary**| `{'a': 1}` | Yes | Yes (3.7+) | Key-value storage. |
| **Set** | `{1, 2, 3}` | Yes | No | Uniqueness, mathematical set operations. |

---

### 3. "Pythonic" Idioms

- **List Comprehension**: Create lists concisely.
  ```python
  # squares of even numbers from 0 to 9
  squares = [x**2 for x in range(10) if x % 2 == 0]
  # [0, 4, 16, 36, 64]
  ```
- **Dictionary/Set Comprehension**:
  ```python
  # Dictionary
  # {k: v for k, v in some_iterable}
  # Set
  # {x for x in another_iterable}
  ```
- **Unpacking**:
  ```python
  a, b, *remaining = [1, 2, 3, 4, 5]
  # a=1, b=2, remaining=[3, 4, 5]
  ```

---

### 4. Control Flow

- **Indentation**: Python uses indentation (typically 4 spaces) to define code blocks. There are no curly braces `{}`.
- **`if/elif/else`**:
  ```python
  if score >= 90:
      grade = "A"
  elif score >= 80:
      grade = "B"
  else:
      grade = "F"
  ```
- **`for` loop**: Iterates over any sequence.
  - Use `enumerate()` to get both index and value.
  ```python
  for i, item in enumerate(['a', 'b', 'c']):
      print(i, item)
  ```
- **`while` loop**:
  ```python
  count = 5
  while count > 0:
      count -= 1
  ```

---

### 5. Functions

- **Definition**: Use the `def` keyword.
- **Type Hinting** (Optional but recommended):
  ```python
  def greet(name: str) -> str:
      return f"Hello, {name}"
  ```
- **Multiple Return Values**: Returns a tuple.
  ```python
  def get_point():
      return 10, 20

  x, y = get_point() # x=10, y=20
  ```

---
This covers the fundamental syntax. For a deeper dive, refer to the main [part_2_python_core_syntax.md](./part_2_python_core_syntax.md) document. 