---
marp: true
theme: gaia
class:
  - lead
  - invert
---

<!-- _class: lead -->
<!-- _header: "" -->
<!-- _footer: "" -->

<style>
h1 {
    font-size: 2.5em;
    font-weight: 600;
}
h2 {
    font-size: 2em;
    font-weight: 600;
}
h3 {
    font-size: 1.6em;
    font-weight: 600;
}
h4 {
    font-size: 1.3em;
    font-weight: 600;
}
h5 {
    font-size: 1.1em;
    font-weight: 600;
}
h6 {
    font-size: 1em;
    font-weight: 600;
}
p, li, ul, ol, table {
    font-size: 28px;
}
pre, code {
    font-size: 24px;
}
</style>

# Part 1: AI 개발 환경 설정

**⬅️ 이전 시간: [인공지능의 역사](../00_introduction/part_0.1_history_of_ai.md)**
**➡️ 다음 시간: [Part 2: 파이썬 핵심 문법](../02_python_core_syntax/part_2_python_core_syntax.md)**

---

## 1. 학습 목표 (Learning Objectives)

이번 시간에는 AI 개발 여정을 시작하기 위한 첫 단추를 끼웁니다. 다음 목표를 달성할 수 있도록 함께 나아갑시다.

- **AI 개발 환경의 핵심 구성 요소**를 이해합니다. ([Anaconda](../../glossary.md#anaconda-아나콘다), [Python](../../glossary.md#python-파이썬), [Jupyter Notebook](../../glossary.md#jupyter-notebook-주피터-노트북), [VS Code](../../glossary.md#visual-studio-code-vs-code))
- 자신의 운영체제(Windows, macOS, Linux)에 **Anaconda를 성공적으로 설치**하고 환경 변수를 설정합니다.
- **가상 환경의 중요성**을 깨닫고, [conda](../../glossary.md#conda-콘다) 명령어를 활용하여 **프로젝트별 가상 환경을 생성하고 관리**할 수 있습니다.
- **Jupyter Notebook과 VS Code**를 실행하고, 기본적인 사용법을 익혀 코드를 작성하고 실행할 수 있습니다.
- **개발 환경 설정 중 발생할 수 있는 일반적인 문제**와 그 해결 방법을 이해합니다. ([FAQ](../../glossary.md#자주-묻는-질문-faq) 참고)

## 2. 핵심 요약 (Key Summary)
이 파트에서는 AI 개발의 기초가 되는 개발 환경 설정 방법을 배웁니다. Anaconda를 설치하고, 가상 환경의 중요성을 이해하며, `conda` 명령어를 사용하여 프로젝트별로 격리된 개발 환경을 직접 만들어 봅니다. 마지막으로, Jupyter Notebook과 VS Code의 기본 사용법을 익혀 실제 코드를 작성하고 실행할 준비를 마칩니다.

- **핵심 키워드**: `Anaconda`, `conda`, `가상 환경`, `Python`, `Jupyter Notebook`, `VS Code`, `의존성 관리`

## 3. 왜 개발 환경 설정이 중요할까요? (Introduction)

멋진 AI 모델을 만들고 싶다는 부푼 꿈을 안고 코딩을 시작했지만, **"어? 내 컴퓨터에서는 왜 안 되지?"** 하는 순간을 마주한 적 있으신가요? 바로 개발 환경 설정의 중요성을 간과했기 때문일 가능성이 큽니다.

개발 환경 설정은 마치 **요리를 시작하기 전에 주방을 정리하고 필요한 도구를 갖추는 것**과 같습니다. 깨끗한 도마, 잘 드는 칼, 정확한 계량컵이 있어야 맛있는 요리가 탄생하듯, 잘 갖춰진 개발 환경은 효율적이고 즐거운 프로그래밍 경험의 첫걸음입니다.

특히 여러 라이브러리와 프레임워크가 복잡하게 얽혀 작동하는 AI 개발에서는, **프로젝트별로 격리된 개발 환경을 구축하는 것이 필수적**입니다. 이를 통해 다음과 같은 이점을 얻을 수 있습니다.

- **의존성 충돌 방지:** 프로젝트 A에서는 라이브러리 X의 1.0 버전이 필요한데, 프로젝트 B에서는 2.0 버전이 필요하다면? 가상 환경이 없다면 둘 중 하나는 제대로 동작하지 않을 것입니다.
- **재현성 확보:** 내가 만든 코드가 다른 사람의 컴퓨터에서도 동일하게 동작하려면, 동일한 개발 환경을 공유해야 합니다. 가상 환경은 이를 가능하게 합니다.
- **협업 효율 증대:** 팀원 모두가 동일한 개발 환경 위에서 작업함으로써 불필요한 오류를 줄이고 생산성을 높일 수 있습니다.

이번 시간에는 이러한 개발 환경을 구성하는 핵심 도구인 **Anaconda, Python, Jupyter Notebook, VS Code**의 설치 및 기본 사용법을 익히고, 프로젝트별 독립적인 개발 공간인 **가상 환경**을 만드는 방법을 배웁니다.

## 4. 핵심 도구 소개 (Key Tools)

우리의 AI 개발 여정에 함께할 핵심 도구들을 소개합니다. 이들은 각자의 역할과 강점을 가지고 있으며, 서로 협력하여 강력한 개발 환경을 구성합니다.

| 도구                                                                 | 역할 및 특징                                                                                                                                                             | 비유             |
| :------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------- |
| **1. [Python](../../glossary.md#python-파이썬)**                               | AI 개발의 핵심 프로그래밍 언어. 간결하고 배우기 쉬우며, 강력한 라이브러리 생태계를 자랑합니다.                                                                                                   | 만능 스위스 칼   |
| **2. [Anaconda](../../glossary.md#anaconda-아나콘다)**                             | Python과 수백 개의 데이터 과학 패키지([NumPy](../05_ai_core_libraries/glossary.md#numpy-넘파이), [Pandas](../05_ai_core_libraries/glossary.md#pandas-판다스), Scikit-learn 등)를 한 번에 설치하고 관리할 수 있는 배포판입니다. 가상 환경 관리 도구인 `conda`를 포함합니다. | 종합 공구함      |
| **3. [conda](../../glossary.md#conda-콘다)**                                   | Anaconda에 포함된 패키지 및 가상 환경 관리 시스템입니다. 프로젝트별로 독립된 개발 환경을 손쉽게 만들고 관리할 수 있게 해줍니다.                                                                          | 작업 공간 관리자 |
| **4. [Jupyter Notebook](../../glossary.md#jupyter-notebook-주피터-노트북)** / JupyterLab | 대화형 코드 실행, 시각화, 문서 작성이 가능한 웹 기반 개발 환경입니다. 코드와 설명을 함께 기록하며 실험하고 결과를 바로 확인할 수 있어 데이터 분석 및 교육에 매우 유용합니다. JupyterLab은 Jupyter Notebook의 차세대 버전입니다. | 실험 노트        |
| **5. [Visual Studio Code (VS Code)](../../glossary.md#visual-studio-code-vs-code)** | Microsoft에서 개발한 경량 코드 편집기입니다. 강력한 기능, 다양한 확장 프로그램, 뛰어난 사용자 인터페이스를 제공하여 Python 개발을 비롯한 다양한 프로그래밍 작업에 널리 사용됩니다.                    | 스마트 작업대    |

이 도구들은 마치 **레고 블록**처럼 각자의 역할을 하며, 서로 연결되어 우리가 원하는 AI 서비스를 만드는 데 필요한 환경을 구성합니다.

## 5. 운영체제별 Anaconda 설치 가이드 (Installation Guide)

이제 본격적으로 Anaconda를 설치하여 AI 개발 환경 구축의 첫발을 내디뎌 보겠습니다. Anaconda는 Python과 여러 데이터 과학 패키지를 포함하고 있어, 한 번의 설치로 많은 준비를 마칠 수 있습니다.

자신의 운영체제에 맞는 설치 방법을 따라 진행해주세요.

<br/>

### 5.1. Windows에 Anaconda 설치하기

1.  **Anaconda 다운로드:**
    *   [Anaconda 공식 웹사이트](https://www.anaconda.com/products/distribution)에 접속합니다.
    *   **"Download"** 버튼을 클릭하여 최신 버전의 Anaconda 설치 프로그램을 다운로드합니다. (Python 3.x 버전 권장)

2.  **설치 프로그램 실행:**
    *   다운로드한 `.exe` 파일을 실행합니다.
    *   **"Next"** 를 클릭합니다.

3.  **라이선스 동의:**
    *   **"I Agree"** 를 클릭합니다.

4.  **설치 유형 선택:**
    *   **"Just Me (recommended)"** 를 선택하고 **"Next"** 를 클릭합니다. (관리자 권한 없이 개인 사용자 계정에 설치)
    *   만약 모든 사용자를 위해 설치하려면 "All Users"를 선택할 수 있지만, 특별한 경우가 아니라면 "Just Me"를 권장합니다.

5.  **설치 경로 지정:**
    *   Anaconda를 설치할 경로를 지정합니다. 기본 경로를 사용하거나, 원하는 경로로 변경할 수 있습니다.
        *   **주의:** 경로에 한글이나 공백이 포함되지 않도록 하는 것이 좋습니다. 예: `C:\Anaconda3`
    *   **"Next"** 를 클릭합니다.

6.  **고급 설치 옵션 (Advanced Installation Options):**
    *   **"Add Anaconda3 to my PATH environment variable" (Anaconda3를 내 PATH 환경 변수에 추가):**
        *   **초보자에게는 이 옵션을 선택하는 것을 권장하지 않습니다.** (Anaconda Prompt를 통해 실행 권장)
        *   이 옵션을 선택하면 명령 프롬프트(cmd)나 PowerShell에서 직접 `conda` 명령어를 사용할 수 있게 되지만, 기존 Python 설치와 충돌을 일으킬 수 있습니다.
        *   Anaconda Prompt를 사용하는 것이 더 안정적입니다.
    *   **"Register Anaconda3 as my default Python 3.x" (Anaconda3를 기본 Python 3.x로 등록):**
        *   이 옵션은 보통 선택된 상태로 두는 것이 좋습니다.
    *   **"Next"** 를 클릭합니다.

7.  **설치 시작:**
    *   **"Install"** 버튼을 클릭하여 설치를 시작합니다. 설치에는 몇 분 정도 소요될 수 있습니다.

8.  **설치 완료:**
    *   설치가 완료되면 **"Next"** 를 클릭합니다.
    *   **"Anaconda Distribution"** 정보 창이 나타나면 **"Next"** 를 클릭합니다.
    *   **"Finish"** 를 클릭하여 설치를 마칩니다.
        *   "Launch Anaconda Navigator" 와 "Getting Started with Anaconda" 옵션은 필요에 따라 선택 해제할 수 있습니다.

9.  **설치 확인 (Anaconda Prompt 실행):**
    *   Windows 시작 메뉴에서 **"Anaconda Prompt"** 를 검색하여 실행합니다.
    *   프롬프트 창에 다음 명령어를 입력하고 Enter 키를 누릅니다.
        ```bash
        conda --version
        ```
    *   `conda 4.x.x` 와 같이 버전 정보가 출력되면 정상적으로 설치된 것입니다.
    *   다음 명령어로 Python 버전도 확인합니다.
        ```bash
        python --version
        ```
    *   `Python 3.x.x` 와 같이 버전 정보가 출력되면 됩니다.

<br/>

### 5.2. macOS에 Anaconda 설치하기

1.  **Anaconda 다운로드:**
    *   [Anaconda 공식 웹사이트](https://www.anaconda.com/products/distribution)에 접속합니다.
    *   macOS용 **"Graphical Installer"** 또는 **"Command-Line Installer"** 중 하나를 다운로드합니다. 일반적으로 그래픽 설치 프로그램(.pkg)이 더 사용하기 쉽습니다.

2.  **그래픽 설치 프로그램(.pkg) 실행:**
    *   다운로드한 `.pkg` 파일을 실행합니다.
    *   화면의 지시에 따라 **"Continue"** 를 클릭하며 설치를 진행합니다.
    *   라이선스 동의, 설치 위치 선택 등의 과정을 거칩니다. 기본 설정을 사용하는 것이 일반적입니다.
    *   **"Install"** 버튼을 클릭하여 설치를 시작합니다.

3.  **설치 완료:**
    *   설치가 완료되면 **"Close"** 버튼을 클릭합니다.

4.  **환경 변수 설정 (터미널에서):**
    *   macOS에서는 `.bash_profile` 또는 `.zshrc` 파일(사용하는 쉘에 따라 다름)에 Anaconda 경로를 추가해야 할 수 있습니다. 일반적으로 설치 과정에서 자동으로 추가되지만, 그렇지 않은 경우 수동으로 설정해야 합니다.
    *   터미널(Terminal)을 엽니다.
    *   만약 Zsh를 사용한다면 (macOS Catalina 이후 기본 쉘), 다음 명령어를 실행하여 `conda init`을 수행합니다.
        ```bash
        conda init zsh
        ```
    *   Bash를 사용한다면 다음 명령어를 실행합니다.
        ```bash
        conda init bash
        ```
    *   터미널을 **재시작**합니다.

5.  **설치 확인 (터미널 실행):**
    *   새로운 터미널 창을 엽니다.
    *   다음 명령어를 입력하고 Enter 키를 누릅니다.
        ```bash
        conda --version
        ```
    *   `conda 4.x.x` 와 같이 버전 정보가 출력되면 정상적으로 설치된 것입니다.
    *   다음 명령어로 Python 버전도 확인합니다.
        ```bash
        python --version
        ```
    *   `Python 3.x.x` 와 같이 버전 정보가 출력되면 됩니다.

<br/>

### 5.3. Linux에 Anaconda 설치하기

1.  **Anaconda 다운로드:**
    *   [Anaconda 공식 웹사이트](https://www.anaconda.com/products/distribution)에 접속합니다.
    *   Linux용 Anaconda 설치 스크립트(`.sh` 파일)를 다운로드합니다. (예: `Anaconda3-202x.xx-Linux-x86_64.sh`)

2.  **설치 스크립트 실행 권한 부여 (터미널에서):**
    *   터미널을 엽니다.
    *   다운로드한 파일이 있는 디렉토리로 이동합니다. (예: `cd Downloads`)
    *   다음 명령어를 사용하여 스크립트에 실행 권한을 부여합니다. (파일 이름은 실제 다운로드한 파일 이름으로 변경)
        ```bash
        chmod +x Anaconda3-202x.xx-Linux-x86_64.sh
        ```

3.  **설치 스크립트 실행 (터미널에서):**
    *   다음 명령어를 사용하여 스크립트를 실행합니다.
        ```bash
        ./Anaconda3-202x.xx-Linux-x86_64.sh
        ```

4.  **설치 진행:**
    *   화면에 나타나는 지시에 따라 설치를 진행합니다.
    *   **Enter** 키를 눌러 라이선스 내용을 확인하고, **"yes"** 를 입력하여 동의합니다.
    *   설치 경로를 확인하거나 변경합니다. (기본 경로는 `~/anaconda3`)
    *   설치가 완료된 후, `conda init`을 실행할지 묻는 메시지가 나타나면 **"yes"** 를 입력합니다. 이렇게 하면 쉘 설정 파일(`.bashrc` 또는 `.zshrc`)에 필요한 설정이 자동으로 추가됩니다.

5.  **환경 변수 적용 (터미널 재시작 또는 source 명령어):**
    *   변경 사항을 적용하려면 터미널을 **재시작**하거나, 다음 명령어를 실행합니다. (자신의 쉘에 맞는 파일 사용)
        *   Bash 쉘의 경우:
            ```bash
            source ~/.bashrc
            ```
        *   Zsh 쉘의 경우:
            ```bash
            source ~/.zshrc
            ```

6.  **설치 확인 (터미널 실행):**
    *   새로운 터미널 창을 엽니다.
    *   다음 명령어를 입력하고 Enter 키를 누릅니다.
        ```bash
        conda --version
        ```
    *   `conda 4.x.x` 와 같이 버전 정보가 출력되면 정상적으로 설치된 것입니다.
    *   다음 명령어로 Python 버전도 확인합니다.
        ```bash
        python --version
        ```
    *   `Python 3.x.x` 와 같이 버전 정보가 출력되면 됩니다.

<br/>

## 6. 가상 환경 다루기 (Managing Virtual Environments)

Anaconda 설치가 완료되었다면, 이제 프로젝트별로 독립적인 개발 환경인 **가상 환경**을 만드는 방법을 알아봅니다. 가상 환경을 사용하면 각 프로젝트에 필요한 라이브러리 버전들을 격리하여 관리할 수 있어, 의존성 문제를 해결하고 프로젝트의 재현성을 높일 수 있습니다.

### 6.1. 가상 환경이란 무엇일까요?

가상 환경은 마치 **\'나만의 작은 실험실\'**과 같습니다. 각 실험실마다 필요한 도구와 재료(라이브러리와 패키지)를 독립적으로 갖추고 있어서, 한 실험실에서의 작업이 다른 실험실에 영향을 주지 않는 것과 같은 원리입니다.

예를 들어, A 프로젝트에서는 `numpy 1.20` 버전이 필요하고, B 프로젝트에서는 `numpy 1.25` 버전이 필요하다고 가정해 봅시다. 만약 가상 환경 없이 시스템 전체에 하나의 `numpy`만 설치되어 있다면, 두 프로젝트 중 하나는 호환성 문제로 제대로 동작하지 않을 수 있습니다.

가상 환경을 사용하면, A 프로젝트를 위한 환경에는 `numpy 1.20`을, B 프로젝트를 위한 환경에는 `numpy 1.25`를 각각 설치하여 이러한 문제를 해결할 수 있습니다.

### 6.2. `conda`를 이용한 가상 환경 관리

Anaconda는 `conda`라는 강력한 명령줄 도구를 제공하여 가상 환경을 손쉽게 생성, 활성화, 비활성화, 삭제할 수 있도록 지원합니다.

**주요 `conda` 명령어:**

| 명령어                                      | 설명                                                                 | 예시                                                                |
| :------------------------------------------ | :------------------------------------------------------------------- | :------------------------------------------------------------------ |
| `conda create -n <env_name> python=<version>` | 특정 Python 버전으로 새로운 가상 환경을 생성합니다.                            | `conda create -n myenv python=3.9`                                  |
| `conda activate <env_name>`                 | 생성된 가상 환경을 활성화합니다. 활성화 후에는 해당 환경에 패키지를 설치할 수 있습니다. | `conda activate myenv`                                              |
| `conda deactivate`                          | 현재 활성화된 가상 환경을 비활성화합니다.                                    | `conda deactivate`                                                  |
| `conda env list`                            | 생성된 모든 가상 환경 목록을 보여줍니다.                                   | `conda env list`                                                    |
| `conda remove -n <env_name> --all`          | 특정 가상 환경과 그 안에 설치된 모든 패키지를 삭제합니다.                     | `conda remove -n myenv --all`                                       |
| `conda install <package_name>`              | 활성화된 가상 환경에 특정 패키지를 설치합니다.                               | `conda install numpy` (myenv 활성화 상태에서)                         |
| `conda install <package_name>=<version>`    | 특정 버전의 패키지를 설치합니다.                                           | `conda install numpy=1.20`                                          |
| `conda list`                                | 활성화된 가상 환경에 설치된 패키지 목록을 보여줍니다.                           | `conda list`                                                        |
| `conda search <package_name>`               | 설치 가능한 패키지를 검색합니다.                                           | `conda search tensorflow`                                           |
| `conda env export > environment.yml`        | 현재 환경의 패키지 목록을 `environment.yml` 파일로 저장합니다. (환경 공유용)   | `conda env export > environment.yml`                                |
| `conda env create -f environment.yml`       | `environment.yml` 파일로부터 가상 환경을 생성합니다. (환경 복원용)         | `conda env create -f environment.yml`                               |

**실습: `my_project_env` 가상 환경 만들고 사용하기**

1.  **Anaconda Prompt (Windows) 또는 터미널(macOS/Linux)을 엽니다.**

2.  **`my_project_env`라는 이름으로 Python 3.9 버전을 사용하는 가상 환경을 생성합니다.**
    ```bash
    conda create -n my_project_env python=3.9
    ```
    *   설치 과정에서 프롬프트가 나타나면 `y`를 입력하고 Enter를 누릅니다.

3.  **생성된 가상 환경을 활성화합니다.**
    ```bash
    conda activate my_project_env
    ```
    *   프롬프트 앞부분이 `(my_project_env)` 와 같이 변경되면 가상 환경이 성공적으로 활성화된 것입니다.

4.  **활성화된 가상 환경에 `numpy`와 `pandas` 패키지를 설치합니다.**
    ```bash
    conda install numpy pandas
    ```
    *   마찬가지로 설치 과정에서 프롬프트가 나타나면 `y`를 입력하고 Enter를 누릅니다.

5.  **설치된 패키지 목록을 확인합니다.**
    ```bash
    conda list
    ```
    *   `numpy`와 `pandas`가 목록에 있는지 확인합니다.

6.  **가상 환경을 비활성화합니다.**
    ```bash
    conda deactivate
    ```
    *   프롬프트 앞부분에서 `(my_project_env)`가 사라지고 원래대로 돌아옵니다.

7.  **(선택 사항) 생성한 가상 환경을 삭제합니다.**
    ```bash
    conda remove -n my_project_env --all
    ```

**💡 Tip:** 앞으로 진행할 모든 프로젝트는 **반드시 새로운 가상 환경을 생성하고 활성화한 후**에 시작하는 습관을 들이는 것이 좋습니다. 이는 프로젝트 간의 의존성 충돌을 막고, 깨끗하고 관리하기 쉬운 개발 환경을 유지하는 데 매우 중요합니다. 각 파트별 실습을 시작할 때마다 해당 파트에 맞는 가상 환경을 만드는 것을 권장합니다. 예를 들어, `part2_env`, `part3_env` 와 같이 말이죠!

## 7. 개발 도구 실행 및 기본 사용법 (Running Tools)

Anaconda와 가상 환경 설정이 완료되었다면, 이제 코드를 작성하고 실행할 개발 도구인 Jupyter Notebook과 VS Code를 사용해 보겠습니다.

### 7.1. Jupyter Notebook / JupyterLab 사용하기

[Jupyter Notebook](../../glossary.md#jupyter-notebook-주피터-노트북)은 코드, 텍스트, 이미지를 하나의 문서에 통합하여 대화형으로 작업할 수 있게 해주는 강력한 도구입니다. 데이터 분석, 머신러닝 모델링, 교육 자료 작성 등에 널리 사용됩니다. [JupyterLab](../../glossary.md#jupyterlab-주피터랩)은 Jupyter Notebook의 기능을 확장한 차세대 인터페이스입니다.

**실행 방법:**

1.  **Anaconda Prompt (Windows) 또는 터미널(macOS/Linux)을 엽니다.**
2.  **작업하고자 하는 프로젝트의 가상 환경을 활성화합니다.** (예: `conda activate my_project_env`)
3.  **Jupyter Notebook 실행:**
    ```bash
    jupyter notebook
    ```
    또는 **JupyterLab 실행:**
    ```bash
    jupyter lab
    ```
4.  명령어를 실행하면 웹 브라우저가 자동으로 열리면서 Jupyter Notebook/Lab 인터페이스가 나타납니다.
    *   만약 브라우저가 자동으로 열리지 않으면, 터미널에 출력된 URL (예: `http://localhost:8888/`)을 복사하여 웹 브라우저 주소창에 붙여넣습니다.

**기본 사용법:**

*   **새 노트북 생성:** 오른쪽 상단의 "New" 버튼(Jupyter Notebook) 또는 왼쪽의 파일 탐색기에서 "+" 버튼(JupyterLab)을 클릭하고 "Python 3 (ipykernel)" 또는 유사한 항목을 선택합니다.
*   **셀(Cell) 유형:**
    *   **Code Cell:** Python 코드를 입력하고 실행하는 셀입니다. `Shift + Enter` 또는 상단 메뉴의 "Run" 버튼으로 실행합니다.
    *   **Markdown Cell:** 텍스트, 제목, 목록, 이미지, 링크 등을 [Markdown](../../glossary.md#markdown-마크다운) 문법으로 작성하는 셀입니다. `Shift + Enter`로 렌더링합니다.
*   **파일 저장:** `Ctrl + S` 또는 파일 메뉴에서 "Save"를 선택합니다.
*   **노트북 종료:** Jupyter Notebook/Lab을 실행한 터미널 창에서 `Ctrl + C`를 두 번 누릅니다.

Jupyter Notebook/Lab은 코드 스니펫을 빠르게 테스트하고, 데이터 시각화 결과를 바로 확인하며, 아이디어를 정리하는 데 매우 효과적입니다.

#### 💡 Jupyter Notebook 필수 단축키

Jupyter Notebook을 200% 활용하려면 단축키 사용이 필수입니다. Jupyter는 **명령 모드(Command Mode)**와 **편집 모드(Edit Mode)** 두 가지 상태를 가집니다.

*   **편집 모드 (Edit Mode):** 셀 안의 텍스트나 코드를 편집하는 상태입니다. 셀을 클릭하거나 `Enter` 키를 누르면 활성화되며, 셀 왼쪽에 **녹색** 테두리가 생깁니다.
*   **명령 모드 (Command Mode):** 셀 자체를 관리(추가, 삭제, 복사 등)하는 상태입니다. 편집 모드에서 `Esc` 키를 누르면 활성화되며, 셀 왼쪽에 **파란색** 테두리가 생깁니다.

아래는 각 모드에서 가장 유용한 단축키들입니다.

**명령 모드 (Command Mode) 단축키**

| 단축키 | 설명 |
| :--- | :--- |
| `Enter` | 편집 모드로 전환합니다. |
| `Shift + Enter` | 현재 셀을 실행하고, 아래 셀로 이동합니다. (아래 셀이 없으면 생성) |
| `Ctrl + Enter` | 현재 셀을 실행하고, 현재 셀에 머무릅니다. |
| `Alt + Enter` | 현재 셀을 실행하고, 바로 아래에 새 셀을 추가합니다. |
| `A` | 현재 셀 **위에(Above)** 새 셀을 추가합니다. |
| `B` | 현재 셀 **아래에(Below)** 새 셀을 추가합니다. |
| `M` | 현재 셀을 Markdown 셀로 변경합니다. |
| `Y` | 현재 셀을 Code 셀로 변경합니다. |
| `C` | 현재 셀을 복사합니다. |
| `X` | 현재 셀을 잘라냅니다. |
| `V` | 잘라내거나 복사한 셀을 현재 셀 아래에 붙여넣습니다. |
| `D, D` (D 두 번 누르기) | 현재 셀을 삭제합니다. |
| `Z` | 삭제한 셀을 되돌립니다. |
| `H` | 모든 단축키 목록을 보여주는 도움말 창을 엽니다. |

**편집 모드 (Edit Mode) 단축키**

| 단축키 | 설명 |
| :--- | :--- |
| `Esc` | 명령 모드로 전환합니다. |
| `Tab` | 코드 자동 완성 또는 들여쓰기를 합니다. |
| `Shift + Tab` | 함수나 객체에 대한 설명을 보여줍니다. (Tooltip) |
| `Ctrl + /` | 현재 줄 또는 선택된 영역을 주석 처리/해제합니다. |
| `Ctrl + Z` | 실행을 취소합니다. (Undo) |
| `Ctrl + Y` | 취소한 작업을 다시 실행합니다. (Redo) |

### 7.2. Visual Studio Code (VS Code) 사용하기

[VS Code](../../glossary.md#visual-studio-code-vs-code)는 강력한 기능과 다양한 확장 프로그램을 제공하는 현대적인 코드 편집기입니다. Python 개발을 위한 훌륭한 환경을 제공하며, Jupyter Notebook 파일(`.ipynb`)도 직접 열고 편집할 수 있습니다.

**설치 (아직 설치하지 않았다면):**

*   [VS Code 공식 웹사이트](https://code.visualstudio.com/)에서 자신의 운영체제에 맞는 설치 프로그램을 다운로드하여 설치합니다.

#### 🐍 Python 개발 생산성을 높여주는 필수 확장 프로그램

VS Code의 진정한 강력함은 확장 프로그램(Extensions)에 있습니다. 왼쪽 사이드바의 네모 블록 모양 아이콘을 클릭하여 확장 프로그램 마켓플레이스에 접근할 수 있습니다. Python 개발을 위해 아래의 확장 프로그램들을 설치하고 설정하는 것을 적극 권장합니다.

**1. 기본 확장 프로그램 (Microsoft 제공)**

검색창에 `Python`을 검색하여 Microsoft에서 제공하는 공식 **Python Extension Pack**을 설치하면, 다음과 같은 핵심 확장 프로그램들이 함께 설치되어 강력한 기본 개발 환경을 구축해 줍니다.

*   **Python ([ms-python.python](https://marketplace.visualstudio.com/items?itemName=ms-python.python))**
    *   **역할**: VS Code에서 파이썬을 사용하기 위한 모든 기능의 기반이 되는 **필수 확장 프로그램**입니다.
    *   **주요 기능**: 코드 구문 강조(Syntax Highlighting), 디버깅, 테스트 지원, 가상 환경 관리 등 파이썬 개발에 필요한 핵심 기능을 제공합니다. 이 확장 프로그램을 설치하는 것만으로도 대부분의 준비는 끝납니다.

*   **Pylance ([ms-python.vscode-pylance](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance))**
    *   **역할**: 파이썬 코드를 매우 빠르고 정확하게 분석해주는 **지능형 언어 서버**입니다. `Python` 확장 프로그램에 의해 자동으로 설치됩니다.
    *   **주요 기능**:
        *   **IntelliSense**: 변수나 함수의 타입을 미리 파악하여 매우 정확한 자동 완성 제안을 해줍니다.
        *   **실시간 오류 검사**: 코드를 작성하는 중 잠재적인 오류를 즉시 찾아내고 밑줄로 표시해줍니다.
        *   **타입 힌트(Type Hint) 분석**: 코드에 명시된 타입 힌트를 분석하여 코드의 안정성을 높여줍니다.

*   **Jupyter ([ms-toolsai.jupyter](https://marketplace.visualstudio.com/items?itemName=ms-toolsai.jupyter))**
    *   **역할**: VS Code 내에서 **Jupyter Notebook(`.ipynb`) 파일을 직접 실행하고 편집**할 수 있게 해주는 확장 프로그램입니다.
    *   **주요 기능**: VS Code 편집기 안에서 셀 단위로 코드를 실행하고, 시각화 결과를 바로 확인하는 등 Jupyter Notebook의 모든 경험을 그대로 누릴 수 있습니다.

**2. 추가 추천 확장 프로그램**

기본 확장 프로그램 외에, 아래 프로그램들을 추가로 설치하면 개발 효율을 한 단계 더 끌어올릴 수 있습니다.

*   **Ruff ([charliermarsh.ruff](https://marketplace.visualstudio.com/items?itemName=charliermarsh.ruff))**
    *   **역할**: **매우 빠른 속도를 자랑하는 최신 Python 린터(Linter) 및 포매터(Formatter)**입니다.
    *   **왜 사용해야 할까요?**: 기존의 `Flake8`, `isort`, `Black` 등 여러 도구를 하나로 합친 것과 같으면서도, 훨씬 빠른 성능을 보여줍니다. 코드의 잠재적 오류를 찾아내고(Linting), 정해진 스타일 규칙에 맞게 코드를 자동으로 정리(Formatting)해주는 두 가지 역할을 모두 수행하여 코드 품질을 일관되게 유지하는 데 큰 도움이 됩니다.
    *   **설정 팁**: VS Code 설정에서 "Format on Save" 옵션을 켜고, 기본 포매터를 Ruff로 지정하면 파일을 저장할 때마다 자동으로 코드가 예쁘게 정리됩니다.

*   **autoDocstring ([njpwerner.autodocstring](https://marketplace.visualstudio.com/items?itemName=njpwerner.autodocstring))**
    *   **역할**: **함수나 클래스의 설명문(Docstring)을 자동으로 생성**해주는 편리한 도구입니다.
    *   **왜 사용해야 할까요?**: 함수의 파라미터, 반환값 등을 분석하여 표준 형식(Google, NumPy, Sphinx 등)에 맞는 Docstring의 틀을 자동으로 만들어줍니다. 잘 작성된 Docstring은 협업과 유지보수에 필수적이며, 이 확장 프로그램은 문서화에 드는 시간을 크게 줄여줍니다.

*   **indent-rainbow ([oderwat.indent-rainbow](https.marketplace.visualstudio.com/items?itemName=oderwat.indent-rainbow))**
    *   **역할**: **들여쓰기(Indentation) 깊이에 따라 다른 색상**을 입혀 코드의 가독성을 높여줍니다.
    *   **왜 사용해야 할까요?**: 파이썬은 들여쓰기가 문법적으로 매우 중요하기 때문에, 이 확장 프로그램을 사용하면 코드 블록의 구조를 시각적으로 파악하기가 훨씬 쉬워집니다.

#### Python 인터프리터 선택 (가상 환경 연결)

1.  **VS Code 실행 후, 앞서 추천한 확장 프로그램들을 설치합니다.**
2.  **VS Code에서 Python 파일을 열거나, 새 Python 파일을 생성합니다.** (`.py` 확장자로 끝나는 파일)
3.  **인터프리터 선택:**
    *   VS Code 하단 상태 표시줄의 오른쪽(또는 `Ctrl+Shift+P`를 눌러 명령 팔레트를 열고 `Python: Select Interpreter` 검색)을 보면 현재 선택된 Python 인터프리터가 표시됩니다.
    *   이 부분을 클릭하면 사용 가능한 Python 인터프리터 목록이 나타납니다.
    *   이 목록에서 **앞서 `conda`로 생성한 가상 환경** (예: `my_project_env: conda`)을 선택합니다.
    *   만약 목록에 보이지 않는다면, "Enter interpreter path..."를 선택하고 직접 가상 환경 내 Python 실행 파일 경로를 지정할 수도 있습니다. (예: `C:\Users\YourUser\anaconda3\envs\my_project_env\python.exe` 또는 `~/anaconda3/envs/my_project_env/bin/python`)
    *   **중요:** 올바른 가상 환경을 인터프리터로 선택해야, 해당 환경에 설치한 라이브러리들을 VS Code가 인식하고 코드 자동 완성 및 실행을 제대로 지원할 수 있습니다.

**기본 사용법:**

*   **새 파일 또는 폴더 열기:** "File" 메뉴 또는 시작 화면에서 프로젝트 폴더를 엽니다.
*   **코드 작성 및 실행:**
    *   Python 파일(`.py`)을 생성하거나 엽니다.
    *   코드를 작성한 후, 오른쪽 상단의 실행 버튼(삼각형 모양)을 클릭하거나, 터미널에서 `python <파일명>.py` 명령으로 실행합니다.
    *   VS Code 내 터미널은 "Terminal" > "New Terminal" 메뉴로 열 수 있습니다. (이때 터미널은 선택된 `conda` 가상 환경으로 자동 활성화됩니다.)
*   **디버깅:** 중단점(breakpoint)을 설정하고 디버깅 모드를 실행하여 코드 실행 과정을 단계별로 추적할 수 있습니다.
*   **Git 연동:** VS Code는 Git 버전 관리 시스템을 내장하고 있어, 코드 변경 사항을 손쉽게 추적하고 협업할 수 있습니다.

VS Code는 단순한 스크립트 작성부터 대규모 프로젝트 개발까지 모두 지원하는 강력하고 유연한 도구입니다. Jupyter Notebook과 함께 사용하면 더욱 효율적인 개발이 가능합니다.

### 7.3. AI 기반 코드 에디터 활용 (Cursor)

지금까지 우리는 AI 개발을 위한 기초 체력을 기르기 위해 Anaconda, VS Code 등 필수적인 도구들을 설치하고 가상 환경을 구축했습니다. 이제 개발 생산성을 극대화할 수 있는 강력한 도구인 **AI 기반 코드 에디터, Cursor**의 활용법에 대해 알아봅니다.

VS Code가 '스마트 작업대'라면, Cursor는 **'AI 조수가 함께하는 최첨단 스마트 작업대'**라고 할 수 있습니다. Cursor는 VS Code를 기반으로 만들어져 기존 VS Code의 모든 기능을 그대로 사용하면서, 강력한 AI 기능을 통합하여 개발의 모든 단계에서 도움을 줍니다.

#### 왜 AI 코드 에디터를 사용해야 할까요?

- **개발 시간 단축**: 반복적인 코드 작성, 복잡한 로직 구현, 문서 검색 등에 소요되는 시간을 AI가 대신 처리해주어 핵심 비즈니스 로직에 더 집중할 수 있습니다.
- **학습 곡선 완화**: 새로운 라이브러리나 프레임워크를 배울 때, AI에게 직접 질문하고 코드 예시를 받으며 빠르게 학습할 수 있습니다.
- **코드 품질 향상**: AI가 코드 스니펫 생성, 리팩토링, 버그 수정 등을 제안하여 더 깨끗하고 효율적인 코드를 작성하도록 돕습니다.
- **맥락(Context) 기반의 정확한 지원**: AI가 현재 작업 중인 전체 프로젝트 구조, 열려 있는 파일, 터미널 내용 등을 이해하고 질문의 의도에 맞는 정확하고 실용적인 답변을 제공합니다.

#### Cursor 설치 및 기본 설정

1.  **설치**:
    - [Cursor 공식 홈페이지](https://cursor.sh/)에 접속하여 자신의 운영체제에 맞는 버전을 다운로드하고 설치합니다.
    - 설치 과정은 일반적인 애플리케이션과 동일하며 매우 간단합니다.

2.  **기본 설정 (OpenAI API 키 연동 - 선택 사항)**:
    - Cursor는 기본적으로 내장된 AI 모델을 무료로 제공하지만, 더 높은 성능의 GPT-4와 같은 모델을 사용하려면 개인의 OpenAI API 키를 등록할 수 있습니다.
    - `File > Preferences > Settings` (단축키: `Ctrl + ,`) 로 이동한 후 'Cursor'를 검색하여 관련 설정을 찾을 수 있습니다.

3.  **기존 VS Code 설정 마이그레이션**:
    - Cursor는 최초 실행 시 기존에 사용하던 VS Code의 확장 프로그램과 설정을 그대로 가져올지 묻습니다. 이를 통해 별도의 설정 없이 기존 개발 환경을 그대로 사용할 수 있습니다.

#### Cursor 핵심 기능 완전 정복

Cursor의 핵심 기능은 단축키 `Ctrl + K` (AI에게 질문/코드 생성)와 `Ctrl + L` (채팅)에 집약되어 있습니다.

| 기능 | 단축키 (Windows/Linux) | 설명 | 활용 예시 |
|---|---|---|---|
| **AI 채팅 (Chat)** | `Ctrl + L` | 사이드바 형태의 채팅창을 열어 AI와 대화합니다. 현재 열린 파일이나 선택된 코드 블록을 자동으로 인식(`@` 기호 활용)하여 맥락에 맞는 답변을 제공합니다. | - "이 `calculate_metrics` 함수의 코드를 설명해줘."<br>- "Pandas 데이터프레임에서 중복된 행을 제거하는 방법을 알려줘."<br>- "이 프로젝트의 전체 구조를 다이어그램으로 그려줘." |
| **인라인 코드 생성/수정 (Inline Edit/Generate)** | `Ctrl + K` | 코드 편집기 내에서 직접 AI에게 코드 생성을 요청하거나, 기존 코드를 수정하도록 지시합니다. | - 빈 줄에서: "사용자 정보를 담는 `User` Pydantic 모델을 만들어줘."<br>- 기존 코드 블록 선택 후: "이 코드를 try-except 구문으로 감싸서 예외 처리를 추가해줘."<br>- "이 함수의 이름을 `process_data`로 변경하고 관련 참조도 모두 수정해줘." |
| **컨텍스트 활용 (`@` 기호)** | 채팅 또는 인라인(`Ctrl+K`)에서 `@` 입력 | AI에게 참고할 파일이나 심볼(함수/클래스), 문서를 명시적으로 지정하여 더 정확한 답변을 유도합니다. | - `@main.py` 파일의 내용을 기반으로 질문<br>- `@calculate_metrics` 함수에 대해 질문<br>- `@fastapi` 공식 문서를 참고하여 답변 요청 |
| **AI를 이용한 디버깅 (Debug with AI)** | 코드 에디터의 'Run and Debug' 또는 에러 발생 시 | 코드 실행 중 발생한 에러에 대해 `Fix with AI` 버튼을 클릭하면, AI가 에러의 원인을 분석하고 해결책을 제시합니다. | - `NullPointerException` 발생 시 원인 분석 및 해결 코드 제안 |

#### 사내 Best Practice 공유

- **새로운 기능 구현은 AI와 함께**: 새로운 API 엔드포인트나 데이터 처리 로직을 구현할 때, 주석으로 원하는 기능을 명시하고 `Ctrl + K`를 눌러 AI에게 초안 작성을 맡겨보세요. 개발 속도가 비약적으로 향상됩니다.
- **문서(Documentation)는 AI에게**: 잘 작성된 코드 블록을 선택하고 "이 코드에 대한 docstring을 작성해줘"라고 요청하면, 표준 형식에 맞는 문서 초안을 얻을 수 있습니다.
- **리팩토링은 부담 없이**: 개선하고 싶은 코드(예: 중복 코드, 긴 함수)를 선택하고 "이 코드를 더 효율적으로 리팩토링해줘" 또는 "이 함수를 여러 개의 작은 함수로 분리해줘" 와 같이 요청하여 코드 품질을 지속적으로 관리하세요.
- **막힐 때는 바로 질문하기**: 개발 중 모르는 것이 생겼을 때 웹 브라우저를 열어 검색하는 대신, `Ctrl + L`을 눌러 바로 AI에게 질문하세요. 작업의 흐름을 유지하면서 필요한 정보를 즉시 얻을 수 있습니다.

Cursor와 같은 AI 기반 도구를 적극적으로 활용하는 것은 이제 선택이 아닌 필수입니다. 이러한 도구를 통해 반복적인 작업을 자동화하고, 창의적인 문제 해결에 더 많은 시간을 투자하여 개발자로서의 가치를 더욱 높일 수 있습니다.

#### 🚀 Cursor 고급 사용 팁 12가지

Hacker News 커뮤니티와 실제 개발자들의 경험을 바탕으로 한 고급 사용 팁들을 소개합니다. 이 팁들을 활용하면 Cursor를 훨씬 더 효율적으로 사용할 수 있습니다.

**팁 1: 전략적으로 모델을 선택하자**
- **Thinking 모델** (Claude 4, Gemini 2.5 Pro): 자율적이고 창의적이지만 속도가 느림. 복잡한 아키텍처 설계나 리팩토링에 적합
- **Non-Thinking 모델** (GPT-4.1): 명확한 지시를 잘 따르고 속도가 빠름. 단순한 코드 수정이나 버그 수정에 적합
- **Auto-select 기능은 신뢰도가 낮으므로**, 여러 모델을 직접 써보고 자신만의 스타일을 찾는 것이 좋음

**팁 2: 복잡한 앱 수정 시 Ask 모드로 계획을 먼저 세우자**
- **Agent 모드**는 코드를 직접 수정하므로 복잡한 앱에서는 기존 기능을 망가뜨릴 가능성이 있음
- **Ask 모드**는 파일을 수정하지 않는 읽기 전용 모드로, 계획을 세울 때 매우 유용함
- 먼저 Ask 모드에서 AI와 계획을 논의한 후, Agent 모드에서 실행하는 것이 안전함
- "지금 당장 수정하지 마"처럼 프롬프트를 명확히 하면 불필요한 동작을 줄일 수 있음

**팁 3: 디버깅할 때는 TDD 방식으로 접근하자**
1. **1단계 (Agent)**: 버그를 재현하는 '실패하는' 테스트 코드를 먼저 작성하게 함
   ```
   "X 페이지에서 Y를 누르면 A처럼 동작해야 하는데 B처럼 동작해. 
   TDD 방식으로 고쳐보려고 하는데, 이 현상을 재현하는 테스트 코드를 작성해서 실행해줘. 
   현 시점에 테스트 코드는 일단 실패해야 한다는 걸 기억해."
   ```
2. **2단계 (Ask)**: 가능한 원인과 확인 방법을 설명하게 하여 근본 원인을 파악함
3. **3단계 (Agent)**: 테스트 코드는 `.cursorignore`로 잠근 뒤, 테스트가 통과될 때까지 코드 수정을 지시함

**팁 4: Cursor가 스스로 학습하도록 룰을 관리하자**
- 채팅 세션에서 유의미한 대화가 오갔다면, `/Generate Cursor Rules` 기능을 활용
- "이번 대화 내용을 기반으로 Rule을 만들거나 수정해줘"라고 요청
- 특히 디버깅 후, 버그의 원인을 파악했다면 같은 실수를 반복하지 않도록 Rule을 추가/수정
- 이를 통해 Cursor가 스스로 학습하고 점점 더 똑똑해지게 만들 수 있음

**팁 5: 다중 탭과 Auto 옵션을 활용해 생산성을 높이자**
- Cursor에서는 여러 채팅 탭을 동시에 사용 가능
- 한 탭에서 Agent가 코드를 수정하는 동안 다른 탭에서 Ask 모드로 다른 작업을 할 수 있음
- **'Auto-run'** 옵션을 켜두면 터미널 실행이나 파일 쓰기 등을 일일이 승인할 필요 없이 자동으로 진행
- **'Auto-Fix Lints'** 옵션을 켜두면 타입 에러 등을 알아서 수정해줘서 편리함

**팁 6: 하나의 채팅 세션을 오래 지속하지 말자**
- 채팅이 길어지면 컨텍스트 크기 한계로 인해 AI가 이전의 중요 정보를 잊어버릴 수 있음
- 하나의 작업이 끝나면 새 채팅 세션을 시작하는 것이 더 유리함
- 새 채팅에서 `@Past Chats`를 이용해 이전 대화 요약을 컨텍스트로 주입할 수 있음
- 유의미한 내용은 룰로 만들어두면 긴 채팅을 유지할 필요성이 줄어듦

**팁 7: 유의미한 변경이 완료되면 반드시 커밋하자**
- 하나의 작업이 끝나면 반드시 Git에 커밋하는 습관이 중요함
- 커밋은 AI가 코드를 잘못 수정했을 때 돌아갈 수 있는 최소한의 안전장치
- Cursor 채팅을 통해 Git 초기 설정부터 커밋 메시지 작성까지 도움을 받을 수 있음
- **AI Commit Message** 기능을 사용하면 커밋 메시지를 자동으로 생성할 수도 있음

**팁 8: 코드 구조를 AI에게 알려주고 파일 관리를 최적화하자**
- Cursor의 내부 Tools 특성을 이해해두면 좋음:
  - **List Directory**: 파일의 내용은 읽지 않고 디렉토리명과 파일명만 읽음
  - **Read File**: 파일의 내용을 한번에 최대 250줄까지만 읽음 (Max 모드에서는 750줄)
  - 한 채팅 세션에서 Tool 호출을 25번까지만 할 수 있음 (Max 모드에서는 200번)
- 따라서 역할이 명확하도록 파일과 디렉토리 이름을 짓고, 파일 길이는 500줄 이내로 유지하는 것이 좋음
- 핵심 디렉토리 구조나 컴포넌트 정보는 **Always Applied 룰**로 추가해두면 AI가 매번 탐색할 필요가 없음

**팁 9: 파일이 길어지면 AI에게 모듈화를 요청하자**
1. **1단계 (Ask)**: "이 프로젝트를 모듈화한다면 어떤 관점이나 전략에서 하는 게 좋을지 제안해줘"
2. **2단계 (Ask)**: "제시한 전략들을 종합하여 적절한 모듈화 계획을 세워줘"
3. **3단계 (Agent)**: "그 계획을 문서화한 뒤 실행해줘"

**팁 10: @을 써서 적극적으로 컨텍스트를 주입하자**
- `@` 기호를 사용해 파일, 폴더 외에 다양한 컨텍스트를 직접 주입하면 AI가 더 일을 잘함
- **@Code**: 코드의 특정 함수나 변수 등 일부만 참조할 수 있음
- **@Docs**: 라이브러리 공식 문서를 참조하여 더 정확한 코드를 작성하게 함
- **@Git**: 특정 브랜치나 커밋 내용을 참조하게 하여 비교하거나 설명시킬 수 있음
- **@Web, @Link**: 웹 검색을 하거나 특정 링크의 내용을 읽어오게 할 수 있음
- **@Recent Change**: 최근 코드베이스 변경사항을 참조시킬 수 있음

**팁 11: 보안이 중요하다면 Privacy 모드를 켜자**
- Privacy 모드를 켜지 않으면 코드, 프롬프트 등 데이터가 수집되어 모델 학습에 사용될 수 있음
- Privacy 모드를 켜면 코드 일부가 암호화되어 잠시 저장될 수는 있지만, 영구 저장되거나 학습에 사용되지 않음
- 단, Privacy 모드에서는 백그라운드 에이전트 등 일부 최신 기능을 사용할 수 없음

**팁 12: MCP(Model Context Protocol)와 도구들을 활용하자**
- **태스크 관리**: 메모리 뱅크, TaskMaster, Vooster 추천
- **브라우저 자동화**: Browserbase로 브라우저 실행, 클릭, 콘솔 읽기, 스크린샷 찍기 등
- **테스트 자동화**: PlayWright로 E2E 테스트 추가하기
- **에러 모니터링**: Sentry로 에러 모니터링하고 수정하기
- **결제 시스템**: Stripe와 Paypal로 결제하기
- **배포**: Netlify와 Heroku로 배포하기
- **보안 검사**: Snyk와 Semgrep으로 보안 검사하기
- **데이터베이스**: Supabase로 DB 테이블 읽고 쓰기

**💡 추가 팁들:**
- **Max 모드**: 요청이 아닌 토큰 기반 과금이며, 더 큰 컨텍스트와 더 많은 Tool 사용이 가능함
- **모델 추가**: 설정에서 Claude 4 Opus 등 기본으로 숨겨진 모델을 활성화할 수 있음
- **Custom API Key**: 자신의 LLM API 키를 연동하는 기능 (활용도는 낮은 편)
- **설정 동기화**: 여러 PC 간 설정 동기화는 아직 공식적으로 잘 지원되지 않음

이러한 고급 팁들을 활용하면 Cursor를 단순한 코드 에디터가 아닌, 진정한 AI 개발 파트너로 활용할 수 있습니다. 처음에는 기본 기능부터 시작하여 점전적으로 고급 기능들을 익혀나가는 것을 권장합니다.

## 8. 연습 문제 (Exercises)
1. AI 개발에서 가상 환경을 사용하는 것이 왜 중요한가요? 가상 환경을 사용하지 않았을 때 발생할 수 있는 문제점 2가지를 설명해보세요.
2. `conda`를 사용하여 `my_test_env`라는 이름의 새로운 가상 환경을 만들고, 그 환경에 `numpy`와 `pandas` 라이브러리를 설치하는 데 필요한 명령어들을 순서대로 작성해보세요.
3. 현재 활성화된 `conda` 가상 환경을 비활성화하는 명령어는 무엇인가요?
4. Jupyter Notebook과 VS Code는 각각 어떤 상황에서 사용하는 것이 더 효과적일지, 두 도구의 주요 특징과 차이점을 비교하여 설명해보세요.

---

**⬅️ 이전 시간: [인공지능의 역사](../00_introduction/part_0.1_history_of_ai.md)**
**➡️ 다음 시간: [Part 2: 파이썬 핵심 문법](../02_python_core_syntax/part_2_python_core_syntax.md)**