# Part 0: 시작하며 - AI 전문가 양성 과정

안녕하세요! "AI 전문가 양성 과정"에 오신 것을 환영합니다. 이 과정은 여러분이 AI 기술을 활용하여 세상에 가치를 더하는 서비스를 직접 만들 수 있도록 안내하는 나침반이 될 것입니다.

## 1. 학습 목표 (Learning Objectives)

본 과정을 완주하면 여러분은 다음과 같은 핵심 역량을 갖춘 'AI 서비스 개발자'로 거듭나게 됩니다.

- **탄탄한 프로그래밍 역량:** Python 기초 문법부터 [객체 지향 설계(OOP)](../../glossary.md#객체-지향-프로그래밍-object-oriented-programming-oop)까지 깊이 있게 이해하고 활용할 수 있습니다.
- **실전적인 모델링 경험:** 데이터 전처리, 모델 학습, 평가, 튜닝까지 [머신러닝](../../glossary.md#머신러닝-machine-learning) 프로젝트의 전 과정을 주도할 수 있습니다.
- **고성능 API 서버 구축 능력:** [FastAPI](../../glossary.md#fastapi)를 기반으로 안정적이고 확장 가능한 AI API 서버를 설계하고 운영할 수 있습니다.
- **최신 MLOps 및 AI 심화 지식:** [Docker](../../glossary.md#도커-docker)를 활용한 배포, MLOps, 모델 최적화, 생성형 AI, AI 윤리 등 프로덕션 레벨의 전문 지식을 습득합니다.
- **나만의 AI 포트폴리오 완성:** 자신만의 아이디어를 실제 동작하는 AI 서비스로 구현한 [캡스톤 프로젝트](../../glossary.md#캡스톤-프로젝트-capstone-project)를 통해 실력을 증명할 수 있습니다.

## 2. 핵심 요약 (Key Summary)
이 과정은 Python 프로그래밍, 머신러닝/딥러닝 모델링, FastAPI를 이용한 API 서버 구축, MLOps, 생성형 AI 등 AI 서비스 개발에 필요한 모든 기술을 다룹니다. 수강생은 탄탄한 이론과 실전 프로젝트 경험을 통해 자신만의 AI 서비스를 만들 수 있는 풀스택 AI 개발자로 성장하는 것을 목표로 합니다.

- **핵심 키워드**: `Python`, `OOP`, `NumPy`, `Pandas`, `Scikit-learn`, `PyTorch`, `Machine Learning`, `Deep Learning`, `LLM`, `RAG`, `FastAPI`, `API`, `Docker`, `MLOps`, `Model Optimization`, `Generative AI`, `AI Ethics`, `XAI`

## 3. 왜 'AI 서비스 개발'을 배워야 할까요? (Introduction)

AI 서비스를 만드는 것은 마치 **'스스로 생각하고 행동하는 기계'**를 조립하는 것과 같습니다. 처음에는 작은 부품(프로그래밍 기초)을 다루는 법부터 배우고, 점차 엔진(AI 모델)을 만들어 올리고, 마지막에는 멋진 차체(API 서버)를 씌워 실제 세상(인터넷)을 달리게 하는 것과 같죠.

단순한 '모델' 개발을 넘어 '서비스' 개발을 배우는 것은, **'레시피만 따라 요리 하나를 만드는 것'**과 **'손님들이 언제든 찾아와 주문할 수 있는 식당 주방을 설계하는 것'**의 차이와 같습니다. 우리는 후자를 목표로 합니다. 언제든 요청에 응답하고, 안정적으로 서비스를 제공하는 '프로의 시스템'을 만드는 경험을 하게 될 것입니다.

## 4. 누구를 위한 강의인가요? (Target Audience)

이 과정은 다음과 같은 분들을 위해 체계적으로 설계되었습니다.

- 프로그래밍은 처음이지만 AI 서비스를 직접 만들어보고 싶은 **입문자**
- Python 기본 문법은 알지만, 실제 프로젝트 경험이 부족한 **학생 또는 주니어 개발자**
- AI 모델은 개발했지만, 이를 어떻게 서비스로 만들어야 할지 막막한 **연구자 및 데이터 분석가**

## 5. 학습 로드맵 (Course Roadmap)

우리는 다음의 로드맵에 따라 체계적으로 학습을 진행합니다. 이 로드맵은 AI 서비스 개발이라는 보물섬을 찾아가는 **'친절한 안내 지도'**입니다. 각 주차별 목표를 따라 한 걸음씩 나아가다 보면, 어느새 유능한 AI 전문가로 성장한 자신을 발견하게 될 것입니다.

```mermaid
graph TD
    subgraph "1부: AI 개발을 위한 파이썬 마스터리 (1-5주)"
        W1["1주차: 개발 환경 설정"]
        W2["2주차: 파이썬 핵심 문법"]
        W3["3주차: 파이썬 컬렉션"]
        W4["4주차: 객체 지향 프로그래밍"]
        W5["5주차: AI 핵심 라이브러리<br/>(NumPy & Pandas)"]
    end

    subgraph "2부: 핵심 AI 모델 개발 및 서빙 (6-9주)"
        W6["6주차: 머신러닝"]
        W7["7주차: 딥러닝 & LLM<br/>- RNN, Transformer<br/>- LangChain, GNN, 강화학습"]
        W8["8주차: FastAPI 모델 서빙"]
        W9["9주차: 프로덕션 API"]
    end

    subgraph "3부: 프로덕션 MLOps 및 AI 심화 (10-14주)"
        W10["10주차: 전문가 로드맵"]
        W11["11주차: MLOps 심화"]
        W12["12주차: 모델 최적화"]
        W13["13주차: 생성형 AI와 에이전트"]
        W14["14주차: AI 윤리와 거버넌스"]
    end

    subgraph "4부: 최종 캡스톤 프로젝트 (15-16주)"
        W15["15주차: 캡스톤 프로젝트<br/>기획 및 개발"]
        W16["16주차: 캡스톤 프로젝트<br/>마무리 및 발표"]
    end

    W1 --> W2 --> W3 --> W4 --> W5 --> W6 --> W7 --> W8 --> W9 --> W10 --> W11 --> W12 --> W13 --> W14 --> W15 --> W16

    click W1 "../01_ai_development_environment/part_1_ai_development_environment.md" _blank
    click W2 "../02_python_core_syntax/part_2_python_core_syntax.md" _blank
    click W3 "../03_python_collections/part_3_python_collections.md" _blank
    click W4 "../04_object_oriented_programming/part_4_object_oriented_programming.md" _blank
    click W5 "../05_ai_core_libraries/part_5_ai_core_libraries.md" _blank
    click W6 "../06_machine_learning/part_6_machine_learning.md" _blank
    click W7 "../07_deep_learning/part_7_deep_learning.md" _blank
    click W8 "../08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md" _blank
    click W9 "../09_production_ready_api/part_9_production_ready_api.md" _blank
    click W10 "../10_expert_path/part_10_expert_path.md" _blank
    click W11 "../11_mlops/part_11_mlops.md" _blank
    click W12 "../12_model_optimization/part_12_model_optimization.md" _blank
    click W13 "../13_generative_ai/part_13_generative_ai.md" _blank
    click W14 "../14_ai_ethics/part_14_ai_ethics.md" _blank
    click W15 "../15_capstone_project/part_15_capstone_project.md" _blank
    click W16 "../15_capstone_project/part_15_capstone_project.md" _blank
```

### AI 전문가로 성장하는 16주간의 여정 (A Narrative-driven Overview)

이 과정은 단순한 지식의 나열이 아닌, 여러분이 'AI 전문가'로 성장해 나가는 하나의 완성된 이야기입니다. 전체 여정은 4개의 큰 부로 구성되어 있으며, 각 부는 여러분의 성장에 명확한 이정표를 제시합니다.

#### **1부: 단단한 기초 세우기 (1~5주)**

모든 위대한 여정은 첫걸음부터 시작됩니다. 1부에서는 AI라는 거대한 세계를 탐험하기 위한 가장 중요한 도구인 **Python 프로그래밍 언어**를 마스터합니다. 변수와 자료구조 같은 기본 개념부터, 복잡한 프로그램을 설계하는 객체 지향 프로그래밍(OOP)까지, 코드를 통해 생각을 구체화하는 훈련을 합니다. 마지막으로, 데이터의 바다에서 길을 잃지 않도록 도와주는 나침반과 지도, `Numpy`와 `Pandas` 사용법을 익혀 데이터 분석의 기초를 다집니다.

#### **2부: AI의 '두뇌' 만들기 (6~9주)**

탄탄한 기초 위에 이제 AI의 핵심인 '두뇌', 즉 모델을 만듭니다. 6주차에는 **머신러닝**의 기본 원리를 배우고, 데이터를 통해 스스로 학습하는 모델을 처음으로 만들어 봅니다. 7주차에는 인간의 뇌를 모방한 **딥러닝**의 세계로 깊이 들어가, 이미지와 텍스트를 이해하는 `CNN`, `RNN` 그리고 현대 AI의 심장인 `Transformer`의 원리를 파헤칩니다. 8-9주차에서는 이 똑똑한 두뇌를 세상과 연결하는 방법을 배웁니다. `FastAPI`를 이용해 우리가 만든 AI 모델을 누구나 사용할 수 있는 빠르고 안정적인 **API 서비스**로 만들어냅니다.

#### **3부: '프로'의 시스템 구축하기 (10~14주)**

이제 여러분은 작동하는 AI 서비스를 만들 수 있습니다. 하지만 '프로'의 세계는 그 이상을 요구합니다. 3부에서는 여러분의 서비스를 '아마추어의 작품'에서 **'프로덕션 레벨의 시스템'**으로 격상시키는 방법을 배웁니다. `Docker`를 활용한 배포 자동화, `MLOps`를 통한 지속적인 모델 관리, 더 빠른 서비스를 위한 **모델 최적화** 기법을 익힙니다. 또한, `ChatGPT`와 같은 **생성형 AI**와 **AI 에이전트**의 최신 트렌드를 학습하고, 기술의 윤리적 사용을 고민하는 **AI 윤리**까지 다루며 기술적 깊이와 책임감을 겸비한 전문가로 거듭납니다.

#### **4부: 나만의 AI 서비스로 증명하기 (15~16주)**

대장정의 마지막입니다. 4부에서는 지금까지 배운 모든 지식과 기술을 총동원하여 **자신만의 아이디어를 실제 동작하는 AI 서비스로 구현**하는 **캡스톤 프로젝트**를 진행합니다. 이 프로젝트는 여러분의 실력을 증명하는 최고의 포트폴리오이자, AI 서비스 개발자로서의 커리어를 시작하는 발판이 될 것입니다.

## 6. 미래를 향한 한 걸음: AI 에이전트 (The Future of AI)

최근 AI 분야의 가장 뜨거운 화두는 바로 **'AI 에이전트'**입니다. 스탠포드 대학의 앤드류 응(Andrew Ng) 교수는 AI의 미래가 에이전트에 달려있다고 강조합니다.

> **💡 AI 에이전트란?**
>
> 단순히 주어진 질문에 한 번 답하고 끝나는 것이 아니라, 목표를 달성하기 위해 **스스로 계획을 세우고, 도구를 사용하며, 스스로 피드백하고 수정하는 과정을 반복**하는 지능형 시스템을 말합니다.
>
> 이는 마치 우리가 복잡한 문제를 해결하기 위해 여러 번 생각하고, 자료를 찾아보고, 계획을 수정하는 과정과 유사합니다. 이러한 **에이전틱 워크플로우(Agentic Workflow)**는 기존 모델보다 훨씬 더 뛰어난 문제 해결 능력을 보여줍니다.
>
> (참고: [Agents: The Future of AI, Explained by Dr. Andrew Ng](https://medium.com/@honeyricky1m3/agents-the-future-of-ai-explained-by-dr-andrew-ng-9be4675a6079))

본 과정의 후반부에서는 이러한 최신 트렌드를 맛보고, 여러분이 만든 AI 모델을 어떻게 더 똑똑한 '에이전트'로 발전시킬 수 있을지에 대한 아이디어를 얻게 될 것입니다.

## 7. 자주 묻는 질문 (Q&A)

**Q1: 정말 프로그래밍을 하나도 몰라도 따라갈 수 있나요?**
> A1: 네, 가능합니다. 본 과정의 1부(1-5주차)는 비전공자 및 입문자를 위해 파이썬 기초를 매우 상세하게 다룹니다. 열정과 꾸준함만 있다면 누구나 과정을 완주할 수 있습니다.

**Q2: 과정에서 사용하는 주요 기술은 무엇인가요?**
> A2: <a href="../../glossary.md#python-파이썬">Python</a>, <a href="./glossary.md#numpy-넘파이">NumPy</a>, <a href="../../glossary.md#pandas-판다스">Pandas</a>, <a href="../../glossary.md#scikit-learn-사이킷런">Scikit-learn</a>, <a href="../../glossary.md#fastapi-패스트에이피아이">FastAPI</a>, <a href="../../glossary.md#도커-docker">Docker</a> 등 현재 AI 서비스 개발 현업에서 가장 널리 사용되는 기술 스택을 중심으로 학습합니다.

**Q3: 개인 노트북 사양이 많이 좋아야 하나요?**
> A3: 기본적인 코딩은 일반적인 노트북으로 충분합니다. 모델 학습 등 높은 사양이 필요한 경우, 무료로 사용할 수 있는 <a href="../../glossary.md#google-colab-구글-코랩">Google Colab</a>을 활용하는 방법을 안내해 드리므로 걱정하지 않으셔도 됩니다.

**Q4: 캡스톤 프로젝트는 어떻게 진행되나요?**
> A4: 과정의 마지막 15-16주차에 진행되며, 수강생들이 직접 주제를 선정하고 기획, 개발, 발표까지 진행합니다. 이 과정에서 멘토링을 통해 프로젝트가 올바른 방향으로 나아갈 수 있도록 적극적으로 지원합니다. 자세한 내용은 <a href="../15_capstone_project/part_15_capstone_project.md">캡스톤 프로젝트 가이드</a>를 참고하세요.

---

## 8. 여정을 시작하며 (Next Steps)

자, 이제 16주간의 여정을 시작할 준비가 되셨나요?
다음 시간에는 본격적인 개발을 위해 여러분의 컴퓨터에 개발 환경을 설정하는 방법을 알아보겠습니다.

**➡️ 다음 읽을거리: [AI의 역사와 발전 과정 알아보기](./part_0.1_history_of_ai.md)**
**➡️ 다음 시간: [Part 1: AI 개발 환경 준비](../01_ai_development_environment/part_1_ai_development_environment.md)** 