---
marp: true
theme: gaia
class:
  - lead
  - invert
---

<!-- _class: lead -->
<!-- _header: "" -->
<!-- _footer: "" -->

<style>
h1 {
    font-size: 2.5em;
    font-weight: 600;
}
h2 {
    font-size: 2em;
    font-weight: 600;
}
h3 {
    font-size: 1.6em;
    font-weight: 600;
}
h4 {
    font-size: 1.3em;
    font-weight: 600;
}
h5 {
    font-size: 1.1em;
    font-weight: 600;
}
h6 {
    font-size: 1em;
    font-weight: 600;
}
p, li, ul, ol, table {
    font-size: 28px;
}
pre, code {
    font-size: 24px;
}
</style>

# Part 0.1: AI의 역사와 주요 이정표

## 서론: 생각하는 기계라는 오랜 꿈

인류는 고대부터 스스로 생각하는 기계를 꿈꿔왔습니다. 이러한 오랜 야망은 신화나 소설 속에서 지능을 가진 존재를 상상하고, 때로는 체스 두는 기계와 같은 실제 장치를 만들려는 역사적 시도로 나타났습니다. 20세기 중반, 이 꿈은 '인공지능'이라는 학문 분야로 구체화되었고, 수많은 부침(浮沈)을 거치며 오늘날 우리 삶을 바꾸는 핵심 기술로 자리 잡았습니다. 이 문서는 단순한 연대기 나열을 넘어, 주요 개념들이 어떻게 탄생하고 서로 영향을 주며 현재의 딥러닝과 생성 AI 시대로 이어졌는지 그 진화의 과정을 추적합니다.

## 1. 인공지능의 태동과 황금기 (1940년대 ~ 1960년대)

### 신경망의 첫 아이디어와 지능에 대한 질문

- **1943년, 신경망의 기원:** 신경과학자 워렌 맥컬록과 수학자 월터 피츠는 뇌의 뉴런이 작동하는 방식을 본뜬 간단한 수학 모델을 제안합니다. 이 모델은 '참' 또는 '거짓' 신호를 처리하는 논리 회로로, 비록 단순했지만 뇌를 계산 기계로 볼 수 있다는 가능성을 제시했습니다. 이는 훗날 **연결주의(Connectionism)** 라는 AI의 큰 흐름, 즉 수많은 단순한 처리 장치들의 연결로 지능을 구현하려는 시도의 씨앗이 됩니다.

<p align="center">
  <img src="../../assets/history_of_ai/mcculloch_pitts_neuron.png" alt="McCulloch-Pitts Neuron Model" width="500"/>
  <br>
  <em>맥컬록-피츠 뉴런 모델: 뇌의 뉴런을 단순한 논리 회로로 표현한 초기 인공 신경망의 개념도입니다.</em>
</p>

- **1950년, 튜링 테스트:** "기계가 생각할 수 있는가?" 앨런 튜링은 이 철학적인 질문에 답하기 위해 '이미테이션 게임', 즉 **튜링 테스트**를 제안합니다. 이는 AI의 지능을 인간과 얼마나 구별하기 어려운지로 평가하는 실용적인 기준을 제시했으며, AI가 나아가야 할 목표와 철학적 기반을 제공했습니다.

<p align="center">
  <img src="../../assets/history_of_ai/turing_test.png" alt="Turing Test" width="600"/>
  <br>
  <em>튜링 테스트 개념도: 심문자가 인간과 기계의 답변을 보고 누가 기계인지 판별할 수 없다면, 그 기계는 지능을 가졌다고 할 수 있습니다.</em>
</p>

### '인공지능'의 탄생과 폭발적인 낙관론

- **1956년, 다트머스 워크숍:** 존 매카시가 '인공지능(Artificial Intelligence)'이라는 용어를 처음 사용하며 역사적인 워크숍을 개최합니다. 이 사건은 AI를 공식적인 학문 분야로 만들었으며, 초기 AI 연구는 인간의 논리적 사고 과정을 컴퓨터로 재현하려는 **기호주의(Symbolic AI)** 에 집중되었습니다.

- **초기 성공과 낙관론:** 이 시기에는 Lisp(AI 연구의 표준 언어), 최초의 인공 신경망 SNARC, 그리고 패턴을 학습할 수 있었던 프랭크 로젠블랫의 **퍼셉트론(Perceptron, 1957)** 과 같은 성과들이 쏟아졌습니다. 특히 퍼셉트론은 신경망의 가능성을 보여주며 큰 기대를 모았고, 당시 연구자들은 10년 안에 인간 수준의 AI가 등장할 것이라 낙관했습니다.

<p align="center">
  <img src="../../assets/history_of_ai/perceptron.png" alt="Perceptron Model" width="500"/>
  <br>
  <em>프랭크 로젠블랫의 퍼셉트론: 입력 값에 가중치를 곱하고 합산하여 특정 임계값을 넘으면 1, 아니면 0을 출력하는 단순한 분류기입니다.</em>
</p>

## 2. 첫 번째 AI 겨울과 새로운 패러다임의 모색 (1970년대 ~ 1980년대)

### 퍼셉트론의 한계와 AI의 겨울

- **1969년, 퍼셉트론의 한계 증명:** AI의 선구자였던 마빈 민스키와 시모어 페퍼트는 저서 『퍼셉트론』에서 단층 퍼셉트론이 XOR와 같은 간단한 논리 문제조차 풀 수 없음을 수학적으로 증명했습니다. 이 연구는 당시 신경망 연구에 치명타를 날렸고, AI에 대한 과장된 약속에 실망한 정부와 기업들이 연구 자금을 대거 철회하면서 **첫 번째 AI 겨울(AI Winter)** 이 시작되었습니다.

<p align="center">
  <img src="../../assets/history_of_ai/gartner_hype_cycle.png" alt="First AI Winter" width="600"/>
  <br>
  <em>첫 번째 AI 겨울: 가트너 하이프 사이클의 '환멸의 계곡'은 AI 겨울처럼 기술에 대한 기대가 꺾이고 투자가 줄어드는 시기를 상징적으로 보여줍니다.</em>
</p>

- **기호주의의 한계:** 한편, 주류였던 기호주의 AI 역시 현실 세계의 복잡하고 애매모호한 문제들을 처리하는 데 어려움을 겪으며 한계에 부딪혔습니다.

### 전문가 시스템과 머신러닝의 등장

- **1980년대, 전문가 시스템(Expert System):** AI 연구는 '인간처럼 생각하는 기계' 대신, 특정 분야의 전문가 지식을 규칙 기반으로 저장해 문제를 해결하는 실용적인 '전문가 시스템'으로 방향을 전환합니다. 이는 AI가 처음으로 상업적 성공을 거두는 계기가 되었습니다.

<p align="center">
  <img src="../../assets/history_of_ai/expert_system.png" alt="Expert System Architecture" width="600"/>
  <br>
  <em>전문가 시스템의 구조: 전문가의 지식을 '지식 베이스'에 저장하고, '추론 엔진'을 통해 사용자의 질문에 답하는 방식입니다.</em>
</p>

- **1959년, '머신러닝'의 탄생:** 아서 사무엘은 스스로 체커 게임을 하면서 학습하여 실력을 향상시키는 프로그램을 개발하고, 여기에 **'머신러닝(Machine Learning)'** 이라는 이름을 붙였습니다. 데이터를 기반으로 컴퓨터가 명시적인 프로그래밍 없이 스스로 학습하는 이 개념은, 모든 규칙을 인간이 직접 입력해야 하는 기호주의 AI와 근본적으로 다른 패러다임이었습니다. 이 아이디어는 수십 년 후 AI의 주류가 됩니다.

## 3. 연결주의의 부활과 데이터 기반 접근법의 확립 (1980년대 후반 ~ 2000년대)

### 역전파 알고리즘과 연결주의의 부활

- **1986년, 역전파 알고리즘:** 제프리 힌튼을 비롯한 연구자들이 다층 신경망을 효과적으로 훈련시킬 수 있는 **역전파(Backpropagation) 알고리즘**을 대중화시켰습니다. 이는 '퍼셉트론'이 제기했던 한계를 정면으로 돌파하는 혁신이었고, 신경망 연구의 부활을 이끌었습니다. 비록 당시의 컴퓨팅 파워로는 깊은 신경망을 훈련시키기 어려웠지만, 이 알고리즘은 훗날 **딥러닝 혁명의 핵심 엔진**이 됩니다.

<p align="center">
  <img src="../../assets/history_of_ai/backpropagation.png" alt="Backpropagation Concept" width="600"/>
  <br>
  <em>역전파 알고리즘 개념도: 출력층의 오류를 입력층 방향으로 거꾸로 전파하며 각 연결의 가중치를 조정하여 신경망을 학습시킵니다.</em>
</p>

### 두 번째 AI 겨울과 통계적 머신러닝의 시대

- **1990년대, 두 번째 AI 겨울:** 80년대의 반짝 부흥을 이끌었던 전문가 시스템은 지식 추가 및 유지보수의 어려움 등으로 인해 다시 한계를 드러냈고, AI 시장은 또다시 침체기를 맞습니다.

- **데이터 기반 접근법의 승리:** 이 침체기 동안 AI 연구의 패러다임은 규칙 기반의 기호주의에서 **데이터 기반의 통계적 머신러닝**으로 완전히 전환되었습니다. 서포트 벡터 머신(SVM), 결정 트리 등 강력하고 수학적 기반이 탄탄한 알고리즘들이 주목받았고, AI는 더 과학적이고 실용적인 학문으로 발전했습니다.

- **1997년, 딥블루의 승리:** IBM의 체스 컴퓨터 '딥블루'가 세계 챔피언 가리 카스파로프를 꺾은 사건은 AI의 역사에서 중요한 이정표입니다. 딥블루는 머신러닝보다는 엄청난 계산 능력과 탐색 알고리즘에 의존했지만, 이 사건은 AI가 인간의 지능을 특정 영역에서 넘어설 수 있음을 대중에게 각인시켰습니다.

<p align="center">
  <img src="../../assets/history_of_ai/deep_blue_kasparov.jpg" alt="Deep Blue vs Garry Kasparov" width="600"/>
  <br>
  <em>1997년, IBM의 슈퍼컴퓨터 딥블루와 체스 챔피언 가리 카스파로프의 역사적인 대결 모습입니다.</em>
</p>

## 4. 딥러닝 혁명과 생성 AI의 시대 (2010년대 ~ 현재)

2010년대에 들어, 수십 년간 축적된 AI 연구는 세 가지 거대한 변화와 만나 폭발적인 '혁명'을 일으킵니다.

<p align="center">
  <img src="../../assets/history_of_ai/deep_learning_revolution.png" alt="Deep Learning Revolution Trifecta" width="700"/>
  <br>
  <em>딥러닝 혁명의 3요소: 빅데이터, GPU를 통한 하드웨어 발전, 그리고 성숙한 알고리즘의 결합이 딥러닝의 폭발적인 성장을 이끌었습니다.</em>
</p>

1.  **빅데이터(Big Data):** 인터넷의 발달로 ImageNet과 같은 대규모의 정제된 데이터셋이 등장했습니다.
2.  **하드웨어의 발전(Hardware):** 게임 산업을 위해 개발된 **GPU**가 신경망의 병렬 연산에 최적이라는 사실이 발견되면서, 이전에는 불가능했던 규모의 모델 훈련이 가능해졌습니다.
3.  **알고리즘의 성숙(Algorithms):** 1980년대에 등장했던 **역전파 알고리즘**이 마침내 빛을 발하기 시작했습니다.

### 딥러닝의 충격과 전성기

- **2012년, AlexNet의 등장:** 제프리 힌튼과 그의 제자들이 개발한 심층 합성곱 신경망(Deep CNN)인 **AlexNet**이 이미지 인식 대회(ILSVRC)에서 압도적인 성능으로 우승합니다. 이 사건은 딥러닝(Deep Learning)의 잠재력을 전 세계에 증명했으며, 이후 AI 연구의 모든 패러다임을 딥러닝 중심으로 바꾸어 놓았습니다.

<p align="center">
  <img src="../../assets/history_of_ai/alexnet.png" alt="AlexNet Architecture" width="600"/>
  <br>
  <em>AlexNet의 구조: 합성곱 신경망(CNN)을 깊게 쌓아 이미지 인식에서 획기적인 성능을 보인 딥러닝 모델입니다.</em>
</p>

- **2016년, 알파고 쇼크:** 구글 딥마인드의 **알파고**는 딥러닝과 강화학습을 결합하여, 인간의 직관과 창의성의 영역으로 여겨졌던 바둑에서 세계 최고 기사 이세돌을 꺾었습니다. 이는 AI가 복잡한 전략적 사고까지 가능하다는 것을 보여준 충격적인 사건이었습니다.

<p align="center">
  <img src="../../assets/history_of_ai/alphago_lee_sedol.jpg" alt="AlphaGo vs Lee Sedol" width="600"/>
  <br>
  <em>2016년, 구글 딥마인드의 알파고와 이세돌 9단의 대국은 전 세계에 AI의 충격을 안겨주었습니다.</em>
</p>

### 거대 언어 모델과 생성 AI

- **2017년, 트랜스포머의 등장:** 구글 연구진이 발표한 "Attention Is All You Need" 논문에서 제시된 **트랜스포머(Transformer)** 아키텍처는 자연어 처리 분야에 혁명을 일으켰습니다. 순차적인 처리에 의존했던 기존 모델(RNN, LSTM)의 한계를 극복한 트랜스포머는 **GPT, BERT**와 같은 **거대 언어 모델(LLM)**의 기반이 되었습니다.

<p align="center">
  <img src="../../assets/history_of_ai/transformer_architecture.png" alt="Transformer Architecture" width="600"/>
  <br>
  <em>"Attention Is All You Need" 논문에 제시된 트랜스포머 모델의 아키텍처. 이 구조는 현대 거대 언어 모델의 근간이 되었습니다.</em>
</p>

- **2020년대, 생성 AI의 부상:** OpenAI의 **GPT-3, DALL-E**를 시작으로, AI는 이제 주어진 데이터를 분석하고 예측하는 것을 넘어, 인간처럼 글을 쓰고, 그림을 그리고, 코드를 작성하고, 음악을 만드는 **생성(Generative) AI**의 시대로 접어들었습니다. 이는 AI가 단순한 도구를 넘어 창의적인 파트너가 될 수 있는 가능성을 열었습니다.

<p align="center">
  <img src="../../assets/history_of_ai/generative_ai_examples.png" alt="Generative AI Examples" width="700"/>
  <br>
  <em>생성 AI의 시대: DALL-E가 생성한 이미지, GPT가 작성한 글 등 AI가 만들어내는 창의적인 결과물들.</em>
</p>

## 결론: 계속되는 진화

인공지능의 역사는 낙관과 절망, 경쟁과 협력이 교차하는 거대한 서사시입니다. 뇌를 모방하려던 작은 아이디어에서 시작해, 두 번의 겨울을 거치며 패러다임을 전환했고, 마침내 데이터와 컴퓨팅 파워를 만나 딥러닝 혁명을 이루었습니다. 현재 우리는 AI가 인간의 지능과 창의성을 어떻게 확장시킬 수 있는지 목격하는 새로운 시대의 출발점에 서 있습니다.

---
*이 문서는 [IBM의 AI 역사](https://www.ibm.com/think/topics/history-of-artificial-intelligence) 등 여러 AI 역사 관련 자료를 참고하여 개념의 흐름을 중심으로 재구성되었습니다.*

---

**⬅️ 이전 시간: [Part 0: 시작하며 - AI 전문가 양성 과정](./part_0_introduction.md)**
**➡️ 다음 시간: [Part 1: AI 개발 환경 준비](../01_ai_development_environment/part_1_ai_development_environment.md)** 