# 🧰 주요 AI 개발 도구 및 프레임워크 비교 분석

이 문서는 AI 프로젝트 개발 과정에서 마주하게 되는 주요 도구와 프레임워크들의 특징을 비교하고, 기술 선택에 도움이 되는 가이드라인을 제공하기 위해 작성되었습니다.

---

## 1. Deep Learning Frameworks: `TensorFlow` vs. `PyTorch`

TensorFlow와 PyTorch는 현재 딥러NING 모델 개발의 양대 산맥을 이루는 가장 중요한 프레임워크입니다. 두 도구 모두 강력한 기능과 방대한 커뮤니티를 자랑하지만, 설계 철학과 강점에서 차이를 보입니다.

| 구분 항목 | TensorFlow (Google) | PyTorch (Meta) |
| :--- | :--- | :--- |
| **핵심 철학** | "Define-and-Run" (정적 계산 그래프) | "Define-by-Run" (동적 계산 그래프) |
| **API 스타일** | Keras를 통한 고수준 API의 강력한 추상화 | Pythonic하고 직관적인 저수준 API |
| **그래프 모델** | **정적 그래프 (Static Graph)**: 먼저 전체 모델의 계산 그래프를 정의하고, 세션(Session)을 통해 데이터를 주입하여 실행. 최적화에 유리. | **동적 그래프 (Dynamic Graph)**: 코드가 실행되는 시점에 그래프가 생성. 유연하고 디버깅이 쉬움. |
| **사용 편의성** | Keras 통합 이후 매우 쉬워졌으나, 저수준 API는 다소 복잡. | NumPy와 유사한 구조로 Python 개발자에게 매우 친숙하고 직관적. |
| **디버깅** | `tf.print` 또는 별도 디버거 필요. 정적 그래프 특성상 디버깅이 상대적으로 까다로움. | 표준 Python 디버깅 도구(e.g., `pdb`)를 그대로 사용 가능하여 매우 편리함. |
| **생태계** | **TensorFlow Extended (TFX)**를 중심으로 한 강력한 프로덕션 및 배포 생태계 (TensorFlow Serving, TensorFlow Lite 등) | 학계 및 연구 커뮤니티에서 압도적인 지지를 받으며, 최신 논문 구현체가 빠르게 공유됨. (Hugging Face 등) |
| **배포** | 모바일, 엣지, 서버 등 다양한 환경에 모델을 배포하기 위한 **TensorFlow Serving**, **TF Lite** 등 성숙한 솔루션 보유. | **TorchServe**, **ONNX** 등을 통해 배포를 지원하지만, 과거에는 TensorFlow 대비 약점으로 꼽혔음. 최근 빠르게 발전 중. |
| **시각화** | **TensorBoard**: 강력하고 상세한 모델 분석 및 시각화 기능 기본 제공. | TensorBoard를 함께 사용할 수 있으나, 내장 솔루션은 상대적으로 기능이 적음. |
| **커뮤니티** | 대기업 중심의 강력한 지원과 방대한 사용자 기반 보유. | 연구자 및 학계 커뮤니티가 매우 활발하며, 최신 기술 트렌드를 주도. |

### 선택 가이드 (When to use what?)

-   **`TensorFlow`를 선택하는 경우:**
    -   **프로덕션 환경에 바로 배포**해야 하는 상용 서비스를 개발할 때. (특히 모바일/엣지 디바이스 포함)
    -   **확장성**과 **분산 학습** 성능이 매우 중요한 대규모 프로젝트를 진행할 때.
    -   TFX(TensorFlow Extended)를 활용하여 데이터 전처리부터 모델 서빙까지 **End-to-End MLOps 파이프라인**을 구축하고자 할 때.

-   **`PyTorch`를 선택하는 경우:**
    -   **최신 연구 논문을 빠르게 구현**하고 실험해야 하는 연구/개발 환경일 때.
    -   **유연한 모델 구조**와 **직관적인 디버깅**이 중요한 프로토타이핑 단계일 때.
    -   Python 코드처럼 간결하고 직관적인 개발 경험을 선호할 때.

**결론:** "연구는 PyTorch, 프로덕션은 TensorFlow"라는 말은 이제 옛말이 되었습니다. PyTorch가 프로덕션 지원을 강화하고 TensorFlow가 Keras와 Eager Execution으로 유연성을 확보하면서 두 프레임워크는 서로의 장점을 흡수하며 발전하고 있습니다. 그럼에도 불구하고, **빠른 실험과 연구에는 `PyTorch`가, 강력하고 성숙한 배포 생태계가 필요할 때는 `TensorFlow`가 여전히 약간의 우위**를 가지고 있다고 볼 수 있습니다. 프로젝트의 목적과 팀의 숙련도에 따라 적절한 도구를 선택하는 것이 중요합니다.

---

## 2. Experiment Tracking & MLOps: `MLflow` vs. `Weights & Biases (W&B)`

머신러닝 모델 개발은 수많은 실험의 연속입니다. 어떤 파라미터, 데이터셋, 코드로 어떤 결과가 나왔는지 체계적으로 기록하고 관리하는 것은 재현성 확보와 협업에 필수적입니다. MLflow와 W&B는 이러한 '실험 관리'를 위한 대표적인 MLOps 도구입니다.

| 구분 항목 | MLflow (Databricks, Open-source) | Weights & Biases (W&B, Commercial) |
| :--- | :--- | :--- |
| **핵심 철학** | **개방형 MLOps 플랫폼**: 실험 트래킹, 모델 관리, 배포 등 MLOps 라이프사이클 전반을 포괄하는 모듈형 오픈소스. | **개발자 우선의 실험 관리 도구**: 아름답고 강력한 UI/UX를 통해 실험 과정을 시각화하고 협업하는 것에 집중. |
| **주요 기능** | **Tracking**: 파라미터, 메트릭, 아티팩트 로깅<br>**Projects**: 코드 환경 재현<br>**Models**: 모델 저장 및 버전 관리<br>**Registry**: 중앙 모델 레지스트리 | **Experiments**: 자동 로깅, 실시간 시각화<br>**Sweeps**: 하이퍼파라미터 튜닝<br>**Artifacts**: 데이터셋/모델 버전 관리<br>**Reports**: 분석 내용 공유 및 협업 |
| **UI 및 사용성** | 기능적이지만 다소 투박한 기본 UI. | 매우 세련되고 직관적이며, 커스터마이징 가능한 대시보드 제공. 사용자 경험이 뛰어남. |
| **설치 및 호스팅** | **완전한 오픈소스**: 로컬, 자체 서버, Databricks 등 원하는 환경에 자유롭게 설치 및 운영 가능. | **SaaS가 기본**: W&B 클라우드에 데이터를 저장. Self-hosting 옵션은 엔터프라이즈 플랜에서 제공. |
| **시각화** | 기본적인 그래프 및 비교 기능 제공. | 매우 강력하고 인터랙티브한 시각화 기능 제공. 여러 실험 결과를 비교하고 분석하는 데 탁월함. |
| **협업 기능** | 모델 레지스트리를 통한 협업에 중점. | 프로젝트, 팀, 리포트 기능을 통해 여러 개발자가 실험 결과를 공유하고 논의하기에 매우 용이함. |
| **비용** | **무료 (오픈소스)**. 단, 자체 서버 운영 시 인프라 비용 발생. | 개인 및 학술용은 무료. 팀/기업용은 유료 구독 모델 (사용자 수, 기능에 따라 차등) |

### 선택 가이드 (When to use what?)

-   **`MLflow`를 선택하는 경우:**
    -   **오픈소스 기반**으로 모든 것을 직접 구축하고 제어하고 싶을 때.
    -   **특정 클라우드나 기술 스택에 종속되지 않는** 유연한 솔루션을 원할 때.
    -   이미 Databricks 생태계를 사용하고 있거나, 실험 추적을 넘어 **모델 서빙까지 포괄하는 End-to-End 파이프라인**을 하나의 프레임워크로 관리하고 싶을 때.
    -   비용에 민감하여 **무료 솔루션**이 필요할 때.

-   **`Weights & Biases (W&B)`를 선택하는 경우:**
    -   **최고 수준의 사용자 경험과 시각화**를 통해 실험 과정을 분석하고 인사이트를 얻고 싶을 때.
    -   **팀원들과의 협업**이 매우 중요하고, 실험 결과를 쉽게 공유하고 논의할 필요가 있을 때.
    -   **하이퍼파라미터 스윕(Sweep)** 기능을 적극적으로 활용하여 모델을 최적화하고 싶을 때.
    -   인프라 관리에 드는 노력을 최소화하고, **SaaS 형태로 빠르게 시작**하고 싶을 때.

**결론:** `MLflow`는 **유연성과 확장성을 갖춘 개방형 플랫폼**을 지향하며, MLOps의 전체 사이클을 커버하려는 큰 그림을 가지고 있습니다. 반면 `W&B`는 **실험 추적과 시각화, 협업이라는 특정 문제에 깊게 파고들어 매우 완성도 높은 사용자 경험을 제공**하는 데 집중합니다. **'직접 구축하는 자유도'가 중요하다면 `MLflow`**를, **'최고의 실험 관리 경험과 협업'이 중요하다면 `W&B`**가 매력적인 선택지가 될 것입니다.

---

## 3. Containerization & Orchestration: `Docker` vs. `Kubernetes` for ML

"제 컴퓨터에서는 잘 되는데요?" 라는 말은 AI/ML 프로젝트에서 가장 피해야 할 상황 중 하나입니다. Docker와 Kubernetes는 개발 환경의 일관성을 보장하고, 학습 및 서빙 환경을 안정적으로 운영하기 위한 핵심 기술입니다. 둘은 경쟁 관계가 아닌, 함께 사용될 때 강력한 시너지를 내는 상호 보완적인 관계입니다.

| 구분 항목 | Docker | Kubernetes (k8s) |
| :--- | :--- | :--- |
| **핵심 역할** | **컨테이너화 (Containerization)** | **컨테이너 오케스트레이션 (Orchestration)** |
| **개념** | 애플리케이션과 그 종속성(라이브러리, 코드 등)을 **'컨테이너'라는 격리된 표준 단위로 패키징**하는 기술. | 수많은 컨테이너들을 **클러스터 환경에서 자동으로 배포, 확장, 관리**하는 시스템. |
| **주요 기능** | - `Dockerfile`을 통한 이미지 빌드<br>- 컨테이너 생성, 실행, 중지<br>- Docker Hub를 통한 이미지 공유 | - 자동화된 롤아웃과 롤백<br>- 서비스 디스커버리 및 로드 밸런싱<br>- 스토리지 오케스트레이션<br>- 자동화된 복구(Self-healing) |
| **관리 단위** | **개별 컨테이너 (Individual Containers)** | **컨테이너의 집합 (Pods, Deployments, Services)** |
| **사용 목적** | **Build & Ship**: 개발 환경을 코드처럼 관리하고, 어떤 환경에서든 동일하게 실행되도록 보장. | **Run & Scale**: 여러 서버에 걸쳐 컨테이너화된 애플리케이션을 안정적으로 운영하고, 트래픽에 따라 동적으로 확장. |
| **복잡성** | 상대적으로 배우기 쉽고, CLI 명령어가 직관적임. | 개념이 많고(Pod, Service, Ingress 등) 설정이 복잡하여 학습 곡선이 가파름. |
| **ML/AI 활용** | - **재현 가능한 연구 환경**: `requirements.txt`, CUDA 드라이버 등 복잡한 의존성을 Docker 이미지 하나로 관리.<br>- **모델 서빙 API 패키징**: 학습된 모델과 FastAPI/Flask 앱을 함께 패키징. | - **분산 학습**: 여러 노드에 학습 작업을 분산시켜 대규모 모델 학습.<br>- **모델 서빙**: 수백/수천 개의 모델 서빙 API 컨테이너를 무중단으로 운영 및 확장.<br>- **ML 파이프라인 자동화**: Kubeflow, Argo와 같은 도구를 통해 k8s 위에서 전체 ML 파이프라인을 구축. |

### Docker와 Kubernetes는 어떻게 함께 사용되나요?

1.  **개발 (Docker)**: 개발자는 자신의 로컬 머신에서 `Dockerfile`을 작성하여, Python 버전, CUDA 버전, 라이브러리 등이 모두 포함된 **ML 개발 환경 이미지**를 만듭니다.
2.  **패키징 (Docker)**: 학습이 완료된 모델과 예측을 수행하는 API 서버 코드를 **하나의 Docker 이미지로 패키징**합니다.
3.  **배포 (Kubernetes)**: 운영팀은 이 Docker 이미지를 **Kubernetes 클러스터에 배포**합니다. Kubernetes는 사용자 요청에 따라 이 이미지를 여러 서버에 자동으로 분산시키고, 트래픽을 분산(로드 밸런싱)합니다.
4.  **운영 및 확장 (Kubernetes)**: 특정 모델에 대한 요청이 급증하면, Kubernetes는 해당 모델의 컨테이너 수를 **자동으로 늘려(Auto-scaling)** 안정적인 서비스를 보장합니다. 특정 서버에 장애가 발생하면, 다른 서버에 컨테이너를 **자동으로 다시 시작(Self-healing)** 시켜 서비스 중단을 방지합니다.

### 선택 가이드 (When to use what?)

-   **`Docker`만으로 충분한 경우:**
    -   개인 연구자나 소규모 팀이 **개발 환경의 일관성**을 맞추고 싶을 때.
    -   모델을 **단일 서버**에 배포하여 소규모 트래픽을 처리하는 경우.
    -   복잡한 온라인 서빙보다는, 배치(Batch) 예측 작업을 컨테이너화하여 실행하는 경우.

-   **`Kubernetes`까지 필요한 경우:**
    -   **여러 서버(노드)에 걸쳐 대규모 분산 학습**을 수행해야 할 때.
    -   **높은 가용성(High Availability)**과 **무중단 배포**가 필수적인 프로덕션 환경에서 모델을 서빙할 때.
    -   **수십, 수백 개 이상의 다양한 모델**을 동시에 서비스하고 관리해야 할 때 (Multi-tenant serving).
    -   **Kubeflow, Argo Workflows** 등 Kubernetes 네이티브 MLOps 도구를 활용하여 전체 머신러닝 파이프라인을 자동화하고 싶을 때.

**결론:** `Docker`는 **'어디서든 동일하게 실행되는 환경'**을 만드는 **'포장 기술'**이고, `Kubernetes`는 이렇게 포장된 수많은 박스들을 **'자동으로 관리하고 지휘하는 거대한 물류 시스템'**과 같습니다. 대부분의 ML 프로젝트는 `Docker`로 시작하여 개발 및 실험의 재현성을 확보하고, 프로젝트가 성숙하여 **'확장성'과 '안정성'** 이라는 프로덕션 요구사항에 직면했을 때 `Kubernetes`를 도입하게 됩니다. 