# AI 전문가 양성 과정 - 개발 환경 설정 가이드

이 문서는 AI 전문가 양성 과정을 위한 현대적인 개발 환경 설정 방법을 안내합니다.

## 🚀 빠른 시작

### 방법 1: Poetry 사용 (권장)

Poetry는 현대적인 Python 의존성 관리 도구입니다. 프로젝트별 가상환경과 의존성을 자동으로 관리해줍니다.

#### 1. Poetry 설치

**Windows (PowerShell):**
```powershell
(Invoke-WebRequest -Uri https://install.python-poetry.org -UseBasicParsing).Content | py -
```

**macOS/Linux:**
```bash
curl -sSL https://install.python-poetry.org | python3 -
```

#### 2. 프로젝트 설정

```bash
# 프로젝트 디렉토리로 이동
cd "ai lecture"

# 의존성 설치 (가상환경 자동 생성)
poetry install

# 가상환경 활성화
poetry shell

# Jupyter Lab 실행
poetry run jupyter lab
```

### 방법 2: 기존 pip 사용

기존 방식을 선호하시는 경우:

```bash
# 가상환경 생성
python -m venv venv

# 가상환경 활성화
# Windows:
venv\Scripts\activate
# macOS/Linux:
source venv/bin/activate

# 의존성 설치
pip install -r requirements.txt

# Jupyter Lab 실행
jupyter lab
```

## 🛠️ 개발 도구 사용법

### 코드 포매팅 (Black)

```bash
# 전체 코드 포매팅
poetry run black .

# 특정 파일 포매팅
poetry run black source_code/05_ai_core_libraries/
```

### 코드 린팅 (Ruff)

```bash
# 코드 품질 검사
poetry run ruff check .

# 자동 수정 가능한 문제 해결
poetry run ruff check --fix .
```

### 타입 검사 (MyPy)

```bash
# 타입 힌트 검사
poetry run mypy source_code --ignore-missing-imports
```

### 테스트 실행

```bash
# 모든 테스트 실행
poetry run pytest

# 커버리지와 함께 테스트 실행
poetry run pytest --cov=source_code --cov-report=html
```

## 📚 Jupyter Notebook 사용법

### JupyterLab 시작

```bash
# Poetry 환경에서
poetry run jupyter lab

# 또는 가상환경 활성화 후
jupyter lab
```

### 주요 단축키

- `Shift + Enter`: 셀 실행 후 다음 셀로 이동
- `Ctrl + Enter`: 셀 실행 (현재 셀 유지)
- `A`: 위에 새 셀 추가
- `B`: 아래에 새 셀 추가
- `M`: 마크다운 셀로 변경
- `Y`: 코드 셀로 변경
- `DD`: 셀 삭제

## 🔧 문제 해결

### Poetry 관련 문제

**가상환경 위치 확인:**
```bash
poetry env info --path
```

**가상환경 재생성:**
```bash
poetry env remove python
poetry install
```

**의존성 업데이트:**
```bash
poetry update
```

### Jupyter 관련 문제

**커널이 보이지 않는 경우:**
```bash
poetry run python -m ipykernel install --user --name=ai-expert-course
```

**패키지 import 오류:**
```bash
# Poetry 환경에서 Jupyter 실행 확인
poetry run jupyter lab
```

## 📁 프로젝트 구조

```
ai lecture/
├── pyproject.toml          # Poetry 설정 및 의존성
├── requirements.txt        # pip 호환용 의존성 목록
├── README.md              # 프로젝트 개요
├── SETUP.md              # 이 파일
├── glossary.md           # 통합 용어집
├── courses/              # 강의 자료
├── source_code/          # 실습 코드 (Jupyter Notebooks 포함)
├── .gitlab-ci.yml        # GitLab CI/CD 파이프라인
└── assets/              # 이미지 및 자료
```

## 🎯 다음 단계

1. **환경 설정 완료 확인**: `poetry run python -c "import numpy, pandas, torch; print('모든 패키지 정상 설치됨')"`
2. **첫 번째 노트북 실행**: `source_code/05_ai_core_libraries/part_5_ai_core_libraries.ipynb`
3. **강의 자료 탐색**: `courses/` 디렉토리의 마크다운 파일들

## 💡 추가 팁

- **VS Code 사용자**: Poetry 가상환경을 VS Code에서 자동 인식하려면 `Ctrl+Shift+P` → "Python: Select Interpreter"에서 Poetry 환경 선택
- **성능 최적화**: 대용량 데이터 작업 시 `numpy`와 `pandas`의 벡터화 연산 활용
- **메모리 관리**: Jupyter에서 큰 데이터프레임 사용 후 `del df`로 메모리 해제

---

문제가 발생하면 해당 교육 담당자인 박인선 주임에게 문의해주세요