# 16주 완성! AI 전문가 양성 과정: 파이썬부터 프로덕션 배포까지

![과정 배너](./assets/course_banner.png)

[![파이썬](https://img.shields.io/badge/Python-3.10+-blue.svg)](https://www.python.org/downloads/)
[![Poetry](https://img.shields.io/badge/Poetry-dependency%20management-blue.svg)](https://python-poetry.org/)
[![코드 스타일: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Ruff](https://img.shields.io/badge/linter-ruff-red.svg)](https://github.com/astral-sh/ruff)
[![라이센스: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![CI/CD](https://img.shields.io/badge/CI%2FCD-GitLab%20CI-orange.svg)](http://gitlab.geumdo.net/root/geumdo_docs/-/pipelines)
[![진행 상황 추적](https://img.shields.io/badge/Progress-Tracking-green.svg)](./TODO.md)

"아이디어는 있는데, 어떻게 만들어야 할지 막막하신가요?"
"AI, 이제는 소비하는 것을 넘어 직접 만들고 싶으신가요?"

본 과정은 파이썬 기초 문법부터 시작하여, 실제 동작하는 AI 서비스를 직접 기획하고, 개발하며, 세상에 배포하는 전 과정을 경험하는 **16주 완성 실전형 AI 엔지니어링 코스**입니다. 막연한 아이디어를 현실로 만드는 '만들기 능력자'로 거듭나세요.

---

## 🚀 빠른 시작 (Quick Start)

1.  **저장소 복제:**
    ```bash
    git clone https://gds.geumdo.net/root/geumdo_docs.git
    cd geumdo_docs/2_services/ai_lecture
    ```

2.  **개발 환경 설정:**
    -   자세한 내용은 [SETUP.md](./SETUP.md) 파일을 참고하여 Poetry 또는 venv를 사용해 가상환경을 설정하고 필요한 라이브러리를 설치하세요.
    ```bash
    # Poetry 사용 시
    poetry install

    # venv + pip 사용 시
    python -m venv .venv
    source .venv/bin/activate
    pip install -r requirements.txt
    ```

3.  **강의 자료 및 코드 탐색:**
    -   `courses` 디렉토리에서 각 파트별 강의 노트를 확인하세요.
    -   `source_code` 디렉토리에서 실습 코드를 직접 실행하며 학습을 진행하세요.

4.  **학습 진도 관리:**
    ```bash
    # 전체 진도 확인
    make progress

    # 특정 파트 진도 확인
    make progress-show PART=part_2

    # 학습 항목 완료 표시
    make progress-complete PART=part_2 ITEM=0

    # 진도 리포트 생성
    make progress-export FILE=my_progress.md
    ```

---

## 🚀 이 과정을 통해 얻을 수 있는 것

- **AI 서비스 개발의 A to Z**: 데이터 분석, 머신러닝/딥러닝 모델링, API 서버 개발, Docker를 이용한 배포까지, AI 제품 개발의 전체 사이클을 직접 경험하고 이해합니다.
- **실무 중심의 프로젝트 경험**: 체계적인 학습 후, '나만의 개성이 담긴 **캡스톤 프로젝트**'를 진행하며 현업 수준의 문제 해결 능력과 포트폴리오를 확보합니다.
- **생산성을 극대화하는 최신 기술 스택**: `FastAPI`, `Docker`, `PyTorch`, `LangChain` 등 현업에서 가장 수요가 높은 기술 스택을 사용합니다. `Cursor`, `GitHub Copilot` 같은 AI 네이티브 도구를 활용하여 개발 효율을 극대화하는 방법을 체득합니다.
- **지속 가능한 성장을 위한 발판**: MLOps의 기본 개념을 이해하고, 최신 AI 기술 트렌드를 읽는 눈을 기르며, AI 전문가로서 지속적으로 성장할 수 있는 학습 로드맵을 얻게 됩니다.

---

## 📚 전체 강의 목록 (Full Course List)

각 파트별 상세 내용과 학습 목표는 아래 링크를 통해 확인하실 수 있습니다.

-   [Part 0: 과정 소개](./courses/00_introduction/README.md)
-   [Part 1: AI 개발 환경](./courses/01_ai_development_environment/README.md)
-   [Part 2: 파이썬 핵심 문법](./courses/02_python_core_syntax/README.md)
-   [Part 3: 파이썬 컬렉션](./courses/03_python_collections/README.md)
-   [Part 4: 객체 지향 프로그래밍](./courses/04_object_oriented_programming/README.md)
-   [Part 5: AI 핵심 라이브러리](./courses/05_ai_core_libraries/README.md)
-   [Part 5.5: 선형대수학](./courses/05.5_linear_algebra_with_numpy/README.md)
-   [Part 5.6: 미적분학](./courses/05.6_calculus_for_ml/README.md)
-   [Part 6: 머신러닝](./courses/06_machine_learning/README.md)
-   [Part 7: 딥러닝](./courses/07_deep_learning/README.md)
-   [Part 8: FastAPI를 이용한 모델 서빙](./courses/08_model_serving_with_fastapi/README.md)
-   [Part 9: 프로덕션 레벨 API](./courses/09_production_ready_api/README.md)
-   [Part 10: 전문가 과정 로드맵](./courses/10_expert_path/README.md)
-   [Part 11: MLOps](./courses/11_mlops/README.md)
-   [Part 12: 모델 최적화](./courses/12_model_optimization/README.md)
-   [Part 13: 생성형 AI](./courses/13_generative_ai/README.md)
-   [Part 14: AI 윤리](./courses/14_ai_ethics/README.md)
-   [Part 15: 캡스톤 프로젝트](./courses/15_capstone_project/README.md)

---

## 📚 전체 커리큘럼 개요

| 파트 (Part) | 주차 (Week) | 주제 (Topic) | 관련 문서 | 소스코드 |
|:---:|:---:|:---|:---|:---|
| **1** | 1-5주차 | **AI 개발을 위한 파이썬 마스터리** | [0. 소개](./courses/00_introduction/part_0_introduction.md)<br/>[0.1. AI의 역사](./courses/00_introduction/part_0.1_history_of_ai.md)<br/>[1. 개발환경](./courses/01_ai_development_environment/part_1_ai_development_environment.md)<br/>[2. 파이썬 핵심](./courses/02_python_core_syntax/part_2_python_core_syntax.md)<br/>[3. 컬렉션](./courses/03_python_collections/part_3_python_collections.md)<br/>[4. 객체지향](./courses/04_object_oriented_programming/part_4_object_oriented_programming.md)<br/>[5. AI 라이브러리](./courses/05_ai_core_libraries/part_5_ai_core_libraries.md)<br/>[5.5. 선형대수학](./courses/05.5_linear_algebra_with_numpy/part_5.5_linear_algebra_with_numpy.md)<br/>[5.6. 미적분학](./courses/05.6_calculus_for_ml/part_5.6_calculus_for_ml.md) | [Part 2](./source_code/02_python_core_syntax/)<br/>[Part 3](./source_code/03_python_collections/)<br/>[Part 4](./source_code/04_object_oriented_programming/)<br/>[Part 5](./source_code/05_ai_core_libraries/)<br/>[Part 5.5](./source_code/05.5_linear_algebra_with_numpy/)<br/>[Part 5.6](./source_code/05.6_calculus_for_ml/) |
| **2** | 6-9주차 | **핵심 AI 모델 개발 및 서빙** | [6. 머신러닝](./courses/06_machine_learning/part_6_machine_learning.md)<br/>[7. 딥러닝](./courses/07_deep_learning/part_7_deep_learning.md)<br/>[7.1. RNN](./courses/07_deep_learning/part_7.1_recurrent_neural_networks.md)<br/>[7.2. Transformer](./courses/07_deep_learning/part_7.2_transformer_and_llm_principles.md)<br/>[7.3. LangChain](./courses/07_deep_learning/part_7.3_llm_application_development_with_langchain.md)<br/>[7.4. GNN](./courses/07_deep_learning/part_7.4_graph_neural_networks.md)<br/>[7.5. 강화학습](./courses/07_deep_learning/part_7.5_reinforcement_learning.md)<br/>[8. FastAPI 서빙](./courses/08_model_serving_with_fastapi/part_8_model_serving_with_fastapi.md)<br/>[9. 프로덕션 API](./courses/09_production_ready_api/part_9_production_ready_api.md) | [Part 6](./source_code/06_machine_learning/)<br/>[Part 7](./source_code/07_deep_learning/)<br/>[Part 8](./source_code/08_model_serving_with_fastapi/)<br/>[Part 9](./source_code/09_production_ready_api/) |
| **3** | 10-13주차 | **프로덕션 MLOps 및 AI 심화** | [10. 전문가 과정](./courses/10_expert_path/part_10_expert_path.md)<br/>[11. MLOps](./courses/11_mlops/part_11_mlops.md)<br/>[12. 모델 최적화](./courses/12_model_optimization/part_12_model_optimization.md)<br/>[13. 생성형 AI](./courses/13_generative_ai/part_13_generative_ai.md)<br/>[14. AI 윤리](./courses/14_ai_ethics/part_14_ai_ethics.md) | [Part 11](./source_code/11_mlops/)<br/>[Part 12](./source_code/12_model_optimization/)<br/>[Part 13](./source_code/13_generative_ai/)<br/>[Part 14](./source_code/14_ai_ethics/) |
| **4** | 14-15주차 | **최종 캡스톤 프로젝트** | [15. 캡스톤](./courses/15_capstone_project/part_15_capstone_project.md) | (프로젝트 개별 진행) |

---

## 🛠️ 기술 스택 (Tech Stack)

- **언어**: Python 3.10+
- **의존성 관리**: Poetry (권장) / pip
- **핵심 라이브러리**: NumPy, Pandas, Scikit-learn, PyTorch, LangChain
- **API 서버**: FastAPI
- **배포 및 운영**: Docker, Git
- **개발 환경**: JupyterLab, Visual Studio Code, Cursor, GitHub Copilot
- **코드 품질**: Black, Ruff, MyPy, Pytest
- **CI/CD**: GitLab CI/CD

---

## 📖 학습 자료

- **[개발 환경 설정 가이드 (SETUP.md)](./SETUP.md)**: Poetry를 사용한 현대적인 개발 환경 설정 방법
- **[전체 강의 계획서 (Course Schedule)](./AI_Expert_Course_Schedule.md)**: 16주 과정의 상세한 주차별 학습 목표와 내용을 확인하세요.
- **[파트별 강의 노트 및 용어집 (Courses)](./courses/)**: 각 파트별 강의 자료와 핵심 용어집을 확인할 수 있습니다.
- **[실습 코드 모음 (Source Code)](./source_code/)**: Jupyter Notebook과 Python 파일로 구성된 실습 코드를 직접 실행하고 수정해볼 수 있습니다.
- **[튜토리얼 자료 (Tutorials)](./resources/tutorials/)**: NumPy, Pandas 등 주요 라이브러리 학습을 위한 추가 튜토리얼 자료입니다.
- **[유틸리티 스크립트 (Scripts)](./scripts/)**: 학습 진도 관리, 마크다운-노트북 변환 등 유용한 스크립트 모음입니다.
- **[통합 용어집 (Glossary)](./glossary.md)**: 전체 과정에서 사용되는 핵심 용어들을 한 곳에서 확인할 수 있습니다.
- **[자주 묻는 질문 (FAQ)](./FAQ.md)**: 학습 중 자주 발생하는 질문들과 답변을 확인하세요.
- **[트러블슈팅 가이드 (TROUBLESHOOTING.md)](./TROUBLESHOOTING.md)**: 설치 및 실행 중 발생하는 문제 해결 방법을 참고하세요.
- **[개선 사항 및 TODO](./TODO.md)**: 프로젝트 개선 계획과 기여 방법을 확인하세요.

---

## 📑 추가 가이드 및 참고 자료

**커뮤니티 및 협업**
- **[온라인 커뮤니티 가이드](./ONLINE_COMMUNITY_GUIDE.md)**: Discord 및 Slack 커뮤니티 활용 방법과 효과적인 참여 가이드
- **[짝 프로그래밍 가이드](./PAIR_PROGRAMMING_GUIDE.md)**: 효율적인 학습을 위한 짝 프로그래밍 방법론 및 실습 적용 방안

**실무 적용 및 도구**
- **[산업 사례 연결 가이드](./INDUSTRY_CASE_STUDIES.md)**: 이론적 학습 내용과 실제 산업 적용 사례를 연결하는 가이드
- **[클라우드 AI 서비스 가이드](./Cloud_AI_Services_Guide.md)**: AWS, Google Cloud, Azure의 AI 서비스 특징 및 선택 가이드
- **[도구 및 프레임워크 비교](./Tooling_Frameworks_Comparison.md)**: 주요 AI 개발 도구 및 프레임워크 비교 분석

**학습 관리 및 콘텐츠**
- **[진도 관리 시스템](./PROGRESS_TRACKING_SYSTEM.md)**: 학습 진도를 체계적으로 관리하는 고급 시스템 설명
- **[콘텐츠 업데이트 정책](./AI_CONTENT_UPDATE_POLICY.md)**: 최신 AI 기술 트렌드를 교육 과정에 반영하는 업데이트 정책

---

## 🎯 학습 진도 관리

### 진도 체크 시스템
본 과정에서는 학습 진도를 체계적으로 관리할 수 있는 도구를 제공합니다:

```bash
# 전체 진도 확인
make progress

# 특정 파트 진도 확인
make progress-show PART=part_2

# 학습 항목 완료 표시
make progress-complete PART=part_2 ITEM=0

# 진도 리포트 생성
make progress-export FILE=my_progress.md
```

### 진도 관리 기능
- ✅ **파트별 체크리스트**: 각 파트의 핵심 학습 항목들을 체크리스트로 관리
- 📊 **진도 시각화**: 전체 과정과 개별 파트별 진도를 퍼센트로 표시
- 📄 **진도 리포트**: 마크다운 형태의 진도 리포트 자동 생성
- 🔄 **진도 초기화**: 필요시 특정 파트 또는 전체 진도 초기화

---

## 🤝 기여 및 피드백

### 기여 방법
1. **이슈 등록**: 발견한 문제나 개선 아이디어를 [GitHub Issues](https://github.com/your-repo/issues)에 등록
2. **풀 리퀘스트**: 코드 개선이나 문서 수정을 위한 풀 리퀘스트 제출
3. **피드백 제공**: 학습 중 발견한 문제점이나 개선 사항 공유

### 커뮤니티
- **Discord/Slack**: 실시간 질의응답 및 스터디 그룹
- **GitHub Discussions**: 기술적 토론 및 아이디어 공유
- **Email**: geumdo@geumdo.net

---

## 📊 프로젝트 통계

- **파이썬 코드**: 6,492줄
- **문서**: 10,224줄 (마크다운)
- **Jupyter 노트북**: 10개
- **테스트 파일**: 8개
- **Docker 설정**: 2개 (개발/GPU 환경)

---

> [!NOTE]
> 이 과정은 '금도'님의 AI 강의 자료를 기반으로, 수강생의 학습 경험 극대화를 위해 커리큘럼을 재구성하고 내용을 심화시킨 결과물입니다. 원작자의 훌륭한 비유와 설명에 깊이 감사합니다.

> [!TIP]
> **학습 팁**: 각 파트를 완료할 때마다 진도 체크 시스템을 활용하여 학습 현황을 기록하고, 정기적으로 진도 리포트를 생성하여 학습 동기를 유지하세요! 