# 짝 프로그래밍(Pair Programming) 가이드라인

본 문서는 AI 전문가 과정의 주요 실습 과제를 짝 프로그래밍 방식으로 진행하고자 하는 분들을 위한 가이드라인입니다.

## 1. 짝 프로그래밍이란?

짝 프로그래밍은 두 명의 개발자가 하나의 컴퓨터(워크스테이션)에서 함께 작업하는 애자일 소프트웨어 개발 방법론입니다. 두 개발자는 다음과 같은 역할을 번갈아 수행합니다.

- **드라이버 (Driver)**: 키보드와 마우스를 잡고 실제로 코드를 작성하는 역할을 합니다. '어떻게' 구현할 것인가(How)에 집중하며, 당면한 로직을 코드로 옮기는 데 집중합니다.
- **네비게이터 (Navigator)**: 작성 중인 코드를 실시간으로 검토하고, 다음에 진행할 방향을 제시합니다. '무엇을, 왜'(What, Why) 해야 하는지에 집중하며, 큰 그림을 보고 잠재적인 오류나 더 나은 설계 방향을 고민합니다.

## 2. 왜 짝 프로그래밍을 해야 할까요?

이 과정에서 짝 프로그래밍을 권장하는 이유는 다음과 같습니다.

- **지식 공유 및 학습 효과 증대**: 서로의 지식과 경험을 실시간으로 공유하며 혼자서는 발견하기 어려운 새로운 해결책을 찾을 수 있습니다.
- **코드 품질 향상**: 네비게이터의 지속적인 코드 리뷰를 통해 버그를 조기에 발견하고, 더 명확하고 효율적인 코드를 작성할 수 있습니다.
- **문제 해결 능력 강화**: 복잡한 문제에 직면했을 때, 함께 논의하며 다양한 관점에서 해결책을 모색할 수 있어 문제 해결 능력이 향상됩니다.
- **커뮤니케이션 능력 향상**: 자신의 생각을 명확히 설명하고, 동료의 의견을 경청하며 합의를 이끌어내는 과정을 통해 협업 능력을 기를 수 있습니다.

## 3. 성공적인 짝 프로그래밍 세션 진행 방법

1.  **시작 전 (5-10분)**
    -   실습 과제의 요구사항을 함께 읽고 목표를 명확히 이해합니다.
    -   코드를 작성하기 전에, 전체적인 구조와 접근 방식에 대해 함께 논의하고 간단한 계획을 세웁니다. (예: "먼저 데이터 로딩 함수부터 만들고, 그 다음 API 엔드포인트를 설계하자.")

2.  **진행 중**
    -   **역할 교대**: 20~30분 간격으로 타이머를 설정하여 '드라이버'와 '네비게이터' 역할을 주기적으로 교대합니다. 이는 두 사람의 집중력을 유지하고 양쪽 모두가 동등하게 기여하도록 돕습니다.
    -   **지속적인 소통**: 드라이버는 자신이 작성하는 코드의 의도를 소리 내어 설명하고, 네비게이터는 질문하거나 대안을 제시하며 적극적으로 대화에 참여합니다. 침묵은 길어지지 않는 것이 좋습니다.
    -   **존중하는 자세**: 아이디어에 대해 비판하되, 사람을 비판하지 않습니다. 정중하고 건설적인 방식으로 의견을 교환합니다.

3.  **문제가 막혔을 때**
    -   곧바로 혼자 검색부터 시작하지 마세요.
    -   먼저 두 사람이 현재 상황과 문제점을 다시 한번 정리하고, 시도해 본 방법과 가능한 다음 단계를 함께 논의합니다.
    -   함께 논의한 후, 검색 키워드를 정해 해결책을 찾아봅니다.

4.  **세션 종료 후**
    -   완성된 코드를 함께 리뷰하며, 잘된 점과 다음 세션에서 개선할 점에 대해 간단히 회고합니다.

## 4. 도구 및 환경 설정

- **VS Code Live Share**: 원격으로 짝 프로그래밍을 진행할 때 가장 추천하는 도구입니다. 한 사람이 호스트가 되어 세션을 시작하고, 링크를 공유하면 다른 사람이 게스트로 참여하여 실시간으로 코드를 편집하고, 서버를 공유하며, 터미널을 함께 사용할 수 있습니다.
    1.  VS Code의 '확장(Extensions)' 탭에서 `Live Share`를 검색하여 설치합니다.
    2.  설치 후 VS Code 좌측 하단의 Live Share 아이콘을 클릭하여 로그인 및 세션을 시작할 수 있습니다.

## 5. 본 과정에서의 적용 예시

다음과 같은 실습 과제들은 짝 프로그래밍을 통해 더 큰 학습 효과를 얻을 수 있습니다.

- **`08_model_serving_with_fastapi`**: FastAPI를 사용하여 API 엔드포인트의 요청/응답 스키마를 정의하고, 라우팅 로직을 구현할 때.
- **`09_production_ready_api`**: Dockerfile을 작성하고, 테스트 코드를 구현하며 API 구조를 설계할 때.
- **`13_generative_ai/advanced_rag_chatbot.py`**: 복잡한 RAG 파이프라인(문서 로딩, 분할, 임베딩, 검색)의 전체적인 흐름을 설계하고 구현할 때.
- **`15_capstone_project`**: 전체 프로젝트는 기획부터 구현, 테스트까지 모든 단계를 짝 프로그래밍으로 진행하기에 매우 적합합니다.

짝 프로그래밍은 단순한 기술이 아닌, 협업과 소통의 문화입니다. 열린 마음으로 시도해본다면 기술적 성장과 더불어 훌륭한 동료를 얻는 값진 경험을 하게 될 것입니다. 