# AI 전문가 양성 과정 - 자주 묻는 질문 (FAQ)

## 📋 개요
AI 전문가 양성 과정에 대해 자주 묻는 질문들을 정리한 문서입니다.

---

## 🚀 과정 개요

### Q: 이 과정은 어떤 사람들을 대상으로 하나요?
**A:** 다음과 같은 분들을 대상으로 합니다:
- Python 기초 지식이 있는 개발자
- 데이터 분석에 관심있는 분석가
- AI/ML 분야로 전환을 고려하는 전문가
- 대학생 및 대학원생 (컴퓨터과학, 수학, 통계 관련 전공)

### Q: 사전 요구사항이 있나요?
**A:** 네, 다음과 같은 기초 지식이 필요합니다:
- **필수:** Python 기본 문법 (변수, 함수, 클래스)
- **필수:** 기초 수학 (선형대수, 미적분 기본 개념)
- **권장:** 통계학 기초
- **권장:** 대학 수준의 수학 (행렬, 확률)

### Q: 과정을 완주하는데 얼마나 걸리나요?
**A:** 
- **전체 과정:** 16주 (약 4개월)
- **주당 학습시간:** 15-20시간 권장
- **일일 학습시간:** 2-3시간 권장
- 개인의 학습 속도에 따라 조정 가능

### Q: 과정 수료 후 어떤 역량을 갖게 되나요?
**A:** 다음과 같은 역량을 갖게 됩니다:
- 머신러닝/딥러닝 모델 개발 및 튜닝
- 실제 데이터로 AI 프로젝트 수행
- MLOps 파이프라인 구축
- API 개발 및 모델 서빙
- 최신 AI 기술 트렌드 이해

---

## 💻 기술 환경

### Q: 어떤 운영체제에서 실행할 수 있나요?
**A:** 모든 주요 운영체제를 지원합니다:
- **Windows 10/11** (Python 3.8+)
- **macOS** (Intel/Apple Silicon 모두 지원)
- **Linux** (Ubuntu 18.04+, CentOS 7+ 등)

### Q: GPU가 필요한가요?
**A:** 
- **기본 학습:** CPU만으로도 충분
- **딥러닝 실습:** GPU 권장 (NVIDIA GPU)
- **클라우드 대안:** Google Colab, AWS, Azure 활용 가능
- **로컬 GPU 요구사항:** CUDA 지원 GPU (GTX 1060 이상 권장)

### Q: 최소 시스템 요구사항은?
**A:**
- **CPU:** 4코어 이상 권장
- **RAM:** 8GB 이상 (16GB 권장)
- **저장공간:** 50GB 이상 여유공간
- **네트워크:** 안정적인 인터넷 연결

### Q: Docker를 사용해야 하나요?
**A:** Docker 사용은 선택사항입니다:
- **장점:** 환경 설정 간소화, 일관성 보장
- **단점:** 초기 학습 곡선, 리소스 사용량 증가
- **대안:** 로컬 환경 또는 가상환경 사용 가능

---

## 📚 학습 내용

### Q: 프로그래밍 경험이 적은데 따라갈 수 있을까요?
**A:** 
- Python 기초 문법을 아시면 가능합니다
- Part 2-3에서 Python 복습 과정이 포함되어 있습니다
- 추가 학습 자료와 연습 문제를 제공합니다
- 커뮤니티를 통한 질의응답 지원

### Q: 수학이 약한데 문제없을까요?
**A:**
- 필요한 수학 개념을 과정 중에 설명합니다
- 코드 구현에 중점을 두고 이론은 간소화했습니다
- 추천 수학 학습 자료를 제공합니다
- 실무 중심으로 필요한 부분만 학습합니다

### Q: 최신 AI 기술(GPT, BERT 등)도 다루나요?
**A:** 네, 최신 기술들을 포괄적으로 다룹니다:
- **Transformer 아키텍처** (Part 7.2)
- **Large Language Models** (Part 7.3)
- **Generative AI** (Part 13)
- **LangChain 활용** (Part 7.3)
- **최신 논문 리뷰** (Part 10)

### Q: 실무 프로젝트 경험을 쌓을 수 있나요?
**A:** 네, 다양한 실무 프로젝트를 제공합니다:
- **Capstone Project** (Part 15): 종합 프로젝트
- **각 파트별 미니 프로젝트**
- **실제 데이터셋 활용**
- **API 개발 및 배포 실습**
- **포트폴리오 작성 가이드**

---

## 🛠️ 설치 및 환경 설정

### Q: 설치가 너무 복잡해요. 간단한 방법이 있나요?
**A:** 여러 설치 옵션을 제공합니다:
1. **자동 설치 스크립트** (`scripts/setup.sh` 또는 `scripts/setup.ps1`)
2. **Docker 환경** (`docker-compose up`)
3. **Google Colab** (브라우저에서 바로 실행)
4. **클라우드 환경** (AWS, Azure 등)

### Q: 패키지 설치 중 오류가 발생해요.
**A:** 다음 순서로 해결해보세요:
1. **Python 버전 확인** (3.8 이상)
2. **가상환경 생성 및 활성화**
3. **pip 업그레이드** (`pip install --upgrade pip`)
4. **시스템 도구 설치** (Windows: Visual Studio Build Tools)
5. **TROUBLESHOOTING.md 참조**

### Q: 주피터 노트북이 실행되지 않아요.
**A:** 일반적인 해결방법:
```bash
# 주피터 재설치
pip uninstall jupyter jupyterlab
pip install jupyter jupyterlab

# 커널 등록
python -m ipykernel install --user --name=ai_course

# 포트 변경하여 실행
jupyter lab --port=8889
```

---

## 📖 학습 방법

### Q: 어떤 순서로 학습해야 하나요?
**A:** 권장 학습 순서:
1. **Part 0-1:** 기초 개념 및 환경 설정
2. **Part 2-4:** Python 복습 (필요시)
3. **Part 5-6:** 데이터 과학 기초
4. **Part 7:** 딥러닝 (가장 중요)
5. **Part 8-9:** 실무 응용
6. **Part 10-15:** 심화 및 프로젝트

### Q: 실습 위주로 학습하고 싶어요.
**A:** 실습 중심 학습 방법:
- **주피터 노트북** 위주로 학습
- **이론 설명은 최소화**하고 코드 실행에 집중
- **프로젝트 기반 학습** (각 Part별 미니 프로젝트)
- **Kaggle 컴페티션** 참여

### Q: 이론 위주로 학습하고 싶어요.
**A:** 이론 중심 학습 방법:
- **논문 리뷰** (Part 10의 추천 자료)
- **수학적 배경** 깊이 있게 학습
- **알고리즘 구현**을 직접 해보기
- **관련 서적** 병행 학습

### Q: 학습 진도를 어떻게 체크하나요?
**A:** 진도 관리 방법:
- **각 Part별 체크리스트** 활용
- **연습 문제** 해결
- **미니 프로젝트** 완성
- **포트폴리오** 작성
- **커뮤니티** 참여 및 질문

---

## 🤝 커뮤니티 및 지원

### Q: 질문은 어디서 할 수 있나요?
**A:** 다양한 지원 채널이 있습니다:
- **GitHub Issues:** 기술적 문제
- **Discord/Slack:** 실시간 질의응답
- **Stack Overflow:** `ai-expert-course` 태그
- **Email:** 긴급하지 않은 문의

### Q: 스터디 그룹은 어떻게 찾나요?
**A:** 스터디 그룹 운영:
- **온라인 스터디:** Discord에서 진행
- **지역별 오프라인 모임:** 커뮤니티에서 매칭
- **주제별 특별 세션:** 월 1회 운영
- **멘토링 프로그램:** 경력자-신입 매칭

### Q: 수료증이나 인증서가 제공되나요?
**A:** 
- **공식 인증서는 제공하지 않습니다**
- **대신:** 포트폴리오 작성 가이드 제공
- **GitHub 프로필** 최적화 도움
- **취업 면접** 대비 자료 제공
- **프로젝트 결과물**이 실무 역량 증명

---

## 💼 진로 및 취업

### Q: 과정 수료 후 어떤 직군으로 진출할 수 있나요?
**A:** 다양한 직군으로 진출 가능:
- **AI/ML 엔지니어**
- **데이터 사이언티스트**
- **MLOps 엔지니어**
- **AI 제품 매니저**
- **연구원** (기업 연구소, 대학원)

### Q: 실무 경험이 없는데 취업이 가능한가요?
**A:** 취업 전략:
- **포트폴리오 프로젝트** 3-5개 완성
- **GitHub 활동** 꾸준히 진행
- **오픈소스 기여** 경험 쌓기
- **Kaggle 컴페티션** 참여 및 수상
- **인턴십/계약직**부터 시작

### Q: 연봉 수준은 어느 정도인가요?
**A:** 경력별 예상 연봉 (한국 기준):
- **신입:** 4,000-6,000만원
- **경력 2-3년:** 6,000-8,000만원
- **경력 5년+:** 8,000만원-1억원+
- **해외 진출시:** 더 높은 수준
- **스타트업 vs 대기업:** 차이 존재

---

## 🔄 업데이트 및 유지보수

### Q: 과정 내용이 정기적으로 업데이트되나요?
**A:** 네, 지속적으로 업데이트됩니다:
- **분기별 내용 업데이트**
- **최신 라이브러리 버전 반영**
- **새로운 AI 기술 추가**
- **커뮤니티 피드백 반영**
- **실습 환경 개선**

### Q: 오래된 버전을 사용해도 되나요?
**A:** 
- **최신 버전 사용 권장**
- **호환성 문제** 발생 가능
- **보안 업데이트** 포함
- **버그 수정** 반영
- **새로운 기능** 추가

### Q: 기여는 어떻게 할 수 있나요?
**A:** 기여 방법:
- **GitHub Pull Request** 제출
- **오타 수정, 코드 개선**
- **새로운 예제 추가**
- **문서 번역** (영어 등)
- **커뮤니티 질문 답변**

---

## 📞 추가 문의

### 아직 해결되지 않은 질문이 있다면?

**즉시 답변이 필요한 경우:**
- Discord 채팅방 참여
- Stack Overflow에 질문 게시

**일반적인 문의:**
- GitHub Issues에 이슈 등록
- Email로 문의

**기여 및 제안:**
- GitHub Pull Request 제출
- 개선사항 이슈로 등록

---

**마지막 업데이트:** 2024-12-28  
**담당자:** AI Expert Course Team  
**연락처:** [GitHub Issues](https://github.com/your-repo/ai-expert-course/issues) 