# 🤝 AI 전문가 양성 과정 기여 가이드

본 AI 전문가 양성 과정의 발전에 기여해주셔서 진심으로 감사합니다! 여러분의 참여가 이 교육 자료를 더욱 풍성하고 정확하게 만듭니다.

오탈자 수정, 내용 보강, 예제 코드 개선, 새로운 학습 자료 제안, 버그 수정 등 모든 종류의 기여를 환영합니다.

## 📋 목차

- [기여 방법](#-기여-방법)
- [개발 환경 설정](#-개발-환경-설정)
- [프로젝트 구조](#-프로젝트-구조)
- [코딩 스타일 가이드](#-코딩-스타일-가이드)
- [테스트 작성 및 실행](#-테스트-작성-및-실행)
- [문서화 가이드](#-문서화-가이드)
- [Pull Request 가이드라인](#-pull-request-가이드라인)
- [이슈 관리](#-이슈-관리)

## 🚀 기여 방법

### 1. 기여 유형별 가이드

#### 📝 문서 개선
- 오탈자 수정
- 설명 보완 및 명확화
- 새로운 개념 추가
- README 파일 개선

#### 💻 코드 기여
- 예제 코드 개선
- 새로운 실습 예제 추가
- 버그 수정
- 성능 최적화

#### 🧪 테스트 추가
- 단위 테스트 작성
- 통합 테스트 추가
- 테스트 케이스 개선

#### 🛠️ 도구 및 환경 개선
- CI/CD 파이프라인 개선
- Docker 환경 개선
- 개발 도구 추가

### 2. 기여 프로세스

1. **이슈 확인**: [GitHub Issues](https://github.com/your-repo/issues)에서 기존 이슈를 확인하고, 필요시 새로운 이슈를 생성합니다.
2. **Repository Fork**: 프로젝트를 자신의 GitHub 계정으로 Fork합니다.
3. **로컬 개발 환경 설정**: [개발 환경 설정](#-개발-환경-설정) 섹션을 참고하여 환경을 구성합니다.
4. **브랜치 생성**: 의미 있는 이름으로 새로운 브랜치를 생성합니다.
5. **개발 및 테스트**: 변경사항을 구현하고 테스트합니다.
6. **Pull Request 생성**: 변경사항을 원본 프로젝트에 반영하기 위한 PR을 생성합니다.

## 🔧 개발 환경 설정

### 1. 기본 요구사항

- **Python**: 3.8 이상
- **Git**: 최신 버전
- **권장 IDE**: VS Code, PyCharm, Jupyter Lab

### 2. 환경 설정 단계

```bash
# 1. Repository 클론
git clone https://github.com/your-username/ai-expert-course.git
cd ai-expert-course

# 2. 가상환경 생성 (권장)
python -m venv venv

# 3. 가상환경 활성화
# Windows
venv\Scripts\activate
# macOS/Linux
source venv/bin/activate

# 4. 자동 설정 스크립트 실행
# Linux/macOS
bash scripts/setup.sh
# Windows
powershell scripts/setup.ps1

# 5. 개발 의존성 추가 설치
pip install -r requirements-dev.txt
```

### 3. 개발 도구 설정

```bash
# 코드 포맷팅 도구 설정
pre-commit install

# 코드 품질 검사
bash scripts/format_code.sh

# 테스트 실행
bash scripts/run_tests.sh
```

## 📁 프로젝트 구조

```
ai_lecture/
├── courses/              # 강의 자료 (Markdown)
│   ├── 00_introduction/
│   ├── 01_ai_development_environment/
│   └── ...
├── source_code/          # 실습 코드
│   ├── 02_python_core_syntax/
│   ├── 05_ai_core_libraries/
│   └── ...
├── datasets/             # 실습용 데이터셋
├── scripts/              # 자동화 스크립트
├── .github/              # CI/CD 설정
│   └── workflows/
├── docker/               # Docker 관련 파일
└── docs/                 # 추가 문서
```

### 주요 디렉토리 설명

- **`courses/`**: 각 파트별 이론 강의 자료 (Markdown 형식)
- **`source_code/`**: 파이썬 실습 코드 및 Jupyter 노트북
- **`datasets/`**: 실습에 사용되는 샘플 데이터셋
- **`scripts/`**: 환경 설정, 테스트, 포맷팅 등 자동화 스크립트

## 🎨 코딩 스타일 가이드

### Python 코드 스타일

- **PEP 8** 스타일 가이드를 준수합니다
- **Black**으로 코드 포맷팅을 자동화합니다
- **Ruff**로 린팅 검사를 수행합니다

```python
# 좋은 예시
def calculate_accuracy(predictions: List[int], targets: List[int]) -> float:
    """
    모델 예측의 정확도를 계산합니다.
    
    Args:
        predictions: 모델의 예측값 리스트
        targets: 실제 정답 리스트
    
    Returns:
        정확도 (0.0 ~ 1.0)
    """
    correct = sum(p == t for p, t in zip(predictions, targets))
    return correct / len(targets)
```

### 주석 및 문서화

- **함수와 클래스에는 docstring을 작성**합니다
- **복잡한 로직에는 주석을 추가**합니다
- **타입 힌트를 적극 활용**합니다

## 🧪 테스트 작성 및 실행

### 테스트 작성 가이드

각 모듈에 대해 `tests/` 디렉토리에 테스트 파일을 작성합니다:

```python
# tests/test_part_5.py 예시
import pytest
import numpy as np
from source_code.part_5_ai_core_libraries import create_sample_dataframe


def test_create_sample_dataframe():
    """DataFrame 생성 함수 테스트"""
    df = create_sample_dataframe()
    
    assert len(df) > 0
    assert 'feature1' in df.columns
    assert df['feature1'].dtype == np.float64
```

### 테스트 실행

```bash
# 전체 테스트 실행
bash scripts/run_tests.sh

# 특정 모듈 테스트
python -m pytest source_code/05_ai_core_libraries/tests/ -v

# 커버리지 포함 테스트
bash scripts/run_tests.sh --coverage
```

## 📚 문서화 가이드

### Markdown 스타일

- **제목**: 명확하고 간결한 제목 사용
- **코드 블록**: 언어를 명시하고 적절한 들여쓰기 사용
- **링크**: 상대 경로를 사용하여 내부 문서 연결

```markdown
## 좋은 예시

### 데이터 전처리

다음은 데이터 전처리 과정입니다:

```python
import pandas as pd

def preprocess_data(df: pd.DataFrame) -> pd.DataFrame:
    # 결측값 처리
    df = df.fillna(0)
    return df
```

자세한 내용은 [데이터 전처리 가이드](./preprocessing_guide.md)를 참고하세요.
```

### README 파일 작성

각 `source_code/*/README.md` 파일은 다음 구조를 따릅니다:

1. **개요**: 모듈의 목적과 내용
2. **파일 설명**: 포함된 파일들의 역할
3. **실행 방법**: 단계별 실행 가이드
4. **주요 내용**: 다루는 핵심 개념들
5. **테스트**: 테스트 실행 방법

## 📬 Pull Request 가이드라인

### PR 제목 규칙

- **feat**: 새로운 기능 추가
- **fix**: 버그 수정
- **docs**: 문서 수정
- **style**: 코드 포맷팅 (기능 변경 없음)
- **refactor**: 코드 리팩토링
- **test**: 테스트 추가/수정
- **chore**: 빌드 프로세스 또는 도구 변경

```
feat: Part 7에 Transformer 실습 예제 추가
fix: Part 5 NumPy 예제의 배열 차원 오류 수정
docs: Part 2 README에 실행 가이드 보완
```

### PR 설명 템플릿

```markdown
## 변경 내용
- [ ] 새로운 기능 추가
- [ ] 버그 수정
- [ ] 문서 개선
- [ ] 기타: ___________

## 상세 설명
이 PR에서 수행한 작업에 대한 상세 설명을 작성합니다.

## 테스트
- [ ] 새로운 테스트를 추가했습니다
- [ ] 기존 테스트가 모두 통과합니다
- [ ] 수동 테스트를 수행했습니다

## 체크리스트
- [ ] 코드 스타일 가이드를 준수했습니다
- [ ] 필요한 문서를 업데이트했습니다
- [ ] 관련 이슈가 있다면 링크했습니다
```

### 리뷰 프로세스

1. **자동 검사**: CI/CD 파이프라인이 자동으로 코드 품질과 테스트를 검사합니다
2. **코드 리뷰**: 프로젝트 관리자가 코드를 검토합니다
3. **피드백 반영**: 요청된 수정사항을 반영합니다
4. **승인 및 병합**: 모든 검토가 완료되면 메인 브랜치에 병합됩니다

## 🐛 이슈 관리

### 이슈 유형

- **Bug**: 오류나 예상치 못한 동작
- **Enhancement**: 기존 기능 개선
- **Feature Request**: 새로운 기능 제안
- **Documentation**: 문서 관련 이슈
- **Question**: 질문이나 도움 요청

### 이슈 작성 가이드

```markdown
**이슈 유형**: Bug / Enhancement / Feature Request / Documentation / Question

**설명**:
문제나 제안사항에 대한 명확한 설명

**재현 방법** (Bug의 경우):
1. 실행한 코드나 명령어
2. 예상 결과
3. 실제 결과

**환경 정보**:
- OS: Windows 10 / macOS / Ubuntu
- Python 버전: 3.9.0
- 관련 라이브러리 버전

**추가 정보**:
스크린샷, 로그, 또는 기타 도움이 될 만한 정보
```

## 🙏 기여자 인정

모든 기여자는 프로젝트의 [CONTRIBUTORS.md](./CONTRIBUTORS.md) 파일에 이름이 추가됩니다. 또한 주요 기여에 대해서는 릴리즈 노트에서 특별히 언급됩니다.

## 📞 도움이 필요한 경우

- **GitHub Issues**: 기술적 문제나 기능 제안
- **GitHub Discussions**: 일반적인 질문이나 토론
- **이메일**: [contact@example.com](mailto:contact@example.com)

## 🎯 우선순위 높은 기여 영역

현재 다음 영역에서의 기여를 특히 환영합니다:

1. **테스트 코드 작성**: 기존 실습 코드에 대한 단위 테스트
2. **문서 개선**: 더 명확한 설명과 예시 추가
3. **실습 예제 추가**: 실제 데이터를 활용한 프로젝트 예제
4. **성능 최적화**: 코드 효율성 개선
5. **접근성 개선**: 다양한 환경에서의 호환성 향상

다시 한번 기여에 감사드립니다! 🚀

---

**마지막 업데이트**: 2024-12-28  
**문서 버전**: v2.0 