<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<div class="content-wrapper">
	<section class="content-header">
		<?php echo $pagetitle; ?>
		<?php echo $breadcrumb; ?>
	</section>
	<section class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="box">
					<div class="box-body">
						<table id="table_user" class="table table-striped table-hover">
							<thead>
								<tr>
									<th>인덱스</th>
									<th>아이디</th>
									<th>이름</th>
									<th>상태</th>
									<th>상세</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($users as $user){ ?>
									<?php if($user->index != 1){ ?>
								<tr>
									<td><?= $user->index ?></td>
									<td><?= $user->id ?></td>
									<td><?= $user->name ?></td>
									<td><?php
	echo ($user->is_active == 1 ? '<button class="btn btn-xs btn-success" disabled>활성</button>' : '<button class="btn btn-xs btn-danger" disabled>비활성</button>');
?></td>
									<td><?= '<button onclick="button_modal(\''.$user->uid.'\', \''.$user->id.'\', \''.$user->pw.'\', \''.$user->name.'\', \''.$user->is_active.'\')" class="btn btn-xs btn-default">확인</button>' ?></td>
								</tr>
									<?php } ?>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<div id="div_modal" class="modal fade" role="dialog">
	<div class-"modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">이용자 정보</h4>
			</div>
			<div class="modal-body">
				<label>고유값</label>
				<input id="input_uid" class="form-control" disabled>
				<br>
				<label>아이디</label>
				<input id="input_id" class="form-control">
				<br>
				<label>비밀번호</label>
				<input id="input_pw" class="form-control">
				<br>
				<label>이름</label>
				<input id="input_name" class="form-control">
			</div>
			<div id="div_modal_footer" class="modal-footer">
			</div>
		</div>
		<hr>
		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title">미션 정보</h4>
			</div>
			<div id="div_modal_body_mission" class="modal-body">
			</div>
			<div id="div_modal_footer_mission" class="modal-footer">
			</div>
		</div>
	</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animsition/3.2.1/js/animsition.min.js"></script>
<script>
$(document).ready(function (){
	$(document).on('hide.bs.modal','#div_modal', function () {
		$('#div_modal_footer').empty();
		$('#div_modal_body_mission').empty();
		$('#div_modal_footer_mission').empty();
	});

	var table_user = new DataTable('#table_user', {
		pageLength: 25,
		layout: {
			topStart: {
				pageLength: {
					menu: [10, 25, 100]
				}
			}
		}
	});
});

function button_toggle_is_active(uid){
	if(confirm('이용자의 상태를 변경할까요? 상태는 언제든지 다시 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/users/toggle_is_active',
			type: 'POST',
			data: {
				uid: uid,
			},
			success: function (res){
				console.log(res);
				if(res > 0){
					alert('상태 변경에 성공했습니다.');
					location.reload();
				}else{
					alert('상태 변경에 실패했습니다.');
				}
			},
			error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function button_set_user(uid){
	var id = $('#input_id').val();
	var pw = $('#input_pw').val();
	var name = $('#input_name').val();
	if((id.length < 8) || (id.length > 16) || (pw.length < 8) || (pw.length > 16) || (name.length < 3) || (name.length > 16)){
		console.log(id.length);
		console.log(pw.length);
		console.log(name.length);
		alert('아이디와 비밀번호는 8~16자, 이름은 3~16자로 설정해 주세요.');
		return;
	}
	if(confirm('이용자의 정보를 변경할까요? 언제든지 다시 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/users/set_user',
			type: 'POST',
			data: {
				uid: uid,
				id: id,
				pw: pw,
				name: name,
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('정보 변경에 성공했습니다.');
					//location.reload();
				}else{
					alert('정보 변경에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function set_mission(uid, i){
	var point = parseInt($(`input[name="point_${i}"]`).val());
	if((point < 0) || (point > 100)){
		alert('점수는 0~100 사이로 설정해 주세요.');
		return;
	}
	if(confirm('미션 점수를 변경할까요? 언제든지 다시 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/users/set_mission',
			type: 'POST',
			data: {
				uid: uid,
				point: point,
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('점수 변경에 성공했습니다.');
				}else{
					alert('점수 변경에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function button_reset_missions(uid){
	if(confirm('모든 미션을 초기화할까요? 복구할 수 없습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/users/reset_missions',
			type: 'POST',
			data: {
				uid: uid,
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('미션 초기화에 성공했습니다.');
					location.reload();
				}else{
					alert('미션 초기화에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function get_missions(uid){
	$.ajax({
		url: '<?= base_url() ?>admin/users/get_missions',
		type: 'POST',
		dataType: 'json',
		data: {
			uid: uid,
		}, success: function (res){
//div_modal_body_mission
//div_modal_footer_mission
			if(res.length > 0){
				for(var i = 0; i < res.length; i++){
					$('#div_modal_body_mission').append(`<div class="row" style="margin: 0px;">
						<label>미션 ${res[i].level}</label>
						<div class="input-group">
							<input name="point_${i}" class="form-control" type="number" value="${res[i].point}">
							<span class="input-group-btn">
								<button onclick="set_mission('${res[i].uid}', '${i}')" class="btn btn-success">점수 변경</button>
							</span>
						</div>
					</div>`);
				}
				$('#div_modal_footer_mission').prepend(`<button onclick="button_reset_missions('${uid}')" class="btn btn-danger" style="float: left;">모든 미션 삭제</button>`);
			}else{
				$('#div_modal_body_mission').append(`<span>수행한 미션 없음</span>`);
			}
		}, error: function (data, status, err){
			console.log(err);
		}
	});
}

function button_modal(uid, id, pw, name, is_active){
	$('#input_uid').val(uid);
	$('#input_id').val(id);
	$('#input_pw').val(pw);
	$('#input_name').val(name);
	if(is_active == 1){
		$('#div_modal_footer').prepend(`<button onclick="button_toggle_is_active('${uid}')" class="btn btn-danger" style="float: left;">탈퇴 처리</button>`);
	}else{
		$('#div_modal_footer').prepend(`<button onclick="button_toggle_is_active('${uid}')" class="btn btn-warning" style="float: left;">탈퇴 복구</button>`);
	}
	$('#div_modal_footer').append(`<button onclick="button_set_user('${uid}')" class="btn btn-success" style="float: right;">이용자 정보 변경</button>`);
	get_missions(uid);
	$('#div_modal').modal('show');
}
</script>
