<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<div class="content-wrapper">
	<section class="content-header">
		<?php echo $pagetitle; ?>
		<?php echo $breadcrumb; ?>
	</section>
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<button onclick="button_modal_add()" class="btn btn-default"><i class="fa fa-plus"></i> 설문 등록</button>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="box">
					<div class="box-body">
						<table id="table_question" class="table table-striped table-hover">
							<thead>
								<tr>
									<th>인덱스</th>
									<th>설문</th>
									<th>상태</th>
									<th>상세</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($questions as $question){ ?>
								<tr>
									<td><?= $question->index ?></td>
									<td><?= $question->question ?></td>
									<td><?= $question->is_active == 1 ? '<button class="btn btn-xs btn-success" disabled>활성</button>' : '<button class="btn btn-xs btn-danger" disabled>비활성</button>' ?></td>
									<td><?= '<button onclick="button_modal(\''.$question->uid.'\', \''.$question->question.'\', \''.$question->is_active.'\')" class="btn btn-xs btn-default">확인</button>' ?></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<div id="div_modal_add" class="modal fade" role="dialog">
	<div>
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">설문 등록</h4>
			</div>
			<div class="modal-body">
				<label>설문</label>
				<textarea id="input_question_add" class="form-control" rows="4" placeholder="설문을 입력하세요."></textarea>
				<br>
				<label>답안</label>
				<div class="row" style="padding: 0px 15px 15px 15px;">
					<div class="col-12">
						<label>
							<input id="input_a0_add" class="form-control" placeholder="첫번째 답안" value="좋지 않다" disabled>
						</label>
					</div>
					<div class="col-12">
						<label>
							<input id="input_a1_add" class="form-control" placeholder="두번째 답안" value="보통이다" disabled>
						</label>
					</div>
					<div class="col-12">
						<label>
							<input id="input_a2_add" class="form-control" placeholder="세번째 답안" value="좋다" disabled>
						</label>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button onclick="button_add()" class="btn btn-success">새로운 설문 등록</button>
			</div>
		</div>
	</div>
</div>
<div id="div_modal" class="modal fade" role="dialog">
	<div>
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">설문 정보</h4>
			</div>
			<div class="modal-body">
				<label>고유값</label>
				<input id="input_uid" class="form-control" disabled>
				<br>
				<label>설문</label>
				<textarea id="input_question" class="form-control" rows="4"></textarea>
				<br>
				<label>답안</label>
				<div class="row" style="padding: 0px 15px 15px 15px;">
					<div class="col-12">
						<label>
							<input id="input_a0" class="form-control" disabled value="좋지 않다">
						</label>
					</div>
					<div class="col-12">
						<label>
							<input id="input_a1" class="form-control" disabled value="보통이다">
						</label>
						</div>
					<div class="col-12">
						<label>
							<input id="input_a2" class="form-control" disabled value="좋다">
						</label>
					</div>
				</div>
			</div>
			<div id="div_modal_footer" class="modal-footer">
			</div>
		</div>
	</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animsition/3.2.1/js/animsition.min.js"></script>
<script>
$(document).ready(function (){
	$(document).on('hide.bs.modal','#div_modal', function () {
		$('#div_modal_footer').empty();
		$('#div_modal_body_mission').empty();
		$('#div_modal_footer_mission').empty();
	});

	var table_question = new DataTable('#table_question', {
		columnDefs: [{
			targets: 1,
			render: DataTable.render.ellipsis(40),
		}],
		pageLength: 25,
		layout: {
			topStart: {
				pageLength: {
					menu: [10, 25, 100]
				}
			}
		}
	});
});

function button_toggle_is_active(uid){
	if(confirm('설문의 상태를 변경할까요? 상태는 언제든지 다시 복구할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/surveys/toggle_is_active',
			type: 'POST',
			data: {
				uid: uid,
			},
			success: function (res){
				console.log(res);
				if(res > 0){
					alert('상태 변경에 성공했습니다.');
					location.reload();
				}else{
					alert('상태 변경에 실패했습니다.');
				}
			},
			error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function replaceSpecial(text){
	var res_text = text.replaceAll('"', '');
	res_text = res_text.replaceAll("'", '');
	res_text = res_text.replaceAll('(', '');
	res_text = res_text.replaceAll(')', '');
	return res_text;
}

function button_set_question(uid){
	var question = $('#input_question').val();
	question = replaceSpecial(question);
	var answers = [{
		'a': '좋지 않다',
		'c': '0',
	},{
		'a': '보통이다',
		'c': '1',
	},{
		'a': '좋다',
		'c': '2',
	}];
	if((question.length <= 0)){
		alert('설문에는 내용이 존재해야 합니다.');
		return;
	}
	if(confirm('설문의 정보를 변경할까요? 언제든지 다시 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/surveys/set_question',
			type: 'POST',
			data: {
				uid: uid,
				question: question,
				answers: JSON.stringify(answers),
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('정보 변경에 성공했습니다.');
					location.reload();
				}else{
					alert('정보 변경에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function button_modal(uid, question, is_active){
	$('#input_uid').val(uid);
	$('#input_question').val(question);
	if(is_active == 1){
		$('#div_modal_footer').prepend(`<button onclick="button_toggle_is_active('${uid}')" class="btn btn-danger" style="float: left;">설문 삭제</button>`);
	}else{
		$('#div_modal_footer').prepend(`<button onclick="button_toggle_is_active('${uid}')" class="btn btn-warning" style="float: left;">설문 복구</button>`);
	}
	$('#div_modal_footer').append(`<button onclick="button_set_question('${uid}')" class="btn btn-success" style="float: right;">설문 정보 변경</button>`);
	//get_missions(uid);
	$('#div_modal').modal('show');
}

function button_modal_add(){
	$('#div_modal_add').modal('show');
}

function button_add(){
	var question = $('#input_question_add').val();
	question = replaceSpecial(question);
	var answers = [{
		'a': '좋지 않다',
		'c': '0',
	},{
		'a': '보통이다',
		'c': '1',
	},{
		'a': '좋다',
		'c': '2',
	}];
	if((question.length <= 0)){
		alert('설문에는 내용이 존재해야 합니다.');
		return;
	}
	if(confirm('설문을 새로 등록할까요? 설문은 언제든지 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/surveys/add_question',
			type: 'POST',
			data: {
				question: question,
				answers: JSON.stringify(answers),
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('설문 등록에 성공했습니다.');
					location.reload();
				}else{
					alert('설문 등록에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}
</script>
