<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<div class="content-wrapper">
	<section class="content-header">
		<?php echo $pagetitle; ?>
		<?php echo $breadcrumb; ?>
	</section>
	<section class="content">
		<!--
		<div class="row">i
			<div class="col-xs-12">
				<button onclick="button_modal_add()" class="btn btn-default"><i class="fa fa-plus"></i> 미디어 등록</button>
			</div>
		</div>
		-->
		<div class="row">
			<div class="col-md-12">
				<div class="box">
					<div class="box-body">
						<table id="table_question" class="table table-striped table-hover">
							<thead>
								<tr>
									<th>인덱스</th>
									<th>미션</th>
									<th>종류</th>
									<th>경로</th>
									<th>상세</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach ($medias as $media){ ?>
								<tr>
									<td><?= $media->index ?></td>
									<td><?= $media->level ?></td>
									<td><?= ($media->type == 0 ? '영상' : ($media->type == 1 ? '소리' : '그림')) ?></td>
									<td><?= $media->path ?></td>
									<td><?= '<button onclick="button_modal(\''.$media->index.'\',\''.$media->type.'\',\''.$media->path.'\',\''.$media->level.'\')" class="btn btn-xs btn-default">확인</button>' ?></td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<div id="div_modal" class="modal fade" role="dialog">
	<div>
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">미디어 정보</h4>
			</div>
			<div class="modal-body">
				<label>고유값</label>
				<input id="input_uid" class="form-control" disabled>
				<br>
				<label>미션</label>
				<input id="input_level" class="form-control" disabled>
				<br>
				<label>종류</label>
				<input id="input_type" class="form-control" disabled>
				<br>
				<label>경로</label>
				<input id="input_path" class="form-control">
			</div>
			<div id="div_modal_footer" class="modal-footer">
			</div>
		</div>
	</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animsition/3.2.1/js/animsition.min.js"></script>
<script>
$(document).ready(function (){
	$(document).on('hide.bs.modal','#div_modal', function () {
		$('#div_modal_footer').empty();
		$('#div_modal_body_mission').empty();
		$('#div_modal_footer_mission').empty();
	});

	var table_question = new DataTable('#table_question', {
		columnDefs: [{
			targets: 3,
			render: DataTable.render.ellipsis(50, true),
		}],
		pageLength: 25,
		layout: {
			topStart: {
				pageLength: {
					menu: [10, 25, 100]
				}
			}
		}
	});
});

function replaceSpecial(text){
	var res_text = text.replaceAll('"', '');
	res_text = res_text.replaceAll("'", '');
	res_text = res_text.replaceAll('(', '');
	res_text = res_text.replaceAll(')', '');
	return res_text;
}

function button_set_media(uid){
	var path = $('#input_path').val();
	path = replaceSpecial(path);
	if((path.length <= 0)){
		alert('경로에는 내용이 존재해야 합니다.');
		return;
	}
	if(confirm('경로의 정보를 변경할까요? 언제든지 다시 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/medias/set_path',
			type: 'POST',
			data: {
				uid: uid,
				path: path,
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('정보 변경에 성공했습니다.');
					location.reload();
				}else{
					alert('정보 변경에 실패했습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function button_modal(uid, type, path, level){
	$('#input_uid').val(uid);
	$('#input_type').val((type == 0 ? '영상' : (type == 1 ? '소리' : '그림')));
	$('#input_path').val(path);
	$('#input_level').val(level);
	$('#div_modal_footer').append(`<button onclick="button_set_path('${uid}')" class="btn btn-success" style="float: right;">미디어 정보 변경</button>`);
	//get_missions(uid);
	$('#div_modal').modal('show');
}
</script>
