<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<div class="content-wrapper">
	<section class="content-header">
		<?php echo $pagetitle; ?>
		<?php echo $breadcrumb; ?>
	</section>
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<button onclick="button_modal_add()" class="btn btn-default"><i class="fa fa-plus"></i> 금지어 등록</button>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="box">
					<div class="box-body">
						<table id="table_fword" class="table table-striped table-hover">
							<thead>
								<tr>
									<th>금지어</th>
									<th>상태</th>
									<th>상태 변경</th>
								</tr>
							</thead>
							<tbody>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<div id="div_modal_add" class="modal fade" role="dialog">
	<div>
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal">&times;</button>
				<h4 class="modal-title">금지어 등록</h4>
			</div>
			<div class="modal-body">
				<label>금지어</label>
				<input id="input_fword_add" class="form-control" rows="4" placeholder="금지어를 입력하세요."></textarea>
			</div>
			<div class="modal-footer">
				<button onclick="button_add()" class="btn btn-success">새로운 금지어 등록</button>
			</div>
		</div>
	</div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animsition/3.2.1/js/animsition.min.js"></script>
<script>
$(document).ready(function (){
	$(document).on('hide.bs.modal','#div_modal', function () {
		$('#div_modal_footer').empty();
		$('#div_modal_body_mission').empty();
		$('#div_modal_footer_mission').empty();
	});

	/*
	var table_fword = new DataTable('#table_fword', {
		columnDefs: [{
			targets: 0,
			render: DataTable.render.ellipsis(40),
		}],
		pageLength: 25,
		layout: {
			topStart: {
				pageLength: {
					menu: [10, 25, 100]
				}
			}
		}
	});
	*/

	console.log('<?= base_url() ?>admin/fwords/get_fwords_page');
	var table_fword = $('#table_fword');
	$('#table_fword').DataTable({
		ajax: {
			url: '<?= base_url() ?>admin/fwords/get_fwords_page',
			type: 'get',
		},
		columns: [{
			data: 'word'
		},{
			data: 'is_active',
			render: function (data, type){
				var string_html = '';
				if(data == 1){
					string_html += '<button class="btn btn-xs btn-success" disabled>활성</button>';
				}else{
					string_html += '<button class="btn btn-xs btn-danger" disabled>비활성</button>';
				}
				return string_html;
			}
		},{
			data: 'index',
			render: function (data, type){
				return '<button onclick="button_toggle_is_active(' + data + ')" class="btn btn-xs btn-warning">변경</button>';
			}
		}],
		processing: true,
		serverSide: true,
		pageLength: 25,
		lengthMenu: [10, 25, 100],
	});
});

function button_toggle_is_active(word){
	if(confirm('금지어의 상태를 변경할까요? 금지어는 언제든지 다시 복구할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/fwords/toggle_is_active',
			type: 'POST',
			data: {
				word: word,
			},
			success: function (res){
				console.log(res);
				if(res > 0){
					alert('상태 변경에 성공했습니다.');
					location.reload();
				}else{
					alert('상태 변경에 실패했습니다.');
				}
			},
			error: function (data, status, err){
				console.log(err);
			}
		});
	}
}

function replaceSpecial(text){
	var res_text = text.replaceAll('"', '');
	res_text = res_text.replaceAll("'", '');
	res_text = res_text.replaceAll('(', '');
	res_text = res_text.replaceAll(')', '');
	return res_text;
}

function button_modal_add(){
	$('#div_modal_add').modal('show');
}

function button_add(){
	var word = $('#input_fword_add').val();
	word = replaceSpecial(word);
	if((word.length <= 0)){
		alert('금지어는 내용이 존재해야 합니다.');
		return;
	}
	if(confirm('금지어를 새로 등록할까요? 금지어는 중복될 수 없으며, 활성 상태만 변경할 수 있습니다.')){
		$.ajax({
			url: '<?= base_url() ?>admin/fwords/add_fword',
			type: 'POST',
			data: {
				word: word,
			}, success: function (res){
				console.log(res);
				if(res > 0){
					alert('금지어 등록에 성공했습니다.');
					location.reload();
				}else{
					alert('금지어 등록에 실패했습니다. 중복된 단어는 입력할 수 없습니다.');
				}
			}, error: function (data, status, err){
				console.log(err);
			}
		});
	}
}
</script>
