<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="content-wrapper">
	<section class="content-header">
		<?php echo $pagetitle; ?>
		<?php echo $breadcrumb; ?>
	</section>
	<section class="content">
		<div class="row">
			<!--
			<div class="col-sm-12">
				<div class="info-box bg-green">
					<span class="info-box-icon bg-green">
						<i class="fa fa-plug"></i>
					</span>
					<div class="info-box-content" style="background-color: white; height: 90px;">
						<button id="button_socket_connect" class="btn btn-success">소켓 연결</button>
						<span></span>
					</div>
				</div>
			</div>
			-->
			<div class="col-sm-12 col-md-6">
				<div class="info-box bg-green">
					<span class="info-box-icon bg-green">
						<i class="fa fa-user"></i>
					</span>
					<div class="info-box-content" style="background-color: white; height: 180px; overflow-y: scroll;">
						<span class="info-box-text" style="color: black;">USERS IN PARK <label id="label_user_count">-</label></span>
						<div id="div_users" style="color: black;">
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-12 col-md-6">
				<div class="info-box bg-aqua">
					<span class="info-box-icon bg-aqua">
						<i class="fa fa-comment"></i>
					</span>
					<div class="info-box-content" style="background-color: white; height: 180px; overflow-y: scroll;">
						<span class="info-box-text" style="color: black;">CHAT</span>
						<form id="form_chat">
							<div class="row" style="padding: 0px 15px;">
								<div class="col-xs-6 col-md-3" style="padding: 0px;">
									<input id="input_name" class="form-control" value="관리자"/>
								</div>
								<div class="col-xs-6 col-md-7" style="padding: 0px;">
									<input id="input_chat" class="form-control" placeholder="채팅을 입력하세요."/>
								</div>
								<div class="col-xs-12 col-md-2" style="padding: 0px;">
									<button id="button_chat" type="submit" class="btn btn-default" style="width: 100%;">
										<i class="fa fa-paper-plane"></i>
									</button>
								</div>
							</div>
						</form>
						<div id="div_chats" style="color: black;">
						</div>
					</div>
				</div>
			</div>
			<div class="col-xs-12">
				<div class="info-box bg-maroon">
					<span class="info-box-icon bg-maroon">
						<i class="fa fa-map"></i>
					</span>
					<div class="info-box-content" style="background-color: white;">
						<span class="info-box-text" style="color: black;">MAP</span>
						<div class="text-center">
							<span style="color: black;">시청각실</span>
						</div>
						<div id="div_map" style="color: black; height: 500px; width: 100%;">
						</div>
						<div class="text-center">
							<span style="color: black;">실험실</span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/animsition/3.2.1/js/animsition.min.js"></script>-->
<script src="https://cdn.canvasjs.com/canvasjs.min.js"></script>
<script src='http://118.45.160.139:52533/socket.io/socket.io.js'></script>
<!--<script src="https://cdn.socket.io/4.7.5/socket.io.min.js" integrity="sha384-2huaZvOR9iDzHqslqwpR87isEmrfxqyWOF7hr7BY6KG0+hVKLoEXMPUJw3ynWuhO" crossorigin="anonymous"></script>-->
<script>
$(document).ready(function (){
	var arr_user = [];

	var socket = io.connect('http://118.45.160.139:52533', {
		cors: {
			origin: '*'
		}
	});

	socket.on('connect', function (){
		console.log('connected to server');
		console.log(socket.id);
	});

	socket.on('disconnect', function (){
		console.log('disconnected from server');
	});

	document.addEventListener('keydown', function (e){
		if(e.code == 'Space'){
			socket.emit('jump', {code: 2, id: socket.id});
		}
	});
	
	socket.emit('get_users');
	setInterval(function (){
		socket.emit('get_users');
	}, 250);

	socket.on('get_users', function (res){
		arr_user = res;
		console.log(arr_user);
		$('#label_user_count').text((res.length - 1).toString());
		$('#div_users').empty();
		for(var i = 0; i < res.length; i++){
			if(res[i].socket_id != socket.id){
				$('#div_users').append(
					`<span class="info-box-number">${res[i].name}</span>`
				);
			}
		}
		var arr_chart = [];
		for(var i = 0; i < res.length; i++){
			if(res[i].socket_id != socket.id){
				arr_chart.push({
					x: Math.abs(res[i].pos_x - 28.5),
					y: Math.abs(res[i].pos_z - 28.5),
					name: res[i].name,
				});
			}
		}
		chart.options.data[0].dataPoints = arr_chart;
		chart.render();
	});

	$('#button_chat').click(function (e){
		var name = $('#input_name').val();
		var chat = $('#input_chat').val();
		if(name == null || name.trim() == '' || chat == null || chat.trim() == ''){
			alert('이름 혹은 대화를 입력해주세요.');
			return;
		}
		var json_data = {code: 0, id: socket.id, name: name, data: chat};
		socket.emit('chat', json_data);
		$('#input_chat').val('');
	});

	socket.on('chat', function (data){
		$('#div_chats').prepend(`<div class="row" style="padding: 5px 15px 0px 15px;">
				<label>${data.name}</label>
				<span>${data.data}</span>
			</div>`
		);
	});

	$('#form_chat').on('submit', function (e){
		e.preventDefault();
	});

	var chart;
	window.onload = function (){
		chart = new CanvasJS.Chart("div_map", {
			animationEnabled: false,
			zoomEnabled: false,
			axisX: {
				lineThickness: 0,
				gridThickness: 1,
				gridDashType: 'dot',
				minimum: 0,
				maximum: 29,
				tickLength: 0,
				//logarithmBase: 1.5,
				stripLines: [{
					value: 0,
				}],
				labelFormatter: function (){
					return '';
				}
			},
			axisY:{
				lineThickness: 0,
				gridThickness: 1,
				gridDashType: 'dot',
				minimum: 0,
				maximum: 29,
				tickLength: 0,
				//logarithmBase: 1.5,
				labelFormatter: function (){
					return '';
				}
			},
			data: [{
				type: "scatter",
				toolTipContent: "{name}",
				dataPoints: [
					{ x: 8, y: 3, name: '사파키엘' },
					{ x: 9, y: 4, name: '관리자' },
				]
			}]
		});
		chart.render();
	}

	function update_chart(){
		chart.options.data[0].dataPoints = [
			{x: 5, y: 5, name: 'safaquiel'}
		];
		chart.render();
	}

	/*
	setTimeout(function (){
		update_chart();
	}, 5000);
	*/
});
</script>
