<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		/* Load :: Common */
		//$this->lang->load('admin/users');

		/* Title Page :: Common */
		$this->page_title->push('Users');
		$this->data['pagetitle'] = $this->page_title->show();

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_users'), 'admin/users');
		$this->output->delete_cache();
	}


	public function index(){
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			$this->load->model('admin/user_model');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			$this->data['users'] = $this->user_model->get_users();
			$this->template->admin_render('admin/users/index', $this->data);
		}
	}

	public function toggle_is_active(){
		$uid = $this->input->post('uid');
		$this->load->model('admin/user_model');
		echo $this->user_model->toggle_is_active($uid);
	}
	
	public function set_user(){
		$uid = $this->input->post('uid');
		$id = $this->input->post('id');
		$pw = $this->input->post('pw');
		$name = $this->input->post('name');
		$this->load->model('admin/user_model');
		echo $this->user_model->set_user($uid, $id, $pw, $name);
	}

	public function get_missions(){
		$uid = $this->input->post('uid');
		$this->load->model('admin/user_level_model');
		$res = $this->user_level_model->get_missions($uid);
		header('Content-Type: application/json');
		echo json_encode($res);
	}

	public function set_mission(){
		$uid = $this->input->post('uid');
		$point = $this->input->post('point');
		$this->load->model('admin/user_level_model');
		echo $this->user_level_model->set_mission($uid, $point);
	}

	public function reset_missions(){
		$uid = $this->input->post('uid');
		$this->load->model('admin/user_level_model');
		echo $this->user_level_model->reset_missions($uid);
	}
}
