<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Survey_results extends Admin_Controller {
	public function __construct(){
		parent::__construct();
		$this->page_title->push('Survey Results');
		$this->data['pagetitle'] = $this->page_title->show();
		$this->breadcrumbs->unshift(1, 'Survey Results', 'admin/suvey_results');
		$this->output->delete_cache();
	}

	public function index(){
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin()){
			redirect('auth/login', 'refresh');
		}else{
			$this->load->model('admin/survey_result_model');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			$this->data['surveys'] = $this->survey_result_model->gets();
			$this->data['questions'] = $this->survey_result_model->get_surveys();
			$this->template->admin_render('admin/survey_results/index', $this->data);
		}
	}

	public function get_answers(){
		$index = $this->input->post('index');
		$this->load->model('admin/survey_result_model');
		//echo print_r($this->survey_result_model->get_answers($index)[0]->answers);
		//return;
		echo json_encode($this->survey_result_model->get_answers($index)[0]->answers);
	}

	public function set_media(){
		$uid = $this->input->post('uid');
		$path = $this->input->post('path');
		$this->load->model('admin/path_model');
		echo $this->path_model->set_path($uid, $path);
	}

	function gen_uid(){
		$data = random_bytes(16);
		$data[6] = chr(ord($data[6]) & 0x0f | 0x40);
		$data[8] = chr(ord($data[8]) & 0x3f | 0x80);
		return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
	}
}
