<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pictures extends Admin_Controller {
	public function __construct(){
		parent::__construct();
		$this->page_title->push('Pictures');
		$this->data['pagetitle'] = $this->page_title->show();
		$this->breadcrumbs->unshift(1, 'Pictures', 'admin/pictures');
		$this->output->delete_cache();
	}

	public function index(){
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin()){
			redirect('auth/login', 'refresh');
		}else{
			$this->load->model('admin/picture_model');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			$this->data['pictures'] = $this->picture_model->gets();
			$this->template->admin_render('admin/pictures/index', $this->data);
		}
	}

	public function toggle_is_active(){
		$uid = $this->input->post('index');
		$this->load->model('admin/picture_model');
		echo $this->picture_model->toggle_is_active($uid);
	}
}
