<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Medias extends Admin_Controller {
	public function __construct(){
		parent::__construct();
		$this->page_title->push('Medias');
		$this->data['pagetitle'] = $this->page_title->show();
		$this->breadcrumbs->unshift(1, 'Medias', 'admin/medias');
		$this->output->delete_cache();
	}

	public function index(){
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin()){
			redirect('auth/login', 'refresh');
		}else{
			$this->load->model('admin/media_model');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			$this->data['medias'] = $this->media_model->get_medias();
			$this->template->admin_render('admin/medias/index', $this->data);
		}
	}

	public function set_media(){
		$uid = $this->input->post('uid');
		$path = $this->input->post('path');
		$this->load->model('admin/path_model');
		echo $this->path_model->set_path($uid, $path);
	}

	function gen_uid(){
		$data = random_bytes(16);
		$data[6] = chr(ord($data[6]) & 0x0f | 0x40);
		$data[8] = chr(ord($data[8]) & 0x3f | 0x80);
		return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
	}
}
