<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fwords extends Admin_Controller {
	public function __construct(){
		parent::__construct();
		$this->page_title->push('Fwords');
		$this->data['pagetitle'] = $this->page_title->show();
		$this->breadcrumbs->unshift(1, 'Fwords', 'admin/fwords');
		$this->output->delete_cache();
	}

	public function index(){
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin()){
			redirect('auth/login', 'refresh');
		}else{
			$this->load->model('admin/fword_model');
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			//$this->data['fwords'] = $this->fword_model->get_fwords();
			$this->template->admin_render('admin/fwords/index', $this->data);
		}
	}

	public function toggle_is_active(){
		$word = $this->input->post('word');
		$this->load->model('admin/fword_model');
		echo $this->fword_model->toggle_is_active($word);
	}
	
	public function add_fword(){
		$word = $this->input->post('word');
		$this->load->model('admin/fword_model');
		echo $this->fword_model->add_fword($word);
	}

	public function get_fwords_page(){
		$search = (strlen($this->input->get("search")["value"]) >= 2) ? $this->input->get("search",true)["value"] : false;
		$start = intval($this->input->get('start'));
		$offset = intval($this->input->get('length'));
		$this->load->model('admin/fword_model');
		$datas = $this->fword_model->get_fwords_page($search, $start, $offset);
		$query = $this->db->last_query();
		$count = $this->fword_model->get_fwords_page_count($search);

		echo json_encode(
			Array(
				'draw' => $_GET['draw'],
				'data' => $datas,
				'query' => $query,
				'recordsTotal' => $count,
				'recordsFiltered' => $count,
				'pageNumber' => ceil($start / $offset) + 1,
				'pageSize' => ceil($count / $offset) + 1,
			)
		);
	}
}
