<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends MY_Controller {

	function __construct()
	{
		parent::__construct();

		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
		$this->lang->load('auth');
	}


	function index(){
	        if ( ! $this->ion_auth->logged_in()){
			redirect('auth/login', 'refresh');
		}else{
			redirect('/', 'refresh');
		}
	}

	function login(){
		if ( ! $this->ion_auth->logged_in()){
			/* Load */
			$this->load->config('admin/dp_config');
			$this->load->config('common/dp_config');
			$this->load->model('admin/user_model');

			/* Valid form */
			$this->form_validation->set_rules('identity', 'Identity', 'required');
			$this->form_validation->set_rules('password', 'Password', 'required');

			/* Data */
			$this->data['title']               = $this->config->item('title');
			$this->data['title_lg']            = $this->config->item('title_lg');
			$this->data['auth_social_network'] = $this->config->item('auth_social_network');
			$this->data['forgot_password']     = $this->config->item('forgot_password');
			$this->data['new_membership']      = $this->config->item('new_membership');

			if ($this->form_validation->run() == TRUE){
				if($this->user_model->login($this->input->post('identity'), $this->input->post('password')) == TRUE){
					$this->ion_auth->is_admin();
					$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
					$this->session->set_userdata('id', $this->input->post('identity'));
					$this->session->set_userdata('identity', $this->input->post('identity'));
					//$this->template->auth_render('auth/choice', $this->data);
					redirect('admin', 'refresh');
		                }else{
					$this->session->set_flashdata('message', '<span style="color:red;">존재하지 않는 회원 정보입니다.</span>');
					redirect('auth/login', 'refresh');
				}
			}else{
				$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
				$this->data['identity'] = array(
					'name'        => 'identity',
					'id'          => 'identity',
					'type'        => 'email',
					'value'       => $this->form_validation->set_value('identity'),
					'class'       => 'form-control',
					'placeholder' => lang('auth_your_email')
				);
				$this->data['password'] = array(
					'name'        => 'password',
					'id'          => 'password',
					'type'        => 'password',
					'class'       => 'form-control',
					'placeholder' => lang('auth_your_password')
				);
				$this->template->auth_render('auth/login', $this->data);
			}
		}else{
			redirect('/', 'refresh');
		}
	}


    function logout($src = NULL)
	{
        $logout = $this->ion_auth->logout();

        $this->session->set_flashdata('message', $this->ion_auth->messages());

        if ($src == 'admin')
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            redirect('/', 'refresh');
        }
	}

}
