# 서버 백업 시스템

이 디렉토리는 금도 서버의 데이터 백업 관련 스크립트 및 가이드를 제공합니다.

## 개요

서버 백업 시스템은 다음과 같은 주요 기능을 제공합니다:

1. 소스 코드 및 업로드 파일의 증분 백업
2. 압축 백업 파일 생성 
3. 월별 백업 로테이션 및 미러링
4. 원격 서버로 백업 파일 전송

## 디렉토리 구조

```
/data/
  ├── backup/
  │   ├── source/       # 원본 백업 저장
  │   ├── compress/     # 압축된 백업 파일
  │   └── mirror/       # 미러링 백업 저장 (연도별/월별)
  ├── webapps/          # 웹 애플리케이션 디렉토리
  └── upload/           # 업로드 파일 디렉토리
```

## 백업 스크립트 소개

### 1. source_backup.sh

웹앱과 업로드 디렉토리에 대한 증분 백업을 수행하는 스크립트입니다.

주요 기능:
- rsync를 사용한 증분 백업 구현
- 백업 디렉토리 자동 생성
- 압축 백업 파일 생성

### 2. geumdo_mirror_backup.sh

월별 백업 로테이션을 관리하고 원격 서버로 백업 파일을 전송하는 스크립트입니다.

주요 기능:
- 월별 백업 디렉토리 생성
- 6개월 이상 지난 백업 자동 삭제
- lftp를 사용하여 원격 FTP 서버로 백업 파일 전송

### 3. iact_mirror_backup.sh

IACT 서버를 위한 미러 백업 스크립트입니다.

주요 기능:
- 월별 백업 디렉토리 생성
- 6개월 이상 지난 백업 자동 삭제
- 내부 네트워크를 통한 백업 파일 전송

### 4. last_day_of_month.sh

월의 마지막 날을 확인하는 유틸리티 스크립트입니다. 월말 백업 작업에 활용할 수 있습니다.

## 백업 전략

### 백업 대상
- 웹 애플리케이션 소스 코드
- 사용자 업로드 파일
- Docker 데이터 및 설정 파일

### 백업 주기
- 일일 백업: 중요 데이터
- 월별 백업: 전체 시스템

### 백업 로테이션
- 최근 6개월 백업 데이터 유지
- 오래된 백업 자동 삭제

## 백업 자동화

다음과 같이 crontab을 설정하여 백업을 자동화할 수 있습니다:

```
# 매일 오전 3시에 소스 백업 실행
0 3 * * * /path/to/source_backup.sh

# 매일 오전 4시에 미러 백업 실행
0 4 * * * /path/to/geumdo_mirror_backup.sh

# 월말에만 특정 백업 작업 실행
0 5 * * * /path/to/last_day_of_month.sh && /path/to/특정_백업_스크립트.sh
```

## 원격 백업 설정

서버 백업 시스템은 lftp를 사용하여 다음과 같이 원격 FTP 서버로 백업 파일을 전송합니다:

```bash
lftp -c "open -u USERNAME,PASSWORD FTP서버주소 -p 포트번호; mirror -R 로컬디렉토리 원격디렉토리"
```

### lftp 설치 방법

**1. CentOS / Rocky Linux / RHEL**
```bash
# EPEL 저장소 추가 (필요한 경우)
sudo yum install -y epel-release

# lftp 설치
sudo yum install -y lftp
```

**2. Ubuntu / Debian**
```bash
# 패키지 목록 업데이트
sudo apt update

# lftp 설치
sudo apt install -y lftp
```

**3. Fedora**
```bash
sudo dnf install -y lftp
```

**4. openSUSE / SUSE Linux**
```bash
sudo zypper install -y lftp
```

**5. Alpine Linux**
```bash
sudo apk add lftp
```

## 참고 문서

더 자세한 백업 정보는 다음 파일을 참조하세요:
- [Docker 백업 가이드](server_backup_guide.md)

## 주의사항

- 백업 스크립트에 포함된 비밀번호는 보안상 위험이 있으므로 실제 운영 환경에서는 환경 변수나 별도의 보안 저장소를 사용하는 것을 권장합니다.
- 백업 파일은 정기적으로 복원 테스트를 수행하여 정상 작동하는지 확인해야 합니다. 