# Nginx 프록시 설정 분석 (완성본)

이 문서는 제공된 Nginx 설정 파일을 바탕으로 현재 구성된 프록시 서버의 구조와 주요 설정을 설명합니다. 개발자들이 애플리케이션 배포 및 트러블슈팅 시 참고할 수 있도록 작성되었습니다.

## 1. 개요

현재 Nginx 설정은 메인 설정 파일인 `/etc/nginx/nginx.conf`와 가상 호스트 설정 파일들이 위치하는 `/etc/nginx/sites-enabled/` 디렉토리의 조합으로 구성되어 있습니다.

- **`nginx.conf`**: Nginx 프로세스의 동작 방식, 로그 형식, SSL/TLS 기본 설정 등 전역적인 설정을 담당합니다.
- **`/etc/nginx/sites-enabled/`**: 각 도메인 또는 서비스에 대한 구체적인 프록시 규칙, 서버 블록(`server { ... }`)을 정의합니다. `nginx.conf`에서 이 디렉토리의 모든 파일을 `include`하여 설정을 불러옵니다.

## 2. 메인 설정 분석 (`/etc/nginx/nginx.conf`)

`nginx.conf` 파일의 주요 설정은 다음과 같습니다.

- **`user gds;`**: Nginx 워커 프로세스가 `gds` 사용자 권한으로 실행됩니다. (기본값: `www-data`)
- **`worker_processes auto;`**: 서버의 CPU 코어 수에 맞춰 워커 프로세스 수가 자동으로 조절됩니다.
- **`worker_connections 8092;`**: 각 워커 프로세스는 최대 8092개의 동시 연결을 처리할 수 있습니다.
- **`client_max_body_size 300M;`**: 클라이언트가 요청 시 보낼 수 있는 본문(body)의 최대 크기를 300MB로 설정하여 대용량 파일 업로드를 허용합니다.
- **`proxy_*_timeout 1800;`**: 프록시 관련 타임아웃이 1800초(30분)로 길게 설정되어 있어, 오래 걸리는 백엔드 작업에 대응할 수 있습니다.
- **`log_format custom_log ...`**: 커스텀 로그 형식을 정의하여 더 상세한 정보를 기록합니다.
- **`gzip on;`**: 응답을 압축하여 전송함으로써 네트워크 대역폭을 절약합니다.
- **`ssl_protocols TLSv1 TLSv1.1 TLSv1.2 TLSv1.3;`**: 보안을 위해 TLS 1.0 이상의 프로토콜만 사용하도록 설정되어 있습니다.
- **`include /etc/nginx/sites-enabled/*;`**: `sites-enabled` 디렉토리 내의 모든 설정 파일을 불러와 가상 호스트로 사용합니다.

## 3. 가상 호스트 분석 (`/etc/nginx/sites-enabled/`)

`sites-enabled` 디렉토리의 설정 파일을 분석하여 서비스 유형별로 분류했습니다.

### 3.1. 리버스 프록시 (Reverse Proxy) 목록

Nginx가 백엔드 애플리케이션 서버로 요청을 전달하는 리버스 프록시 목록입니다.

| 설정 파일                          | 도메인 (server_name)                                                                                                                                                                                                                                                             | 프록시 대상 (proxy_pass)                | 비고                                     |
| ---------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------- | ---------------------------------------- |
| `3dp_nextcloud.conf`               | `3dp-nextcloud.geumdo.net`                                                                                                                                                                                                                                                       | `http://192.168.0.235`                  |                                          |
| `ai_was.conf`                      | `gdlab.co.kr www.gdlab.co.kr`                                                                                                                                                                                                                                                     | `https://192.168.0.166:4333`            | SSL 적용                                 |
| `fastapi.conf`                     | `fastapi.geumdo.net`                                                                                                                                                                                                                                                             | `http://192.168.0.166:8000`             |                                          |
| `fastapi_new.conf`                 | `fastapi-new.geumdo.net`                                                                                                                                                                                                                                                         | `http://192.168.0.166:8001`             |                                          |
| `flask_proxy.conf`                 | `proxy.geumdo.net`                                                                                                                                                                                                                                                               | `https://192.168.0.166:3001`            | SSL 적용 (Certbot)                       |
| `flaskapi.conf`                    | `flaskapi.geumdo.net`                                                                                                                                                                                                                                                            | `http://192.168.0.236:3000`             |                                          |
| `g3d-test.conf`                    | `g3d-test.geumdo.net`                                                                                                                                                                                                                                                            | `http://192.168.0.235:8090`             |                                          |
| `gbax.conf`                        | `gbmax.or.kr`                                                                                                                                                                                                                                                                    | `http://192.168.0.236:8092`             | SSL 적용, `www` 서브도메인 리다이렉트      |
| `geumdo_desktop_docker.conf`       | `g3d.geumdo.net`                                                                                                                                                                                                                                                                 | `http://192.168.0.11:8091`              |                                          |
| `geumdo_desktop_docker.conf`       | `geumdo.net www.geumdo.net`                                                                                                                                                                                                                                                      | `https://192.168.0.11:4445`             | SSL 적용, HTTP to HTTPS 리다이렉트      |
| `geumdo_java.conf`                 | `gbtp.geumdo.net`, `ems.geumdo.net`, `gds-ems.geumdo.net`, `meeting.geumdo.net`, `auth.geumdo.net`, `hub.geumdo.net`, `dgse.geumdo.net`, `survey.geumdo.net`, `assign.geumdo.net`, `lms.ictcog.geumdo.net`, `recruit-cc.geumdo.net`, `report.geumdo.net`, `dmi-recruit.geumdo.net`, `play.geumdo.net`, `gbsos.geumdo.net` | `http://localhost:8083`                 | 여러 도메인을 하나의 백엔드로 연결      |
| `geumdo_java.conf`                 | (위와 동일)                                                                                                                                                                                                                                                                          | `http://localhost:3690`                 | `/svn` 경로 요청은 SVN 서버로 프록시    |
| `geumdo_java_upgrade.conf`         | `dip-zero.geumdo.net`                                                                                                                                                                                                                                                            | `https://192.168.0.166:4444`            | SSL 적용 (Certbot)                       |
| `geumdo_java_upgrade_http.conf`    | `max.geumdo.net`, `gbmax.geumdo.net`, `mobility.geumdo.net`, `eval-new.geumdo.net`, `vnexa.geumdo.net`                                                                                                                                                                             | `http://192.168.0.166:8093`             | 여러 도메인을 하나의 백엔드로 연결      |
| `geumdo_ollama_docker.conf`        | `ollama.geumdo.net`                                                                                                                                                                                                                                                              | `http://192.168.0.166:11434`            |                                          |
| `geumdo_ollamaui_docker.conf`      | `ollamaui.geumdo.net`                                                                                                                                                                                                                                                            | `http://192.168.0.70:9000`              |                                          |
| `geumdo_posivibes.conf`            | `posivibes.geumdo.net`                                                                                                                                                                                                                                                           | `http://localhost:8084`                 |                                          |
| `geumdo_registry.conf`             | `118.45.160.139`                                                                                                                                                                                                                                                                 | `http://localhost:5001`                 | Docker Registry 프록시                   |
| `gitlab.conf`                      | `gitlab.geumdo.net`                                                                                                                                                                                                                                                              | `http://gitlab.geumdo.net:8081`         |                                          |
| `iptime.conf`                      | `setting.geumdo.net`                                                                                                                                                                                                                                                             | `http://192.168.0.1:80`                 | 공유기 설정 페이지 프록시                 |
| `jobttp.conf`                      | `tech.jobttp.geumdo.net`, `biz.jobttp.geumdo.net`, 등 다수                                                                                                                                                                                                                         | `http://localhost:8084`                 | 여러 서브도메인을 하나의 백엔드로 연결   |
| `jupyter.conf`                     | `jupyter.geumdo.net`                                                                                                                                                                                                                                                             | `http://jupyter.geumdo.net:8888`        | WebSocket 지원                           |
| `jupyter_gpu.conf`                 | `jupyter-gpu.geumdo.net`                                                                                                                                                                                                                                                         | `http://192.168.0.70:8888`              | WebSocket 지원                           |
| `jupyter_gpu2.conf`                | `jupyter-gpu2.geumdo.net`                                                                                                                                                                                                                                                        | `http://192.168.0.71:8888`              | WebSocket 지원                           |
| `msis.conf`                        | `msis.kr`                                                                                                                                                                                                                                                                        | `http://192.168.0.3:3000`               |                                          |
| `nas.conf`                         | `nas.geumdo.net`                                                                                                                                                                                                                                                                 | `http://192.168.0.16:5000`              | Synology NAS 프록시                      |
| `posteio.conf`                     | `mail.geumdo.net`                                                                                                                                                                                                                                                                | `https://mail.geumdo.net:4433`          | SSL 적용 (Certbot)                       |
| `prusa1.conf`                      | `prusa1.geumdo.net`                                                                                                                                                                                                                                                              | `http://192.168.0.43`                   | 3D 프린터 프록시                         |
| `rvtouch3d-api.conf`               | `rvtouch3d-api.geumdo.net`                                                                                                                                                                                                                                                       | `http://192.168.0.70:8001`              | Prometheus, Grafana 경로 분기            |
| `rvtouch3d-front-test.conf`        | `rvtouch3d-test.geumdo.net`                                                                                                                                                                                                                                                      | `http://192.168.0.70:3002`              |                                          |
| `sw3d-dev.conf`                    | `sw3d-dev.geumdo.net`                                                                                                                                                                                                                                                            | `http://192.168.0.235:8080`             |                                          |
| `tpeap.conf`                       | `wifi.dgei.or.kr`                                                                                                                                                                                                                                                                | `http://192.168.0.61:38088`             |                                          |
| `vnexa_api.conf`                   | `vnexa-api.geumdo.net`                                                                                                                                                                                                                                                           | `http://192.168.0.70:8000`              | SSE 지원                                 |
| `ynax.conf`                        | `max.or.kr`                                                                                                                                                                                                                                                                      | `http://192.168.0.236:8092`             | SSL 적용, `www` 서브도메인 리다이렉트      |

### 3.2. PHP-FPM 연동 사이트 목록

Nginx가 직접 PHP 코드를 실행하기 위해 PHP-FPM(FastCGI Process Manager)으로 요청을 넘기는 사이트 목록입니다. PHP 버전에 따라 분류되었습니다.

#### PHP 7.4-FPM (`unix:/var/run/php/php7.4-fpm.sock`)

| 설정 파일             | 도메인 (server_name)          | 웹 루트 (root)                  |
| --------------------- | ----------------------------- | ------------------------------- |
| `aifor.conf`          | `aifor.geumdo.net`            | `/webFolder/aifor/public`       |
| `boardtest.conf`      | `boardtest.geumdo.net`        | `/webFolder/boardtest/public`   |
| `choi.conf`           | `choi.geumdo.net`             | `/webFolder/choi/public`        |
| `ckeditor.conf`       | `ck.geumdo.net`               | `/webFolder/ckeditor`           |
| `com.conf`            | `com.geumdo.net`              | `/webFolder/com/public`         |
| `cp.conf`             | `cp.geumdo.net`               | `/webFolder/component`          |
| `cubi.conf`           | `cubi.geumdo.net`             | `/webFolder/cubi`               |
| `cubicon.conf`        | `cubicon.geumdo.net`          | `/webFolder/cubicon`            |
| `daeguw.conf`         | `daeguw.geumdo.net`           | `/webFolder/daeguw`             |
| `design.conf`         | `design.geumdo.net`           | `/webFolder/design`             |
| `design2.conf`        | `design2.geumdo.net`          | `/webFolder/design2`            |
| `design3.conf`        | `design3.geumdo.net`          | `/webFolder/design3`            |
| `dgei.conf`           | `dgei.geumdo.net`             | `/webFolder/dgei/public`        |
| `dongbang.conf`       | `dongbang.geumdo.net`         | `/webFolder/dongbang/`          |
| `dsa.conf`            | `dsa.geumdo.net`              | `/webFolder/dsa/public`         |
| `facility.conf`       | `facility.geumdo.net`         | `/webFolder/facility/public`    |
| `geumdo-test.conf`    | `geumdo-test.geumdo.net`      | `/webFolder/geumdo`             |
| `hmg.conf`            | `hmg.geumdo.net`              | `/webFolder/hmg/public`         |
| `ictcog.conf`         | `ictcog.geumdo.net`           | `/webFolder/ictcog/public`      |
| `imdp.conf`           | `imdp.geumdo.net`             | `/webFolder/imdp/public`        |
| `imdp_old.conf`       | `imdp-old.geumdo.net`         | `/webFolder/imdp_old/public`    |
| `jwt.conf`            | `jwt.geumdo.net`              | `/webFolder/jwt/public`         |
| `khvatec.conf`        | `khvatec.geumdo.net`          | `/webFolder/khvatec`            |
| `lac2.conf`           | `lac2.geumdo.net`             | `/webFolder/lac2/public`        |
| `men.conf`            | `men.geumdo.net`              | `/webFolder/men/html`           |
| `mpk.conf`            | `mpk2.geumdo.net`             | `/webFolder/mpk`                |
| `mt.conf`             | `mt.geumdo.net`               | `/webFolder/mt`                 |
| `odin.conf`           | `odin.geumdo.net`             | `/webFolder/odin/html`          |
| `passqr.conf`         | `passqr.geumdo.net`           | `/webFolder/passqr`             |
| `passwifi.conf`       | `passwifi.geumdo.net`         | `/webFolder/passWiFi`           |
| `phpinfo.php`         | `phpinfo.geumdo.net`          | `/webFolder5.6/phpinfo`         |
| `pms.conf`            | `pms.geumdo.net`              | `/webFolder/pms`                |
| `project.conf`        | `project.geumdo.net`          | `/webFolder/project/public`     |
| `rcit.conf`           | `rcit.geumdo.net`             | `/webFolder/rcit/public`        |
| `rully.conf`          | `rully.geumdo.net`            | `/webFolder/rully`              |
| `satisfy.conf`        | `satisfy.geumdo.net`          | `/webFolder/satisfy/public`     |
| `sian.conf`           | `sian.geumdo.net`             | `/webFolder/sian`               |
| `skin.conf`           | `skin.geumdo.net`             | `/webFolder/skin`               |
| `smartmdp.conf`       | `smartmdp.geumdo.net`         | `/webFolder/smartmdp/public`    |
| `smartvillage.conf`   | `smartvillage.geumdo.net`     | `/webFolder/smartvillage/public`|
| `sms_laravel.conf`    | `sms.geumdo.net`              | `/webFolder/sms_laravel/public` |
| `test.conf`           | `test.geumdo.net`             | `/webFolder/geumdo`             |
| `todo_list.conf`      | `todo.geumdo.net`             | `/webFolder/todo_list`          |
| `tva.conf`            | `tva.geumdo.net`              | `/webFolder/moi`                |
| `tva2.conf`           | `tva2.geumdo.net`             | `/webFolder/moi2/public`        |

#### PHP 5.6-FPM (`unix:/var/run/php/php5.6-fpm.sock`)

| 설정 파일          | 도메인 (server_name)       | 웹 루트 (root)                         |
| ------------------ | -------------------------- | -------------------------------------- |
| `3dprinter.conf`   | `3dprinter.geumdo.net`     | `/webFolder5.6/3dprinter`              |
| `dghope.conf`      | `dghope.geumdo.net`        | `/webFolder5.6/ces`                    |
| `g3d-dev.conf`     | `g3d-dev.geumdo.net`       | `/webFolder/g3d_dev`                   |
| `gds_eval.conf`    | `eval.geumdo.net`          | `/webFolder5.6/gds_eval/public_html`   |
| `iact.conf`        | `iact.geumdo.net`          | `/webFolder5.6/iact`                   |
| `ictcog_gnu.conf`  | `ictcog-gnu.geumdo.net`    | `/webFolder5.6/ictcog_gnu`             |
| `imaker.conf`      | `imaker.geumdo.net`        | `/webFolder5.6/imaker`                 |
| `lac.conf`         | `lac.geumdo.net`           | `/webFolder5.6/lac/public_html`        |
| `mailer.conf`      | `mailer.geumdo.net`        | `/webFolder/nmail2/nmail`              |
| `makedaegu.conf`   | `makedaegu.geumdo.net`     | `/webFolder5.6/makedaegu`              |
| `sabg_survey.conf` | `survey.gdlab.co.kr`       | `/webFolder/sabg_survey`               |
| `sms_dgei.conf`    | `sms-gnu.geumdo.net`       | `/webFolder5.6/sms_dgei/public_html`   |
| `sw3d_php.conf`    | `sw3d.geumdo.net`          | `/webFolder5.6/sw3d`                   |
| `upcycle.conf`     | `upcycle.geumdo.net`       | `/webFolder5.6/upcycle/public_html`    |
| `visitor.conf`     | `visitor.geumdo.net`       | `/webFolder5.6/visitor/public_html`    |

### 3.3. SSL/TLS 적용 사이트 목록

HTTPS를 사용하는 사이트 목록입니다. `Certbot`으로 관리되는 인증서는 자동으로 갱신됩니다.

| 설정 파일                      | 도메인 (server_name)          | 인증서 관리                                           | 비고                                     |
| ------------------------------ | ----------------------------- | ----------------------------------------------------- | ---------------------------------------- |
| `ai_was.conf`                  | `gdlab.co.kr www.gdlab.co.kr` | 수동 (`/etc/nginx/ssl/gdlab.co.kr/`)                  | HTTP to HTTPS 리다이렉트                 |
| `flask_proxy.conf`             | `proxy.geumdo.net`            | Certbot (`/etc/letsencrypt/live/proxy.geumdo.net/`)   | HTTP to HTTPS 리다이렉트                 |
| `gbax.conf`                    | `gbmax.or.kr`                 | 수동 (`/etc/nginx/ssl/gbmax.or.kr/`)                  | `www` 리다이렉트, HTTP to HTTPS 리다이렉트 |
| `geumdo_desktop_docker.conf`   | `geumdo.net www.geumdo.net`   | 수동 (`/etc/nginx/ssl/geumdo.net/`)                   | HTTP to HTTPS 리다이렉트                 |
| `geumdo_java_upgrade.conf`     | `dip-zero.geumdo.net`         | Certbot (`/etc/letsencrypt/live/dip-zero.geumdo.net/`) | HTTP to HTTPS 리다이렉트                 |
| `posteio.conf`                 | `mail.geumdo.net`             | Certbot (`/etc/letsencrypt/live/mail.geumdo.net/`)     | HTTP to HTTPS 리다이렉트                 |
| `ynax.conf`                    | `max.or.kr`                   | 수동 (`/etc/nginx/ssl/max.or.kr/`)                    | `www` 리다이렉트, HTTP to HTTPS 리다이렉트 |
| `default`                      | `_` (기본 서버)               | 수동 (`/etc/nginx/ssl-certs/nginx.crt`)               | 일치하는 도메인 없는 443 요청 처리 (444 반환) |

### 3.4. 특수 설정

#### WebSocket 지원

Jupyter Notebook/Lab과 같이 실시간 양방향 통신이 필요한 서비스를 위해 WebSocket을 지원하도록 설정된 프록시입니다.

-   **`jupyter.conf`**: `jupyter.geumdo.net` -> `http://jupyter.geumdo.net:8888`
-   **`jupyter_gpu.conf`**: `jupyter-gpu.geumdo.net` -> `http://192.168.0.70:8888`
-   **`jupyter_gpu2.conf`**: `jupyter-gpu2.geumdo.net` -> `http://192.168.0.71:8888`

#### SSE (Server-Sent Events) 지원

`vnexa-api.geumdo.net` 서비스는 서버에서 클라이언트로 단방향 데이터 스트리밍을 위한 SSE를 지원합니다. 이를 위해 `/api/v1/sse/` 경로에 대해 응답 버퍼링을 끄고(`proxy_buffering off;`), 연결을 오래 유지하도록 타임아웃을 길게 설정했습니다.

-   **`vnexa_api.conf`**: `vnexa-api.geumdo.net` -> `http://192.168.0.70:8000`

#### 기타: 기본 서버 블록 (`default`)

-   `server_name`이 일치하는 가상 호스트가 없을 경우, 모든 **HTTP(80) 요청**은 **404 Not Found**를 반환합니다.
-   일치하는 `server_name`이 없는 **HTTPS(443) 요청**에 대해서는 응답 없이 연결을 즉시 종료하는 **444 Connection Closed Without Response**를 반환하여 보안을 강화합니다.

---