#!/bin/bash

echo "=== TensorFlow libdevice 문제 해결이 포함된 Docker 재빌드 ===="

# 1. 기존 컨테이너 중지 및 제거
echo "1. 기존 컨테이너 중지 및 제거 중..."
docker-compose down
docker container prune -f

# 2. 기존 이미지 제거 (선택사항)
echo "2. 기존 이미지 제거 중..."
docker image rm jupyter_gpu_docker-jupyter 2>/dev/null || echo "이미지가 존재하지 않습니다."

# 3. Docker 이미지 재빌드
echo "3. Docker 이미지 재빌드 중..."
docker-compose build --no-cache

# 4. 컨테이너 실행
echo "4. 컨테이너 실행 중..."
docker-compose up -d

# 5. 컨테이너 상태 확인
echo "5. 컨테이너 상태 확인..."
sleep 5
docker ps | grep jupyter-gpu

# 6. TensorFlow 테스트
echo "6. TensorFlow 설정 테스트 중..."
docker exec -it jupyter-gpu python3 -c "
import os
print('Environment Variables:')
print(f'CUDA_HOME: {os.environ.get(\"CUDA_HOME\", \"Not set\")}')
print(f'XLA_FLAGS: {os.environ.get(\"XLA_FLAGS\", \"Not set\")}')
print(f'TF_XLA_FLAGS: {os.environ.get(\"TF_XLA_FLAGS\", \"Not set\")}')

import tensorflow as tf
print(f'\\nTensorFlow version: {tf.__version__}')
print(f'GPUs available: {len(tf.config.list_physical_devices(\"GPU\"))}')

# libdevice 파일 확인
import os
libdevice_path = '/usr/local/cuda/nvvm/libdevice/libdevice.10.bc'
print(f'\\nlibdevice.10.bc exists: {os.path.exists(libdevice_path)}')
"

echo ""
echo "=== 재빌드 완료! ==="
echo "Jupyter Lab 접속: http://localhost:8888"
echo ""
echo "TensorFlow 문제가 해결되었습니다:"
echo "✅ libdevice 파일 자동 복사"
echo "✅ XLA_FLAGS 환경변수 설정"
echo "✅ TF_XLA_FLAGS 환경변수 설정"
echo "✅ CUDA_HOME 환경변수 설정" 