# 범용 GPU 딥러닝 연구 환경 (Jupyter)

본 프로젝트는 Docker를 사용하여 TensorFlow와 PyTorch를 모두 지원하는 고성능, 범용 딥러닝 연구 환경을 구축합니다. GPU 가속, 최신 Hugging Face 라이브러리, 한국어 자연어 처리, 실시간 리소스 모니터링 기능을 통합하여 제공합니다.

## 기술 아키텍처

-   **`Dockerfile`**: `nvidia/cuda:12.4.1-base-ubuntu22.04`를 베이스 이미지로 사용하여 NVIDIA 드라이버와 CUDA 12.4.1 환경을 기반으로 합니다.
    -   **핵심 의존성**:
        -   **Python 3.10**: 기본 개발 언어.
        -   **cuDNN 9.3**: 특정 딥러닝 프레임워크 버전과의 호환성을 위해 수동으로 설치되는 CUDA 딥러닝 가속 라이브러리.
        -   **Mecab-ko & KoNLPy**: 한국어 형태소 분석 및 자연어 처리를 위해 소스 컴파일 방식으로 설치됩니다.
        -   **Jupyter Lab**: 웹 기반의 대화형 개발 환경을 제공하며, Docker 컨테이너 내에서 원활하게 실행되도록 외부 접속 및 루트 권한 실행이 사전에 설정됩니다.
    -   **문제 해결**: TensorFlow 실행 시 발생할 수 있는 `libdevice` 경로 문제를 해결하는 로직이 포함되어 있습니다.

-   **`docker-compose.yml`**:
    -   **GPU 자원 할당**:
        -   `runtime: nvidia`: Docker 컨테이너가 호스트 시스템의 NVIDIA GPU에 접근할 수 있도록 설정합니다.
        -   `NVIDIA_VISIBLE_DEVICES=all`: 호스트의 모든 GPU를 컨테이너가 사용할 수 있도록 합니다.
    -   **GPU 메모리 관리**: `TF_FORCE_GPU_ALLOW_GROWTH=true` 환경 변수를 설정하여 TensorFlow가 필요한 만큼의 GPU 메모리만 점진적으로 할당하도록 하여 메모리 효율성을 높입니다.
    -   **데이터 영속성**: 호스트의 `./workspace` 디렉토리를 컨테이너의 `/workspace`로 마운트하여, 노트북 파일, 데이터셋, 스크립트 등 모든 작업물을 컨테이너가 재시작되어도 안전하게 보존합니다.

## 기술 스택 및 주요 라이브러리

-   **오케스트레이션**: Docker, Docker Compose
-   **GPU 기술**: NVIDIA CUDA 12.4.1, cuDNN 9.3
-   **딥러닝 프레임워크**: TensorFlow, Keras, PyTorch
-   **자연어 처리 (NLP)**:
    -   **Hugging Face Ecosystem**: `transformers`, `datasets`, `sentencepiece`
    -   **한국어 처리**: `konlpy`, `Mecab-ko` (내부 설치)
-   **데이터 과학**: NumPy, Pandas, Scikit-learn, Matplotlib, Seaborn
-   **Jupyter 확장 기능**:
    -   `jupyterlab-nvdashboard`: Jupyter Lab 내에서 GPU 사용률, 메모리, 온도 등을 실시간으로 모니터링하는 대시보드.
    -   `jupyter-resource-usage`: 노트북 내에서 메모리 사용량 표시.

## 실행 방법

### 사전 요구사항

-   NVIDIA GPU가 장착된 호스트 시스템
-   호스트에 설치된 NVIDIA 드라이버
-   Docker 및 Docker Compose
-   NVIDIA Container Toolkit (docker가 `runtime: nvidia` 옵션을 사용하기 위해 필요)

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_with_fix.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```

2.  **Jupyter Lab 접속**:
    -   컨테이너가 실행된 후, 터미널에서 `docker logs jupyter-gpu` 명령어를 실행하여 Jupyter Lab 접속 URL과 토큰을 확인할 수 있습니다. (단, 본 설정에서는 토큰이 비활성화되어 있음)
    -   웹 브라우저에서 `http://<서버_IP>:8888`로 접속합니다.

3.  **GPU 사용 확인**:
    -   Jupyter Lab에 접속한 후, 터미널을 열고 `nvidia-smi` 명령어를 실행하여 GPU가 정상적으로 인식되는지 확인합니다.
    -   `jupyterlab-nvdashboard` 확장을 통해 GPU 상태를 실시간으로 모니터링할 수 있습니다.

### 중지

```bash
docker-compose down
``` 