# Kubernetes 기반 다중 사용자 JupyterHub 서비스

본 프로젝트는 Docker 컨테이너 기반이 아닌, **Kubernetes(K8s) 클러스터 환경에 다중 사용자를 위한 JupyterHub를 배포하고 운영**하기 위한 전체 설정 파일 및 스크립트 모음입니다. Google OAuth 인증, 동적 사용자 서버 생성(CPU/GPU 선택 가능), NFS 기반 영속성 스토리지, 자동화된 데이터 백업 등 고가용성 서비스를 위한 모든 요소를 포함하고 있습니다.

## 기술 아키텍처

-   **배포 (`config.yaml` & Helm)**:
    -   JupyterHub는 [Helm 차트](https://jupyterhub.github.io/helm-chart/)를 사용하여 Kubernetes 클러스터에 배포됩니다.
    -   `config.yaml`은 이 Helm 차트에 적용되는 핵심 설정 파일로, JupyterHub의 모든 동작 방식을 정의합니다.

-   **인증 및 접근 제어 (`config.yaml`)**:
    -   **인증 방식**: `GoogleOAuthenticator`를 사용하여 모든 사용자는 자신의 Google 계정으로 로그인합니다.
    -   **접근 제어**: `allowed_users` 목록에 명시된 Google 이메일 계정만 서비스에 로그인할 수 있는 화이트리스트 기반의 접근 제어를 사용합니다.

-   **사용자별 개발 환경 (Spawner & Profiles)**:
    -   사용자가 로그인하면, `KubeSpawner`가 해당 사용자를 위한 격리된 노트북 서버(Pod)를 Kubernetes 클러스터 내에 동적으로 생성합니다.
    -   사용자는 로그인 시, 제공되는 프로필 목록(`profileList`)에서 원하는 개발 환경을 선택할 수 있습니다.
        1.  **CPU 서버**: `jupyter/base-notebook` 이미지를 사용하는 표준 개발 환경.
        2.  **GPU 서버**: `jupyter/tensorflow-notebook` 이미지를 사용하며 **NVIDIA H100 GPU** 1개가 할당된 고성능 딥러닝 환경.

-   **외부 트래픽 처리 (`jupyter-hub-nginx.conf`)**:
    -   `jupyter-hub.geumdo.net` 도메인으로 들어오는 모든 웹 트래픽은 외부의 **Nginx 리버스 프록시**가 먼저 수신합니다.
    -   Nginx는 수신한 트래픽을 Kubernetes 클러스터 내부에서 동작하는 JupyterHub 서비스(Ingress Controller)로 안전하게 전달(Proxy Pass)합니다.
    -   WebSocket을 지원하여 Jupyter 커널과의 실시간 통신을 보장하며, 긴 타임아웃을 설정하여 장시간 실행되는 작업의 연결 유실을 방지합니다.

-   **데이터 영속성 및 백업**:
    -   **영속성 스토리지 (`config.yaml`)**: 모든 사용자의 작업 디렉토리는 `nfs-client` 스토리지 클래스를 사용하는 **NFS(Network File System)** 볼륨에 마운트됩니다. 이를 통해 사용자의 노트북, 데이터 등 모든 작업물이 Pod가 재시작되어도 안전하게 보존됩니다.
    -   **자동화된 백업 (`backup-cronjob.yaml`)**: Kubernetes `CronJob` 리소스가 **매일 자정**에 실행됩니다. 이 CronJob은 전체 사용자 데이터가 저장된 NFS 볼륨을 `tar.gz` 파일로 압축하여 별도의 NFS 백업 위치에 저장함으로써, 주기적인 데이터 백업을 자동화합니다.

## 기술 스택

-   **오케스트레이션**: Kubernetes(K8s), Helm
-   **애플리케이션**: JupyterHub
-   **인증**: Google OAuth
-   **리버스 프록시**: Nginx
-   **스토리지**: NFS (Network File System)
-   **백업**: Kubernetes CronJob, `tar`

## 배포 및 운영 절차 (요약)

1.  **사전 준비**:
    -   운영 중인 Kubernetes 클러스터.
    -   `kubectl` 및 `helm` CLI 도구.
    -   JupyterHub 사용자 데이터 및 백업 데이터를 저장할 NFS 서버.
    -   `jupyter-hub.geumdo.net` 도메인에 대한 DNS 설정.
    -   Google Cloud Platform에서 OAuth 2.0 클라이언트 ID 및 시크릿 발급.

2.  **설정 수정**:
    -   `config.yaml`의 `client_id`, `client_secret`, `oauth_callback_url`을 발급받은 정보로 수정합니다.
    -   `backup-cronjob.yaml`의 NFS 서버 정보를 실제 환경에 맞게 수정합니다.

3.  **배포**:
    -   Helm을 사용하여 JupyterHub를 배포합니다.
        ```bash
        helm repo add jupyterhub https://jupyterhub.github.io/helm-chart/
        helm repo update
        helm upgrade --install jupyterhub jupyterhub/jupyterhub --namespace jupyterhub --create-namespace -f config.yaml
        ```
    -   Nginx 리버스 프록시 서버에 `jupyter-hub-nginx.conf` 설정을 적용합니다.
    -   `kubectl apply -f backup-cronjob.yaml` 명령으로 백업 잡을 클러스터에 등록합니다.

4.  **접속**:
    -   웹 브라우저에서 `http://jupyter-hub.geumdo.net`으로 접속하여 Google 계정으로 로그인합니다. 