from typing import List, Dict
from loguru import logger
from .slack_notifier import SlackNotifier

class AlertManager:
    def __init__(self):
        self.notifiers = []
        self._initialize_notifiers()
        logger.info("알림 관리자 초기화 완료")

    def _initialize_notifiers(self):
        """알림 채널들을 초기화합니다."""
        try:
            # Slack 알림 초기화
            self.notifiers.append(SlackNotifier())
        except Exception as e:
            logger.warning(f"Slack 알림 초기화 실패: {str(e)}")

    def send_alerts(self, alerts: List[Dict]) -> bool:
        """모든 알림 채널을 통해 알림을 전송합니다."""
        if not alerts:
            return True

        success = True
        for notifier in self.notifiers:
            try:
                if not notifier.send_alert(alerts):
                    success = False
            except Exception as e:
                logger.error(f"알림 전송 실패 ({notifier.__class__.__name__}): {str(e)}")
                success = False

        return success

    def get_active_notifiers(self) -> List[str]:
        """현재 활성화된 알림 채널 목록을 반환합니다."""
        return [notifier.__class__.__name__ for notifier in self.notifiers] 