import os
import subprocess
import json
from datetime import datetime

def get_sensors_info():
    try:
        result = subprocess.run(['sensors', '-j'], capture_output=True, text=True)
        return json.loads(result.stdout)
    except:
        return {"error": "sensors 명령어를 실행할 수 없습니다. lm-sensors가 설치되어 있는지 확인하세요."}

def get_thermal_info():
    thermal_info = {}
    thermal_path = '/sys/class/thermal'
    if os.path.exists(thermal_path):
        for zone in os.listdir(thermal_path):
            if zone.startswith('thermal_zone'):
                temp_file = os.path.join(thermal_path, zone, 'temp')
                if os.path.exists(temp_file):
                    with open(temp_file, 'r') as f:
                        temp = float(f.read().strip()) / 1000.0  # 밀리켈빈을 섭씨로 변환
                        thermal_info[zone] = temp
    return thermal_info

def get_nvidia_info():
    try:
        result = subprocess.run(['nvidia-smi', '--query-gpu=temperature.gpu,fan.speed', '--format=csv,noheader'], 
                              capture_output=True, text=True)
        return result.stdout.strip()
    except:
        return "NVIDIA GPU 정보를 가져올 수 없습니다."

def main():
    print(f"=== 냉각 시스템 모니터링 ({datetime.now().strftime('%Y-%m-%d %H:%M:%S')}) ===")
    
    print("\n1. sensors 정보:")
    sensors_data = get_sensors_info()
    print(json.dumps(sensors_data, indent=2, ensure_ascii=False))
    
    print("\n2. 열 정보:")
    thermal_data = get_thermal_info()
    for zone, temp in thermal_data.items():
        print(f"{zone}: {temp:.1f}°C")
    
    print("\n3. NVIDIA GPU 정보:")
    print(get_nvidia_info())

if __name__ == "__main__":
    main() 