from pydantic_settings import BaseSettings
from dotenv import load_dotenv
import os

load_dotenv()

class Settings(BaseSettings):
    # Slack 설정
    SLACK_WEBHOOK_URL: str = os.getenv("SLACK_WEBHOOK_URL", "")
    
    # InfluxDB 설정
    INFLUXDB_URL: str = os.getenv("INFLUXDB_URL", "http://influxdb:8086")
    INFLUXDB_TOKEN: str = os.getenv("INFLUXDB_TOKEN", "")
    INFLUXDB_ORG: str = os.getenv("INFLUXDB_ORG", "")
    INFLUXDB_BUCKET: str = os.getenv("INFLUXDB_BUCKET", "")
    
    # 모니터링 설정
    MONITORING_INTERVAL: int = 10  # 초 단위 (10초로 변경)
    GPU_TEMP_THRESHOLD: float = 85.0  # GPU 온도 임계값
    COOLANT_TEMP_THRESHOLD: float = 45.0  # 냉각수 온도 임계값
    MIN_COOLANT_LEVEL: float = 0.2  # 최소 냉각수 레벨 (20%)
    
    # 로깅 설정
    LOG_LEVEL: str = "INFO"
    LOG_FILE: str = "logs/gpu_monitor.log"

settings = Settings() 